/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.volume;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.volume.FluxVolume;
import de.grogra.imp3d.objects.SensorNode;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.SensorDisc;
import de.grogra.vecmath.geom.Variables;
import java.io.IOException;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class FluxSensor
extends FluxVolume {
    private SensorDisc sensorDisc;
    private int groupIndex;
    private SensorNode sensorNode;

    public FluxSensor(SensorNode sensorNode, SensorDisc sensorDisc, int n) {
        this.sensorDisc = sensorDisc;
        this.sensorNode = sensorNode;
        this.groupIndex = n;
    }

    public void getExtent(BoundingBox3d boundingBox3d, Variables variables) {
        this.sensorDisc.getExtent(boundingBox3d.getMin(), boundingBox3d.getMax(), variables);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        computeByteBuffer.writeInt(this.groupIndex);
        Matrix3d matrix3d = new Matrix3d();
        Vector3d vector3d = new Vector3d();
        this.sensorDisc.getTransformation(matrix3d, (Tuple3d)vector3d);
        Matrix3f matrix3f = new Matrix3f(matrix3d);
        Vector3f vector3f = new Vector3f(vector3d);
        computeByteBuffer.write(matrix3f);
        computeByteBuffer.write((Tuple3f)vector3f);
        computeByteBuffer.writeBoolean(this.sensorNode.isTwoSided());
        Color3f color3f = new Color3f();
        color3f.set((Tuple3f)this.sensorNode.getColor());
        color3f.scale((float)(1.0 / (Math.PI * (double)this.sensorNode.getRadius() * (double)this.sensorNode.getRadius())));
        computeByteBuffer.write((Tuple3f)color3f);
        computeByteBuffer.writeFloat(this.sensorNode.getExponent());
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }
}

