/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.volume;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxVertex;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.Variables;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxPolygon
extends FluxPrimitive {
    private int[] idx = new int[3];
    private boolean parallel;
    private Vector<FluxVertex> vertices;
    Vector3d normal = new Vector3d();
    Matrix4f world2obj;

    public FluxPolygon(int n, int n2, int n3, Vector<FluxVertex> vector, boolean bl, Matrix4f matrix4f) {
        this.idx[0] = n;
        this.idx[1] = n2;
        this.idx[2] = n3;
        this.world2obj = matrix4f;
        this.parallel = bl;
        this.vertices = vector;
    }

    public void finish() {
        FluxVertex fluxVertex = this.vertices.get(this.idx[0]);
        FluxVertex fluxVertex2 = this.vertices.get(this.idx[1]);
        FluxVertex fluxVertex3 = this.vertices.get(this.idx[2]);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d.sub((Tuple3d)fluxVertex2.point, (Tuple3d)fluxVertex.point);
        vector3d2.sub((Tuple3d)fluxVertex3.point, (Tuple3d)fluxVertex.point);
        this.normal.cross((javax.vecmath.Vector3d)vector3d, (javax.vecmath.Vector3d)vector3d2);
        this.normal.normalize();
    }

    @Override
    public void getExtent(BoundingBox3d boundingBox3d, Variables variables) {
        Point3d point3d = this.vertices.get((int)this.idx[0]).point;
        Point3d point3d2 = this.vertices.get((int)this.idx[1]).point;
        Point3d point3d3 = this.vertices.get((int)this.idx[2]).point;
        boundingBox3d.extent((Tuple3d)point3d);
        boundingBox3d.extent((Tuple3d)point3d2);
        boundingBox3d.extent((Tuple3d)point3d3);
        if (this.parallel) {
            Point3d point3d4 = variables.tmpPoint0;
            Point3d point3d5 = variables.tmpPoint1;
            point3d4.sub((Tuple3d)point3d2, (Tuple3d)point3d);
            point3d5.sub((Tuple3d)point3d3, (Tuple3d)point3d);
            Point3d point3d6 = variables.tmpPoint2;
            point3d6.add((Tuple3d)point3d4, (Tuple3d)point3d5);
            point3d6.add((Tuple3d)point3d);
            boundingBox3d.extent((Tuple3d)point3d6);
        }
    }

    @Override
    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        this.serialize(computeByteBuffer, this.parallel ? 6 : 5, this.world2obj);
        FluxVertex fluxVertex = this.vertices.get(this.idx[0]);
        FluxVertex fluxVertex2 = this.vertices.get(this.idx[1]);
        FluxVertex fluxVertex3 = this.vertices.get(this.idx[2]);
        computeByteBuffer.write((Tuple3f)new Point3f(fluxVertex.point));
        computeByteBuffer.write((Tuple3f)new Point3f(fluxVertex2.point));
        computeByteBuffer.write((Tuple3f)new Point3f(fluxVertex3.point));
        computeByteBuffer.write((Tuple3f)new Point3f((Tuple3d)this.normal));
        computeByteBuffer.write((Tuple2f)new Point2f(fluxVertex.uv));
        computeByteBuffer.write((Tuple2f)new Point2f(fluxVertex2.uv));
        computeByteBuffer.write((Tuple2f)new Point2f(fluxVertex3.uv));
        computeByteBuffer.write((Tuple3f)new Point3f((Tuple3d)fluxVertex.normal));
        computeByteBuffer.write((Tuple3f)new Point3f((Tuple3d)fluxVertex2.normal));
        computeByteBuffer.write((Tuple3f)new Point3f((Tuple3d)fluxVertex3.normal));
    }

    public Object clone() {
        return new FluxPolygon(this.idx[0], this.idx[1], this.idx[2], this.vertices, this.parallel, this.world2obj);
    }

    public void shiftIndex(int n) {
        this.idx[0] = this.idx[0] + n;
        this.idx[1] = this.idx[1] + n;
        this.idx[2] = this.idx[2] + n;
    }

    public void setWorld2Obj(Matrix4f matrix4f) {
        this.world2obj = matrix4f;
    }
}

