/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.shading;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.utils.CIE;
import de.grogra.imp3d.spectral.ConstantSpectralCurve;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.sunflow.image.XYZColor;

public class FluxSpectrum {
    private SpectralCurve SPD;
    private static SpectralCurve ImportanceSPD = new ConstantSpectralCurve(1.0f);
    private static SpectralDiscretization discretization;
    private static Point3f whiteColor;

    public static void setImportance(SpectralCurve spectralCurve) {
        ImportanceSPD = spectralCurve;
    }

    public static void setDiscretization(SpectralDiscretization spectralDiscretization) {
        discretization = spectralDiscretization;
    }

    public static SpectralDiscretization getDiscretization() {
        return discretization;
    }

    public FluxSpectrum(SpectralCurve spectralCurve) {
        this.SPD = spectralCurve;
    }

    public static void serializeNormalizedSPD(ComputeByteBuffer computeByteBuffer, SpectralCurve spectralCurve, float f) throws IOException {
        float[] fArray = discretization.getDiscreteNormalizedSPD(spectralCurve, f);
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            computeByteBuffer.writeFloat(f2);
        }
    }

    public static void serializeSPD(ComputeByteBuffer computeByteBuffer, SpectralCurve spectralCurve) throws IOException {
        float[] fArray = discretization.getDiscreteSPD(spectralCurve);
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            computeByteBuffer.writeFloat(f);
        }
    }

    public static void serializeCumulativeSPD(ComputeByteBuffer computeByteBuffer, SpectralCurve spectralCurve) throws IOException {
        float[] fArray = discretization.getDiscreteCumulativeSPD(spectralCurve);
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            computeByteBuffer.writeFloat(f);
        }
    }

    public static void serialize(ComputeByteBuffer computeByteBuffer, SpectralCurve spectralCurve) throws IOException {
        Point3f point3f = FluxSpectrum.getRGBDistribution(spectralCurve);
        computeByteBuffer.write((Tuple3f)point3f);
        FluxSpectrum.serializeSPD(computeByteBuffer, spectralCurve);
    }

    public static Point3f getRGBDistribution(SpectralCurve spectralCurve) {
        XYZColor xYZColor = spectralCurve.toXYZ();
        Point3f point3f = new Point3f();
        CIE.XYZtoRGB(point3f, xYZColor);
        point3f.x /= FluxSpectrum.whiteColor.x;
        point3f.y /= FluxSpectrum.whiteColor.y;
        point3f.z /= FluxSpectrum.whiteColor.z;
        point3f.x = Math.max(0.0f, point3f.x);
        point3f.y = Math.max(0.0f, point3f.y);
        point3f.z = Math.max(0.0f, point3f.z);
        return point3f;
    }

    public Point3f getRGBDistribution() {
        return FluxSpectrum.getRGBDistribution(this.SPD);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        FluxSpectrum.serialize(computeByteBuffer, this.SPD);
    }

    public static void serializeCorrectedCumulativeSPD(ComputeByteBuffer computeByteBuffer, final SpectralCurve spectralCurve) throws IOException {
        SpectralCurve spectralCurve2 = new SpectralCurve(){

            public float sample(float f) {
                return ImportanceSPD.sample(f) * spectralCurve.sample(f);
            }

            public ManageableType getManageableType() {
                return null;
            }
        };
        FluxSpectrum.serializeCumulativeSPD(computeByteBuffer, spectralCurve2);
    }

    static {
        whiteColor = new Point3f();
        CIE.XYZtoRGB(whiteColor, new ConstantSpectralCurve(1.0f).toXYZ());
    }

    public static class SpectralDiscretization {
        private static final float CONSERVATIVE_IMPORTANCE = 0.1f;
        int spectralLambdaMin = 360;
        int spectralLambdaMax = 830;
        int spectralLambdaStep = 1;

        public SpectralDiscretization(int n, int n2, int n3) {
            if (n >= n2) {
                throw new IllegalArgumentException("Range must be non-empty: (" + n + "," + n2 + ")");
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("Step size must be strictly positive");
            }
            n2 += (n2 - n) % n3;
            this.spectralLambdaMin = n;
            this.spectralLambdaMax = n2;
            this.spectralLambdaStep = n3;
        }

        public float[] getDiscreteSPD(SpectralCurve spectralCurve) {
            int n = discretization.getLambdaBins();
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                float f;
                fArray[i] = f = spectralCurve.sample(discretization.getLambdaMin() + i * discretization.getLambdaStep());
            }
            return fArray;
        }

        public float[] getDiscreteNormalizedSPD(SpectralCurve spectralCurve, float f) {
            int n;
            float[] fArray = this.getDiscreteSPD(spectralCurve);
            float f2 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f2 += fArray[n];
            }
            n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * ((float)fArray.length * f / f2);
            }
            return fArray;
        }

        public float getSPDPower(SpectralCurve spectralCurve) {
            float[] fArray = this.getDiscreteSPD(spectralCurve);
            float f = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                f += fArray[i];
            }
            return f;
        }

        public float[] getDiscreteCumulativeSPD(SpectralCurve spectralCurve) {
            float[] fArray = this.getDiscreteSPD(spectralCurve);
            int n = 0;
            float f = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] > 0.0f) {
                    ++n;
                }
                f += fArray[i];
            }
            float f2 = 0.0f;
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = 0.0f;
                if (fArray[i] > 0.0f) {
                    f3 += 0.1f * f * (1.0f / (float)n);
                    f3 += 0.9f * fArray[i];
                }
                fArray2[i] = (f2 += f3) / f;
            }
            return fArray2;
        }

        public int getLambdaMin() {
            return this.spectralLambdaMin;
        }

        public int getLambdaMax() {
            return this.spectralLambdaMax;
        }

        public int getLambdaStep() {
            return this.spectralLambdaStep;
        }

        public int getLambdaBins() {
            return (this.spectralLambdaMax - this.spectralLambdaMin) / this.spectralLambdaStep;
        }
    }
}

