/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.shading.FluxSpectrum;
import de.grogra.imp3d.objects.SpectralLight;
import de.grogra.imp3d.spectral.SpectralCurve;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class FluxSpectralLight
extends FluxLight {
    SpectralLight spectralLight;
    FluxLight input;

    public FluxSpectralLight(SpectralLight spectralLight, FluxLight fluxLight) {
        super(spectralLight);
        this.spectralLight = spectralLight;
        this.input = fluxLight;
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        SpectralCurve spectralCurve = this.spectralLight.getSpectrum().getSpectralDistribution();
        this.serializeLightBase(computeByteBuffer, 6, (Tuple3f)new Vector3f(), spectralCurve);
        FluxSpectrum fluxSpectrum = new FluxSpectrum(spectralCurve);
        float f = this.spectralLight.getPower();
        Point3f point3f = fluxSpectrum.getRGBDistribution();
        point3f.scale(3.0f * f / (point3f.x + point3f.y + point3f.z));
        computeByteBuffer.write((Tuple3f)point3f);
        FluxSpectrum.serializeNormalizedSPD(computeByteBuffer, spectralCurve, f);
        this.input.serialize(computeByteBuffer);
    }
}

