/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.imp3d.objects.PhysicalLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.RGBColor;
import java.io.IOException;
import javax.vecmath.Tuple3f;

public class FluxPhysicalLight
extends FluxLight {
    private PhysicalLight physicalLight;

    public FluxPhysicalLight(PhysicalLight physicalLight) {
        super((Light)physicalLight);
        this.physicalLight = physicalLight;
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        int n;
        RGBColor rGBColor = (RGBColor)this.physicalLight.getColor().clone();
        rGBColor.scale(3.0f * this.physicalLight.getPower() / (rGBColor.x + rGBColor.y + rGBColor.z));
        this.serializeLightBase(computeByteBuffer, 4, (Tuple3f)rGBColor, null);
        int n2 = this.physicalLight.getDistribution().getWidth();
        int n3 = this.physicalLight.getDistribution().getHeight();
        double[][] dArray = this.physicalLight.getDistribution().getDistribution();
        double[] dArray2 = this.physicalLight.getDistribution().getLinearCDF();
        computeByteBuffer.writeInt(n2);
        computeByteBuffer.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                computeByteBuffer.writeFloat((float)dArray[n][i]);
            }
        }
        for (n = 0; n < dArray2.length; ++n) {
            computeByteBuffer.writeFloat((float)dArray2[n]);
        }
    }
}

