/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.experiment;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.experiment.Measurement;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxSensor;
import de.grogra.gpuflux.scene.volume.FluxVolume;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.geom.Variables;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuringSetup {
    public static final int MIN_MEASUREMENTS = 262144;
    public static final double EPSILON = 1.0E-5;
    private Vector<FluxDetector> detectors = new Vector();
    private int numMeasurements;
    private int numMeasurementsBits;
    private int measureDimensions;

    public int getDimensions() {
        return this.measureDimensions;
    }

    public void setDimensions(int n) {
        this.measureDimensions = n;
    }

    public int shuffleMeasurement(int n, int n2) {
        n = (n & 0xAAAAAAAA) >>> 1 | (n & 0x55555555) << 1;
        n = (n & 0xCCCCCCCC) >>> 2 | (n & 0x33333333) << 2;
        n = (n & 0xF0F0F0F0) >>> 4 | (n & 0xF0F0F0F) << 4;
        n = (n & 0xFF00FF00) >>> 8 | (n & 0xFF00FF) << 8;
        n = (n & 0xFFFF0000) >>> 16 | (n & 0xFFFF) << 16;
        return n >>> 32 - n2;
    }

    public int unshuffleMeasurement(int n, int n2) {
        n <<= 32 - n2;
        n = (n & 0xAAAAAAAA) >>> 1 | (n & 0x55555555) << 1;
        n = (n & 0xCCCCCCCC) >>> 2 | (n & 0x33333333) << 2;
        n = (n & 0xF0F0F0F0) >>> 4 | (n & 0xF0F0F0F) << 4;
        n = (n & 0xFF00FF00) >>> 8 | (n & 0xFF00FF) << 8;
        n = (n & 0xFFFF0000) >>> 16 | (n & 0xFFFF) << 16;
        return n;
    }

    private int log2(int n) {
        int n2 = 0;
        for (int i = n; i != 0; i >>= 1) {
            ++n2;
        }
        return n2;
    }

    public Vector<Measurement> LoadMeasuredData(float[] fArray, double d) {
        Vector<Measurement> vector = new Vector<Measurement>();
        for (int i = 0; i < this.getNumMeasurement(); ++i) {
            Measurement measurement = this.createMeasurement();
            measurement.data = new double[this.getDimensions()];
            for (int j = 0; j < this.getDimensions(); ++j) {
                measurement.data[j] = fArray[i * this.getDimensions() + j];
            }
            vector.add(measurement);
        }
        return this.aggregateMeasurements(vector, d);
    }

    public Vector<Measurement> aggregateMeasurements(Vector<Measurement> vector, double d) {
        Vector<Measurement> vector2 = new Vector<Measurement>();
        int n = this.getNumMeasurementBits();
        for (int i = 0; i < this.detectors.size(); ++i) {
            FluxDetector fluxDetector = this.detectors.get(i);
            Measurement measurement = this.createMeasurement();
            for (int j = 0; j < fluxDetector.getMeasurements(); ++j) {
                int n2 = fluxDetector.getOffset() + j;
                int n3 = this.shuffleMeasurement(n2, n);
                measurement.add(vector.get(n3));
            }
            measurement.mul(d);
            vector2.add(measurement);
        }
        return vector2;
    }

    public int getNumMeasurement() {
        return this.numMeasurements;
    }

    public int getNumMeasurementBits() {
        return this.numMeasurementsBits;
    }

    public void buildSetup(int n, FluxScene fluxScene) {
        n = Math.max(FluxSettings.getOCLMinMeasurements(), n);
        this.buildDetectors(n, fluxScene);
    }

    private void buildDetectors(int n, FluxScene fluxScene) {
        int n2;
        float[] fArray = this.getGroupSAH(fluxScene);
        this.measureDimensions = fArray.length;
        this.numMeasurements = Math.max(n, fArray.length);
        int n3 = this.log2(this.numMeasurements - 1);
        this.numMeasurements = 1 << n3;
        this.numMeasurementsBits = n3;
        float f = 0.0f;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            f += fArray[n2];
        }
        n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            int n4 = (int)(fArray[i] / f * (float)(this.numMeasurements - fArray.length)) + 1;
            this.detectors.add(new FluxDetector(n2, n4));
            n2 += n4;
        }
    }

    private float[] getGroupSAH(FluxScene fluxScene) {
        FluxVolume fluxVolume;
        int n;
        float[] fArray = new float[fluxScene.getGroupCount()];
        Variables variables = new Variables();
        BoundingBox3d boundingBox3d = new BoundingBox3d();
        for (n = 0; n < fluxScene.getInfPrimitives().size(); ++n) {
            fluxVolume = fluxScene.getInfPrimitives().get(n);
            if (((FluxPrimitive)fluxVolume).getGroupIndex() == -1) continue;
            int n2 = ((FluxPrimitive)fluxVolume).getGroupIndex();
            fArray[n2] = (float)((double)fArray[n2] + Math.max(1.0E-5, fluxScene.getBounds().area()));
        }
        for (n = 0; n < fluxScene.getPrimitives().size(); ++n) {
            fluxVolume = fluxScene.getPrimitives().get(n);
            if (((FluxPrimitive)fluxVolume).getGroupIndex() == -1) continue;
            ((FluxPrimitive)fluxVolume).getExtent(boundingBox3d, variables);
            int n3 = ((FluxPrimitive)fluxVolume).getGroupIndex();
            fArray[n3] = (float)((double)fArray[n3] + Math.max(1.0E-5, boundingBox3d.area()));
        }
        for (n = 0; n < fluxScene.getSensors().size(); ++n) {
            fluxVolume = fluxScene.getSensors().get(n);
            if (((FluxSensor)fluxVolume).getGroupIndex() == -1) continue;
            ((FluxSensor)fluxVolume).getExtent(boundingBox3d, variables);
            int n4 = ((FluxSensor)fluxVolume).getGroupIndex();
            fArray[n4] = (float)((double)fArray[n4] + Math.max(1.0E-5, boundingBox3d.area()));
        }
        return fArray;
    }

    public Vector<FluxDetector> getDetectors() {
        return this.detectors;
    }

    public Measurement createMeasurement() {
        return new Measurement(this.measureDimensions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MeasurementAggregater<T> {
        public T zero();

        public void aggregate(T var1, T var2);

        public void scale(T var1, double var2);
    }

    public class FluxDetector {
        private int offset;
        private int measurements;

        public FluxDetector(int n, int n2) {
            this.offset = n;
            this.measurements = n2;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getMeasurements() {
            return this.measurements;
        }
    }
}

