/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.BVH;

import de.grogra.gpuflux.scene.BVH.BVHNode;
import de.grogra.gpuflux.scene.BVH.BVHTree;

public class BVHAnalyzer {
    private double SAH;
    private int[] depthHist;
    private int[] leafHist;

    public String analyzeBVH(BVHTree bVHTree) {
        int n;
        this.depthHist = new int[63];
        this.leafHist = new int[99];
        String string = "";
        BVHNode bVHNode = bVHTree.getRoot();
        this.analyzeLeafs(bVHNode, 0);
        this.SAH = this.computeSAH(bVHNode, bVHTree.getBounds().area());
        string = string + "    SAH cost: " + this.SAH + "\n";
        string = string + "    Leaf depth histrogram:";
        for (n = 0; n < this.depthHist.length; ++n) {
            if (n % 25 == 0) {
                string = string + "\n        ";
            }
            string = string + this.depthHist[n] + " ";
        }
        string = string + "\n";
        string = string + "    Leaf primitives histrogram:";
        for (n = 0; n < this.leafHist.length; ++n) {
            if (n % 25 == 0) {
                string = string + "\n        ";
            }
            string = string + this.leafHist[n] + " ";
        }
        string = string + "\n";
        return string;
    }

    private void analyzeLeafs(BVHNode bVHNode, int n) {
        if (bVHNode.isLeaf()) {
            int n2 = Math.min(n, this.depthHist.length - 1);
            this.depthHist[n2] = this.depthHist[n2] + 1;
            int n3 = Math.min(bVHNode.pcount, this.leafHist.length - 1);
            this.leafHist[n3] = this.leafHist[n3] + 1;
        }
        if (bVHNode.left != null) {
            this.analyzeLeafs(bVHNode.left, n + 1);
        }
        if (bVHNode.right != null) {
            this.analyzeLeafs(bVHNode.right, n + 1);
        }
    }

    private double computeSAH(BVHNode bVHNode, double d) {
        double d2 = bVHNode.bb.area();
        double d3 = bVHNode.bb.area() / d;
        double d4 = 1.0;
        if (bVHNode.isLeaf()) {
            d4 += d3 * (double)bVHNode.pcount * 10.0;
        } else {
            if (bVHNode.left != null) {
                d4 += d3 * this.computeSAH(bVHNode.left, d2);
            }
            if (bVHNode.right != null) {
                d4 += d3 * this.computeSAH(bVHNode.right, d2);
            }
        }
        return d4;
    }
}

