/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl.compute;

import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLDevice;
import de.grogra.gpuflux.jocl.JOCLKernel;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.jocl.compute.SharedBuffer;
import de.grogra.gpuflux.utils.ByteArray;
import java.nio.ByteOrder;
import org.jocl.Pointer;
import org.jocl.cl_event;

public class Device {
    private ComputeContext context;
    private int contextID;
    private JOCLDevice device;

    protected Device(int n, JOCLDevice jOCLDevice, ComputeContext computeContext) {
        this.contextID = n;
        this.device = jOCLDevice;
        this.context = computeContext;
    }

    public Buffer createBuffer(int n, long l) {
        return new Buffer(this.context.getContext(this.contextID).createBuffer(n, l), this);
    }

    public ComputeContext getContext() {
        return this.context;
    }

    private JOCLKernel getJOCLKernel(Kernel kernel) {
        assert (kernel.getContext() == this.context);
        return kernel.getKernel(this.contextID);
    }

    private JOCLBuffer getJOCLBuffer(Buffer buffer) {
        assert (buffer.getDevice() == this);
        return buffer.getBuffer();
    }

    private JOCLBuffer getJOCLBuffer(SharedBuffer sharedBuffer) {
        assert (sharedBuffer.getContext() == this.context);
        return sharedBuffer.getBuffer(this.contextID, this.device.isLittleEndian());
    }

    public void setKernelArg(Kernel kernel, int n, int n2, Pointer pointer) {
        this.getJOCLKernel(kernel).setKernelArg(n, n2, pointer);
    }

    public void setKernelArgInt(Kernel kernel, int n, int n2) {
        this.getJOCLKernel(kernel).setKernelArgInt(n, n2);
    }

    public void setKernelArgFloat(Kernel kernel, int n, float f) {
        this.getJOCLKernel(kernel).setKernelArgFloat(n, f);
    }

    public void setKernelArgMemBuffer(Kernel kernel, int n, Buffer buffer) {
        this.getJOCLKernel(kernel).setKernelArgMemBuffer(n, this.getJOCLBuffer(buffer));
    }

    public void setKernelArgMemBuffer(Kernel kernel, int n, SharedBuffer sharedBuffer) {
        this.getJOCLKernel(kernel).setKernelArgMemBuffer(n, this.getJOCLBuffer(sharedBuffer));
    }

    public void setKernelArgBuffer(Kernel kernel, int n, ByteArray byteArray) {
        this.getJOCLKernel(kernel).setKernelArgBuffer(n, byteArray);
    }

    public void executeKernel(Kernel kernel, int n) {
        this.device.executeKernel(this.getJOCLKernel(kernel), n);
    }

    public void finish() {
        this.device.finish();
    }

    protected int getContextID() {
        return this.contextID;
    }

    protected JOCLDevice getDevice() {
        return this.device;
    }

    public String getName() {
        return this.device.getName();
    }

    public String toString() {
        return this.device.toString();
    }

    public void executeKernel(Kernel kernel, int n, cl_event cl_event2) {
        this.device.executeKernel(this.getJOCLKernel(kernel), n, cl_event2);
    }

    public ComputeByteBuffer createByteBuffer() {
        boolean bl;
        return new ComputeByteBuffer(bl, !(bl = this.device.isLittleEndian()));
    }

    public boolean isLittleEndian() {
        return this.device.isLittleEndian();
    }

    public ByteOrder getByteOrder() {
        return this.device.getByteOrder();
    }
}

