/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl.compute;

import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import java.io.IOException;

public class Buffer {
    private JOCLBuffer buffer;
    private Device device;

    protected Buffer(JOCLBuffer jOCLBuffer, Device device) {
        this.buffer = jOCLBuffer;
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    public JOCLBuffer getBuffer() {
        return this.buffer;
    }

    public void clear() {
        try {
            Kernel kernel = this.device.getContext().createKernel("kernel/clear_kernel.cl", "clearBuffer", "");
            int n = this.buffer.getSize() / 4;
            this.device.setKernelArgMemBuffer(kernel, 1, this);
            this.device.setKernelArgInt(kernel, 2, n);
            this.device.executeKernel(kernel, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readBuffer(byte[] byArray) {
        this.device.getDevice().readBuffer(this.buffer, byArray);
    }

    public void readBuffer(int[] nArray) {
        this.device.getDevice().readBuffer(this.buffer, nArray);
    }
}

