/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.JOCLDevice;
import de.grogra.gpuflux.jocl.JOCLDeviceFilter;
import java.util.AbstractList;
import java.util.Vector;
import org.jocl.cl_device_id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOCLMultiDeviceFilter
implements JOCLDeviceFilter {
    private boolean GPU = FluxSettings.getOCLGPU();
    private Vector<cl_device_id> devices;
    private boolean hasCPUDevice;

    @Override
    public void init() {
        this.devices = new Vector();
        this.hasCPUDevice = false;
    }

    @Override
    public void filter(cl_device_id cl_device_id2) {
        long l = JOCLDevice.getDeviceType(cl_device_id2);
        if ((l & 0xCL) != 0L && !this.GPU) {
            return;
        }
        if (this.devices.size() != 0 && JOCLDevice.isLittleEndian(this.devices.get(0)) != JOCLDevice.isLittleEndian(cl_device_id2)) {
            return;
        }
        if ((l & 2L) != 0L) {
            if (this.hasCPUDevice) {
                return;
            }
            this.hasCPUDevice = true;
        }
        this.devices.add(cl_device_id2);
    }

    @Override
    public AbstractList<cl_device_id> getDevices() {
        return this.devices;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JOCLMultiDeviceFilter)) {
            return false;
        }
        JOCLMultiDeviceFilter jOCLMultiDeviceFilter = (JOCLMultiDeviceFilter)object;
        return jOCLMultiDeviceFilter.GPU == this.GPU;
    }
}

