/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.dom;

import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.GraphImpl;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.base.GraphQueueImpl;
import de.grogra.xl.impl.dom.DOMProducer;
import de.grogra.xl.impl.dom.RuntimeModel;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.Producer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.util.ObjectList;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Graph
extends GraphImpl {
    final Document doc;
    private final ObjectList siblings = new ObjectList();

    public Graph(RuntimeModel runtimeModel, Document document) {
        super(runtimeModel);
        this.doc = document;
    }

    public boolean canEnumerateEdges(EdgeDirection edgeDirection, boolean bl, Serializable serializable) {
        if (edgeDirection == EdgeDirection.BOTH) {
            return false;
        }
        return edgeDirection == EdgeDirection.FORWARD || !bl || ((Integer)serializable & 0x8000) == 0;
    }

    public GraphQueue createQueue(QueueCollection queueCollection, QueueDescriptor queueDescriptor) {
        return new GraphQueueImpl(queueDescriptor, queueCollection){

            protected int maskConnectionEdges(int n) {
                return n & 0x300;
            }
        };
    }

    protected void beginModifications() {
        this.siblings.clear();
    }

    protected void commitModifications() {
        boolean bl;
        do {
            bl = false;
            for (int i = this.siblings.size() - 2; i >= 0; i -= 2) {
                if (!RuntimeModel.addEdgeBits((Node)this.siblings.get(i), (Node)this.siblings.get(i + 1), 16384)) continue;
                bl = true;
                this.siblings.remove(i + 1);
                this.siblings.remove(i);
            }
        } while (bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enumerateNodes(Type type, QueryState queryState, int n, MatchConsumer matchConsumer, int n2) {
        ObjectList objectList = queryState.userStack0;
        int n3 = objectList.size;
        Node node = this.doc.getDocumentElement();
        try {
            objectList.push((Object)node);
            while (objectList.size > n3) {
                node = (Node)objectList.pop();
                if (type.isInstance((Object)node)) {
                    queryState.amatch(n, (Object)node, matchConsumer, n2);
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    objectList.push((Object)node2);
                }
            }
        }
        finally {
            objectList.setSize(n3);
        }
    }

    public Object getRoot() {
        return this.doc.getDocumentElement();
    }

    public void addNode(Object object) {
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        if (!RuntimeModel.addEdgeBits((Node)object, (Node)object2, n)) {
            this.siblings.push(object).push(object2);
        }
    }

    public void removeEdgeBits(Object object, Object object2, int n) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        if ((n & 0x300) != 0 && node2.getParentNode() == node) {
            node.removeChild(node2);
        }
    }

    public Producer createProducer(QueryState queryState) {
        return new DOMProducer(queryState);
    }
}

