/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.xl.impl.base.Connector;
import de.grogra.xl.impl.base.EdgeData;
import de.grogra.xl.impl.base.Graph;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.EdgePattern;
import de.grogra.xl.query.NodeData;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Producer
implements de.grogra.xl.query.Producer,
Executor {
    private final RuntimeModel model;
    private final Graph.QState match;
    private final Graph graph;
    private int depth;
    private int stdEdgeType;
    private Object prevNode;
    private boolean firstPart;
    private final IntList istack = new IntList();
    private final ObjectList ostack = new ObjectList();
    private final EHashMap<EdgeData> edgeMap = new EHashMap();
    private final EdgeData edgeKey = new EdgeData();
    private final ObjectList<NodeData> restoreContextFlag = new ObjectList();
    private QueueCollection queues;
    protected GraphQueue addNodeQueue;
    protected GraphQueue deleteNodeQueue;
    protected GraphQueue deleteEdgeQueue;
    private int arrow;
    private ObjectList firstDeepNodes = new ObjectList();
    private Object firstNode;
    private Object lastNode;
    private boolean interpretiveRule;
    private int inConnEdges;
    private int outConnEdges;
    private boolean useOperators;

    protected Producer(QueryState queryState) {
        this.match = (Graph.QState)queryState;
        this.graph = (Graph)queryState.getGraph();
        this.model = this.graph.model;
    }

    protected Producer(RuntimeModel runtimeModel) {
        this.match = null;
        this.graph = null;
        this.model = runtimeModel;
    }

    protected QueryState getQueryState() {
        return this.match;
    }

    public de.grogra.xl.query.Graph producer$getGraph() {
        return this.graph;
    }

    public boolean producer$beginExecution(int n) {
        this.arrow = n;
        this.prevNode = null;
        this.firstPart = true;
        this.edgeMap.clear();
        this.firstNode = null;
        this.firstDeepNodes.clear();
        this.lastNode = null;
        this.inConnEdges = -1;
        this.outConnEdges = -1;
        this.useOperators = true;
        this.interpretiveRule = (this.match.data.derivationMode & 4) != 0;
        this.queues = this.graph.getQueues();
        this.addNodeQueue = this.queues.getQueue(GraphQueue.ADD_NODE_DESCRIPTOR);
        this.deleteNodeQueue = this.queues.getQueue(GraphQueue.DELETE_NODE_DESCRIPTOR);
        this.deleteEdgeQueue = this.queues.getQueue(GraphQueue.DELETE_EDGE_DESCRIPTOR);
        this.depth = 0;
        this.istack.clear();
        this.ostack.clear();
        this.restoreContextFlag.clear();
        return this.graph.applyMatch(this.match);
    }

    public void producer$endExecution(boolean bl) {
        int n;
        int n2;
        if (!bl) {
            return;
        }
        if (this.depth > 0) {
            throw new IllegalStateException();
        }
        this.match.visitMatch(this);
        GraphQueue graphQueue = this.queues.getQueue(GraphQueue.ADD_EDGE_DESCRIPTOR);
        GraphQueue graphQueue2 = this.queues.getQueue(GraphQueue.ADD_UNDIRECTED_EDGE_DESCRIPTOR);
        Object object = (EdgeData)this.edgeMap.getFirstEntry();
        while (object != null) {
            int n3 = object.add;
            int n4 = object.delete;
            n2 = object.bits;
            if (n2 == 0) {
                n2 = this.model.getEdgeBits(object.source, object.target);
            }
            if ((n = n3 & 0xFF) != 0) {
                if (n == (n2 & 0xFF)) {
                    n3 &= 0xFFFFFF00;
                    n4 &= 0xFFFFFF00;
                } else if ((n2 & 0xFF) != 0) {
                    n4 |= 0xFF;
                }
            } else if ((n4 & 0xFF) != 0) {
                n4 |= 0xFF;
            }
            if ((n4 &= ~n3 | 0xFF) != 0) {
                this.deleteEdgeQueue.deleteEdgeBits(object.source, object.target, n4);
            }
            if ((n3 &= ~n2 | 0xFF) != 0) {
                graphQueue.addEdgeBits(object.source, object.target, n3);
            }
            if (object.undirectedAdd != 0) {
                graphQueue2.addUndirectedEdgeBits(object.source, object.target, object.undirectedAdd);
            }
            object = (EdgeData)object.listNext;
        }
        this.edgeMap.clear();
        object = this.queues.getQueue(GraphQueue.DELETE_NODE_DESCRIPTOR);
        Object object2 = this.match.getInValue();
        Object object3 = this.match.getOutValue();
        if (this.interpretiveRule) {
            if (this.firstNode != null && object2 != null) {
                GraphQueue graphQueue3 = this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR);
                graphQueue3.embedInterpretive(object2, this.firstNode, this.lastNode);
            }
        } else {
            n2 = 0;
            n = 0;
            Object object4 = this.match.getFirstNodeData();
            while (object4 != null) {
                if (!((NodeData)object4).context) {
                    if (!this.model.isNode(((NodeData)object4).node)) {
                        throw new IllegalArgumentException();
                    }
                    ((GraphQueue)object).deleteNode(((NodeData)object4).node);
                    n2 |= ((NodeData)object4).node == object2 ? 1 : 0;
                    n |= ((NodeData)object4).node == object3 ? 1 : 0;
                    if ((this.match.data.derivationMode & 8) != 0) {
                        this.match.data.excludeFromMatch(((NodeData)object4).node);
                    }
                }
                object4 = (NodeData)((NodeData)object4).listNext;
            }
            if (this.arrow == 0) {
                object4 = this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR);
                if (object2 != null) {
                    for (int i = 0; i < this.firstDeepNodes.size; ++i) {
                        Object object5 = this.firstDeepNodes.get(i);
                        if (object2 == object5) continue;
                        if (this.useOperators) {
                            ((GraphQueue)object4).connectIncoming(object2, object5, this.model.branchIn);
                            continue;
                        }
                        ((GraphQueue)object4).copyIncoming(object2, object5, 768, 0, 512);
                    }
                }
                if (this.firstNode == null) {
                    if (object2 != null && object3 != null && this.outConnEdges != 0) {
                        ((GraphQueue)object4).connectAdjacent(object2, object3, this.outConnEdges);
                    }
                } else {
                    if (object2 != null && object2 != this.firstNode) {
                        if (this.useOperators && this.inConnEdges == -1) {
                            ((GraphQueue)object4).connectIncoming(object2, this.firstNode, this.model.copyIn);
                            if (n2 == 0) {
                                this.deleteEdgeQueue.deleteCurrentEdges(object2, this.inConnEdges, false);
                            }
                        } else if (n2 != 0) {
                            ((GraphQueue)object4).copyIncoming(object2, this.firstNode, this.inConnEdges);
                        } else {
                            ((GraphQueue)object4).moveIncoming(object2, this.firstNode, this.inConnEdges);
                        }
                    }
                    if (object3 != null && object3 != this.lastNode) {
                        if (this.useOperators && this.outConnEdges == -1) {
                            ((GraphQueue)object4).connectOutgoing(object3, this.lastNode, this.model.copyOut);
                            if (n == 0) {
                                this.deleteEdgeQueue.deleteCurrentEdges(object3, this.outConnEdges, true);
                            }
                        } else if (n != 0) {
                            ((GraphQueue)object4).copyOutgoing(object3, this.lastNode, this.outConnEdges);
                        } else {
                            ((GraphQueue)object4).moveOutgoing(object3, this.lastNode, this.outConnEdges);
                        }
                    }
                }
            }
        }
        for (int i = this.restoreContextFlag.size - 1; i >= 0; --i) {
            ((NodeData)this.restoreContextFlag.get((int)i)).context = false;
        }
    }

    protected void pushImpl() {
        ++this.depth;
        this.istack.push(this.stdEdgeType);
        this.istack.push(this.firstPart ? 1 : 0);
        this.ostack.push(this.prevNode);
        this.stdEdgeType = 2;
    }

    protected void popImpl() {
        if (--this.depth < 0) {
            throw new IllegalStateException();
        }
        this.prevNode = this.ostack.pop();
        this.firstPart = this.istack.pop() != 0;
        this.stdEdgeType = this.istack.pop();
    }

    protected void separateImpl() {
        this.prevNode = null;
        this.firstPart = false;
    }

    protected void nodeUsed(Object object) {
        if (this.model != null) {
            NodeData nodeData;
            if (!this.model.isNode(object)) {
                throw new IllegalArgumentException(object + " is not a valid node");
            }
            if (this.match != null && (nodeData = this.match.getNodeData(object)) != null && !nodeData.context) {
                nodeData.context = true;
                this.restoreContextFlag.add((Object)nodeData);
            }
            if (this.addNodeQueue != null) {
                this.addNodeQueue.addNode(object);
            }
        }
    }

    protected void addNodeImpl(Object object, boolean bl) {
        if (bl && this.prevNode != null) {
            this.addEdgeImpl(this.prevNode, object, this.model.getStandardEdgeFor(this.stdEdgeType), (EdgeDirection)EdgeDirection.FORWARD);
        }
        this.nodeUsed(object);
        if (this.firstPart) {
            if (this.prevNode == null) {
                if (this.depth == 0) {
                    this.firstNode = object;
                } else {
                    this.firstDeepNodes.add(object);
                }
            }
            if (this.depth == 0) {
                this.lastNode = object;
            }
        }
        this.prevNode = object;
        this.stdEdgeType = 1;
    }

    protected Object getPreviousNode() {
        return this.prevNode;
    }

    protected final void addEdgeImpl(Object object, Object object2, int n, EdgeDirection edgeDirection) {
        while (true) {
            Object object3;
            if (edgeDirection == EdgeDirection.BACKWARD) {
                object3 = object;
                object = object2;
                object2 = object3;
            }
            if (this.match == null) {
                this.model.addEdgeBits(object, object2, n);
            } else {
                object3 = this.getEdgeDataForAdd(object, object2);
                if (edgeDirection == EdgeDirection.UNDIRECTED) {
                    ((EdgeData)((Object)object3)).add = 0;
                    ((EdgeData)((Object)object3)).undirectedAdd = n;
                } else {
                    ((EdgeData)((Object)object3)).add = n;
                    ((EdgeData)((Object)object3)).undirectedAdd = 0;
                }
                this.edgeMap.put((EHashMap.Entry)object3);
            }
            if (edgeDirection != EdgeDirection.BOTH) {
                return;
            }
            edgeDirection = EdgeDirection.BACKWARD;
        }
    }

    private EdgeData getEdgeDataForAdd(Object object, Object object2) {
        if (!this.model.isNode(object)) {
            throw new IllegalArgumentException(object + " is not a valid node");
        }
        if (!this.model.isNode(object2)) {
            throw new IllegalArgumentException(object2 + " is not a valid node");
        }
        EdgeData edgeData = (EdgeData)this.edgeMap.popEntryFromPool();
        if (edgeData == null) {
            edgeData = new EdgeData();
        }
        edgeData.set(object, object2);
        edgeData.delete = 0;
        edgeData.bits = 0;
        return edgeData;
    }

    public void producer$visitEdge(EdgePattern edgePattern) {
        Object object = this.match.abound(0);
        Object object2 = this.match.abound(1);
        boolean bl = edgePattern.needsBothDirections();
        int n = edgePattern.getMatchIndex();
        while (true) {
            int n2;
            this.edgeKey.set(object, object2);
            EdgeData edgeData = (EdgeData)this.edgeMap.get((EHashMap.Entry)this.edgeKey);
            int n3 = edgePattern.getPatternIndex();
            int n4 = n2 = n3 >= 0 ? this.match.ibound(n3) : ((Number)edgePattern.getPattern()).intValue();
            if (edgeData != null) {
                edgeData.bits = this.match.ibound(n);
                edgeData.delete |= n2 & edgeData.bits;
            } else {
                this.deleteEdgeQueue.deleteEdgeBits(object, object2, n2 & this.match.ibound(n));
            }
            if (!bl) break;
            bl = false;
            ++n;
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
    }

    public void copyIncoming(Object object, Object object2, int n) {
        this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR).copyIncoming(object, object2, n);
    }

    public void copyOutgoing(Object object, Object object2, int n) {
        this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR).copyOutgoing(object, object2, n);
    }

    public void moveIncoming(Object object, Object object2, int n) {
        this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR).moveIncoming(object, object2, n);
    }

    public void moveOutgoing(Object object, Object object2, int n) {
        this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR).moveOutgoing(object, object2, n);
    }

    public <N, P> void connect(N n, N n2, P p, Connector<N, P> connector) {
        this.queues.getQueue(GraphQueue.CONNECT_DESCRIPTOR).connect(n, n2, p, connector);
    }

    @Override
    public void execute(Runnable runnable) {
        this.queues.getQueue(GraphQueue.EXECUTE_DESCRIPTOR).execute(runnable);
    }

    public void setConnectionEdges(int n) {
        this.setInConnectionEdges(n);
        this.setOutConnectionEdges(n);
    }

    public void setInConnectionEdges(int n) {
        this.inConnEdges = n;
    }

    public void setOutConnectionEdges(int n) {
        this.outConnEdges = n;
    }

    public void cut() {
        this.setOutConnectionEdges(0);
    }

    public void useOperators(boolean bl) {
        this.useOperators = bl;
    }

    public void interpretive() {
        this.interpretiveRule = true;
    }

    public void consume(Object object) {
        this.match.data.excludeFromMatch(object);
    }

    public QueueCollection getQueues() {
        return this.queues;
    }

    public <Q extends Queue> Q getQueue(QueueDescriptor<Q> queueDescriptor) {
        return this.queues.getQueue(queueDescriptor);
    }
}

