/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.reflect.TypeLoader;
import de.grogra.util.HierarchicalQueue;
import de.grogra.xl.impl.base.Connector;
import de.grogra.xl.impl.base.Graph;
import de.grogra.xl.impl.base.Operator;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.RuntimeModelException;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphQueue
extends HierarchicalQueue
implements Queue,
Executor {
    public static final AddNodeDescriptor ADD_NODE_DESCRIPTOR = new AddNodeDescriptor();
    public static final ConnectDescriptor CONNECT_DESCRIPTOR = new ConnectDescriptor();
    public static final AddEdgeDescriptor ADD_EDGE_DESCRIPTOR = new AddEdgeDescriptor();
    public static final AddUndirectedEdgeDescriptor ADD_UNDIRECTED_EDGE_DESCRIPTOR = new AddUndirectedEdgeDescriptor();
    public static final DeleteEdgeDescriptor DELETE_EDGE_DESCRIPTOR = new DeleteEdgeDescriptor();
    public static final DeleteNodeDescriptor DELETE_NODE_DESCRIPTOR = new DeleteNodeDescriptor();
    public static final ExecuteDescriptor EXECUTE_DESCRIPTOR = new ExecuteDescriptor();
    public static final QueueDescriptor FIRST_QUEUE = ADD_NODE_DESCRIPTOR;
    public static final QueueDescriptor LAST_QUEUE = EXECUTE_DESCRIPTOR;
    private final QueueDescriptor<?> descriptor;
    private Processor processor;
    transient boolean clearInapplicable = false;
    private ObjectList<HierarchicalQueue.Cursor> segments = new ObjectList();
    private int segmentsSize = 0;

    public GraphQueue(QueueDescriptor<?> queueDescriptor, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.descriptor = queueDescriptor;
    }

    @Override
    public QueueDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    protected abstract Processor createProcessor();

    @Override
    public boolean process(int[] nArray) throws RuntimeModelException {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        this.processor.resetCursor();
        try {
            return this.processor.process(nArray);
        }
        catch (IOException iOException) {
            throw new RuntimeModelException((Throwable)iOException, (de.grogra.xl.query.RuntimeModel)this.getModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSegmentsToExcludeImpl(int[] nArray) {
        try {
            this.clearInapplicable = true;
            this.process(nArray);
        }
        catch (RuntimeModelException runtimeModelException) {
            runtimeModelException.printStackTrace();
        }
        finally {
            this.clearInapplicable = false;
        }
    }

    @Override
    public void markSegment(int n) {
        while (this.segmentsSize <= n) {
            this.segments.set(this.segmentsSize, (Object)this.getCursor((HierarchicalQueue.Cursor)this.segments.get(this.segmentsSize)));
            ++this.segmentsSize;
        }
    }

    @Override
    public void resetToSegment(int n) {
        this.moveTo((HierarchicalQueue.Cursor)this.segments.get(n));
        this.segmentsSize = n + 1;
    }

    @Override
    public void clear() {
        super.clear();
        this.segmentsSize = 0;
    }

    protected abstract RuntimeModel getModel();

    public abstract void addNode(Object var1);

    public abstract void addEdgeBits(Object var1, Object var2, int var3);

    public abstract void addUndirectedEdgeBits(Object var1, Object var2, int var3);

    public abstract void deleteEdgeBits(Object var1, Object var2, int var3);

    public abstract void deleteNode(Object var1);

    public abstract void deleteCurrentEdges(Object var1, int var2, boolean var3);

    public abstract void moveIncoming(Object var1, Object var2, int var3);

    public abstract void copyIncoming(Object var1, Object var2, int var3);

    public abstract void copyIncoming(Object var1, Object var2, int var3, int var4, int var5);

    public abstract void moveOutgoing(Object var1, Object var2, int var3);

    public abstract void copyOutgoing(Object var1, Object var2, int var3);

    public abstract void copyOutgoing(Object var1, Object var2, int var3, int var4, int var5);

    public abstract <N> void connectIncoming(N var1, N var2, Operator<N> var3);

    public abstract <N> void connectOutgoing(N var1, N var2, Operator<N> var3);

    public abstract <N, P> void connect(N var1, N var2, P var3, Connector<N, P> var4);

    public abstract void connectAdjacent(Object var1, Object var2, int var3);

    public abstract void embedInterpretive(Object var1, Object var2, Object var3);

    protected class Processor
    extends HierarchicalQueue.Reader {
        protected boolean execute;
        protected boolean checkApplicability;
        protected boolean markApplicability;
        protected boolean clearSegment;

        protected Processor(TypeLoader typeLoader) {
            super((HierarchicalQueue)GraphQueue.this, typeLoader);
            this.execute = true;
            this.checkApplicability = false;
            this.markApplicability = false;
            this.clearSegment = false;
        }

        protected boolean process(int n) throws IOException, RuntimeModelException {
            switch (n & 0xFFF) {
                case 0: {
                    this.enter(false);
                    boolean bl = this.process(null);
                    this.leave();
                    return bl;
                }
            }
            throw new IOException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(int[] nArray) throws IOException, RuntimeModelException {
            boolean bl = false;
            if (nArray == null) {
                int n = this.readItem();
                while (n >= 0) {
                    bl |= this.process(n);
                    n = this.next();
                }
            } else {
                try {
                    block4: for (int i = 0; i < nArray.length; ++i) {
                        int n;
                        int n2 = nArray[i];
                        if (n2 < 0) continue;
                        HierarchicalQueue.Cursor cursor = (HierarchicalQueue.Cursor)GraphQueue.this.segments.get(n2 + 1);
                        int n3 = n = GraphQueue.this.clearInapplicable ? 1 : 0;
                        while (n >= 0) {
                            this.execute = !GraphQueue.this.clearInapplicable;
                            this.checkApplicability = n == 1;
                            this.markApplicability = GraphQueue.this.clearInapplicable && n == 0;
                            int n4 = this.moveTo((HierarchicalQueue.Cursor)GraphQueue.this.segments.get(n2));
                            while (n4 >= 0 && !this.isAt(cursor)) {
                                this.clearSegment = false;
                                bl |= this.process(n4);
                                if (this.clearSegment) {
                                    nArray[i] = -1;
                                    continue block4;
                                }
                                n4 = this.next();
                            }
                            --n;
                        }
                    }
                }
                finally {
                    this.execute = true;
                    this.checkApplicability = false;
                    this.markApplicability = false;
                }
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExecuteDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{DELETE_NODE_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return DESCRIPTOR_0;
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeleteNodeDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{ADD_NODE_DESCRIPTOR, CONNECT_DESCRIPTOR, ADD_EDGE_DESCRIPTOR, ADD_UNDIRECTED_EDGE_DESCRIPTOR, DELETE_EDGE_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{EXECUTE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeleteEdgeDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{ADD_NODE_DESCRIPTOR, CONNECT_DESCRIPTOR, ADD_EDGE_DESCRIPTOR, ADD_UNDIRECTED_EDGE_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{DELETE_NODE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AddUndirectedEdgeDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{ADD_NODE_DESCRIPTOR, CONNECT_DESCRIPTOR, ADD_EDGE_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{DELETE_EDGE_DESCRIPTOR, DELETE_NODE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AddEdgeDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{ADD_NODE_DESCRIPTOR, CONNECT_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{ADD_UNDIRECTED_EDGE_DESCRIPTOR, DELETE_EDGE_DESCRIPTOR, DELETE_NODE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConnectDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{ADD_NODE_DESCRIPTOR};
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{ADD_EDGE_DESCRIPTOR, ADD_UNDIRECTED_EDGE_DESCRIPTOR, DELETE_EDGE_DESCRIPTOR, DELETE_NODE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AddNodeDescriptor
    extends QueueDescriptor<GraphQueue> {
        @Override
        protected QueueDescriptor[] queuesToProcessBefore() {
            return DESCRIPTOR_0;
        }

        @Override
        protected QueueDescriptor[] queuesToProcessAfter() {
            return new QueueDescriptor[]{CONNECT_DESCRIPTOR, ADD_EDGE_DESCRIPTOR, ADD_UNDIRECTED_EDGE_DESCRIPTOR, DELETE_EDGE_DESCRIPTOR, DELETE_NODE_DESCRIPTOR};
        }

        @Override
        public GraphQueue createQueue(QueueCollection queueCollection) {
            return ((Graph)queueCollection.getGraph()).createQueue(queueCollection, this);
        }
    }
}

