/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.SelectLineRange;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class JEditTextArea
extends JComponent {
    public Exception trace;
    public static int NO_SCROLL = 0;
    public static int NORMAL_SCROLL = 1;
    public static int ELECTRIC_SCROLL = 2;
    Segment lineSegment;
    MouseHandler mouseHandler;
    ChunkCache chunkCache;
    DisplayManager displayManager;
    boolean bufferChanging;
    int maxHorizontalScrollWidth;
    String wrap;
    boolean hardWrap;
    float tabSize;
    int charWidth;
    int maxLineLen;
    boolean scrollBarsInitialized;
    Vector selection;
    Point returnValue;
    boolean lastLinePartial;
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private static final String BOTTOM = "bottom";
    private static final String TOP = "top";
    private static Timer caretTimer = new Timer(500, new CaretBlinker());
    private static Timer structureTimer;
    private static JEditTextArea focusedComponent;
    private View view;
    private Gutter gutter;
    private TextAreaPainter painter;
    private JPopupMenu popup;
    private boolean popupEnabled;
    private EventListenerList listenerList;
    private MutableCaretEvent caretEvent;
    private boolean caretBlinks;
    private boolean blink;
    private int physLastLine;
    private int screenLastLine;
    private int visibleLines;
    private int electricScroll;
    private int horizontalOffset;
    private boolean quickCopy;
    private Box verticalBox;
    private JScrollBar vertical;
    private JScrollBar horizontal;
    private Buffer buffer;
    private int caret;
    private int caretLine;
    private int caretScreenLine;
    private List structureMatchers;
    private StructureMatcher.Match match;
    private int magicCaret;
    private boolean multi;
    private boolean overwrite;
    private boolean rectangularSelectionMode;
    private boolean dndEnabled;
    private Method dndCallback;
    private boolean dndInProgress;
    private boolean queuedCaretUpdate;
    private boolean queuedScrollToElectric;
    private boolean queuedFireCaretEvent;

    public JEditTextArea(View view) {
        this.enableEvents(12L);
        this.view = view;
        this.selection = new Vector();
        this.chunkCache = new ChunkCache(this);
        this.painter = new TextAreaPainter(this);
        this.gutter = new Gutter(view, this);
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.blink = true;
        this.lineSegment = new Segment();
        this.returnValue = new Point();
        this.structureMatchers = new LinkedList();
        this.structureMatchers.add(new StructureMatcher.BracketMatcher());
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this.painter);
        this.add(LEFT, this.gutter);
        this.verticalBox = new Box(0);
        this.vertical = new JScrollBar(1);
        this.verticalBox.add(this.vertical);
        this.vertical.setRequestFocusEnabled(false);
        this.add(RIGHT, this.verticalBox);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.horizontal.setRequestFocusEnabled(false);
        this.horizontal.setValues(0, 0, 0, 0);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setBorder(new TextAreaBorder());
            this.vertical.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.horizontal.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.mouseHandler = new MouseHandler();
        this.painter.addMouseListener(this.mouseHandler);
        this.painter.addMouseMotionListener(this.mouseHandler);
        this.addFocusListener(new FocusHandler());
        focusedComponent = this;
        this.popupEnabled = true;
    }

    public void dispose() {
        DisplayManager.textAreaDisposed(this);
    }

    public View getView() {
        return this.view;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        if (this.buffer != null) {
            this.invalidateLine(this.caretLine);
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public final boolean isQuickCopyEnabled() {
        return this.quickCopy;
    }

    public final void setQuickCopyEnabled(boolean bl) {
        this.quickCopy = bl;
    }

    public final Buffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(Buffer buffer) {
        if (this.buffer == buffer) {
            return;
        }
        try {
            this.bufferChanging = true;
            if (this.buffer != null) {
                this.selectNone();
                this.caretScreenLine = 0;
                this.caret = 0;
                this.caretLine = 0;
                this.match = null;
            }
            this.buffer = buffer;
            this.chunkCache.setBuffer(buffer);
            this.propertiesChanged();
            if (this.displayManager != null) {
                DisplayManager.releaseDisplayManager(this.displayManager);
            }
            this.displayManager = DisplayManager.getDisplayManager(buffer, this);
            this.displayManager.init();
            if (!buffer.isLoaded()) {
                this.updateScrollBars();
            }
            this.repaint();
            this.fireScrollEvent(true);
        }
        finally {
            this.bufferChanging = false;
        }
    }

    public final boolean isEditable() {
        return this.buffer.isEditable();
    }

    public Method getDragAndDropCallback() {
        return this.dndCallback;
    }

    public void setDragAndDropCallback(Method method) {
        this.dndCallback = method;
    }

    public boolean isDragInProgress() {
        return this.dndInProgress;
    }

    public void setDragInProgress(boolean bl) {
        this.dndInProgress = bl;
    }

    public boolean isDragEnabled() {
        return this.dndEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dndEnabled = bl;
    }

    public final int getFirstLine() {
        return this.displayManager.firstLine.scrollLine + this.displayManager.firstLine.skew;
    }

    public void setFirstLine(int n) {
        int n2;
        int n3;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstLine() from " + this.getFirstLine() + " to " + n);
        }
        if (n > (n3 = this.displayManager.getScrollLineCount() - this.visibleLines + (this.lastLinePartial ? 1 : 0))) {
            n = n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n == (n2 = this.getFirstLine())) {
            return;
        }
        this.trace = new Exception();
        if (n >= n2 + this.visibleLines) {
            this.displayManager.firstLine.scrollDown(n - n2);
            this.chunkCache.invalidateAll();
        } else if (n <= n2 - this.visibleLines) {
            this.displayManager.firstLine.scrollUp(n2 - n);
            this.chunkCache.invalidateAll();
        } else if (n > n2) {
            this.displayManager.firstLine.scrollDown(n - n2);
            this.chunkCache.scrollDown(n - n2);
        } else if (n < n2) {
            this.displayManager.firstLine.scrollUp(n2 - n);
            this.chunkCache.scrollUp(n2 - n);
        }
        this.displayManager._notifyScreenLineChanges();
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getFirstPhysicalLine() {
        return this.displayManager.firstLine.physicalLine;
    }

    public void setFirstPhysicalLine(int n) {
        this.setFirstPhysicalLine(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFirstPhysicalLine(int n, int n2) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstPhysicalLine(" + n + "," + n2 + ")");
        }
        int n3 = n - this.displayManager.firstLine.physicalLine;
        int n4 = this.getFirstLine();
        if (n3 == 0) {
            if ((n2 -= this.displayManager.firstLine.skew) < 0) {
                this.displayManager.firstLine.scrollUp(-n2);
            } else {
                if (n2 <= 0) return;
                this.displayManager.firstLine.scrollDown(n2);
            }
        } else if (n3 > 0) {
            this.displayManager.firstLine.physDown(n3, n2);
        } else if (n3 < 0) {
            this.displayManager.firstLine.physUp(-n3, n2);
        }
        int n5 = this.getFirstLine();
        if (n5 != n4) {
            if (n5 >= n4 + this.visibleLines || n5 <= n4 - this.visibleLines) {
                this.chunkCache.invalidateAll();
            } else if (n5 > n4) {
                this.chunkCache.scrollDown(n5 - n4);
            } else if (n5 < n4) {
                this.chunkCache.scrollUp(n4 - n5);
            }
        }
        this.displayManager._notifyScreenLineChanges();
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getLastPhysicalLine() {
        return this.physLastLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        if (n > 0) {
            n = 0;
        }
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        if (n != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
        this.fireScrollEvent(false);
    }

    public void scrollUpLine() {
        this.setFirstLine(this.getFirstLine() - 1);
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownLine() {
        this.setFirstLine(this.getFirstLine() + 1);
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public void scrollToCaret(boolean bl) {
        this.scrollTo(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), bl);
    }

    public void scrollTo(int n, boolean bl) {
        int n2 = this.buffer.getLineOfOffset(n);
        this.scrollTo(n2, n - this.buffer.getLineStartOffset(n2), bl);
    }

    public void scrollTo(int n, int n2, boolean bl) {
        Object object;
        int n3;
        int n4;
        int n5;
        if (Debug.SCROLL_TO_DEBUG) {
            Log.log(1, this, "scrollTo(), lineCount=" + this.getLineCount());
        }
        if (n2 > (n5 = this.buffer.getLineLength(n))) {
            n4 = this.charWidth * (n2 - n5);
            n2 = n5;
        } else {
            n4 = 0;
        }
        int n6 = n3 = bl && this.visibleLines - 1 > this.electricScroll * 2 ? this.electricScroll : 0;
        if (this.visibleLines <= 1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "visibleLines <= 0");
            }
            this.setFirstPhysicalLine(n, n3);
            return;
        }
        int n7 = this.chunkCache.getScreenLineOfOffset(n, n2);
        int n8 = this.getVisibleLines();
        if (n7 == -1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "screenLine == -1");
            }
            object = this.chunkCache.getLineInfosForPhysicalLine(n);
            int n9 = this.chunkCache.getSubregionOfOffset(n2, (ChunkCache.LineInfo[])object);
            int n10 = this.displayManager.getPrevVisibleLine(this.getFirstPhysicalLine());
            int n11 = this.displayManager.getNextVisibleLine(this.getLastPhysicalLine());
            if (n == this.getFirstPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + this.getFirstPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 - n3);
            } else if (n == n10) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + n10);
                }
                this.setFirstPhysicalLine(n10, n9 - n3);
            } else if (n == this.getLastPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 + n3 - n8 + (this.lastLinePartial ? 2 : 1));
            } else if (n == n11) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + n11);
                }
                this.setFirstPhysicalLine(n11, n9 + this.electricScroll - n8 + (this.lastLinePartial ? 2 : 1));
            } else {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "neither");
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 - n8 / 2);
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
            }
        } else if (n7 < n3) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric up");
            }
            this.setFirstLine(this.getFirstLine() - n3 + n7);
        } else if (n7 > n8 - n3 - (this.lastLinePartial ? 2 : 1)) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric down");
            }
            this.setFirstLine(this.getFirstLine() + n3 - n8 + n7 + (this.lastLinePartial ? 2 : 1));
        }
        if (!this.displayManager.isLineVisible(n)) {
            return;
        }
        object = this.offsetToXY(n, n2, this.returnValue);
        if (object == null) {
            Log.log(9, this, "BUG: screenLine=" + n7 + ",visibleLines=" + n8 + ",physicalLine=" + n + ",firstPhysicalLine=" + this.getFirstPhysicalLine() + ",lastPhysicalLine=" + this.getLastPhysicalLine());
        }
        object.x += n4;
        if (object.x < 0) {
            this.setHorizontalOffset(this.horizontalOffset - object.x + this.charWidth + 5);
        } else if (object.x >= this.painter.getWidth() - this.charWidth - 5) {
            this.setHorizontalOffset(this.horizontalOffset + (this.painter.getWidth() - object.x) - this.charWidth - 5);
        }
    }

    public final void addScrollListener(ScrollListener scrollListener) {
        this.listenerList.add(ScrollListener.class, scrollListener);
    }

    public final void removeScrollListener(ScrollListener scrollListener) {
        this.listenerList.remove(ScrollListener.class, scrollListener);
    }

    public int getPhysicalLineOfScreenLine(int n) {
        return this.chunkCache.getLineInfo((int)n).physicalLine;
    }

    public int getScreenLineOfOffset(int n) {
        int n2 = this.buffer.getLineOfOffset(n);
        return this.chunkCache.getScreenLineOfOffset(n2, n -= this.buffer.getLineStartOffset(n2));
    }

    public int getScreenLineStartOffset(int n) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    public int getScreenLineEndOffset(int n) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    public int xyToOffset(int n, int n2) {
        return this.xyToOffset(n, n2, true);
    }

    public int xyToOffset(int n, int n2, boolean bl) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = n2 / n3;
        if (n4 < 0 || n4 >= this.visibleLines) {
            return -1;
        }
        return this.xToScreenLineOffset(n4, n, bl);
    }

    public int xToScreenLineOffset(int n, int n2, boolean bl) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        }
        int n3 = Chunk.xToOffset(lineInfo.chunks, n2 - this.horizontalOffset, bl);
        if (n3 == -1 || n3 == lineInfo.offset + lineInfo.length) {
            n3 = lineInfo.offset + lineInfo.length - 1;
        }
        return this.getLineStartOffset(lineInfo.physicalLine) + n3;
    }

    public Point offsetToXY(int n) {
        int n2 = this.buffer.getLineOfOffset(n);
        Point point = new Point();
        return this.offsetToXY(n2, n -= this.buffer.getLineStartOffset(n2), point);
    }

    public Point offsetToXY(int n, int n2, Point point) {
        if (!this.displayManager.isLineVisible(n)) {
            return null;
        }
        int n3 = this.chunkCache.getScreenLineOfOffset(n, n2);
        if (n3 == -1) {
            return null;
        }
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        point.y = n3 * fontMetrics.getHeight();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n3);
        point.x = (int)((float)this.horizontalOffset + Chunk.offsetToX(lineInfo.chunks, n2));
        return point;
    }

    public void invalidateScreenLineRange(int n, int n2) {
        if (!this.buffer.isLoaded()) {
            return;
        }
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        if (this.chunkCache.needFullRepaint()) {
            n2 = this.visibleLines;
        }
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n4 = n * fontMetrics.getHeight();
        int n5 = (n2 - n + 1) * fontMetrics.getHeight();
        this.painter.repaint(0, n4, this.painter.getWidth(), n5);
        this.gutter.repaint(0, n4, this.gutter.getWidth(), n5);
    }

    public void invalidateLine(int n) {
        if (!(this.isShowing() && this.buffer.isLoaded() && n >= this.getFirstPhysicalLine() && n <= this.physLastLine && this.displayManager.isLineVisible(n))) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if ((lineInfo.physicalLine >= n || lineInfo.physicalLine == -1) && n2 == -1) {
                n2 = i;
            }
            if ((lineInfo.physicalLine < n || !lineInfo.lastSubregion) && lineInfo.physicalLine != -1) continue;
            n3 = i;
            break;
        }
        if (this.chunkCache.needFullRepaint() || n3 == -1) {
            n3 = this.visibleLines;
        }
        this.invalidateScreenLineRange(n2, n3);
    }

    public void invalidateLineRange(int n, int n2) {
        int n3;
        if (!this.isShowing() || !this.buffer.isLoaded()) {
            return;
        }
        if (n2 < n) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        if (n2 < this.getFirstPhysicalLine() || n > this.getLastPhysicalLine()) {
            return;
        }
        n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if ((lineInfo.physicalLine >= n || lineInfo.physicalLine == -1) && n3 == -1) {
                n3 = i;
            }
            if ((lineInfo.physicalLine < n2 || !lineInfo.lastSubregion) && lineInfo.physicalLine != -1) continue;
            n4 = i;
            break;
        }
        if (n3 == -1) {
            n3 = 0;
        }
        if (this.chunkCache.needFullRepaint() || n4 == -1) {
            n4 = this.visibleLines;
        }
        this.invalidateScreenLineRange(n3, n4);
    }

    public void invalidateSelectedLines() {
        this.invalidateLine(this.caretLine);
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection = (Selection)this.selection.elementAt(i);
            this.invalidateLineRange(selection.startLine, selection.endLine);
        }
    }

    public final int getBufferLength() {
        return this.buffer.getLength();
    }

    public final int getLineCount() {
        return this.buffer.getLineCount();
    }

    public final int getLineOfOffset(int n) {
        return this.buffer.getLineOfOffset(n);
    }

    public int getLineStartOffset(int n) {
        return this.buffer.getLineStartOffset(n);
    }

    public int getLineEndOffset(int n) {
        return this.buffer.getLineEndOffset(n);
    }

    public int getLineLength(int n) {
        return this.buffer.getLineLength(n);
    }

    public final String getText(int n, int n2) {
        return this.buffer.getText(n, n2);
    }

    public final void getText(int n, int n2, Segment segment) {
        this.buffer.getText(n, n2, segment);
    }

    public final String getLineText(int n) {
        return this.buffer.getLineText(n);
    }

    public final void getLineText(int n, Segment segment) {
        this.buffer.getLineText(n, segment);
    }

    public String getText() {
        return this.buffer.getText(0, this.buffer.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, string);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public final void selectAll() {
        this.setSelection(new Selection.Range(0, this.buffer.getLength()));
        this.moveCaretPosition(this.buffer.getLength(), true);
    }

    public void selectLine() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n) - 1;
        Selection.Range range = new Selection.Range(n2, n3);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n3);
    }

    public void selectParagraph() {
        int n;
        int n2 = this.getCaretLine();
        if (this.getLineLength(n2) == 0) {
            this.getToolkit().beep();
            return;
        }
        int n3 = n2;
        for (n = n2; n >= 0 && this.getLineLength(n) != 0; --n) {
        }
        while (n3 < this.getLineCount() && this.getLineLength(n3) != 0) {
            ++n3;
        }
        int n4 = this.getLineStartOffset(n + 1);
        int n5 = this.getLineEndOffset(n3 - 1) - 1;
        Selection.Range range = new Selection.Range(n4, n5);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n5);
    }

    public void selectWord() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getCaretPosition() - n2;
        if (this.getLineLength(n) == 0) {
            return;
        }
        String string = this.getLineText(n);
        String string2 = this.buffer.getStringProperty("noWordSep");
        if (n3 == this.getLineLength(n)) {
            --n3;
        }
        int n4 = TextUtilities.findWordStart(string, n3, string2);
        int n5 = TextUtilities.findWordEnd(string, n3 + 1, string2);
        Selection.Range range = new Selection.Range(n2 + n4, n2 + n5);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n2 + n5);
    }

    public Selection selectToMatchingBracket(int n, boolean bl) {
        int n2;
        int n3 = this.buffer.getLineOfOffset(n);
        int n4 = n - this.buffer.getLineStartOffset(n3);
        if (this.getLineLength(n3) != 0 && (n2 = TextUtilities.findMatchingBracket(this.buffer, n3, Math.max(0, n4 - 1))) != -1) {
            Selection.Range range;
            if (n2 < n) {
                if (!bl) {
                    this.moveCaretPosition(n, false);
                }
                range = new Selection.Range(n2, n);
            } else {
                if (!bl) {
                    this.moveCaretPosition(n2 + 1, false);
                }
                range = new Selection.Range(n - 1, n2 + 1);
            }
            if (!this.multi && !bl) {
                this.selectNone();
            }
            this.addToSelection(range);
            return range;
        }
        return null;
    }

    public void selectToMatchingBracket() {
        this.selectToMatchingBracket(this.caret, false);
    }

    public void selectBlock() {
        char c;
        int n;
        int n2;
        String string = "([{";
        String string2 = ")]}";
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (selection == null) {
            n = n2 = this.caret;
        } else {
            n = selection.start;
            n2 = selection.end;
        }
        String string3 = this.getText(0, this.buffer.getLength());
        int n3 = 1;
        char c2 = '\u0000';
        char c3 = '\u0000';
        if (n == 0) {
            this.getToolkit().beep();
            return;
        }
        while (--n > 0) {
            c = string3.charAt(n);
            int n4 = string.indexOf(c);
            if (n4 != -1) {
                if (--n3 != 0) continue;
                c2 = c;
                c3 = string2.charAt(n4);
                break;
            }
            if (string2.indexOf(c) == -1) continue;
            ++n3;
        }
        n3 = 1;
        if (c2 == '\u0000') {
            this.getToolkit().beep();
            return;
        }
        do {
            if ((c = string3.charAt(n2)) == c3) {
                if (--n3 != 0) continue;
                ++n2;
                break;
            }
            if (c != c2) continue;
            ++n3;
        } while (++n2 < this.buffer.getLength());
        selection = new Selection.Range(n, n2);
        if (this.multi) {
            this.addToSelection(selection);
        } else {
            this.setSelection(selection);
        }
        this.moveCaretPosition(n2);
    }

    public boolean lineInStructureScope(int n) {
        if (this.match == null) {
            return false;
        }
        if (this.match.startLine < this.caretLine) {
            return n >= this.match.startLine && n <= this.caretLine;
        }
        return n <= this.match.endLine && n >= this.caretLine;
    }

    public final void invertSelection() {
        Selection[] selectionArray = new Selection[this.selection.size() + 1];
        int n = 0;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection = (Selection)this.selection.elementAt(i);
            selectionArray[i] = new Selection.Range(n, selection.getStart());
            n = selection.getEnd();
        }
        selectionArray[this.selection.size()] = new Selection.Range(n, this.buffer.getLength());
        this.setSelection(selectionArray);
    }

    public int getSelectionCount() {
        return this.selection.size();
    }

    public Selection[] getSelection() {
        Object[] objectArray = new Selection[this.selection.size()];
        this.selection.copyInto(objectArray);
        return objectArray;
    }

    public void selectNone() {
        this.setSelection((Selection)null);
    }

    public void setSelection(Selection[] selectionArray) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        if (selectionArray != null) {
            for (int i = 0; i < selectionArray.length; ++i) {
                this._addToSelection(selectionArray[i]);
            }
        }
        this.fireCaretEvent();
    }

    public void setSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        if (selection != null) {
            this._addToSelection(selection);
        }
        this.fireCaretEvent();
    }

    public void addToSelection(Selection[] selectionArray) {
        if (selectionArray != null) {
            for (int i = 0; i < selectionArray.length; ++i) {
                this._addToSelection(selectionArray[i]);
            }
        }
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void addToSelection(Selection selection) {
        this._addToSelection(selection);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public Selection getSelectionAtOffset(int n) {
        if (this.selection != null) {
            for (int i = 0; i < this.selection.size(); ++i) {
                Selection selection = (Selection)this.selection.elementAt(i);
                if (n < selection.start || n > selection.end) continue;
                return selection;
            }
        }
        return null;
    }

    public void removeFromSelection(Selection selection) {
        this.selection.removeElement(selection);
        this.invalidateLineRange(selection.startLine, selection.endLine);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void removeFromSelection(int n) {
        Selection selection = this.getSelectionAtOffset(n);
        if (selection == null) {
            return;
        }
        this.selection.removeElement(selection);
        this.invalidateLineRange(selection.startLine, selection.endLine);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void resizeSelection(int n, int n2, int n3, boolean bl) {
        Selection selection;
        Selection selection2 = this.getSelectionAtOffset(n);
        if (selection2 != null) {
            this.invalidateLineRange(selection2.startLine, selection2.endLine);
            this.selection.removeElement(selection2);
        }
        boolean bl2 = false;
        if (n2 < n) {
            int n4 = n;
            n = n2;
            n2 = n4;
            bl2 = true;
        }
        if (bl) {
            Selection.Rect rect = new Selection.Rect(n, n2);
            if (bl2) {
                rect.extraStartVirt = n3;
            } else {
                rect.extraEndVirt = n3;
            }
            selection = rect;
        } else {
            selection = new Selection.Range(n, n2);
        }
        this._addToSelection(selection);
        this.fireCaretEvent();
    }

    public void extendSelection(int n, int n2) {
        this.extendSelection(n, n2, 0, 0);
    }

    public void extendSelection(int n, int n2, int n3, int n4) {
        int n5;
        Selection selection = this.getSelectionAtOffset(n);
        if (selection != null) {
            this.invalidateLineRange(selection.startLine, selection.endLine);
            this.selection.removeElement(selection);
            if (n == selection.start) {
                n = n2;
                n2 = selection.end;
            } else if (n == selection.end) {
                n = selection.start;
            }
        }
        if (n2 < n) {
            n5 = n2;
            n2 = n;
            n = n5;
        }
        if (this.rectangularSelectionMode) {
            selection = new Selection.Rect(n, n2);
            ((Selection.Rect)selection).extraStartVirt = n3;
            ((Selection.Rect)selection).extraEndVirt = n4;
        } else {
            selection = new Selection.Range(n, n2);
        }
        this._addToSelection(selection);
        this.fireCaretEvent();
        if (this.rectangularSelectionMode && n4 != 0) {
            n5 = this.getLineOfOffset(n2);
            this.scrollTo(n5, this.getLineLength(n5) + n4, false);
        }
    }

    public String getSelectedText(Selection selection) {
        StringBuffer stringBuffer = new StringBuffer();
        selection.getText(this.buffer, stringBuffer);
        return stringBuffer.toString();
    }

    public String getSelectedText(String string) {
        if (this.selection.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.selection.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(string);
            }
            ((Selection)this.selection.elementAt(i)).getText(this.buffer, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String getSelectedText() {
        return this.getSelectedText("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(Selection selection, String string) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        try {
            this.buffer.beginCompoundEdit();
            this.moveCaretPosition(selection.setText(this.buffer, string));
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void setSelectedText(String string) {
        this.setSelectedText(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(String string, boolean bl) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        Selection[] selectionArray = this.getSelection();
        if (selectionArray.length == 0) {
            this.buffer.insert(this.caret, string);
        } else {
            try {
                int n = -1;
                this.buffer.beginCompoundEdit();
                for (int i = 0; i < selectionArray.length; ++i) {
                    n = selectionArray[i].setText(this.buffer, string);
                }
                if (bl) {
                    this.moveCaretPosition(n);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
        this.selectNone();
    }

    public int[] getSelectedLines() {
        if (this.selection.size() == 0) {
            return new int[]{this.caretLine};
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection = (Selection)this.selection.elementAt(i);
            int n = selection.end == this.getLineStartOffset(selection.endLine) ? selection.endLine - 1 : selection.endLine;
            for (int j = selection.startLine; j <= n; ++j) {
                Integer n2 = new Integer(j);
                treeSet.add(n2);
            }
        }
        int[] nArray = new int[treeSet.size()];
        int n = 0;
        for (Integer n2 : treeSet) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public void showSelectLineRangeDialog() {
        new SelectLineRange(this.view);
    }

    public void addStructureMatcher(StructureMatcher structureMatcher) {
        this.structureMatchers.add(structureMatcher);
    }

    public void removeStructureMatcher(StructureMatcher structureMatcher) {
        this.structureMatchers.remove(structureMatcher);
    }

    public StructureMatcher.Match getStructureMatch() {
        return this.match;
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.invalidateLine(this.caretLine);
        } else {
            this.blink = true;
        }
    }

    public void centerCaret() {
        int n = this.getScreenLineStartOffset(this.visibleLines / 2);
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            this.setCaretPosition(n);
        }
    }

    public void setCaretPosition(int n) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        this.moveCaretPosition(n, true);
    }

    public void setCaretPosition(int n, boolean bl) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        this.moveCaretPosition(n, bl);
    }

    public void moveCaretPosition(int n) {
        this.moveCaretPosition(n, true);
    }

    public void moveCaretPosition(int n, boolean bl) {
        this.moveCaretPosition(n, bl ? ELECTRIC_SCROLL : NORMAL_SCROLL);
    }

    public void moveCaretPosition(int n, int n2) {
        if (n < 0 || n > this.buffer.getLength()) {
            throw new IllegalArgumentException("caret out of bounds: " + n);
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            this.match = null;
        }
        if (this.caret == n) {
            if (n2 == NORMAL_SCROLL) {
                this.finishCaretUpdate(false, false);
            } else if (n2 == ELECTRIC_SCROLL) {
                this.finishCaretUpdate(true, false);
            }
        } else {
            int n3 = this.getLineOfOffset(n);
            this.magicCaret = -1;
            if (this.caretLine == n3) {
                if (this.caretScreenLine != -1) {
                    this.invalidateScreenLineRange(this.caretScreenLine, this.caretScreenLine);
                }
            } else {
                int n4 = this.chunkCache.getScreenLineOfOffset(n3, n - this.buffer.getLineStartOffset(n3));
                if (this.caretScreenLine == -1) {
                    this.invalidateScreenLineRange(n4, n4);
                } else {
                    this.invalidateScreenLineRange(this.caretScreenLine, n4);
                }
                this.caretScreenLine = n4;
            }
            this.caret = n;
            this.caretLine = n3;
            if (n2 == NORMAL_SCROLL) {
                this.finishCaretUpdate(false, true);
            } else if (n2 == ELECTRIC_SCROLL) {
                this.finishCaretUpdate(true, true);
            }
        }
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public int getMagicCaretPosition() {
        if (this.magicCaret == -1) {
            this.magicCaret = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        }
        return this.magicCaret;
    }

    public void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    public final void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    public final void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    public void goToNextBracket(boolean bl) {
        int n = -1;
        if (this.caret != this.buffer.getLength()) {
            String string = this.getText(this.caret, this.buffer.getLength() - this.caret - 1);
            block3: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        n = this.caret + i + 1;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            if (bl) {
                this.extendSelection(this.caret, n);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void goToNextCharacter(boolean bl) {
        int n;
        int n2;
        int n3;
        block17: {
            block19: {
                Selection selection;
                block18: {
                    selection = this.getSelectionAtOffset(this.caret);
                    if (!bl && selection instanceof Selection.Range) {
                        if (!this.multi) {
                            this.setCaretPosition(selection.end);
                            return;
                        }
                        if (this.caret != selection.end) {
                            this.moveCaretPosition(selection.end);
                            return;
                        }
                    }
                    if (selection instanceof Selection.Rect) {
                        n3 = ((Selection.Rect)selection).extraStartVirt;
                        n2 = ((Selection.Rect)selection).extraEndVirt;
                    } else {
                        n3 = 0;
                        n2 = 0;
                    }
                    n = this.caret;
                    if (this.caret != this.buffer.getLength()) break block18;
                    if (bl && (this.rectangularSelectionMode || selection instanceof Selection.Rect)) {
                        if (selection != null && this.caret == selection.start) {
                            ++n3;
                            break block17;
                        } else {
                            ++n2;
                        }
                        break block17;
                    } else {
                        this.getToolkit().beep();
                        return;
                    }
                }
                if (this.caret != this.getLineEndOffset(this.caretLine) - 1) break block19;
                if (bl && (this.rectangularSelectionMode || selection instanceof Selection.Rect)) {
                    if (selection != null && this.caret == selection.start) {
                        ++n3;
                        break block17;
                    } else {
                        ++n2;
                    }
                    break block17;
                } else {
                    int n4 = this.displayManager.getNextVisibleLine(this.caretLine);
                    if (n4 == -1) {
                        this.getToolkit().beep();
                        return;
                    }
                    n = this.getLineStartOffset(n4);
                }
                break block17;
            }
            n = this.caret + 1;
        }
        if (bl) {
            this.extendSelection(this.caret, n, n3, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToNextLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        boolean bl2 = selection == null ? this.rectangularSelectionMode : selection instanceof Selection.Rect;
        int n = this.getMagicCaretPosition();
        int n2 = this.chunkCache.getBelowPosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), n + 1, bl2 && bl);
        if (n2 == -1) {
            int n3 = this.getLineEndOffset(this.caretLine) - 1;
            if (this.caret == n3) {
                this.getToolkit().beep();
                return;
            }
            n2 = n3;
        }
        if (bl) {
            int n4;
            int n5;
            RectParams rectParams = this.getRectParams(this.caret, n2);
            if (rectParams == null) {
                n5 = 0;
                n4 = 0;
            } else {
                n5 = rectParams.extraStartVirt;
                n4 = rectParams.extraEndVirt;
                n2 = rectParams.newCaret;
            }
            this.extendSelection(this.caret, n2, n5, n4);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
        this.setMagicCaretPosition(n);
    }

    public void goToNextMarker(boolean bl) {
        Vector vector = this.buffer.getMarkers();
        if (vector.size() == 0) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        for (int i = 0; i < vector.size(); ++i) {
            Marker marker2 = (Marker)vector.get(i);
            if (marker2.getPosition() <= this.caret) continue;
            marker = marker2;
            break;
        }
        if (marker == null) {
            marker = (Marker)vector.get(0);
        }
        if (bl) {
            this.extendSelection(this.caret, marker.getPosition());
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(marker.getPosition());
    }

    public void goToNextPage(boolean bl) {
        int n;
        this.scrollToCaret(false);
        int n2 = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() + this.getVisibleLines() >= this.displayManager.getScrollLineCount()) {
            int n3 = this.displayManager.getLastVisibleLine();
            n = this.getLineEndOffset(n3) - 1;
        } else {
            int n4 = this.getScreenLineOfOffset(this.caret);
            this.scrollDownPage();
            n = this.xToScreenLineOffset(n4, n2, true);
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n, false);
        this.setMagicCaretPosition(n2);
    }

    public void goToNextParagraph(boolean bl) {
        int n = this.getCaretLine();
        int n2 = this.getBufferLength();
        boolean bl2 = false;
        block3: for (int i = n + 1; i < this.getLineCount(); ++i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!bl2) continue block3;
                        n2 = this.getLineStartOffset(i);
                        break block3;
                    }
                }
            }
            bl2 = true;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToNextWord(boolean bl) {
        this.goToNextWord(bl, false);
    }

    public void goToNextWord(boolean bl, boolean bl2) {
        String string;
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        if (n2 == (string = this.getLineText(this.caretLine)).length()) {
            int n3 = this.displayManager.getNextVisibleLine(this.caretLine);
            if (n3 == -1) {
                this.getToolkit().beep();
                return;
            }
            n2 = this.getLineStartOffset(n3);
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            n2 = TextUtilities.findWordEnd(string, n2 + 1, string2, true, bl2);
            n2 += n;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToPrevBracket(boolean bl) {
        String string = this.getText(0, this.caret);
        int n = -1;
        block3: for (int i = this.getCaretPosition() - 1; i >= 0; --i) {
            switch (string.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    n = i;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            if (bl) {
                this.extendSelection(this.caret, n);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(n);
        }
    }

    public void goToPrevCharacter(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (!bl && selection instanceof Selection.Range) {
            if (this.multi) {
                if (this.caret != selection.start) {
                    this.moveCaretPosition(selection.start);
                    return;
                }
            } else {
                this.setCaretPosition(selection.start);
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.caret;
        if (bl && this.caret == this.getLineEndOffset(this.caretLine) - 1) {
            if (selection instanceof Selection.Rect) {
                n = ((Selection.Rect)selection).extraStartVirt;
                n2 = ((Selection.Rect)selection).extraEndVirt;
                if (this.caret == selection.start) {
                    if (n == 0) {
                        n3 = this.caret - 1;
                    } else {
                        --n;
                    }
                } else if (n2 == 0) {
                    n3 = this.caret - 1;
                } else {
                    --n2;
                }
            } else {
                n3 = this.caret - 1;
            }
        } else if (this.caret == this.getLineStartOffset(this.caretLine)) {
            int n4 = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (n4 == -1) {
                this.getToolkit().beep();
                return;
            }
            n3 = this.getLineEndOffset(n4) - 1;
        } else {
            n3 = this.caret - 1;
        }
        if (bl) {
            this.extendSelection(this.caret, n3, n, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToPrevLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        boolean bl2 = selection == null ? this.rectangularSelectionMode : selection instanceof Selection.Rect;
        int n = this.getMagicCaretPosition();
        int n2 = this.chunkCache.getAbovePosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), n + 1, bl2 && bl);
        if (n2 == -1) {
            int n3 = this.getLineStartOffset(this.caretLine);
            if (this.caret == n3) {
                this.getToolkit().beep();
                return;
            }
            n2 = n3;
        }
        if (bl) {
            int n4;
            int n5;
            RectParams rectParams = this.getRectParams(this.caret, n2);
            if (rectParams == null) {
                n5 = 0;
                n4 = 0;
            } else {
                n5 = rectParams.extraStartVirt;
                n4 = rectParams.extraEndVirt;
                n2 = rectParams.newCaret;
            }
            this.extendSelection(this.caret, n2, n5, n4);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
        this.setMagicCaretPosition(n);
    }

    public void goToPrevMarker(boolean bl) {
        Vector vector = this.buffer.getMarkers();
        if (vector.size() == 0) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        for (int i = vector.size() - 1; i >= 0; --i) {
            Marker marker2 = (Marker)vector.elementAt(i);
            if (marker2.getPosition() >= this.caret) continue;
            marker = marker2;
            break;
        }
        if (marker == null) {
            marker = (Marker)vector.get(vector.size() - 1);
        }
        if (bl) {
            this.extendSelection(this.caret, marker.getPosition());
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(marker.getPosition());
    }

    public void goToPrevPage(boolean bl) {
        int n;
        this.scrollToCaret(false);
        int n2 = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() == 0) {
            int n3 = this.displayManager.getFirstVisibleLine();
            n = this.getLineStartOffset(n3);
        } else {
            int n4 = this.getScreenLineOfOffset(this.caret);
            this.scrollUpPage();
            n = this.xToScreenLineOffset(n4, n2, true);
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n, false);
        this.setMagicCaretPosition(n2);
    }

    public void goToPrevParagraph(boolean bl) {
        int n = this.caretLine;
        int n2 = 0;
        boolean bl2 = false;
        block3: for (int i = n - 1; i >= 0; --i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!bl2) continue block3;
                        n2 = this.getLineEndOffset(i) - 1;
                        break block3;
                    }
                }
            }
            bl2 = true;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToPrevWord(boolean bl) {
        this.goToPrevWord(bl, false);
    }

    public void goToPrevWord(boolean bl, boolean bl2) {
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        String string = this.getLineText(this.caretLine);
        if (n2 == 0) {
            if (n == 0) {
                this.getToolkit().beep();
                return;
            }
            int n3 = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (n3 == -1) {
                this.getToolkit().beep();
                return;
            }
            n2 = this.getLineEndOffset(n3) - 1;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            n2 = TextUtilities.findWordStart(string, n2 - 1, string2, true, bl2);
            n2 += n;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void smartHome(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + bl + ");");
                }
                this.goToStartOfWhiteSpace(bl);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + bl + ");");
                }
                this.goToStartOfLine(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToFirstVisibleLine(" + bl + ");");
                }
                this.goToFirstVisibleLine(bl);
            }
        }
    }

    public void smartEnd(boolean bl) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + bl + ");");
                }
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + bl + ");");
                }
                this.goToEndOfLine(bl);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToLastVisibleLine(" + bl + ");");
                }
                this.goToLastVisibleLine(bl);
            }
        }
    }

    public void goToStartOfLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        int n = bl || selection == null ? this.caretLine : selection.startLine;
        int n2 = this.getLineStartOffset(n);
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToEndOfLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        int n = bl || selection == null ? this.caretLine : selection.endLine;
        int n2 = this.getLineEndOffset(n) - 1;
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToStartOfWhiteSpace(boolean bl) {
        int n;
        int n2;
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (bl || selection == null) {
            n2 = this.caretLine;
            n = this.caret - this.buffer.getLineStartOffset(n2);
        } else {
            n2 = selection.startLine;
            n = selection.start - this.buffer.getLineStartOffset(n2);
        }
        int n3 = this.chunkCache.getSubregionStartOffset(n2, n);
        if (n3 == this.getLineStartOffset(n2)) {
            n3 = MiscUtilities.getLeadingWhiteSpace(this.getLineText(n2));
            if (n3 == this.getLineLength(n2)) {
                n3 = 0;
            }
            n3 += this.getLineStartOffset(n2);
        }
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToEndOfWhiteSpace(boolean bl) {
        int n;
        int n2;
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (bl || selection == null) {
            n2 = this.caretLine;
            n = this.caret - this.getLineStartOffset(n2);
        } else {
            n2 = selection.endLine;
            n = selection.end - this.getLineStartOffset(n2);
        }
        int n3 = this.chunkCache.getSubregionEndOffset(n2, n);
        if (n3 == this.getLineEndOffset(n2)) {
            n3 = this.getLineLength(n2) - MiscUtilities.getTrailingWhiteSpace(this.getLineText(n2));
            if (n3 == 0) {
                n3 = this.getLineLength(n2);
            }
            n3 += this.getLineStartOffset(n2);
        } else {
            --n3;
        }
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToFirstVisibleLine(boolean bl) {
        int n = this.getFirstLine() == 0 ? 0 : this.electricScroll;
        int n2 = this.getScreenLineStartOffset(n);
        if (n2 == -1) {
            n2 = this.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToLastVisibleLine(boolean bl) {
        int n;
        if (this.getFirstLine() + this.visibleLines >= this.displayManager.getScrollLineCount()) {
            n = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        } else {
            n = this.visibleLines - this.electricScroll - 1;
            if (this.lastLinePartial) {
                --n;
            }
            if (n < 0) {
                n = 0;
            }
            if ((n = this.getScreenLineEndOffset(n) - 1) == -1) {
                n = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
            }
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToBufferStart(boolean bl) {
        int n = this.buffer.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToBufferEnd(boolean bl) {
        int n = this.buffer.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToMatchingBracket() {
        int n;
        int n2;
        if (this.getLineLength(this.caretLine) != 0 && (n2 = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (n = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            this.selectNone();
            this.moveCaretPosition(n2 + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    public void showGoToLineDialog() {
        String string = GUIUtilities.input((Component)((Object)this.view), "goto-line", null);
        if (string == null) {
            return;
        }
        try {
            int n = Integer.parseInt(string) - 1;
            this.setCaretPosition(this.getLineStartOffset(n));
        }
        catch (Exception exception) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userInput(char c) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (c == ' ' && Abbrevs.getExpandOnInput() && Abbrevs.expandAbbrev(this.view, false)) {
            return;
        }
        if (c == '\t') {
            if (this.selection.size() == 1) {
                Selection selection = (Selection)this.selection.elementAt(0);
                if (selection instanceof Selection.Rect || selection.startLine == selection.endLine && (selection.start != this.buffer.getLineStartOffset(selection.startLine) || selection.end != this.buffer.getLineEndOffset(selection.startLine) - 1)) {
                    this.insertTab();
                } else {
                    this.shiftIndentRight();
                }
            } else if (this.selection.size() != 0) {
                this.shiftIndentRight();
            } else {
                this.insertTab();
            }
            return;
        }
        String string = (String)this.buffer.getProperty("indentOpenBrackets");
        String string2 = (String)this.buffer.getProperty("indentCloseBrackets");
        boolean bl = string2 != null && string2.indexOf(c) != -1 || string != null && string.indexOf(c) != -1;
        String string3 = String.valueOf(c);
        Selection[] selectionArray = this.getSelection();
        if (selectionArray.length != 0) {
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                this.setSelectedText(selection, string3);
            }
            return;
        }
        if (c == ' ') {
            if (this.doWordWrap(true)) {
                return;
            }
        } else {
            this.doWordWrap(false);
        }
        try {
            int n;
            if (this.overwrite || bl) {
                this.buffer.beginCompoundEdit();
            }
            if (this.overwrite && (n = this.getLineEndOffset(this.caretLine)) - this.caret > 1) {
                this.buffer.remove(this.caret, 1);
            }
            this.buffer.insert(this.caret, string3);
            if (bl) {
                this.buffer.indentLine(this.caretLine, true);
            }
        }
        finally {
            if (this.overwrite || bl) {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.blink = true;
        caretTimer.restart();
        this.overwrite = bl;
        this.invalidateLine(this.caretLine);
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
    }

    public final void toggleOverwriteEnabled() {
        this.setOverwriteEnabled(!this.overwrite);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.overwrite-changed", new Integer[]{new Integer(this.overwrite ? 1 : 0)}));
        }
    }

    public void backspace() {
        this.delete(false);
    }

    public void backspaceWord() {
        this.backspaceWord(false);
    }

    public void backspaceWord(boolean bl) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            this.setSelectedText("");
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        String string = this.getLineText(this.caretLine);
        if (n2 == 0) {
            if (n == 0) {
                this.getToolkit().beep();
                return;
            }
            --n2;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            n2 = TextUtilities.findWordStart(string, n2 - 1, string2, true, bl);
        }
        this.buffer.remove(n2 + n, this.caret - (n2 + n));
    }

    public void delete() {
        this.delete(true);
    }

    public void deleteToEndOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.caret, this.getLineEndOffset(this.caretLine) - this.caret - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.getLineEndOffset(this.caretLine);
        int n3 = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - n);
        try {
            if (n2 > this.buffer.getLength()) {
                if (n != 0) {
                    --n;
                }
                --n2;
            }
            this.buffer.beginCompoundEdit();
            this.buffer.remove(n, n2 - n);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        int n4 = this.displayManager.getLastVisibleLine();
        if (this.caretLine == n4) {
            int n5 = this.chunkCache.xToSubregionOffset(n4, 0, n3, true);
            this.setCaretPosition(this.buffer.getLineStartOffset(n4) + n5);
        } else {
            int n6 = this.chunkCache.xToSubregionOffset(this.caretLine, 0, n3, true);
            this.setCaretPosition(n + n6);
        }
    }

    public void deleteParagraph() {
        int n;
        int n2;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int n3 = 0;
        int n4 = this.buffer.getLength();
        block6: for (n2 = this.caretLine - 1; n2 >= 0; --n2) {
            this.getLineText(n2, this.lineSegment);
            block7: for (n = 0; n < this.lineSegment.count; ++n) {
                switch (this.lineSegment.array[this.lineSegment.offset + n]) {
                    case '\t': 
                    case ' ': {
                        continue block7;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            n3 = this.getLineStartOffset(n2);
            break;
        }
        block8: for (n2 = this.caretLine + 1; n2 < this.getLineCount(); ++n2) {
            this.getLineText(n2, this.lineSegment);
            block9: for (n = 0; n < this.lineSegment.count; ++n) {
                switch (this.lineSegment.array[this.lineSegment.offset + n]) {
                    case '\t': 
                    case ' ': {
                        continue block9;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            n4 = this.getLineEndOffset(n2) - 1;
            break;
        }
        this.buffer.remove(n3, n4 - n3);
    }

    public void deleteToStartOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.getLineStartOffset(this.caretLine), this.caret - this.getLineStartOffset(this.caretLine));
    }

    public void deleteWord() {
        this.deleteWord(false);
    }

    public void deleteWord(boolean bl) {
        String string;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            this.setSelectedText("");
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        if (n2 == (string = this.getLineText(this.caretLine)).length()) {
            if (n + n2 == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            ++n2;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            n2 = TextUtilities.findWordEnd(string, n2 + 1, string2, true, bl);
        }
        this.buffer.remove(this.caret, n2 + n - this.caret);
    }

    public final boolean isMultipleSelectionEnabled() {
        return this.multi;
    }

    public final void toggleMultipleSelectionEnabled() {
        this.setMultipleSelectionEnabled(!this.multi);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.multi-changed", new Integer[]{new Integer(this.multi ? 1 : 0)}));
        }
    }

    public final void setMultipleSelectionEnabled(boolean bl) {
        this.multi = bl;
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
        this.painter.repaint();
    }

    public final boolean isRectangularSelectionEnabled() {
        return this.rectangularSelectionMode;
    }

    public final void toggleRectangularSelectionEnabled() {
        this.setRectangularSelectionEnabled(!this.rectangularSelectionMode);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.rect-select-changed", new Integer[]{new Integer(this.rectangularSelectionMode ? 1 : 0)}));
        }
    }

    public final void setRectangularSelectionEnabled(boolean bl) {
        this.rectangularSelectionMode = bl;
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
        this.painter.repaint();
    }

    public void goToMarker(char c, boolean bl) {
        Marker marker = this.buffer.getMarker(c);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int n = marker.getPosition();
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void addMarker() {
        Selection[] selectionArray = this.getSelection();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection = selectionArray[i];
            if (selection.startLine != selection.endLine && selection.startLine != this.caretLine) {
                this.buffer.addMarker('\u0000', selection.start);
            }
            if (selection.endLine == this.caretLine) continue;
            this.buffer.addMarker('\u0000', selection.end);
        }
        this.buffer.addOrRemoveMarker('\u0000', this.caret);
    }

    public void swapMarkerAndCaret(char c) {
        Marker marker = this.buffer.getMarker(c);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int n = this.getCaretPosition();
        this.setCaretPosition(marker.getPosition());
        this.buffer.addMarker(c, n);
    }

    public void goToParentFold() {
        int n;
        int n2 = -1;
        int n3 = this.buffer.getFoldLevel(this.caretLine);
        for (n = this.caretLine - 1; n >= 0; --n) {
            if (this.buffer.getFoldLevel(n) >= n3) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n4 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n4);
        this.setMagicCaretPosition(n);
    }

    public void goToNextFold(boolean bl) {
        int n;
        int n2 = -1;
        for (n = this.caretLine + 1; n < this.buffer.getLineCount(); ++n) {
            if (!this.buffer.isFoldStart(n) || !this.displayManager.isLineVisible(n)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n3 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
        this.setMagicCaretPosition(n);
    }

    public void goToPrevFold(boolean bl) {
        int n;
        int n2 = -1;
        for (n = this.caretLine - 1; n >= 0; --n) {
            if (!this.buffer.isFoldStart(n) || !this.displayManager.isLineVisible(n)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n3 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
        this.setMagicCaretPosition(n);
    }

    public void collapseFold() {
        int n = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        this.displayManager.collapseFold(this.caretLine);
        if (this.displayManager.isLineVisible(this.caretLine)) {
            return;
        }
        int n2 = this.displayManager.getPrevVisibleLine(this.caretLine);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n, true));
    }

    public void expandFold(boolean bl) {
        int n = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int n2 = this.displayManager.expandFold(this.caretLine, bl);
        if (!bl && n2 != -1) {
            if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(this.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n, true));
        }
    }

    public void selectFold() {
        this.selectFold(this.caretLine);
    }

    public void selectFold(int n) {
        int[] nArray = this.buffer.getFoldAtLine(n);
        int n2 = this.getLineEndOffset(nArray[1]) - 1;
        Selection.Range range = new Selection.Range(this.getLineStartOffset(nArray[0]), n2);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n2);
    }

    public void narrowToFold() {
        int[] nArray = this.buffer.getFoldAtLine(this.caretLine);
        if (nArray[0] == 0 && nArray[1] == this.buffer.getLineCount() - 1) {
            this.getToolkit().beep();
        } else {
            this.displayManager.narrow(nArray[0], nArray[1]);
        }
    }

    public void narrowToSelection() {
        if (this.selection.size() != 1) {
            this.getToolkit().beep();
            return;
        }
        Selection selection = (Selection)this.selection.elementAt(0);
        this.displayManager.narrow(selection.getStartLine(), selection.getEndLine());
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitFold() {
        String string;
        String string2;
        if (!this.buffer.getStringProperty("folding").equals("explicit")) {
            GUIUtilities.error((Component)((Object)this.view), "folding-not-explicit", null);
            return;
        }
        String string3 = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        String string4 = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String string5 = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (string3 != null) {
            string2 = string3 + "{{{ \n";
            string = string3 + "}}}";
        } else if (string4 != null && string5 != null) {
            string2 = string4 + "{{{  " + string5 + "\n";
            string = string4 + "}}}" + string5;
        } else {
            string2 = "{{{ \n";
            string = "}}}";
        }
        try {
            this.buffer.beginCompoundEdit();
            if (this.selection.size() == 0) {
                String string6 = this.buffer.getLineText(this.caretLine);
                String string7 = string6.substring(0, MiscUtilities.getLeadingWhiteSpace(string6));
                int n = this.caret + string2.length() - 1;
                string2 = string2 + string7;
                this.buffer.insert(this.caret, string2);
                this.buffer.insert(this.caret, string);
                this.moveCaretPosition(n, false);
            } else {
                int n = -1;
                for (int i = 0; i < this.selection.size(); ++i) {
                    Selection selection = (Selection)this.selection.elementAt(i);
                    String string8 = this.buffer.getLineText(selection.startLine);
                    String string9 = string8.substring(0, MiscUtilities.getLeadingWhiteSpace(string8));
                    n = selection.start + string2.length() - 1;
                    this.buffer.insert(selection.start, string2 + string9);
                    if (selection.end == this.buffer.getLineStartOffset(selection.endLine)) {
                        this.buffer.insert(selection.end, string);
                        continue;
                    }
                    this.buffer.insert(selection.end, " " + string);
                }
                this.setCaretPosition(n, false);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComment() {
        String string = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        if (!this.buffer.isEditable() || string == null || string.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        string = string + ' ';
        this.buffer.beginCompoundEdit();
        int[] nArray = this.getSelectedLines();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = this.getLineText(nArray[i]);
                this.buffer.insert(this.getLineStartOffset(nArray[i]) + MiscUtilities.getLeadingWhiteSpace(string2), string);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeComment() {
        String string = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String string2 = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        string = string + ' ';
        string2 = ' ' + string2;
        try {
            int n;
            this.buffer.beginCompoundEdit();
            Selection[] selectionArray = this.getSelection();
            if (selectionArray.length == 0) {
                n = this.caret;
                this.buffer.insert(this.caret, string);
                this.buffer.insert(this.caret, string2);
                this.setCaretPosition(n + string.length());
            }
            for (n = 0; n < selectionArray.length; ++n) {
                Selection selection = selectionArray[n];
                if (selection instanceof Selection.Range) {
                    this.buffer.insert(selection.start, string);
                    this.buffer.insert(selection.end, string2);
                    continue;
                }
                if (!(selection instanceof Selection.Rect)) continue;
                Selection.Rect rect = (Selection.Rect)selection;
                int n2 = rect.getStartColumn(this.buffer);
                int n3 = rect.getEndColumn(this.buffer);
                for (int i = selection.startLine; i <= selection.endLine; ++i) {
                    this.buffer.insertAtColumn(i, n3, string2);
                    this.buffer.insertAtColumn(i, n2, string);
                }
            }
            this.selectNone();
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatParagraph() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.maxLineLen <= 0) {
            GUIUtilities.error((Component)((Object)this.view), "format-maxlinelen", null);
            return;
        }
        Selection[] selectionArray = this.getSelection();
        if (selectionArray.length != 0) {
            this.buffer.beginCompoundEdit();
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                this.setSelectedText(selection, TextUtilities.format(this.getSelectedText(selection), this.maxLineLen, this.buffer.getTabSize()));
            }
            this.buffer.endCompoundEdit();
        } else {
            int n;
            int n2;
            int n3 = this.getCaretLine();
            int n4 = 0;
            int n5 = this.buffer.getLength();
            block10: for (n2 = n3 - 1; n2 >= 0; --n2) {
                this.getLineText(n2, this.lineSegment);
                block11: for (n = 0; n < this.lineSegment.count; ++n) {
                    switch (this.lineSegment.array[this.lineSegment.offset + n]) {
                        case '\t': 
                        case ' ': {
                            continue block11;
                        }
                        default: {
                            continue block10;
                        }
                    }
                }
                n4 = this.getLineEndOffset(n2);
                break;
            }
            block12: for (n2 = n3 + 1; n2 < this.getLineCount(); ++n2) {
                this.getLineText(n2, this.lineSegment);
                block13: for (n = 0; n < this.lineSegment.count; ++n) {
                    switch (this.lineSegment.array[this.lineSegment.offset + n]) {
                        case '\t': 
                        case ' ': {
                            continue block13;
                        }
                        default: {
                            continue block12;
                        }
                    }
                }
                n5 = this.getLineStartOffset(n2) - 1;
                break;
            }
            try {
                this.buffer.beginCompoundEdit();
                String string = this.buffer.getText(n4, n5 - n4);
                this.buffer.remove(n4, n5 - n4);
                this.buffer.insert(n4, TextUtilities.format(string, this.maxLineLen, this.buffer.getTabSize()));
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void spacesToTabs() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selectionArray.length == 0) {
            this.setText(TextUtilities.spacesToTabs(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                this.setSelectedText(selection, TextUtilities.spacesToTabs(this.getSelectedText(selection), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void tabsToSpaces() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selectionArray.length == 0) {
            this.setText(TextUtilities.tabsToSpaces(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                this.setSelectedText(selection, TextUtilities.tabsToSpaces(this.getSelectedText(selection), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void toUpperCase() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable() || selectionArray.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection = selectionArray[i];
            this.setSelectedText(selection, this.getSelectedText(selection).toUpperCase());
        }
        this.buffer.endCompoundEdit();
    }

    public void toLowerCase() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable() || selectionArray.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection = selectionArray[i];
            this.setSelectedText(selection, this.getSelectedText(selection).toLowerCase());
        }
        this.buffer.endCompoundEdit();
    }

    public void removeTrailingWhiteSpace() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.removeTrailingWhiteSpace(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEnterAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            try {
                this.buffer.beginCompoundEdit();
                this.setSelectedText("\n");
                this.buffer.indentLine(this.caretLine, true);
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void insertTabAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() == 0) {
            int n;
            String string = this.buffer.getLineText(this.caretLine);
            int n2 = this.buffer.getLineStartOffset(this.caretLine);
            if (this.caret - n2 <= (n = MiscUtilities.getLeadingWhiteSpace(string)) && this.buffer.indentLine(this.caretLine, false)) {
                return;
            }
        }
        this.userInput('\t');
    }

    public void indentSelectedLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentLines(this.getSelectedLines());
            this.selectNone();
        }
    }

    public void shiftIndentLeft() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentLeft(this.getSelectedLines());
        }
    }

    public void shiftIndentRight() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentRight(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        int n = this.getLineEndOffset(this.caretLine);
        if (!this.buffer.isEditable() || n > this.buffer.getLength()) {
            this.getToolkit().beep();
            return;
        }
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(n - 1, MiscUtilities.getLeadingWhiteSpace(this.buffer.getLineText(this.caretLine + 1)) + 1);
            this.buffer.insert(n - 1, " ");
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.setCaretPosition(n - 1);
    }

    public void showWordCountDialog() {
        String string = this.getSelectedText();
        if (string != null) {
            this.doWordCount(this.view, string);
            return;
        }
        this.doWordCount(this.view, this.buffer.getText(0, this.buffer.getLength()));
    }

    public boolean isRightClickPopupEnabled() {
        return this.popupEnabled;
    }

    public void setRightClickPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public void handlePopupTrigger(MouseEvent mouseEvent) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.xyToOffset(n, n2, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
            if (this.getSelectionCount() == 0 || this.multi) {
                this.moveCaretPosition(n3, false);
            }
            GUIUtilities.showPopupMenu(this.popup, this.painter, n, n2);
        }
    }

    public void addLeftOfScrollBar(Component component) {
        this.verticalBox.add(component, this.verticalBox.getComponentCount() - 1);
    }

    public void removeLeftOfScrollBar(Component component) {
        this.verticalBox.remove(component);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.painter);
        ToolTipManager.sharedInstance().registerComponent(this.gutter);
        this.recalculateVisibleLines();
        if (this.buffer.isLoaded()) {
            this.recalculateLastPhysicalLine();
        }
        this.propertiesChanged();
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.painter);
        ToolTipManager.sharedInstance().unregisterComponent(this.gutter);
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.view.processKeyEvent(keyEvent, 1);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void addTopComponent(Component component) {
        this.add(TOP, component);
    }

    public void removeTopComponent(Component component) {
        this.remove(component);
    }

    public void propertiesChanged() {
        int n;
        int n2;
        if (this.buffer == null) {
            return;
        }
        int n3 = this.buffer.getTabSize();
        char[] cArray = new char[n3];
        for (n2 = 0; n2 < cArray.length; ++n2) {
            cArray[n2] = 32;
        }
        this.tabSize = this.painter.getStringWidth(new String(cArray));
        this.charWidth = (int)Math.round(this.painter.getFont().getStringBounds(cArray, 0, 1, this.painter.getFontRenderContext()).getWidth());
        n2 = 0;
        String string = this.buffer.getStringProperty("wrap");
        if (!string.equals(this.wrap)) {
            this.wrap = string;
            this.hardWrap = string.equals("hard");
            if (this.displayManager != null && !this.bufferChanging) {
                this.displayManager.firstLine.callReset = true;
                this.displayManager.scrollLineCount.callReset = true;
            }
            n2 = 1;
        }
        if ((n = this.buffer.getIntegerProperty("maxLineLen", 0)) != this.maxLineLen) {
            this.maxLineLen = n;
            if (this.displayManager != null && !this.bufferChanging) {
                this.displayManager.firstLine.callReset = true;
                this.displayManager.scrollLineCount.callReset = true;
            }
            n2 = 1;
        }
        if (n2 != 0) {
            this.buffer.invalidateCachedScreenLineCounts();
        }
        this.chunkCache.invalidateAll();
        if (this.displayManager != null && !this.bufferChanging) {
            this.displayManager.updateWrapSettings();
            this.displayManager._notifyScreenLineChanges();
        }
        this.gutter.repaint();
        this.painter.repaint();
    }

    public final int getSelectionStart() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStart();
    }

    public int getSelectionStart(int n) {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStart(this.buffer, n);
    }

    public final int getSelectionStartLine() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStartLine();
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd(), true);
    }

    public final int getSelectionEnd() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEnd();
    }

    public int getSelectionEnd(int n) {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEnd(this.buffer, n);
    }

    public final int getSelectionEndLine() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEndLine();
    }

    public final void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n, true);
    }

    public final int getMarkPosition() {
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (selection == null) {
            return this.caret;
        }
        if (selection.start == this.caret) {
            return selection.end;
        }
        if (selection.end == this.caret) {
            return selection.start;
        }
        return this.caret;
    }

    public final int getMarkLine() {
        if (this.selection.size() != 1) {
            return this.caretLine;
        }
        Selection selection = (Selection)this.selection.elementAt(0);
        if (selection.start == this.caret) {
            return selection.endLine;
        }
        if (selection.end == this.caret) {
            return selection.startLine;
        }
        return this.caretLine;
    }

    public void select(int n, int n2) {
        this.select(n, n2, true);
    }

    public void select(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.selectNone();
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        this.setSelection(new Selection.Range(n4, n3));
        this.moveCaretPosition(n2, bl);
    }

    public boolean isSelectionRectangular() {
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (selection == null) {
            return false;
        }
        return selection instanceof Selection.Rect;
    }

    final boolean isCaretVisible() {
        return this.blink && this.hasFocus();
    }

    final boolean isStructureHighlightVisible() {
        return this.match != null && this.hasFocus() && this.displayManager.isLineVisible(this.match.startLine) && this.displayManager.isLineVisible(this.match.endLine);
    }

    void updateMaxHorizontalScrollWidth() {
        int n = this.chunkCache.getMaxHorizontalScrollWidth();
        if (n != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = n;
            this.horizontal.setValues(Math.max(0, Math.min(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth(), -this.horizontalOffset)), this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.charWidth);
        }
    }

    void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        int n2 = this.painter.getFontMetrics().getHeight();
        if (n2 == 0) {
            this.visibleLines = 0;
        } else if (n <= 0) {
            this.visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this.visibleLines = n / n2;
            boolean bl = this.lastLinePartial = n % n2 != 0;
            if (this.lastLinePartial) {
                ++this.visibleLines;
            }
        }
        this.chunkCache.recalculateVisibleLines();
        if (this.displayManager != null && this.buffer != null && this.buffer.isLoaded()) {
            this.setFirstLine(this.getFirstLine());
        }
        this.updateScrollBars();
    }

    void foldStructureChanged() {
        this.chunkCache.invalidateAll();
        this.recalculateLastPhysicalLine();
        this.repaint();
    }

    void updateScrollBars() {
        int n;
        if (this.buffer == null) {
            return;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "updateScrollBars(), slc=" + this.displayManager.getScrollLineCount());
        }
        if (this.vertical != null && this.visibleLines != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Vertical ok");
            }
            n = this.displayManager.getScrollLineCount();
            int n2 = this.getFirstLine();
            int n3 = this.visibleLines - (this.lastLinePartial ? 1 : 0);
            this.vertical.setValues(n2, n3, 0, n);
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(n3);
        }
        n = this.painter.getWidth();
        if (this.horizontal != null && n != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Horizontal ok");
            }
            this.painter.repaint();
            this.horizontal.setValue(-this.horizontalOffset);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(n / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _finishCaretUpdate() {
        if (!this.queuedCaretUpdate) {
            return;
        }
        try {
            this.blink = true;
            caretTimer.restart();
            if (!this.displayManager.isLineVisible(this.caretLine)) {
                if (this.caretLine < this.displayManager.getFirstVisibleLine() || this.caretLine > this.displayManager.getLastVisibleLine()) {
                    int n = this.buffer.getIntegerProperty("collapseFolds", 0);
                    if (n != 0) {
                        this.displayManager.expandFolds(n);
                        this.displayManager.expandFold(this.caretLine, false);
                    } else {
                        this.displayManager.expandAllFolds();
                    }
                } else {
                    this.displayManager.expandFold(this.caretLine, false);
                }
            }
            this.scrollToCaret(this.queuedScrollToElectric);
            this.updateBracketHighlightWithDelay();
            if (this.queuedFireCaretEvent) {
                this.fireCaretEvent();
            }
        }
        finally {
            this.queuedFireCaretEvent = false;
            this.queuedScrollToElectric = false;
            this.queuedCaretUpdate = false;
        }
    }

    int[] getSelectionStartAndEnd(int n, int n2, Selection selection) {
        int n3;
        int n4;
        int n5 = this.getScreenLineStartOffset(n);
        int n6 = this.getScreenLineEndOffset(n);
        if (n6 <= selection.start || n5 > selection.end) {
            return null;
        }
        int n7 = this.displayManager.isLineVisible(selection.startLine) ? this.getScreenLineOfOffset(selection.start) : -1;
        int n8 = this.displayManager.isLineVisible(selection.endLine) ? this.getScreenLineOfOffset(selection.end) : -1;
        int n9 = this.buffer.getLineStartOffset(n2);
        if (selection instanceof Selection.Rect) {
            n5 -= n9;
            n6 -= n9;
            Selection.Rect rect = (Selection.Rect)selection;
            int n10 = rect.getStartColumn(this.buffer);
            int n11 = rect.getEndColumn(this.buffer);
            int n12 = this.buffer.getLineLength(n2);
            int[] nArray = new int[1];
            int n13 = this.buffer.getOffsetOfVirtualColumn(n2, n10, nArray);
            if (n13 == -1) {
                n4 = (n10 - nArray[0]) * this.charWidth;
                n13 = n12;
            } else {
                n4 = 0;
            }
            int n14 = this.buffer.getOffsetOfVirtualColumn(n2, n11, nArray);
            if (n14 == -1) {
                n3 = (n11 - nArray[0]) * this.charWidth;
                n14 = n12;
            } else {
                n3 = 0;
            }
            if (n6 <= n13 || n5 > n14) {
                return null;
            }
            n4 = n13 < n5 ? 0 : n4 + this.offsetToXY((int)n2, (int)n13, (Point)this.returnValue).x;
            n3 = n14 > n6 ? this.getWidth() : n3 + this.offsetToXY((int)n2, (int)n14, (Point)this.returnValue).x;
        } else if (n7 == n8 && n7 != -1) {
            n4 = this.offsetToXY((int)n2, (int)(selection.start - n9), (Point)this.returnValue).x;
            n3 = this.offsetToXY((int)n2, (int)(selection.end - n9), (Point)this.returnValue).x;
        } else if (n == n7) {
            n4 = this.offsetToXY((int)n2, (int)(selection.start - n9), (Point)this.returnValue).x;
            n3 = this.getWidth();
        } else if (n == n8) {
            n4 = 0;
            n3 = this.offsetToXY((int)n2, (int)(selection.end - n9), (Point)this.returnValue).x;
        } else {
            n4 = 0;
            n3 = this.getWidth();
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 == n3) {
            // empty if block
        }
        return new int[]{n4, ++n3};
    }

    boolean insideSelection(int n, int n2) {
        int n3 = this.xyToOffset(n, n2);
        Selection selection = this.getSelectionAtOffset(n3);
        if (selection == null) {
            return false;
        }
        int n4 = this.getScreenLineOfOffset(n3);
        if (n4 == -1) {
            return false;
        }
        int[] nArray = this.getSelectionStartAndEnd(n4, this.buffer.getLineOfOffset(n3), selection);
        if (nArray == null) {
            return false;
        }
        return n >= nArray[0] && n <= nArray[1];
    }

    private void startDragAndDrop(InputEvent inputEvent, boolean bl) {
        try {
            this.dndCallback.invoke(null, this, inputEvent, new Boolean(bl));
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    private void _addToSelection(Selection selection) {
        int n;
        if (selection.start > selection.end) {
            throw new IllegalArgumentException(selection.start + " > " + selection.end);
        }
        if (selection.start == selection.end) {
            if (selection instanceof Selection.Range) {
                return;
            }
            if (selection instanceof Selection.Rect && ((Selection.Rect)selection).extraEndVirt == 0) {
                return;
            }
        }
        for (n = 0; n < this.selection.size(); ++n) {
            Selection selection2 = (Selection)this.selection.elementAt(n);
            if (!selection2.overlaps(selection)) continue;
            selection.start = Math.min(selection2.start, selection.start);
            selection.end = Math.max(selection2.end, selection.end);
            this.selection.removeElement(selection2);
            --n;
        }
        selection.startLine = this.getLineOfOffset(selection.start);
        selection.endLine = this.getLineOfOffset(selection.end);
        n = 0;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection selection3 = (Selection)this.selection.elementAt(i);
            if (selection.start >= selection3.start) continue;
            this.selection.insertElementAt(selection, i);
            n = 1;
            break;
        }
        if (n == 0) {
            this.selection.addElement(selection);
        }
        this.invalidateLineRange(selection.startLine, selection.endLine);
    }

    private void finishCaretUpdate(boolean bl, boolean bl2) {
        this.queuedScrollToElectric |= bl;
        this.queuedFireCaretEvent |= bl2;
        if (this.queuedCaretUpdate) {
            return;
        }
        this.queuedCaretUpdate = true;
        if (!this.buffer.isTransactionInProgress()) {
            this._finishCaretUpdate();
        }
    }

    private void fireCaretEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != CaretListener.class) continue;
            try {
                ((CaretListener)objectArray[i + 1]).caretUpdate(this.caretEvent);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireScrollEvent(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != ScrollListener.class) continue;
            try {
                if (bl) {
                    ((ScrollListener)objectArray[i + 1]).scrolledVertically(this);
                    continue;
                }
                ((ScrollListener)objectArray[i + 1]).scrolledHorizontally(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void insertTab() {
        int n = this.buffer.getTabSize();
        if (this.buffer.getBooleanProperty("noTabs")) {
            int n2 = this.getLineStartOffset(this.caretLine);
            String string = this.getText(n2, this.caret - n2);
            int n3 = 0;
            block3: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(n3)) {
                    case '\t': {
                        n3 = 0;
                        continue block3;
                    }
                    default: {
                        if (++n3 < n) continue block3;
                        n3 = 0;
                    }
                }
            }
            this.setSelectedText(MiscUtilities.createWhiteSpace(n - n3, 0));
        } else {
            this.setSelectedText("\t");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doWordWrap(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.hardWrap || this.maxLineLen <= 0) {
            return false;
        }
        this.buffer.getLineText(this.caretLine, this.lineSegment);
        int n5 = this.getLineStartOffset(this.caretLine);
        int n6 = this.getLineEndOffset(this.caretLine);
        int n7 = n6 - n5 - 1;
        for (n4 = n3 = this.caret - n5; n4 < n7; ++n4) {
            char c = this.lineSegment.array[this.lineSegment.offset + n4];
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        n4 = this.buffer.getTabSize();
        String string = this.buffer.getStringProperty("wordBreakChars");
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        boolean bl2 = true;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.lineSegment.array[this.lineSegment.offset + n2];
            if (n == 9) {
                n9 += n4 - n9 % n4;
                if (bl2 || n9 > this.maxLineLen) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            if (n == 32) {
                if (bl2 || ++n9 > this.maxLineLen + 1) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            if (string != null && string.indexOf(n) != -1) {
                if (bl2 || ++n9 > this.maxLineLen) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            n8 = n2;
            ++n9;
            bl2 = false;
        }
        if (bl && n9 == this.maxLineLen && n8 == n3 - 1) {
            n = n3;
            n2 = 1;
        } else if (n9 >= this.maxLineLen && n10 != -1) {
            n = n10;
            n2 = 0;
        } else {
            return false;
        }
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.insert(n5 + n, "\n");
            this.buffer.indentLine(this.caretLine, true);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        return n2 != 0;
    }

    private void doWordCount(View view, String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = n == 0 ? 0 : 1;
        int n3 = 1;
        boolean bl = false;
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': 
                case '\r': {
                    ++n3;
                }
                case '\t': 
                case ' ': {
                    if (!bl) continue block4;
                    ++n2;
                    bl = false;
                    continue block4;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (!bl) {
            --n2;
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        GUIUtilities.message((Component)((Object)view), "wordcount", objectArray);
    }

    private void updateBracketHighlightWithDelay() {
        structureTimer.stop();
        structureTimer.start();
    }

    private void updateStructureHighlight() {
        if (!this.painter.isStructureHighlightEnabled() && !this.gutter.isStructureHighlightEnabled()) {
            return;
        }
        for (StructureMatcher structureMatcher : this.structureMatchers) {
            this.match = structureMatcher.getMatch(this);
            if (this.match == null) continue;
            break;
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            if (!this.displayManager.isLineVisible(this.match.startLine) || this.chunkCache.getScreenLineOfOffset(this.match.startLine, this.match.start - this.getLineStartOffset(this.match.startLine)) == -1) {
                this.showStructureStatusMessage(this.match.startLine < this.caretLine);
            }
        }
    }

    private void showStructureStatusMessage(boolean bl) {
        String string = this.buffer.getLineText(this.match.startLine).trim();
        if (bl && this.match.startLine != 0 && string.length() == 1) {
            switch (string.charAt(0)) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    string = this.buffer.getLineText(this.match.startLine - 1).trim() + " " + string;
                }
            }
        }
        string = string.replace('\t', ' ');
        this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.bracket", new Object[]{new Integer(this.match.startLine + 1), string}));
    }

    void recalculateLastPhysicalLine() {
        int n = this.screenLastLine;
        for (int i = this.visibleLines - 1; i >= 0; --i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if (lineInfo.physicalLine == -1) continue;
            this.physLastLine = lineInfo.physicalLine;
            this.screenLastLine = i;
            break;
        }
        this.invalidateScreenLineRange(n, this.screenLastLine);
    }

    private RectParams getRectParams(int n, int n2) {
        int n3;
        Selection selection = this.getSelectionAtOffset(n);
        if (selection instanceof Selection.Rect) {
            n3 = n == selection.end ? this.buffer.getVirtualWidth(selection.endLine, selection.end - this.getLineStartOffset(selection.endLine)) + ((Selection.Rect)selection).extraEndVirt : this.buffer.getVirtualWidth(selection.startLine, selection.start - this.getLineStartOffset(selection.startLine)) + ((Selection.Rect)selection).extraStartVirt;
        } else if (this.rectangularSelectionMode) {
            n3 = this.buffer.getVirtualWidth(this.caretLine, n - this.buffer.getLineStartOffset(this.caretLine));
        } else {
            return null;
        }
        int n4 = this.getLineOfOffset(n2);
        int[] nArray = new int[1];
        int n5 = this.buffer.getOffsetOfVirtualColumn(n4, n3, nArray);
        if (n5 == -1) {
            int n6 = n3 - nArray[0];
            n2 = this.getLineEndOffset(n4) - 1;
            boolean bl = selection == null ? n2 < n : (selection.start == n ? n2 <= selection.end : (selection.end == n ? n2 <= selection.start : false));
            RectParams rectParams = bl ? new RectParams(n6, 0, n2) : new RectParams(0, n6, n2);
            return rectParams;
        }
        return new RectParams(0, 0, this.getLineStartOffset(n4) + n5);
    }

    private void delete(boolean bl) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            Selection[] selectionArray = this.getSelection();
            for (int i = 0; i < selectionArray.length; ++i) {
                Selection selection = selectionArray[i];
                if (selection instanceof Selection.Rect) {
                    Selection.Rect rect = (Selection.Rect)selection;
                    int n = rect.getStartColumn(this.buffer);
                    if (n == rect.getEndColumn(this.buffer)) {
                        if (!bl && n == 0) {
                            this.getToolkit().beep();
                            continue;
                        }
                        this.tallCaretDelete(rect, bl);
                        continue;
                    }
                    this.setSelectedText(selection, null);
                    continue;
                }
                this.setSelectedText(selection, null);
            }
        } else if (bl) {
            if (this.caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret, 1);
        } else {
            if (this.caret == 0) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret - 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallCaretDelete(Selection.Rect rect, boolean bl) {
        try {
            this.buffer.beginCompoundEdit();
            int[] nArray = new int[1];
            int n = rect.getStartColumn(this.buffer);
            int n2 = rect.startLine;
            int n3 = rect.endLine;
            for (int i = n2; i <= n3; ++i) {
                int n4 = this.buffer.getOffsetOfVirtualColumn(i, n, nArray);
                if (n4 == -1) {
                    if (nArray[0] == n) {
                        n4 = this.getLineLength(i);
                    } else {
                        if (i != n2 || bl) continue;
                        this.shiftTallCaretLeft(rect);
                        continue;
                    }
                }
                n4 += this.buffer.getLineStartOffset(i);
                if (bl) {
                    if (n4 == this.buffer.getLineEndOffset(i) - 1) continue;
                    this.buffer.remove(n4, 1);
                    continue;
                }
                this.buffer.remove(n4 - 1, 1);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void shiftTallCaretLeft(Selection.Rect rect) {
        this.removeFromSelection(rect);
        this.addToSelection(new Selection.Rect(this.buffer, rect.getStartLine(), rect.getStartColumn(this.buffer) - 1, rect.getEndLine(), rect.getEndColumn(this.buffer) - 1));
    }

    static {
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        structureTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (focusedComponent != null) {
                    focusedComponent.updateStructureHighlight();
                }
            }
        });
        structureTimer.setInitialDelay(100);
        structureTimer.setRepeats(false);
    }

    class MouseHandler
    extends MouseInputAdapter {
        private int dragStartLine;
        private int dragStartOffset;
        private int dragStart;
        private int clickCount;
        private boolean dragged;
        private boolean quickCopyDrag;
        private boolean clearStatus;
        private boolean control;
        private boolean maybeDragAndDrop;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.control = OperatingSystem.isMacOS() && mouseEvent.isMetaDown() || !OperatingSystem.isMacOS() && mouseEvent.isControlDown();
            JEditTextArea.this.view.getInputHandler().resetLastActionCount();
            boolean bl = this.quickCopyDrag = JEditTextArea.this.isQuickCopyEnabled() && GUIUtilities.isMiddleButton(mouseEvent.getModifiers());
            if (!this.quickCopyDrag) {
                JEditTextArea.this.requestFocus();
                focusedComponent = JEditTextArea.this;
            }
            if (!JEditTextArea.this.buffer.isLoaded()) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.dragStart = JEditTextArea.this.xyToOffset(n, n2, !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled());
            this.dragStartLine = JEditTextArea.this.getLineOfOffset(this.dragStart);
            this.dragStartOffset = this.dragStart - JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            if (GUIUtilities.isPopupTrigger(mouseEvent) && JEditTextArea.this.popup != null) {
                if (JEditTextArea.this.popupEnabled) {
                    JEditTextArea.this.handlePopupTrigger(mouseEvent);
                }
                return;
            }
            this.dragged = false;
            JEditTextArea.this.blink = true;
            JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            this.clickCount = mouseEvent.getClickCount();
            if (JEditTextArea.this.isDragEnabled() && JEditTextArea.this.getDragAndDropCallback() != null && JEditTextArea.this.insideSelection(n, n2) && this.clickCount == 1 && !mouseEvent.isShiftDown()) {
                this.maybeDragAndDrop = true;
                JEditTextArea.this.moveCaretPosition(this.dragStart, false);
                return;
            }
            this.maybeDragAndDrop = false;
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(mouseEvent);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }

        private void doSingleClick(MouseEvent mouseEvent) {
            float f;
            int n = mouseEvent.getX();
            int n2 = 0;
            if (JEditTextArea.this.chunkCache.getLineInfo((int)((JEditTextArea)JEditTextArea.this).screenLastLine).lastSubregion && (float)n > (f = (float)JEditTextArea.this.offsetToXY((int)this.dragStartLine, (int)JEditTextArea.this.getLineLength((int)this.dragStartLine), (Point)JEditTextArea.this.returnValue).x)) {
                n2 = (int)(((float)n - f) / (float)JEditTextArea.this.charWidth);
                if (!JEditTextArea.this.getPainter().isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() && (n - JEditTextArea.this.getHorizontalOffset()) % JEditTextArea.this.charWidth > JEditTextArea.this.charWidth / 2) {
                    ++n2;
                }
            }
            if (this.control || JEditTextArea.this.isRectangularSelectionEnabled()) {
                int n3 = mouseEvent.getY() / JEditTextArea.this.getPainter().getFontMetrics().getHeight();
                if (n3 > JEditTextArea.this.screenLastLine) {
                    n3 = JEditTextArea.this.screenLastLine;
                }
                ChunkCache.LineInfo lineInfo = JEditTextArea.this.chunkCache.getLineInfo(n3);
                if (lineInfo.lastSubregion && n2 != 0) {
                    if (!JEditTextArea.this.isEditable()) {
                        JEditTextArea.this.getToolkit().beep();
                        return;
                    }
                    String string = MiscUtilities.createWhiteSpace(n2, 0);
                    JEditTextArea.this.buffer.insert(this.dragStart, string);
                    this.dragStart += string.length();
                }
            }
            if (mouseEvent.isShiftDown()) {
                JEditTextArea.this.resizeSelection(JEditTextArea.this.getMarkPosition(), this.dragStart, n2, JEditTextArea.this.isRectangularSelectionEnabled() || this.control);
                if (!this.quickCopyDrag) {
                    JEditTextArea.this.moveCaretPosition(this.dragStart, false);
                }
                this.dragStartLine = JEditTextArea.this.getMarkLine();
                this.dragStart = JEditTextArea.this.getMarkPosition();
                this.dragStartOffset = this.dragStart - JEditTextArea.this.getLineStartOffset(this.dragStartLine);
                this.dragged = true;
                return;
            }
            if (!this.quickCopyDrag) {
                JEditTextArea.this.moveCaretPosition(this.dragStart, false);
            }
            if (!JEditTextArea.this.multi && !this.quickCopyDrag) {
                JEditTextArea.this.selectNone();
            }
        }

        private void doDoubleClick() {
            if (JEditTextArea.this.getLineLength(this.dragStartLine) == 0) {
                return;
            }
            String string = JEditTextArea.this.getLineText(this.dragStartLine);
            String string2 = JEditTextArea.this.buffer.getStringProperty("noWordSep");
            if (this.dragStartOffset == JEditTextArea.this.getLineLength(this.dragStartLine)) {
                --this.dragStartOffset;
            }
            boolean bl = jEdit.getBooleanProperty("view.joinNonWordChars");
            int n = TextUtilities.findWordStart(string, this.dragStartOffset, string2, bl);
            int n2 = TextUtilities.findWordEnd(string, this.dragStartOffset + 1, string2, bl);
            int n3 = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            Selection.Range range = new Selection.Range(n3 + n, n3 + n2);
            if (JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.addToSelection(range);
            } else {
                JEditTextArea.this.setSelection(range);
            }
            if (this.quickCopyDrag) {
                this.quickCopyDrag = false;
            }
            JEditTextArea.this.moveCaretPosition(n3 + n2, false);
            this.dragged = true;
        }

        private void doTripleClick() {
            int n = JEditTextArea.this.getLineEndOffset(this.dragStartLine);
            if (this.dragStartLine == JEditTextArea.this.buffer.getLineCount() - 1) {
                --n;
            }
            Selection.Range range = new Selection.Range(JEditTextArea.this.getLineStartOffset(this.dragStartLine), n);
            if (JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.addToSelection(range);
            } else {
                JEditTextArea.this.setSelection(range);
            }
            if (this.quickCopyDrag) {
                this.quickCopyDrag = false;
            }
            JEditTextArea.this.moveCaretPosition(n, false);
            this.dragged = true;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.maybeDragAndDrop) {
                JEditTextArea.this.startDragAndDrop(mouseEvent, this.control);
                return;
            }
            if (JEditTextArea.this.dndInProgress) {
                return;
            }
            if (GUIUtilities.isPopupTrigger(mouseEvent) || JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            if (!JEditTextArea.this.buffer.isLoaded()) {
                return;
            }
            if (mouseEvent.getY() < 0) {
                int n = Math.min(-1, mouseEvent.getY() / JEditTextArea.this.painter.getFontMetrics().getHeight());
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() + n);
            } else if (mouseEvent.getY() >= JEditTextArea.this.painter.getHeight()) {
                int n = Math.max(1, (mouseEvent.getY() - JEditTextArea.this.painter.getHeight()) / JEditTextArea.this.painter.getFontMetrics().getHeight());
                if (JEditTextArea.this.lastLinePartial) {
                    --n;
                }
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() + n);
            }
            if (this.quickCopyDrag) {
                JEditTextArea.this.view.getStatus().setMessage(jEdit.getProperty("view.status.rect-quick-copy"));
                this.clearStatus = true;
            }
            switch (this.clickCount) {
                case 1: {
                    this.doSingleDrag(mouseEvent);
                    break;
                }
                case 2: {
                    this.doDoubleDrag(mouseEvent);
                    break;
                }
                default: {
                    this.doTripleDrag(mouseEvent);
                }
            }
        }

        private void doSingleDrag(MouseEvent mouseEvent) {
            float f;
            this.dragged = true;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= JEditTextArea.this.painter.getHeight()) {
                n2 = JEditTextArea.this.painter.getHeight() - 1;
            }
            int n3 = JEditTextArea.this.xyToOffset(n, n2, !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() || this.quickCopyDrag);
            int n4 = JEditTextArea.this.buffer.getLineOfOffset(n3);
            int n5 = 0;
            if (JEditTextArea.this.chunkCache.getLineInfo((int)((JEditTextArea)JEditTextArea.this).screenLastLine).lastSubregion && (float)n > (f = (float)JEditTextArea.this.offsetToXY((int)n4, (int)JEditTextArea.this.getLineLength((int)n4), (Point)JEditTextArea.this.returnValue).x)) {
                n5 = (int)(((float)n - f) / (float)JEditTextArea.this.charWidth);
                if (!JEditTextArea.this.getPainter().isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() && (n - JEditTextArea.this.getHorizontalOffset()) % JEditTextArea.this.charWidth > JEditTextArea.this.charWidth / 2) {
                    ++n5;
                }
            }
            JEditTextArea.this.resizeSelection(this.dragStart, n3, n5, JEditTextArea.this.isRectangularSelectionEnabled() || this.control);
            if (this.quickCopyDrag) {
                JEditTextArea.this.scrollTo(n4, n3 - JEditTextArea.this.buffer.getLineStartOffset(n4), false);
            } else {
                if (n3 != JEditTextArea.this.caret) {
                    JEditTextArea.this.moveCaretPosition(n3, false);
                }
                if (JEditTextArea.this.isRectangularSelectionEnabled() && n5 != 0) {
                    JEditTextArea.this.scrollTo(n4, n3 - JEditTextArea.this.buffer.getLineStartOffset(n4) + n5, false);
                }
            }
        }

        private void doDoubleDrag(MouseEvent mouseEvent) {
            int n = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            int n2 = JEditTextArea.this.getLineLength(this.dragStartLine);
            int n3 = this.dragStartOffset;
            int n4 = JEditTextArea.this.xyToOffset(mouseEvent.getX(), Math.max(0, Math.min(JEditTextArea.this.painter.getHeight(), mouseEvent.getY())), !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled());
            int n5 = JEditTextArea.this.getLineOfOffset(n4);
            int n6 = JEditTextArea.this.getLineStartOffset(n5);
            int n7 = JEditTextArea.this.getLineLength(n5);
            int n8 = n4 - n6;
            String string = JEditTextArea.this.getLineText(n5);
            String string2 = JEditTextArea.this.getLineText(this.dragStartLine);
            String string3 = JEditTextArea.this.buffer.getStringProperty("noWordSep");
            boolean bl = jEdit.getBooleanProperty("view.joinNonWordChars");
            if (n + this.dragStartOffset > n6 + n8) {
                if (n8 != 0 && n8 != n7) {
                    n8 = TextUtilities.findWordStart(string, n8, string3, bl);
                }
                if (n2 != 0) {
                    n3 = TextUtilities.findWordEnd(string2, n3, string3, bl);
                }
            } else {
                if (n8 != 0 && n7 != 0) {
                    n8 = TextUtilities.findWordEnd(string, n8, string3, bl);
                }
                if (n3 != 0 && n3 != n2) {
                    n3 = TextUtilities.findWordStart(string2, n3, string3, bl);
                }
            }
            if (n6 + n8 == JEditTextArea.this.caret) {
                return;
            }
            JEditTextArea.this.resizeSelection(n + n3, n6 + n8, 0, false);
            JEditTextArea.this.moveCaretPosition(n6 + n8, false);
            this.dragged = true;
        }

        private void doTripleDrag(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3 = JEditTextArea.this.xyToOffset(mouseEvent.getX(), Math.max(0, Math.min(JEditTextArea.this.painter.getHeight(), mouseEvent.getY())), false);
            int n4 = JEditTextArea.this.getLineOfOffset(n3);
            if (this.dragStartLine > n4) {
                n2 = JEditTextArea.this.getLineEndOffset(this.dragStartLine) - 1;
                n = n3 == JEditTextArea.this.getLineEndOffset(n4) - 1 ? n3 : JEditTextArea.this.getLineStartOffset(n4);
            } else {
                n2 = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
                n = n3 == JEditTextArea.this.getLineStartOffset(n4) ? n3 : (n3 == JEditTextArea.this.getLineEndOffset(n4) - 1 && n4 != JEditTextArea.this.getBuffer().getLineCount() - 1 ? JEditTextArea.this.getLineEndOffset(n4) : JEditTextArea.this.getLineEndOffset(n4) - 1);
            }
            n = Math.min(JEditTextArea.this.getBuffer().getLength(), n);
            if (n == JEditTextArea.this.caret) {
                return;
            }
            JEditTextArea.this.resizeSelection(n2, n, 0, false);
            JEditTextArea.this.moveCaretPosition(n, false);
            this.dragged = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Selection selection = JEditTextArea.this.getSelectionAtOffset(this.dragStart);
            if (this.dragged && selection != null) {
                Registers.setRegister('%', JEditTextArea.this.getSelectedText(selection));
                if (this.quickCopyDrag) {
                    JEditTextArea.this.removeFromSelection(selection);
                    Registers.paste(focusedComponent, '%', selection instanceof Selection.Rect);
                    focusedComponent.requestFocus();
                }
            } else if (!this.dragged && JEditTextArea.this.isQuickCopyEnabled() && GUIUtilities.isMiddleButton(mouseEvent.getModifiers())) {
                JEditTextArea.this.requestFocus();
                focusedComponent = JEditTextArea.this;
                JEditTextArea.this.setCaretPosition(this.dragStart, false);
                if (!JEditTextArea.this.isEditable()) {
                    JEditTextArea.this.getToolkit().beep();
                } else {
                    Registers.paste(JEditTextArea.this, '%', this.control);
                }
            } else if (this.maybeDragAndDrop && !JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.selectNone();
            }
            this.dragged = false;
            if (this.clearStatus) {
                this.clearStatus = false;
                JEditTextArea.this.view.getStatus().setMessage(null);
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (JEditTextArea.this.bufferChanging) {
                return;
            }
            if (JEditTextArea.this.match != null) {
                if (JEditTextArea.this.caretLine < ((JEditTextArea)JEditTextArea.this).match.startLine) {
                    JEditTextArea.this.invalidateLineRange(JEditTextArea.this.caretLine, ((JEditTextArea)JEditTextArea.this).match.endLine);
                } else {
                    JEditTextArea.this.invalidateLineRange(((JEditTextArea)JEditTextArea.this).match.startLine, JEditTextArea.this.caretLine);
                }
            } else {
                JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            }
            focusedComponent = JEditTextArea.this;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!JEditTextArea.this.isShowing()) {
                return;
            }
            if (JEditTextArea.this.match != null) {
                if (JEditTextArea.this.caretLine < ((JEditTextArea)JEditTextArea.this).match.startLine) {
                    JEditTextArea.this.invalidateLineRange(JEditTextArea.this.caretLine, ((JEditTextArea)JEditTextArea.this).match.endLine);
                } else {
                    JEditTextArea.this.invalidateLineRange(((JEditTextArea)JEditTextArea.this).match.startLine, JEditTextArea.this.caretLine);
                }
            } else {
                JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            }
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            if (adjustmentEvent.getAdjustable() == JEditTextArea.this.vertical) {
                JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
            } else {
                JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
            }
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    class ScrollLayout
    implements LayoutManager {
        Component center;
        Component left;
        Component right;
        Component bottom;
        Component top;

        ScrollLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (string.equals(JEditTextArea.CENTER)) {
                this.center = component;
            } else if (string.equals(JEditTextArea.RIGHT)) {
                this.right = component;
            } else if (string.equals(JEditTextArea.LEFT)) {
                this.left = component;
            } else if (string.equals(JEditTextArea.BOTTOM)) {
                this.bottom = component;
            } else if (string.equals(JEditTextArea.TOP)) {
                this.top = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this.center == component) {
                this.center = null;
            } else if (this.right == component) {
                this.right = null;
            } else if (this.left == component) {
                this.left = null;
            } else if (this.bottom == component) {
                this.bottom = null;
            } else if (this.top == component) {
                this.top = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.left.getPreferredSize();
            dimension.width += dimension2.width;
            Dimension dimension3 = this.center.getPreferredSize();
            dimension.width += dimension3.width;
            dimension.height += dimension3.height;
            Dimension dimension4 = this.right.getPreferredSize();
            dimension.width += dimension4.width;
            Dimension dimension5 = this.bottom.getPreferredSize();
            dimension.height += dimension5.height;
            if (this.top != null) {
                Dimension dimension6 = this.top.getPreferredSize();
                dimension.height += dimension6.height;
            }
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.left.getMinimumSize();
            dimension.width += dimension2.width;
            Dimension dimension3 = this.center.getMinimumSize();
            dimension.width += dimension3.width;
            dimension.height += dimension3.height;
            Dimension dimension4 = this.right.getMinimumSize();
            dimension.width += dimension4.width;
            Dimension dimension5 = this.bottom.getMinimumSize();
            dimension.height += dimension5.height;
            if (this.top != null) {
                Dimension dimension6 = this.top.getMinimumSize();
                dimension.height += dimension6.height;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            int n = insets.top;
            int n2 = insets.left;
            int n3 = insets.bottom;
            int n4 = insets.right;
            int n5 = this.right.getPreferredSize().width;
            int n6 = this.left.getPreferredSize().width;
            int n7 = this.top != null ? this.top.getPreferredSize().height : 0;
            int n8 = this.bottom.getPreferredSize().height;
            int n9 = Math.max(0, dimension.width - n6 - n5 - n2 - n4);
            int n10 = Math.max(0, dimension.height - n7 - n8 - n - n3);
            this.left.setBounds(n2, n + n7, n6, n10);
            this.center.setBounds(n2 + n6, n + n7, n9, n10);
            this.right.setBounds(n2 + n6 + n9, n + n7, n5, n10);
            this.bottom.setBounds(n2, n + n7 + n10, Math.max(0, dimension.width - JEditTextArea.this.vertical.getWidth() - n2 - n4), n8);
            if (this.top != null) {
                this.top.setBounds(n2, n, n6 + n9 + n5, n7);
            }
        }
    }

    static class TextAreaBorder
    extends AbstractBorder {
        TextAreaBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n3 - 2, 2, n3 - 2, 2);
            graphics.drawLine(1, n4 - 2, 1, n4 - 2);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 2, 2);
        }
    }

    static class RectParams {
        int extraStartVirt;
        int extraEndVirt;
        int newCaret;

        RectParams(int n, int n2, int n3) {
            this.extraStartVirt = n;
            this.extraEndVirt = n2;
            this.newCaret = n3;
        }
    }
}

