/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import com.microstar.xml.HandlerBase;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Stack;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;

public abstract class XModeHandler
extends HandlerBase {
    private String modeName;
    private TokenMarker marker;
    private KeywordMap keywords;
    private Stack stateStack;
    private String propName;
    private String propValue;
    private Hashtable props;
    private Hashtable modeProps;
    private String lastStart;
    private String lastEnd;
    private String lastKeyword;
    private String lastSetName;
    private String lastEscape;
    private ParserRuleSet lastDelegateSet;
    private String lastNoWordSep;
    private ParserRuleSet rules;
    private byte lastDefaultID = 0;
    private byte lastTokenID;
    private int termChar = -1;
    private boolean lastNoLineBreak;
    private boolean lastNoWordBreak;
    private boolean lastExcludeMatch;
    private boolean lastIgnoreCase = true;
    private boolean lastHighlightDigits;
    private boolean lastAtLineStart;
    private boolean lastAtWhitespaceEnd;
    private boolean lastAtWordStart;
    private boolean lastNoEscape;
    private int lastStartPosMatch;
    private int lastEndPosMatch;
    private String lastDigitRE;
    private char lastHashChar;

    public XModeHandler(String string) {
        this.modeName = string;
        this.marker = new TokenMarker();
        this.marker.addRuleSet(new ParserRuleSet(string, "MAIN"));
        this.stateStack = new Stack();
        this.lastNoWordSep = "_";
    }

    public Object resolveEntity(String string, String string2) {
        if ("xmode.dtd".equals(string2)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String string, String string2, boolean bl) {
        String string3 = string = string == null ? null : string.intern();
        if (string == "NAME") {
            this.propName = string2;
        } else if (string == "VALUE") {
            this.propValue = string2;
        } else if (string == "TYPE") {
            this.lastTokenID = Token.stringToToken(string2);
            if (this.lastTokenID == -1) {
                this.error("token-invalid", string2);
            }
        } else if (string == "AT_LINE_START") {
            this.lastAtLineStart = bl ? string2.equals("TRUE") : false;
        } else if (string == "AT_WHITESPACE_END") {
            this.lastAtWhitespaceEnd = bl ? string2.equals("TRUE") : false;
        } else if (string == "AT_WORD_START") {
            this.lastAtWordStart = bl ? string2.equals("TRUE") : false;
        } else if (string == "NO_LINE_BREAK") {
            this.lastNoLineBreak = bl ? string2.equals("TRUE") : false;
        } else if (string == "NO_WORD_BREAK") {
            this.lastNoWordBreak = bl ? string2.equals("TRUE") : false;
        } else if (string == "NO_ESCAPE") {
            this.lastNoEscape = bl ? string2.equals("TRUE") : false;
        } else if (string == "EXCLUDE_MATCH") {
            this.lastExcludeMatch = bl ? string2.equals("TRUE") : false;
        } else if (string == "IGNORE_CASE") {
            this.lastIgnoreCase = bl ? string2.equals("TRUE") : true;
        } else if (string == "HIGHLIGHT_DIGITS") {
            this.lastHighlightDigits = bl ? string2.equals("TRUE") : false;
        } else if (string == "DIGIT_RE") {
            this.lastDigitRE = string2;
        } else if (string == "NO_WORD_SEP") {
            if (bl) {
                this.lastNoWordSep = string2;
            }
        } else if (string == "AT_CHAR") {
            try {
                if (bl) {
                    this.termChar = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.error("termchar-invalid", string2);
                this.termChar = -1;
            }
        } else if (string == "ESCAPE") {
            this.lastEscape = string2;
        } else if (string == "SET") {
            this.lastSetName = string2;
        } else if (string == "DELEGATE") {
            if (string2 != null) {
                String string4;
                String string5;
                int n = string2.indexOf("::");
                if (n != -1) {
                    string5 = string2.substring(0, n);
                    string4 = string2.substring(n + 2);
                } else {
                    string5 = this.modeName;
                    string4 = string2;
                }
                TokenMarker tokenMarker = this.getTokenMarker(string5);
                if (tokenMarker == null) {
                    this.error("delegate-invalid", string2);
                } else {
                    this.lastDelegateSet = tokenMarker.getRuleSet(string4);
                    if (tokenMarker == this.marker && this.lastDelegateSet == null) {
                        this.lastDelegateSet = new ParserRuleSet(string5, string4);
                        this.lastDelegateSet.setDefault((byte)7);
                        this.marker.addRuleSet(this.lastDelegateSet);
                    } else if (this.lastDelegateSet == null) {
                        this.error("delegate-invalid", string2);
                    }
                }
            }
        } else if (string == "DEFAULT") {
            this.lastDefaultID = Token.stringToToken(string2);
            if (this.lastDefaultID == -1) {
                this.error("token-invalid", string2);
                this.lastDefaultID = 0;
            }
        } else if (string == "HASH_CHAR") {
            if (string2.length() != 1) {
                this.error("hash-char-invalid", string2);
                this.lastDefaultID = 0;
            } else {
                this.lastHashChar = string2.charAt(0);
            }
        }
    }

    public void doctypeDecl(String string, String string2, String string3) throws Exception {
        if ("MODE".equalsIgnoreCase(string)) {
            return;
        }
        this.error("doctype-invalid", string);
    }

    public void charData(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        String string2 = new String(cArray, n, n2);
        if (string == "EOL_SPAN" || string == "EOL_SPAN_REGEXP" || string == "MARK_PREVIOUS" || string == "MARK_FOLLOWING" || string == "SEQ" || string == "SEQ_REGEXP" || string == "BEGIN") {
            this.lastStart = string2;
            this.lastStartPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
            this.lastAtLineStart = false;
            this.lastAtWordStart = false;
            this.lastAtWhitespaceEnd = false;
        } else if (string == "END") {
            this.lastEnd = string2;
            this.lastEndPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
            this.lastAtLineStart = false;
            this.lastAtWordStart = false;
            this.lastAtWhitespaceEnd = false;
        } else {
            this.lastKeyword = string2;
        }
    }

    public void startElement(String string) {
        if ((string = this.pushElement(string)) == "WHITESPACE") {
            Log.log(7, this, this.modeName + ": WHITESPACE rule " + "no longer needed");
        } else if (string == "KEYWORDS") {
            this.keywords = new KeywordMap(this.rules.getIgnoreCase());
        } else if (string == "RULES") {
            if (this.lastSetName == null) {
                this.lastSetName = "MAIN";
            }
            this.rules = this.marker.getRuleSet(this.lastSetName);
            if (this.rules == null) {
                this.rules = new ParserRuleSet(this.modeName, this.lastSetName);
                this.marker.addRuleSet(this.rules);
            }
            this.rules.setIgnoreCase(this.lastIgnoreCase);
            this.rules.setHighlightDigits(this.lastHighlightDigits);
            if (this.lastDigitRE != null) {
                try {
                    this.rules.setDigitRegexp(new RE(this.lastDigitRE, this.lastIgnoreCase ? 2 : 0, ParserRule.RE_SYNTAX_JEDIT));
                }
                catch (REException rEException) {
                    this.error("regexp", rEException);
                }
            }
            if (this.lastEscape != null) {
                this.rules.setEscapeRule(ParserRule.createEscapeRule(this.lastEscape));
            }
            this.rules.setDefault(this.lastDefaultID);
            this.rules.setNoWordSep(this.lastNoWordSep);
        }
    }

    public void endElement(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.popElement();
        if (string.equals(string2)) {
            if (string2 == "PROPERTY") {
                this.props.put(this.propName, this.propValue);
            } else if (string2 == "PROPS") {
                if (this.peekElement().equals("RULES")) {
                    this.rules.setProperties(this.props);
                } else {
                    this.modeProps = this.props;
                }
                this.props = new Hashtable();
            } else if (string2 == "RULES") {
                this.rules.setKeywords(this.keywords);
                this.keywords = null;
                this.lastSetName = null;
                this.lastEscape = null;
                this.lastIgnoreCase = true;
                this.lastHighlightDigits = false;
                this.lastDigitRE = null;
                this.lastDefaultID = 0;
                this.lastNoWordSep = "_";
                this.rules = null;
            } else if (string2 == "IMPORT") {
                this.rules.addRuleSet(this.lastDelegateSet);
                this.lastDelegateSet = null;
            } else if (string2 == "TERMINATE") {
                this.rules.setTerminateChar(this.termChar);
                this.termChar = -1;
            } else if (string2 == "SEQ") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "SEQ");
                    return;
                }
                this.rules.addRule(ParserRule.createSequenceRule(this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID));
                this.reset();
            } else if (string2 == "SEQ_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "SEQ_REGEXP");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpSequenceRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastIgnoreCase));
                }
                catch (REException rEException) {
                    this.error("regexp", rEException);
                }
                this.reset();
            } else if (string2 == "SPAN") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "BEGIN");
                    return;
                }
                if (this.lastEnd == null) {
                    this.error("empty-tag", "END");
                    return;
                }
                this.rules.addRule(ParserRule.createSpanRule(this.lastStartPosMatch, this.lastStart, this.lastEndPosMatch, this.lastEnd, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastNoLineBreak, this.lastNoWordBreak, this.lastNoEscape));
                this.reset();
            } else if (string2 == "SPAN_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "BEGIN");
                    return;
                }
                if (this.lastEnd == null) {
                    this.error("empty-tag", "END");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpSpanRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastEndPosMatch, this.lastEnd, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastNoLineBreak, this.lastNoWordBreak, this.lastIgnoreCase, this.lastNoEscape));
                }
                catch (REException rEException) {
                    this.error("regexp", rEException);
                }
                this.reset();
            } else if (string2 == "EOL_SPAN") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "EOL_SPAN");
                    return;
                }
                this.rules.addRule(ParserRule.createEOLSpanRule(this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else if (string2 == "EOL_SPAN_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "EOL_SPAN_REGEXP");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpEOLSpanRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastIgnoreCase));
                }
                catch (REException rEException) {
                    this.error("regexp", rEException);
                }
                this.reset();
            } else if (string2 == "MARK_FOLLOWING") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "MARK_FOLLOWING");
                    return;
                }
                this.rules.addRule(ParserRule.createMarkFollowingRule(this.lastStartPosMatch, this.lastStart, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else if (string2 == "MARK_PREVIOUS") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "MARK_PREVIOUS");
                    return;
                }
                this.rules.addRule(ParserRule.createMarkPreviousRule(this.lastStartPosMatch, this.lastStart, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else {
                byte by = Token.stringToToken(string2);
                if (by != -1) {
                    this.addKeyword(this.lastKeyword, by);
                }
            }
        } else {
            throw new InternalError();
        }
    }

    public void startDocument() {
        this.props = new Hashtable();
        this.pushElement(null);
    }

    public void endDocument() {
        ParserRuleSet[] parserRuleSetArray = this.marker.getRuleSets();
        for (int i = 0; i < parserRuleSetArray.length; ++i) {
            parserRuleSetArray[i].resolveImports();
        }
    }

    public TokenMarker getTokenMarker() {
        return this.marker;
    }

    public Hashtable getModeProperties() {
        return this.modeProps;
    }

    protected abstract void error(String var1, Object var2);

    protected abstract TokenMarker getTokenMarker(String var1);

    private void reset() {
        this.lastHashChar = '\u0000';
        this.lastStartPosMatch = 0;
        this.lastStart = null;
        this.lastEndPosMatch = 0;
        this.lastEnd = null;
        this.lastDelegateSet = null;
        this.lastTokenID = 0;
        this.lastExcludeMatch = false;
        this.lastNoLineBreak = false;
        this.lastNoWordBreak = false;
        this.lastNoEscape = false;
    }

    private void addKeyword(String string, byte by) {
        if (string == null) {
            this.error("empty-keyword", null);
            return;
        }
        if (this.keywords == null) {
            return;
        }
        this.keywords.add(string, by);
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

