/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.CharIndexedSegment;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class HyperSearchRequest
extends WorkRequest {
    private View view;
    private SearchMatcher matcher;
    private HyperSearchResults results;
    private DefaultMutableTreeNode rootSearchNode;
    private Selection[] selection;
    private String searchString;

    public HyperSearchRequest(View view, SearchMatcher searchMatcher, HyperSearchResults hyperSearchResults, Selection[] selectionArray) {
        this.view = view;
        this.matcher = searchMatcher;
        this.results = hyperSearchResults;
        this.searchString = SearchAndReplace.getSearchString();
        this.rootSearchNode = new DefaultMutableTreeNode(this.searchString);
        this.selection = selectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setStatus(jEdit.getProperty("hypersearch-status"));
        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
        String[] stringArray = searchFileSet.getFiles(this.view);
        if (stringArray == null || stringArray.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIUtilities.error((Component)((Object)HyperSearchRequest.this.view), "empty-fileset", null);
                    HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                }
            });
            return;
        }
        this.setProgressMaximum(searchFileSet.getFileCount(this.view));
        long l = 0L;
        try {
            try {
                if (this.selection != null) {
                    Buffer buffer = this.view.getBuffer();
                    this.searchInSelection(buffer);
                } else {
                    int n = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        Buffer buffer;
                        String string = stringArray[i];
                        ++n;
                        long l2 = System.currentTimeMillis();
                        if (l2 - l > 250L) {
                            this.setProgressValue(n);
                            l = l2;
                        }
                        if ((buffer = jEdit.openTemporary(null, null, string, false)) == null) continue;
                        this.doHyperSearch(buffer);
                    }
                }
                Object var12_12 = null;
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchAndReplace.handleError((Component)((Object)HyperSearchRequest.this.view), exception);
                    }
                });
                Object var12_13 = null;
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                    }
                });
                return;
            }
            catch (WorkThread.Abort abort) {
                Object var12_14 = null;
                VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInSelection(Buffer buffer) throws Exception {
        this.setAbortable(false);
        int n = 0;
        try {
            buffer.readLock();
            for (int i = 0; i < this.selection.length; ++i) {
                Selection selection = this.selection[i];
                if (selection instanceof Selection.Rect) {
                    for (int j = selection.getStartLine(); j <= selection.getEndLine(); ++j) {
                        n += this.doHyperSearch(buffer, selection.getStart(buffer, j), selection.getEnd(buffer, j));
                    }
                    continue;
                }
                n += this.doHyperSearch(buffer, selection.getStart(), selection.getEnd());
            }
            Object var7_6 = null;
            buffer.readUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            buffer.readUnlock();
            throw throwable;
        }
        this.setAbortable(true);
        return n;
    }

    private int doHyperSearch(Buffer buffer) throws Exception {
        return this.doHyperSearch(buffer, 0, buffer.getLength());
    }

    private int doHyperSearch(Buffer buffer, int n, int n2) throws Exception {
        this.setAbortable(false);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(buffer.getPath());
        int n3 = this.doHyperSearch(buffer, n, n2, defaultMutableTreeNode);
        if (n3 != 0) {
            this.rootSearchNode.insert(defaultMutableTreeNode, this.rootSearchNode.getChildCount());
        }
        this.setAbortable(true);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doHyperSearch(Buffer buffer, int n, int n2, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n3 = 0;
        try {
            buffer.readLock();
            boolean bl = buffer.getLineEndOffset(buffer.getLineOfOffset(n2)) - 1 == n2;
            Segment segment = new Segment();
            int n4 = n;
            HyperSearchResult hyperSearchResult = null;
            int n5 = 0;
            while (true) {
                boolean bl2 = buffer.getLineStartOffset(buffer.getLineOfOffset(n4)) == n4;
                buffer.getText(n4, n2 - n4, segment);
                SearchMatcher.Match match = this.matcher.nextMatch(new CharIndexedSegment(segment, false), bl2, bl, n5 == 0, false);
                if (match == null) break;
                int n6 = buffer.getLineOfOffset(n4 + match.start);
                if (hyperSearchResult == null || hyperSearchResult.line != n6) {
                    hyperSearchResult = new HyperSearchResult(buffer, n6);
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(hyperSearchResult, false));
                }
                hyperSearchResult.addOccur(n4 + match.start, n4 + match.end);
                n4 += match.end;
                ++n3;
                ++n5;
            }
            Object var15_14 = null;
            buffer.readUnlock();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            buffer.readUnlock();
            throw throwable;
        }
        return n3;
    }
}

