/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;

public class DirectoryListSet
extends BufferListSet {
    private String directory;
    private String glob;
    private boolean recurse;

    public DirectoryListSet(String string, String string2, boolean bl) {
        this.directory = string;
        this.glob = string2;
        this.recurse = bl;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
        this.invalidateCachedList();
    }

    public String getFileFilter() {
        return this.glob;
    }

    public void setFileFilter(String string) {
        this.glob = string;
        this.invalidateCachedList();
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public void setRecursive(boolean bl) {
        this.recurse = bl;
        this.invalidateCachedList();
    }

    public String getCode() {
        return "new DirectoryListSet(\"" + MiscUtilities.charsToEscapes(this.directory) + "\",\"" + MiscUtilities.charsToEscapes(this.glob) + "\"," + this.recurse + ")";
    }

    protected String[] _getFiles(final Component component) {
        Object object;
        final VFS vFS = VFSManager.getVFSForPath(this.directory);
        if (SwingUtilities.isEventDispatchThread()) {
            object = vFS.createVFSSession(this.directory, component);
        } else {
            final Object[] objectArray = new Object[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        objectArray[0] = vFS.createVFSSession(DirectoryListSet.this.directory, component);
                    }
                });
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
            object = objectArray[0];
        }
        if (object == null) {
            return null;
        }
        try {
            return vFS._listDirectory(object, this.directory, this.glob, this.recurse, component);
        }
        catch (IOException iOException) {
            VFSManager.error(component, this.directory, "ioerror", new String[]{iOException.toString()});
            return null;
        }
    }
}

