/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import gnu.regexp.CharIndexed;
import org.gjt.sp.jedit.search.SearchMatcher;

public class BoyerMooreSearchMatcher
extends SearchMatcher {
    private char[] pattern;
    private int pattern_end;
    private boolean ignoreCase;
    private int[] fwd_skip;
    private int[] fwd_suffix;
    private int[] back_skip;
    private int[] back_suffix;

    public BoyerMooreSearchMatcher(String string, boolean bl) {
        this.pattern = string.toCharArray();
        if (bl) {
            for (int i = 0; i < this.pattern.length; ++i) {
                this.pattern[i] = Character.toUpperCase(this.pattern[i]);
            }
        }
        this.ignoreCase = bl;
        this.pattern_end = this.pattern.length - 1;
    }

    public SearchMatcher.Match nextMatch(CharIndexed charIndexed, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = this.match(charIndexed, bl4);
        if (n == -1) {
            return null;
        }
        this.returnValue.start = n;
        this.returnValue.end = n + this.pattern.length;
        return this.returnValue;
    }

    public int match(CharIndexed charIndexed, boolean bl) {
        int[] nArray;
        int[] nArray2;
        if (bl) {
            if (this.back_skip == null) {
                this.back_skip = this.generateSkipArray(true);
                this.back_suffix = this.generateSuffixArray(true);
            }
            nArray2 = this.back_skip;
            nArray = this.back_suffix;
        } else {
            if (this.fwd_skip == null) {
                this.fwd_skip = this.generateSkipArray(false);
                this.fwd_suffix = this.generateSuffixArray(false);
            }
            nArray2 = this.fwd_skip;
            nArray = this.fwd_suffix;
        }
        int n = 0;
        char c = '\u0000';
        block0: while (charIndexed.isValid()) {
            for (int i = this.pattern_end; i >= 0; --i) {
                c = charIndexed.charAt(i);
                if (this.ignoreCase) {
                    c = Character.toUpperCase(c);
                }
                if (!(bl ? c != this.pattern[this.pattern_end - i] : c != this.pattern[i])) continue;
                int n2 = i - nArray2[BoyerMooreSearchMatcher.getSkipIndex(c)];
                int n3 = nArray[i];
                int n4 = n2 > n3 ? n2 : n3;
                n += n4;
                charIndexed.move(n4);
                continue block0;
            }
            return n;
        }
        return -1;
    }

    private int[] generateSkipArray(boolean bl) {
        int[] nArray = new int[256];
        if (this.pattern.length == 0) {
            return nArray;
        }
        int n = 0;
        do {
            nArray[BoyerMooreSearchMatcher.getSkipIndex((char)this.pattern[bl ? this.pattern_end - n : n])] = n++;
        } while (n < this.pattern.length);
        return nArray;
    }

    private static final int getSkipIndex(char c) {
        return c & 0xFF;
    }

    private int[] generateSuffixArray(boolean bl) {
        int n;
        int n2 = this.pattern.length;
        int n3 = n2 + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        nArray2[n2] = n3;
        for (n = n2; n > 0; --n) {
            while (n3 <= n2 && this.pattern[bl ? this.pattern_end - n + 1 : n - 1] != this.pattern[bl ? this.pattern_end - n3 + 1 : n3 - 1]) {
                if (nArray[n3] == 0) {
                    nArray[n3] = n3 - n;
                }
                n3 = nArray2[n3];
            }
            nArray2[n - 1] = --n3;
        }
        n = nArray2[0];
        for (n3 = 0; n3 <= n2; ++n3) {
            if (n3 > 0) {
                int n4 = nArray[n3 - 1] = nArray[n3] == 0 ? n : nArray[n3];
            }
            if (n3 != n) continue;
            n = nArray2[n];
        }
        return nArray;
    }
}

