/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;

class WindowTableModel
extends AbstractTableModel {
    private Vector windows = new Vector();

    WindowTableModel() {
        String[] stringArray = DockableWindowManager.getRegisteredDockableWindows();
        for (int i = 0; i < stringArray.length; ++i) {
            this.windows.addElement(new Entry(stringArray[i]));
        }
        this.sort();
    }

    public void sort() {
        MiscUtilities.quicksort(this.windows, (MiscUtilities.Compare)new WindowCompare());
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.windows.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int n, int n2) {
        Entry entry = (Entry)this.windows.elementAt(n);
        switch (n2) {
            case 0: {
                return entry.title;
            }
            case 1: {
                return entry.dockPosition;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        Entry entry = (Entry)this.windows.elementAt(n);
        switch (n2) {
            case 1: {
                entry.dockPosition = (String)object;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.docking.title");
            }
            case 1: {
                return jEdit.getProperty("options.docking.dockPosition");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.windows.size(); ++i) {
            ((Entry)this.windows.elementAt(i)).save();
        }
    }

    class WindowCompare
    implements MiscUtilities.Compare {
        WindowCompare() {
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return MiscUtilities.compareStrings(entry.title, entry2.title, true);
        }
    }

    class Entry {
        String name;
        String title;
        String dockPosition;

        Entry(String string) {
            this.name = string;
            this.title = jEdit.getProperty(string + ".title");
            if (this.title == null) {
                this.title = string;
            }
            this.dockPosition = jEdit.getProperty(string + ".dock-position");
            if (this.dockPosition == null) {
                this.dockPosition = "floating";
            }
        }

        void save() {
            jEdit.setProperty(this.name + ".dock-position", this.dockPosition);
        }
    }
}

