/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.UtilEvalError;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.Autosave;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ModeCatalogHandler;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.PropertyManager;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.SettingsReloader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.TipOfTheDay;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.EditorExitRequested;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.EditorStarted;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class jEdit {
    private static String jEditHome;
    private static String settingsDirectory;
    private static String jarCacheDirectory;
    private static long propsModTime;
    private static PropertyManager propMgr;
    private static EditServer server;
    private static boolean background;
    private static ActionContext actionContext;
    private static ActionSet builtInActionSet;
    private static Vector pluginErrors;
    private static Object pluginErrorLock;
    private static Vector jars;
    private static Vector modes;
    private static boolean saveCaret;
    private static InputHandler inputHandler;
    private static boolean sortBuffers;
    private static boolean sortByName;
    private static int bufferCount;
    private static Buffer buffersFirst;
    private static Buffer buffersLast;
    private static Map bufferHash;
    private static Object bufferListLock;
    private static int viewCount;
    private static View viewsFirst;
    private static View viewsLast;
    private static View activeView;
    private static boolean firstViewOpened;
    private static boolean startupDone;
    private static Thread mainThread;

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jEdit.getBuild());
    }

    public static String getBuild() {
        return "04.02.99.00";
    }

    public static void main(String[] stringArray) {
        String string;
        BufferedWriter bufferedWriter;
        Object object;
        Object object2;
        Serializable serializable;
        int n;
        String string2 = System.getProperty("java.version");
        if (string2.compareTo("1.3") < 0) {
            System.err.println("You are running Java version " + string2 + ".");
            System.err.println("jEdit requires Java 1.3 or later.");
            System.exit(1);
        }
        mainThread = Thread.currentThread();
        settingsDirectory = ".jedit";
        background = OperatingSystem.isMacOS();
        boolean bl = false;
        int n2 = 7;
        String string3 = "server";
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = false;
        boolean bl9 = false;
        String string4 = System.getProperty("user.dir");
        String string5 = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string6 = stringArray[n];
            if (string6 == null) continue;
            if (string6.length() == 0) {
                stringArray[n] = null;
                continue;
            }
            if (!string6.startsWith("-") || bl) continue;
            if (string6.equals("--")) {
                bl = true;
            } else if (string6.equals("-usage")) {
                jEdit.version();
                System.err.println();
                jEdit.usage();
                System.exit(1);
            } else if (string6.equals("-version")) {
                jEdit.version();
                System.exit(1);
            } else if (string6.startsWith("-log=")) {
                try {
                    n2 = Integer.parseInt(string6.substring("-log=".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Malformed option: " + string6);
                }
            } else if (string6.equals("-nosettings")) {
                settingsDirectory = null;
            } else if (string6.startsWith("-settings=")) {
                settingsDirectory = string6.substring(10);
            } else if (string6.startsWith("-noserver")) {
                string3 = null;
            } else if (string6.equals("-server")) {
                string3 = "server";
            } else if (string6.startsWith("-server=")) {
                string3 = string6.substring(8);
            } else if (string6.startsWith("-background")) {
                background = true;
            } else if (string6.startsWith("-nobackground")) {
                background = false;
            } else if (string6.equals("-gui")) {
                bl5 = true;
            } else if (string6.equals("-nogui")) {
                bl5 = false;
            } else if (string6.equals("-newview")) {
                bl3 = true;
            } else if (string6.equals("-newplainview")) {
                bl4 = true;
            } else if (string6.equals("-reuseview")) {
                bl3 = false;
                bl4 = false;
            } else if (string6.equals("-restore")) {
                bl2 = true;
            } else if (string6.equals("-norestore")) {
                bl2 = false;
            } else if (string6.equals("-plugins")) {
                bl6 = true;
            } else if (string6.equals("-noplugins")) {
                bl6 = false;
            } else if (string6.equals("-startupscripts")) {
                bl7 = true;
            } else if (string6.equals("-nostartupscripts")) {
                bl7 = false;
            } else if (string6.startsWith("-run=")) {
                string5 = string6.substring(5);
            } else if (string6.equals("-wait")) {
                bl9 = true;
            } else if (string6.equals("-quit")) {
                bl8 = true;
            } else {
                System.err.println("Unknown option: " + string6);
                jEdit.usage();
                System.exit(1);
            }
            stringArray[n] = null;
        }
        if (settingsDirectory != null) {
            settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), settingsDirectory);
            settingsDirectory = MiscUtilities.resolveSymlinks(settingsDirectory);
        }
        string3 = settingsDirectory != null && string3 != null ? MiscUtilities.constructPath(settingsDirectory, string3) : null;
        Log.init(false, n2);
        if (string3 != null && new File(string3).exists()) {
            try {
                serializable = new BufferedReader(new FileReader(string3));
                object2 = ((BufferedReader)((Object)serializable)).readLine();
                if (!((String)object2).equals("b")) {
                    throw new Exception("Wrong port file format");
                }
                n = Integer.parseInt(((BufferedReader)((Object)serializable)).readLine());
                int n3 = Integer.parseInt(((BufferedReader)((Object)serializable)).readLine());
                object = new Socket(InetAddress.getByName("127.0.0.1"), n);
                DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
                dataOutputStream.writeInt(n3);
                String string7 = bl8 ? "socket.close();\njEdit.exit(null,true);\n" : jEdit.makeServerScript(bl9, bl2, bl3, bl4, stringArray, string5);
                dataOutputStream.writeUTF(string7);
                Log.log(1, jEdit.class, "Waiting for server");
                try {
                    ((Socket)object).getInputStream().read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((BufferedReader)((Object)serializable)).close();
                dataOutputStream.close();
                System.exit(0);
            }
            catch (Exception exception) {
                Log.log(5, jEdit.class, "An error occurred while connecting to the jEdit server instance.");
                Log.log(5, jEdit.class, "This probably means that jEdit crashed and/or exited abnormally");
                Log.log(5, jEdit.class, "the last time it was run.");
                Log.log(5, jEdit.class, "If you don't know what this means, don't worry.");
                Log.log(5, jEdit.class, exception);
            }
        }
        if (bl8) {
            System.exit(0);
        }
        if (!new File(settingsDirectory, "nosplash").exists()) {
            GUIUtilities.showSplashScreen();
        }
        if (settingsDirectory != null) {
            File file = new File(settingsDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!((File)(serializable = new File(settingsDirectory, "macros"))).exists()) {
                ((File)serializable).mkdir();
            }
            object2 = MiscUtilities.constructPath(settingsDirectory, "activity.log");
            jEdit.backupSettingsFile(new File((String)object2));
            try {
                bufferedWriter = new BufferedWriter(new FileWriter((String)object2));
                object = System.getProperty("line.separator");
                bufferedWriter.write("Log file created on " + new Date());
                bufferedWriter.write((String)object);
                bufferedWriter.write("IMPORTANT:");
                bufferedWriter.write((String)object);
                bufferedWriter.write("Because updating this file after every log message would kill");
                bufferedWriter.write((String)object);
                bufferedWriter.write("performance, it will be *incomplete* unless you invoke the");
                bufferedWriter.write((String)object);
                bufferedWriter.write("Utilities->Troubleshooting->Update Activity Log on Disk command!");
                bufferedWriter.write((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bufferedWriter = null;
            }
        } else {
            bufferedWriter = null;
        }
        Log.setLogWriter(bufferedWriter);
        Log.log(5, jEdit.class, "jEdit version " + jEdit.getVersion());
        Log.log(3, jEdit.class, "Settings directory is " + settingsDirectory);
        jEdit.initMisc();
        jEdit.initSystemProperties();
        GUIUtilities.advanceSplashProgress();
        GUIUtilities.init();
        BeanShell.init();
        if (jEditHome != null) {
            jEdit.initSiteProperties();
        }
        jEdit.initUserProperties();
        if (string3 != null) {
            server = new EditServer(string3);
            if (!server.isOK()) {
                server = null;
            }
        } else if (background) {
            background = false;
            Log.log(7, jEdit.class, "You cannot specify both the -background and -noserver switches");
        }
        VFSManager.init();
        jEdit.initResources();
        SearchAndReplace.load();
        GUIUtilities.advanceSplashProgress();
        if (bl6) {
            jEdit.initPlugins();
        }
        HistoryModel.loadHistory();
        BufferHistory.load();
        KillRing.load();
        jEdit.propertiesChanged();
        GUIUtilities.advanceSplashProgress();
        sortBuffers = jEdit.getBooleanProperty("sortBuffers");
        sortByName = jEdit.getBooleanProperty("sortByName");
        jEdit.reloadModes();
        GUIUtilities.advanceSplashProgress();
        if (OperatingSystem.hasJava14()) {
            try {
                ClassLoader classLoader = jEdit.class.getClassLoader();
                serializable = classLoader != null ? classLoader.loadClass("org.gjt.sp.jedit.Java14") : Class.forName("org.gjt.sp.jedit.Java14");
                object2 = ((Class)serializable).getMethod("init", new Class[0]);
                ((Method)object2).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
                System.exit(1);
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            ((PluginJAR)jars.elementAt(i)).activatePluginIfNecessary();
        }
        Macros.loadMacros();
        Macros.getMacroActionSet().initKeyBindings();
        if (bl7 && jEditHome != null && ((File)(serializable = new File(string = MiscUtilities.constructPath(jEditHome, "startup")))).exists()) {
            jEdit.runStartupScripts((File)serializable);
        }
        if (bl7 && settingsDirectory != null) {
            String string8 = MiscUtilities.constructPath(settingsDirectory, "startup");
            serializable = new File(string8);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            } else {
                jEdit.runStartupScripts((File)serializable);
            }
        }
        if (string5 != null) {
            string5 = MiscUtilities.constructPath(string4, string5);
            try {
                BeanShell.getNameSpace().setVariable("args", stringArray);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, jEdit.class, utilEvalError);
            }
            BeanShell.runScript(null, string5, null, false);
        }
        GUIUtilities.advanceSplashProgress();
        jEdit.finishStartup(bl5, bl2, string4, stringArray);
    }

    public static final Properties getProperties() {
        return propMgr.getProperties();
    }

    public static final String getProperty(String string) {
        return propMgr.getProperty(string);
    }

    public static final String getProperty(String string, String string2) {
        String string3 = propMgr.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static final String getProperty(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return jEdit.getProperty(string);
        }
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static final boolean getBooleanProperty(String string) {
        return jEdit.getBooleanProperty(string, false);
    }

    public static final boolean getBooleanProperty(String string, boolean bl) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("true") || string2.equals("yes") || string2.equals("on")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("no") || string2.equals("off")) {
            return false;
        }
        return bl;
    }

    public static final int getIntegerProperty(String string, int n) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static double getDoubleProperty(String string, double d) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static final Font getFontProperty(String string) {
        return jEdit.getFontProperty(string, null);
    }

    public static final Font getFontProperty(String string, Font font) {
        int n;
        int n2;
        String string2 = jEdit.getProperty(string);
        String string3 = jEdit.getProperty(string + "size");
        String string4 = jEdit.getProperty(string + "style");
        if (string2 == null || string3 == null || string4 == null) {
            return font;
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        return new Font(string2, n, n2);
    }

    public static Color getColorProperty(String string) {
        return jEdit.getColorProperty(string, Color.black);
    }

    public static Color getColorProperty(String string, Color color) {
        String string2 = jEdit.getProperty(string);
        if (string2 == null) {
            return color;
        }
        return GUIUtilities.parseColor(string2, color);
    }

    public static void setColorProperty(String string, Color color) {
        jEdit.setProperty(string, GUIUtilities.getColorHexString(color));
    }

    public static final void setProperty(String string, String string2) {
        propMgr.setProperty(string, string2);
    }

    public static final void setTemporaryProperty(String string, String string2) {
        propMgr.setTemporaryProperty(string, string2);
    }

    public static final void setBooleanProperty(String string, boolean bl) {
        jEdit.setProperty(string, bl ? "true" : "false");
    }

    public static final void setIntegerProperty(String string, int n) {
        jEdit.setProperty(string, String.valueOf(n));
    }

    public static final void setDoubleProperty(String string, double d) {
        jEdit.setProperty(string, String.valueOf(d));
    }

    public static final void setFontProperty(String string, Font font) {
        jEdit.setProperty(string, font.getFamily());
        jEdit.setIntegerProperty(string + "size", font.getSize());
        jEdit.setIntegerProperty(string + "style", font.getStyle());
    }

    public static final void unsetProperty(String string) {
        propMgr.unsetProperty(string);
    }

    public static final void resetProperty(String string) {
        propMgr.resetProperty(string);
    }

    public static void propertiesChanged() {
        jEdit.initKeyBindings();
        Autosave.setInterval(jEdit.getIntegerProperty("autosave", 30));
        saveCaret = jEdit.getBooleanProperty("saveCaret");
        UIDefaults uIDefaults = UIManager.getDefaults();
        Font font = jEdit.getFontProperty("view.font");
        uIDefaults.put("TextArea.font", font);
        uIDefaults.put("TextPane.font", font);
        ToolTipManager.sharedInstance().setEnabled(jEdit.getBooleanProperty("showTooltips"));
        jEdit.initProxy();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.resetCachedProperties();
            buffer.propertiesChanged();
            buffer = buffer.next;
        }
        HistoryModel.propertiesChanged();
        KillRing.propertiesChanged();
        EditBus.send(new PropertiesChanged(null));
    }

    public static String[] getNotLoadedPluginJARs() {
        Object[] objectArray;
        String[] stringArray;
        Vector vector = new Vector();
        if (jEditHome != null && (stringArray = new File((String)(objectArray = MiscUtilities.constructPath(jEditHome, "jars"))).list()) != null) {
            jEdit.getNotLoadedPluginJARs(vector, (String)objectArray, stringArray);
        }
        if (settingsDirectory != null && (stringArray = new File((String)(objectArray = MiscUtilities.constructPath(settingsDirectory, "jars"))).list()) != null) {
            jEdit.getNotLoadedPluginJARs(vector, (String)objectArray, stringArray);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static EditPlugin getPlugin(String string) {
        return jEdit.getPlugin(string, false);
    }

    public static EditPlugin getPlugin(String string, boolean bl) {
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        EditPlugin editPlugin = null;
        for (int i = 0; i < editPluginArray.length; ++i) {
            if (editPluginArray[i].getClassName().equals(string)) {
                editPlugin = editPluginArray[i];
            }
            if (!bl || !(editPlugin instanceof EditPlugin.Deferred)) continue;
            editPlugin.getPluginJAR().activatePlugin();
            editPlugin = editPlugin.getPluginJAR().getPlugin();
            break;
        }
        return editPlugin;
    }

    public static EditPlugin[] getPlugins() {
        Vector<EditPlugin> vector = new Vector<EditPlugin>();
        for (int i = 0; i < jars.size(); ++i) {
            EditPlugin editPlugin = ((PluginJAR)jars.elementAt(i)).getPlugin();
            if (editPlugin == null) continue;
            vector.add(editPlugin);
        }
        Object[] objectArray = new EditPlugin[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static PluginJAR[] getPluginJARs() {
        Object[] objectArray = new PluginJAR[jars.size()];
        jars.copyInto(objectArray);
        return objectArray;
    }

    public static PluginJAR getPluginJAR(String string) {
        for (int i = 0; i < jars.size(); ++i) {
            PluginJAR pluginJAR = (PluginJAR)jars.elementAt(i);
            if (!pluginJAR.getPath().equals(string)) continue;
            return pluginJAR;
        }
        return null;
    }

    public static void addPluginJAR(String string) {
        EditPlugin.JAR jAR = new EditPlugin.JAR(new File(string));
        jars.addElement(jAR);
        jAR.init();
        EditBus.send(new PluginUpdate(jAR, PluginUpdate.LOADED, false));
        if (!jEdit.isMainThread()) {
            EditBus.send(new DynamicMenuChanged("plugins"));
            jEdit.initKeyBindings();
        }
    }

    private static void addPluginJARsFromDirectory(String string) {
        Log.log(5, jEdit.class, "Loading plugins from " + string);
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.toLowerCase().endsWith(".jar")) continue;
            String string3 = MiscUtilities.constructPath(string, string2);
            if (string2.equals("EditBuddy.jar") || string2.equals("PluginManager.jar") || string2.equals("Firewall.jar") || string2.equals("Tidy.jar") || string2.equals("DragAndDrop.jar")) {
                jEdit.pluginError(string3, "plugin-error.obsolete", null);
                continue;
            }
            jEdit.addPluginJAR(string3);
        }
    }

    public static void removePluginJAR(PluginJAR pluginJAR, boolean bl) {
        if (bl) {
            pluginJAR.uninit(true);
        } else {
            pluginJAR.uninit(false);
            jars.removeElement(pluginJAR);
            jEdit.initKeyBindings();
        }
        EditBus.send(new PluginUpdate(pluginJAR, PluginUpdate.UNLOADED, bl));
        if (!jEdit.isMainThread() && !bl) {
            EditBus.send(new DynamicMenuChanged("plugins"));
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public static void addActionSet(ActionSet actionSet) {
        actionContext.addActionSet(actionSet);
    }

    public static void removeActionSet(ActionSet actionSet) {
        actionContext.removeActionSet(actionSet);
    }

    public static ActionSet getBuiltInActionSet() {
        return builtInActionSet;
    }

    public static ActionSet[] getActionSets() {
        return actionContext.getActionSets();
    }

    public static EditAction getAction(String string) {
        return actionContext.getAction(string);
    }

    public static ActionSet getActionSetForAction(String string) {
        return actionContext.getActionSetForAction(string);
    }

    public static ActionSet getActionSetForAction(EditAction editAction) {
        return actionContext.getActionSetForAction(editAction.getName());
    }

    public static EditAction[] getActions() {
        String[] stringArray = actionContext.getActionNames();
        EditAction[] editActionArray = new EditAction[stringArray.length];
        for (int i = 0; i < editActionArray.length; ++i) {
            editActionArray[i] = actionContext.getAction(stringArray[i]);
            if (editActionArray[i] != null) continue;
            Log.log(9, jEdit.class, "wtf: " + stringArray[i]);
        }
        return editActionArray;
    }

    public static String[] getActionNames() {
        return actionContext.getActionNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void reloadModes() {
        Object object;
        block17: {
            File file;
            block16: {
                modes = new Vector(50);
                if (jEditHome == null) {
                    jEdit.loadModeCatalog("/modes/catalog", true);
                } else {
                    jEdit.loadModeCatalog(MiscUtilities.constructPath(jEditHome, "modes", "catalog"), false);
                }
                if (settingsDirectory == null) break block17;
                object = new File(MiscUtilities.constructPath(settingsDirectory, "modes"));
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                if (!(file = new File(MiscUtilities.constructPath(settingsDirectory, "modes", "catalog"))).exists()) {
                    FileWriter fileWriter = null;
                    fileWriter = new FileWriter(file);
                    fileWriter.write(jEdit.getProperty("defaultCatalog"));
                    fileWriter.close();
                    Object var5_3 = null;
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {}
                    break block16;
                    {
                        catch (IOException iOException) {
                            Log.log(9, jEdit.class, iOException);
                            var5_3 = null;
                            try {
                                if (fileWriter != null) {
                                    fileWriter.close();
                                }
                                break block16;
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        try {
                            if (fileWriter != null) {
                                fileWriter.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            jEdit.loadModeCatalog(file.getPath(), false);
        }
        object = buffersFirst;
        while (object != null) {
            ((Buffer)object).setMode();
            object = ((Buffer)object).next;
        }
    }

    public static Mode getMode(String string) {
        for (int i = 0; i < modes.size(); ++i) {
            Mode mode = (Mode)modes.elementAt(i);
            if (!mode.getName().equals(string)) continue;
            return mode;
        }
        return null;
    }

    public static Mode[] getModes() {
        Object[] objectArray = new Mode[modes.size()];
        modes.copyInto(objectArray);
        return objectArray;
    }

    public static Buffer openFiles(View view, String string, String[] stringArray) {
        Buffer buffer = null;
        Buffer buffer2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (string2.startsWith("+line:") || string2.startsWith("+marker:")) {
                if (buffer2 == null) continue;
                jEdit.gotoMarker(view, buffer2, string2);
                continue;
            }
            buffer2 = jEdit.openFile(null, string, string2, false, null);
            if (buffer != null || buffer2 == null) continue;
            buffer = buffer2;
        }
        if (view != null && buffer != null) {
            view.setBuffer(buffer);
        }
        return buffer;
    }

    public static Buffer openFile(View view, String string) {
        return jEdit.openFile(view, null, string, false, new Hashtable());
    }

    public static Buffer openFile(View view, String string, String string2, boolean bl, boolean bl2) {
        return jEdit.openFile(view, string, string2, bl2, new Hashtable());
    }

    public static Buffer openFile(View view, String string, String string2, boolean bl, boolean bl2, Hashtable hashtable) {
        return jEdit.openFile(view, string, string2, bl2, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openFile(View view, String string, String string2, boolean bl, Hashtable hashtable) {
        Buffer buffer;
        PerspectiveManager.setPerspectiveDirty(true);
        if (view != null && string == null) {
            string = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(string2) && MiscUtilities.getProtocolOfURL(string2).equals("file")) {
            string2 = string2.substring(5);
        }
        string2 = MiscUtilities.constructPath(string, string2);
        Object object = bufferListLock;
        synchronized (object) {
            BufferHistory.Entry entry;
            Buffer buffer2 = jEdit.getBuffer(string2);
            if (buffer2 != null) {
                if (view != null) {
                    view.setBuffer(buffer2);
                }
                return buffer2;
            }
            if (hashtable == null) {
                hashtable = new Hashtable<String, Object>();
            }
            if ((entry = BufferHistory.getEntry(string2)) != null && saveCaret && hashtable.get("Buffer__caret") == null) {
                hashtable.put("Buffer__caret", new Integer(entry.caret));
            }
            if (entry != null && hashtable.get("encoding") == null && entry.encoding != null) {
                hashtable.put("encoding", entry.encoding);
            }
            if (!(buffer = new Buffer(string2, bl, false, hashtable)).load(view, false)) {
                return null;
            }
            jEdit.addBufferToList(buffer);
        }
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CREATED));
        if (view != null) {
            view.setBuffer(buffer);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openTemporary(View view, String string, String string2, boolean bl) {
        if (view != null && string == null) {
            string = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(string2) && MiscUtilities.getProtocolOfURL(string2).equals("file")) {
            string2 = string2.substring(5);
        }
        string2 = MiscUtilities.constructPath(string, string2);
        Object object = bufferListLock;
        synchronized (object) {
            Buffer buffer = jEdit.getBuffer(string2);
            if (buffer != null) {
                return buffer;
            }
            buffer = new Buffer(string2, bl, true, new Hashtable());
            if (!buffer.load(view, false)) {
                return null;
            }
            return buffer;
        }
    }

    public static void commitTemporary(Buffer buffer) {
        if (!buffer.isTemporary()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        jEdit.addBufferToList(buffer);
        buffer.commitTemporary();
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.CREATED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOAD_STARTED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOADED));
    }

    public static Buffer newFile(View view) {
        String string;
        if (view != null && view.getBuffer() != null) {
            string = view.getBuffer().getDirectory();
            VFS vFS = VFSManager.getVFSForPath(string);
            if ((vFS.getCapabilities() & 2) == 0) {
                string = System.getProperty("user.home");
            }
        } else {
            string = null;
        }
        return jEdit.newFile(view, string);
    }

    public static Buffer newFile(View view, String string) {
        if (string != null && buffersFirst != null && buffersFirst == buffersLast && buffersFirst.isUntitled() && !buffersFirst.isDirty()) {
            jEdit.closeBuffer(view, buffersFirst);
            return buffersFirst;
        }
        int n = 0;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getName().startsWith("Untitled-")) {
                try {
                    n = Math.max(n, Integer.parseInt(buffer.getName().substring(9)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buffer = buffer.next;
        }
        return jEdit.openFile(view, string, "Untitled-" + (n + 1), true, null);
    }

    public static boolean closeBuffer(View view, Buffer buffer) {
        if (buffer.isPerformingIO()) {
            VFSManager.waitForRequests();
            if (VFSManager.errorOccurred()) {
                return false;
            }
        }
        if (buffer.isDirty()) {
            Object[] objectArray = new Object[]{buffer.getName()};
            int n = GUIUtilities.confirm((Component)((Object)view), "notsaved", objectArray, 1, 2);
            if (n == 0) {
                if (!buffer.save(view, null, true)) {
                    return false;
                }
                VFSManager.waitForRequests();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return false;
                }
            } else if (n != 1) {
                return false;
            }
        }
        jEdit._closeBuffer(view, buffer);
        return true;
    }

    public static void _closeBuffer(View view, Buffer buffer) {
        Object object;
        if (buffer.isClosed()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        if (!buffer.isNewFile()) {
            if (view != null) {
                view.getEditPane().saveCaretInfo();
            }
            int n = (object = (Integer)buffer.getProperty("Buffer__caret")) == null ? 0 : (Integer)object;
            BufferHistory.setEntry(buffer.getPath(), n, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"));
        }
        if ((VFSManager.getVFSForPath((String)(object = buffer.getSymlinkPath())).getCapabilities() & 0x80) != 0) {
            object = ((String)object).toLowerCase();
        }
        bufferHash.remove(object);
        jEdit.removeBufferFromList(buffer);
        buffer.close();
        DisplayManager.bufferClosed(buffer);
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
        if (buffersFirst == null && buffersLast == null) {
            jEdit.newFile(view);
        }
    }

    public static boolean closeAllBuffers(View view) {
        return jEdit.closeAllBuffers(view, false);
    }

    public static boolean closeAllBuffers(View view, boolean bl) {
        boolean bl2;
        if (view != null) {
            view.getEditPane().saveCaretInfo();
        }
        boolean bl3 = false;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                bl3 = true;
                break;
            }
            buffer = buffer.next;
        }
        if (bl3 && !(bl2 = new CloseDialog(view).isOK())) {
            return false;
        }
        VFSManager.waitForRequests();
        if (VFSManager.errorOccurred()) {
            return false;
        }
        buffer = buffersFirst;
        buffersLast = null;
        buffersFirst = null;
        bufferHash.clear();
        bufferCount = 0;
        while (buffer != null) {
            if (!buffer.isNewFile()) {
                Integer n = (Integer)buffer.getProperty("Buffer__caret");
                int n2 = n == null ? 0 : n;
                BufferHistory.setEntry(buffer.getPath(), n2, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"));
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!bl) {
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            buffer = buffer.next;
        }
        if (!bl) {
            jEdit.newFile(view);
        }
        PerspectiveManager.setPerspectiveDirty(true);
        return true;
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers(view, jEdit.getBooleanProperty("confirmSaveAll"));
    }

    public static void saveAllBuffers(View view, boolean bl) {
        int n;
        if (bl && (n = GUIUtilities.confirm((Component)((Object)view), "saveall", null, 0, 3)) != 0) {
            return;
        }
        Buffer buffer = view.getBuffer();
        Buffer buffer2 = buffersFirst;
        while (buffer2 != null) {
            if (buffer2.isDirty()) {
                if (buffer2.isNewFile()) {
                    view.setBuffer(buffer2);
                }
                buffer2.save(view, null, true);
            }
            buffer2 = buffer2.next;
        }
        view.setBuffer(buffer);
    }

    public static void reloadAllBuffers(View view, boolean bl) {
        int n;
        boolean bl2 = false;
        Buffer[] bufferArray = jEdit.getBuffers();
        for (n = 0; n < bufferArray.length && !bl2; ++n) {
            bl2 = bufferArray[n].isDirty();
        }
        if (bl && bl2 && (n = GUIUtilities.confirm((Component)((Object)view), "reload-all", null, 0, 3)) != 0) {
            return;
        }
        View view2 = viewsFirst;
        while (view2 != null) {
            EditPane[] editPaneArray = view2.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                editPaneArray[i].saveCaretInfo();
            }
            view2 = view2.next;
        }
        for (int i = 0; i < bufferArray.length; ++i) {
            Buffer buffer = bufferArray[i];
            buffer.load(view, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer _getBuffer(String string) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        Object object = bufferListLock;
        synchronized (object) {
            return (Buffer)bufferHash.get(string);
        }
    }

    public static Buffer getBuffer(String string) {
        return jEdit._getBuffer(MiscUtilities.resolveSymlinks(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer[] getBuffers() {
        Object object = bufferListLock;
        synchronized (object) {
            Buffer[] bufferArray = new Buffer[bufferCount];
            Buffer buffer = buffersFirst;
            for (int i = 0; i < bufferCount; ++i) {
                bufferArray[i] = buffer;
                buffer = buffer.next;
            }
            return bufferArray;
        }
    }

    public static int getBufferCount() {
        return bufferCount;
    }

    public static Buffer getFirstBuffer() {
        return buffersFirst;
    }

    public static Buffer getLastBuffer() {
        return buffersLast;
    }

    public static void checkBufferStatus(View view) {
        Object object;
        boolean bl = jEdit.getBooleanProperty("autoReloadDialog");
        boolean bl2 = jEdit.getBooleanProperty("autoReload");
        View view2 = viewsFirst;
        while (view2 != null) {
            object = view2.getEditPanes();
            for (int i = 0; i < ((EditPane[])object).length; ++i) {
                object[i].saveCaretInfo();
            }
            view2 = view2.next;
        }
        object = buffersFirst;
        int[] nArray = new int[bufferCount];
        int n = 0;
        boolean bl3 = false;
        while (object != null) {
            nArray[n] = ((Buffer)object).checkFileStatus(view);
            switch (nArray[n]) {
                case 1: {
                    if (bl2 && bl && !((Buffer)object).isDirty()) {
                        ((Buffer)object).load(view, true);
                    }
                }
                case 2: {
                    bl3 = true;
                }
            }
            object = ((Buffer)object).next;
            ++n;
        }
        if (bl3 && bl) {
            new FilesChangedDialog(view, nArray, bl2);
        }
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static View newView(View view) {
        return jEdit.newView(view, null, false);
    }

    public static View newView(View view, Buffer buffer) {
        return jEdit.newView(view, buffer, false);
    }

    public static View newView(View view, Buffer buffer, boolean bl) {
        View.ViewConfig viewConfig = view != null && bl == view.isPlainView() ? view.getViewConfig() : new View.ViewConfig(bl);
        return jEdit.newView(view, buffer, viewConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View newView(View view, Buffer buffer, View.ViewConfig viewConfig) {
        PerspectiveManager.setPerspectiveDirty(true);
        try {
            EBComponent eBComponent;
            if (view != null) {
                view.showWaitCursor();
                view.getEditPane().saveCaretInfo();
            }
            View view2 = new View(buffer, viewConfig);
            jEdit.addViewToList(view2);
            if (!viewConfig.plainView) {
                eBComponent = view2.getDockableWindowManager();
                if (viewConfig.top != null && viewConfig.top.length() != 0) {
                    ((DockableWindowManager)eBComponent).showDockableWindow(viewConfig.top);
                }
                if (viewConfig.left != null && viewConfig.left.length() != 0) {
                    ((DockableWindowManager)eBComponent).showDockableWindow(viewConfig.left);
                }
                if (viewConfig.bottom != null && viewConfig.bottom.length() != 0) {
                    ((DockableWindowManager)eBComponent).showDockableWindow(viewConfig.bottom);
                }
                if (viewConfig.right != null && viewConfig.right.length() != 0) {
                    ((DockableWindowManager)eBComponent).showDockableWindow(viewConfig.right);
                }
            }
            view2.pack();
            EditBus.send(new ViewUpdate(view2, ViewUpdate.CREATED));
            view2.setVisible(true);
            if (!firstViewOpened) {
                firstViewOpened = true;
                view2.getTextArea().requestFocus();
                if (settingsDirectory != null && jEdit.getBooleanProperty("firstTime")) {
                    new HelpViewer();
                } else if (jEdit.getBooleanProperty("tip.show")) {
                    new TipOfTheDay(view2);
                }
                jEdit.setBooleanProperty("firstTime", false);
            }
            eBComponent = view2;
            Object var6_5 = null;
            if (view != null) {
                view.hideWaitCursor();
            }
            return eBComponent;
        }
        catch (Throwable throwable) {
            block13: {
                Object var6_6 = null;
                if (view == null) break block13;
                view.hideWaitCursor();
            }
            throw throwable;
        }
    }

    public static void closeView(View view) {
        jEdit.closeView(view, true);
    }

    public static View[] getViews() {
        View[] viewArray = new View[viewCount];
        View view = viewsFirst;
        for (int i = 0; i < viewCount; ++i) {
            viewArray[i] = view;
            view = view.next;
        }
        return viewArray;
    }

    public static int getViewCount() {
        return viewCount;
    }

    public static View getFirstView() {
        return viewsFirst;
    }

    public static View getLastView() {
        return viewsLast;
    }

    public static View getActiveView() {
        if (activeView == null) {
            return viewsFirst;
        }
        return activeView;
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isBackgroundModeEnabled() {
        return background;
    }

    public static void showMemoryDialog(View view) {
        Runtime runtime = Runtime.getRuntime();
        int n = (int)(runtime.freeMemory() / 1024L);
        System.gc();
        int n2 = (int)(runtime.freeMemory() / 1024L);
        int n3 = (int)(runtime.totalMemory() / 1024L);
        JProgressBar jProgressBar = new JProgressBar(0, n3);
        jProgressBar.setValue(n3 - n2);
        jProgressBar.setStringPainted(true);
        jProgressBar.setString(jEdit.getProperty("memory-status.use", new Object[]{new Integer(n3 - n2), new Integer(n3)}));
        Object[] objectArray = new Object[]{jEdit.getProperty("memory-status.gc", new Object[]{new Integer(n2 - n)}), Box.createVerticalStrut(12), jProgressBar, Box.createVerticalStrut(6)};
        JOptionPane.showMessageDialog((Component)((Object)view), objectArray, jEdit.getProperty("memory-status.title"), 1);
    }

    public static String getJEditHome() {
        return jEditHome;
    }

    public static String getSettingsDirectory() {
        return settingsDirectory;
    }

    public static String getJARCacheDirectory() {
        return jarCacheDirectory;
    }

    public static void backupSettingsFile(File file) {
        if (settingsDirectory == null) {
            return;
        }
        String string = MiscUtilities.constructPath(settingsDirectory, "settings-backup");
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        MiscUtilities.saveBackup(file, 5, null, "~", string);
    }

    public static void saveSettings() {
        if (settingsDirectory == null) {
            return;
        }
        Abbrevs.save();
        FavoritesVFS.saveFavorites();
        HistoryModel.saveHistory();
        Registers.saveRegisters();
        SearchAndReplace.save();
        File file = new File(MiscUtilities.constructPath(settingsDirectory, "#properties#save#"));
        File file2 = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
        if (file2.exists() && file2.lastModified() != propsModTime) {
            Log.log(7, jEdit.class, file2 + " changed" + " on disk; will not save user properties");
        } else {
            jEdit.backupSettingsFile(file2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                propMgr.saveUserProps(fileOutputStream);
                file2.delete();
                file.renameTo(file2);
            }
            catch (IOException iOException) {
                Log.log(9, jEdit.class, iOException);
            }
            propsModTime = file2.lastModified();
        }
    }

    public static void exit(View view, boolean bl) {
        if (view == null) {
            view = activeView;
        }
        VFSManager.waitForRequests();
        EditBus.send(new EditorExitRequested(view));
        if (!jEdit.closeAllBuffers(view, bl |= !background)) {
            return;
        }
        if (!bl) {
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            jEdit.saveSettings();
        } else {
            if (view != null) {
                view.close();
            }
            Autosave.stop();
            if (server != null) {
                server.stopServer();
            }
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                jEdit.removePluginJAR(pluginJARArray[i], true);
            }
            EditBus.send(new EditorExiting(null));
            jEdit.saveSettings();
            Log.closeStream();
        }
    }

    public static EditServer getEditServer() {
        return server;
    }

    static void updatePosition(String string, Buffer buffer) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        bufferHash.remove(string);
        String string2 = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(string2).getCapabilities() & 0x80) != 0) {
            string2 = string2.toLowerCase();
        }
        bufferHash.put(string2, buffer);
        if (sortBuffers) {
            jEdit.removeBufferFromList(buffer);
            jEdit.addBufferToList(buffer);
        }
    }

    public static void addMode(Mode mode) {
        modes.addElement(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void loadMode(Mode mode) {
        block12: {
            final String string = (String)mode.getProperty("file");
            Log.log(5, jEdit.class, "Loading edit mode " + string);
            final XmlParser xmlParser = new XmlParser();
            XModeHandler xModeHandler = new XModeHandler(mode.getName()){

                public void error(String string3, Object object) {
                    String string2;
                    int n = xmlParser.getLineNumber();
                    int n2 = xmlParser.getColumnNumber();
                    if (object == null) {
                        string2 = jEdit.getProperty("xmode-error." + string3);
                    } else {
                        string2 = jEdit.getProperty("xmode-error." + string3, new String[]{object.toString()});
                        if (object instanceof Throwable) {
                            Log.log(9, this, object);
                        }
                    }
                    Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), string2};
                    GUIUtilities.error(null, "xmode-error", objectArray);
                }

                public TokenMarker getTokenMarker(String string2) {
                    Mode mode = jEdit.getMode(string2);
                    if (mode == null) {
                        return null;
                    }
                    return mode.getTokenMarker();
                }
            };
            mode.setTokenMarker(xModeHandler.getTokenMarker());
            BufferedReader bufferedReader = null;
            xmlParser.setHandler(xModeHandler);
            bufferedReader = new BufferedReader(new FileReader(string));
            xmlParser.parse(null, null, bufferedReader);
            mode.setProperties(xModeHandler.getModeProperties());
            Object var11_5 = null;
            try {
                if (bufferedReader != null) {
                    ((Reader)bufferedReader).close();
                }
                break block12;
            }
            catch (IOException iOException) {
                Log.log(9, jEdit.class, iOException);
            }
            break block12;
            {
                catch (Throwable throwable) {
                    Log.log(9, jEdit.class, throwable);
                    if (throwable instanceof XmlException) {
                        XmlException xmlException = (XmlException)throwable;
                        int n = xmlException.getLine();
                        String string2 = xmlException.getMessage();
                        Object[] objectArray = new Object[]{string, new Integer(n), null, string2};
                        GUIUtilities.error(null, "xmode-error", objectArray);
                    }
                    Object var11_6 = null;
                    try {
                        if (bufferedReader != null) {
                            ((Reader)bufferedReader).close();
                        }
                        break block12;
                    }
                    catch (IOException iOException) {
                        Log.log(9, jEdit.class, iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_7 = null;
                try {
                    if (bufferedReader != null) {
                        ((Reader)bufferedReader).close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, jEdit.class, iOException);
                }
                throw throwable;
            }
        }
    }

    static void addPluginProps(Properties properties) {
        propMgr.addPluginProps(properties);
    }

    static void removePluginProps(Properties properties) {
        propMgr.removePluginProps(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pluginError(String string, String string2, Object[] objectArray) {
        Object object = pluginErrorLock;
        synchronized (object) {
            if (pluginErrors == null) {
                pluginErrors = new Vector();
            }
            ErrorListDialog.ErrorEntry errorEntry = new ErrorListDialog.ErrorEntry(string, string2, objectArray);
            for (int i = 0; i < pluginErrors.size(); ++i) {
                if (!pluginErrors.get(i).equals(errorEntry)) continue;
                return;
            }
            pluginErrors.addElement(errorEntry);
            if (startupDone) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jEdit.showPluginErrorDialog();
                    }
                });
            }
        }
    }

    static void setActiveView(View view) {
        activeView = view;
    }

    private jEdit() {
    }

    private static void usage() {
        System.out.println("Usage: jedit [<options>] [<files>]");
        System.out.println("\t<file> +marker:<marker>: Positions caret at marker <marker>");
        System.out.println("\t<file> +line:<line>: Positions caret at line number <line>");
        System.out.println("\t--: End of options");
        System.out.println("\t-background: Run in background mode");
        System.out.println("\t-nobackground: Disable background mode (default)");
        System.out.println("\t-gui: Only if running in background mode; open initial view (default)");
        System.out.println("\t-nogui: Only if running in background mode; don't open initial view");
        System.out.println("\t-log=<level>: Log messages with level equal to or higher than this to");
        System.out.println("\t standard error. <level> must be between 1 and 9. Default is 7.");
        System.out.println("\t-newplainview: Client instance opens a new plain view");
        System.out.println("\t-newview: Client instance opens a new view (default)");
        System.out.println("\t-plugins: Load plugins (default)");
        System.out.println("\t-noplugins: Don't load any plugins");
        System.out.println("\t-restore: Restore previously open files (default)");
        System.out.println("\t-norestore: Don't restore previously open files");
        System.out.println("\t-reuseview: Client instance reuses existing view");
        System.out.println("\t-quit: Quit a running instance");
        System.out.println("\t-run=<script>: Run the specified BeanShell script");
        System.out.println("\t-server: Read/write server info from/to $HOME/.jedit/server (default)");
        System.out.println("\t-server=<name>: Read/write server info from/to $HOME/.jedit/<name>");
        System.out.println("\t-noserver: Don't start edit server");
        System.out.println("\t-settings=<path>: Load user-specific settings from <path>");
        System.out.println("\t-nosettings: Don't load user-specific settings");
        System.out.println("\t-startupscripts: Run startup scripts (default)");
        System.out.println("\t-nostartupscripts: Don't run startup scripts");
        System.out.println("\t-usage: Print this message and exit");
        System.out.println("\t-version: Print jEdit version and exit");
        System.out.println("\t-wait: Wait until the user closes the specified buffer in the server");
        System.out.println("\t instance. Does nothing if passed to the initial jEdit instance.");
        System.out.println();
        System.out.println("Report bugs to Slava Pestov <slava@jedit.org>.");
    }

    private static void version() {
        System.out.println("jEdit " + jEdit.getVersion());
    }

    private static String makeServerScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("user.dir");
        stringBuffer.append("parent = \"");
        stringBuffer.append(MiscUtilities.charsToEscapes(string2));
        stringBuffer.append("\";\n");
        stringBuffer.append("args = new String[");
        stringBuffer.append(stringArray.length);
        stringBuffer.append("];\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("args[");
            stringBuffer.append(i);
            stringBuffer.append("] = ");
            if (stringArray[i] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(MiscUtilities.charsToEscapes(stringArray[i]));
                stringBuffer.append('\"');
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("view = jEdit.getLastView();\n");
        stringBuffer.append("buffer = EditServer.handleClient(" + bl2 + "," + bl3 + "," + bl4 + ",parent,args);\n");
        stringBuffer.append("if(buffer != null && " + bl + ") {\n");
        stringBuffer.append("\tbuffer.setWaitSocket(socket);\n");
        stringBuffer.append("\tdoNotCloseSocket = true;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("if(view != jEdit.getLastView() && " + bl + ") {\n");
        stringBuffer.append("\tjEdit.getLastView().setWaitSocket(socket);\n");
        stringBuffer.append("\tdoNotCloseSocket = true;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("if(doNotCloseSocket == void)\n");
        stringBuffer.append("\tsocket.close();\n");
        if (string != null) {
            string = MiscUtilities.constructPath(string2, string);
            stringBuffer.append("BeanShell.runScript(view,\"" + MiscUtilities.charsToEscapes(string) + "\",null,this.namespace);\n");
        }
        return stringBuffer.toString();
    }

    private static void initMisc() {
        jars = new Vector();
        actionContext = new ActionContext(){

            public void invokeAction(EventObject eventObject, EditAction editAction) {
                ActionBar actionBar;
                View view = GUIUtilities.getView((Component)eventObject.getSource());
                boolean bl = view.getActionBar() == null || !view.getActionBar().isShowing() ? false : view.getActionBar().isVisible();
                view.getInputHandler().invokeAction(editAction);
                if (bl && (actionBar = view.getActionBar()) != null) {
                    view.removeToolBar(actionBar);
                }
            }
        };
        bufferHash = new HashMap();
        inputHandler = new DefaultInputHandler(null);
        String string = "jEdit/" + jEdit.getVersion() + " (Java " + System.getProperty("java.version") + ". " + System.getProperty("java.vendor") + "; " + System.getProperty("os.arch") + ")";
        System.getProperties().put("http.agent", string);
        jEditHome = System.getProperty("jedit.home");
        if (jEditHome == null) {
            String string2 = System.getProperty("java.class.path");
            int n = string2.toLowerCase().indexOf("jedit.jar");
            int n2 = string2.lastIndexOf(File.pathSeparator, n) + 1;
            if (string2.equalsIgnoreCase("jedit.jar")) {
                jEditHome = System.getProperty("user.dir");
            } else if (n > n2) {
                jEditHome = string2.substring(n2, n - 1);
            } else {
                jEditHome = System.getProperty("user.dir");
                Log.log(7, jEdit.class, "jedit.jar not in class path!");
                Log.log(7, jEdit.class, "Assuming jEdit is installed in " + jEditHome + ".");
                Log.log(7, jEdit.class, "Override with jedit.home system property.");
            }
        }
        jEditHome = MiscUtilities.resolveSymlinks(jEditHome);
        Log.log(3, jEdit.class, "jEdit home directory is " + jEditHome);
        if (settingsDirectory != null) {
            jarCacheDirectory = MiscUtilities.constructPath(settingsDirectory, "jars-cache");
            new File(jarCacheDirectory).mkdirs();
        }
        EditBus.addToBus(new SettingsReloader());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(new JARClassLoader());
            }
        });
    }

    private static void initSystemProperties() {
        propMgr = new PropertyManager();
        try {
            propMgr.loadSystemProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit.props"));
            propMgr.loadSystemProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit_gui.props"));
            propMgr.loadSystemProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit_keys.props"));
        }
        catch (Exception exception) {
            Log.log(9, jEdit.class, "Error while loading system properties!");
            Log.log(9, jEdit.class, "One of the following property files could not be loaded:\n- jedit.props\n- jedit_gui.props\n- jedit_keys.props\njedit.jar is probably corrupt.");
            Log.log(9, jEdit.class, exception);
            System.exit(1);
        }
    }

    private static void initSiteProperties() {
        String string = MiscUtilities.constructPath(jEditHome, "properties");
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        Object[] objectArray = file.list();
        if (objectArray == null) {
            return;
        }
        MiscUtilities.quicksort(objectArray, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!((String)object).toLowerCase().endsWith(".props")) continue;
            try {
                String string2 = MiscUtilities.constructPath(string, (String)object);
                Log.log(1, jEdit.class, "Loading site snippet: " + string2);
                propMgr.loadSiteProps(new FileInputStream(new File(string2)));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log(1, jEdit.class, fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                Log.log(9, jEdit.class, "Cannot load site snippet " + (String)object);
                Log.log(9, jEdit.class, iOException);
            }
        }
    }

    private static void initResources() {
        builtInActionSet = new ActionSet(null, null, null, jEdit.class.getResource("actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.jEdit"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
        DockableWindowManager.loadDockableWindows(null, jEdit.class.getResource("dockables.xml"), null);
        ServiceManager.loadServices(null, jEdit.class.getResource("services.xml"), null);
    }

    private static void initPlugins() {
        Object object;
        if (jEditHome != null) {
            jEdit.addPluginJARsFromDirectory(MiscUtilities.constructPath(jEditHome, "jars"));
        }
        if (settingsDirectory != null) {
            object = new File(settingsDirectory, "jars");
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            jEdit.addPluginJARsFromDirectory(((File)object).getPath());
        }
        object = jEdit.getPluginJARs();
        for (int i = 0; i < ((PluginJAR[])object).length; ++i) {
            ((PluginJAR)object[i]).checkDependencies();
        }
    }

    private static void initUserProperties() {
        if (settingsDirectory != null) {
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            propsModTime = file.lastModified();
            try {
                propMgr.loadUserProps(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
            }
        }
    }

    private static String fontStyleToString(int n) {
        if (n == 0) {
            return "PLAIN";
        }
        if (n == 1) {
            return "BOLD";
        }
        if (n == 2) {
            return "ITALIC";
        }
        if (n == 3) {
            return "BOLDITALIC";
        }
        throw new RuntimeException("Invalid style: " + n);
    }

    private static String fontToString(Font font) {
        return font.getFamily() + "-" + jEdit.fontStyleToString(font.getStyle()) + "-" + font.getSize();
    }

    private static void initPLAF() {
        Object object;
        Object object2;
        Font font = jEdit.getFontProperty("metal.primary.font");
        if (font != null) {
            object2 = jEdit.fontToString(font);
            System.getProperties().put("swing.plaf.metal.controlFont", object2);
            System.getProperties().put("swing.plaf.metal.menuFont", object2);
        }
        if ((object2 = jEdit.getFontProperty("metal.secondary.font")) != null) {
            object = jEdit.fontToString((Font)object2);
            System.getProperties().put("swing.plaf.metal.systemFont", object);
            System.getProperties().put("swing.plaf.metal.userFont", object);
        }
        try {
            object = jEdit.getProperty("lookAndFeel");
            if (object != null && ((String)object).length() != 0) {
                UIManager.setLookAndFeel((String)object);
            } else if (OperatingSystem.isMacOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            Log.log(9, jEdit.class, exception);
        }
        object = UIManager.getDefaults();
        if (jEdit.getBooleanProperty("textColors")) {
            ColorUIResource colorUIResource = new ColorUIResource(jEdit.getColorProperty("view.bgColor"));
            ColorUIResource colorUIResource2 = new ColorUIResource(jEdit.getColorProperty("view.fgColor"));
            ColorUIResource colorUIResource3 = new ColorUIResource(jEdit.getColorProperty("view.caretColor"));
            ColorUIResource colorUIResource4 = new ColorUIResource(jEdit.getColorProperty("view.selectionColor"));
            String[] stringArray = new String[]{"TextField", "TextArea", "List", "Table"};
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                ((UIDefaults)object).put(string + ".disabledBackground", colorUIResource);
                ((UIDefaults)object).put(string + ".background", colorUIResource);
                ((UIDefaults)object).put(string + ".disabledForeground", colorUIResource2);
                ((UIDefaults)object).put(string + ".foreground", colorUIResource2);
                ((UIDefaults)object).put(string + ".caretForeground", colorUIResource3);
                ((UIDefaults)object).put(string + ".selectionForeground", colorUIResource2);
                ((UIDefaults)object).put(string + ".selectionBackground", colorUIResource4);
            }
            ((UIDefaults)object).put("Tree.background", colorUIResource);
            ((UIDefaults)object).put("Tree.foreground", colorUIResource2);
            ((UIDefaults)object).put("Tree.textBackground", colorUIResource);
            ((UIDefaults)object).put("Tree.textForeground", colorUIResource2);
            ((UIDefaults)object).put("Tree.selectionForeground", colorUIResource2);
            ((UIDefaults)object).put("Tree.selectionBackground", colorUIResource4);
        }
        ((Hashtable)object).remove("SplitPane.border");
        ((Hashtable)object).remove("SplitPaneDivider.border");
    }

    private static void runStartupScripts(File file) {
        if (!file.isDirectory()) {
            return;
        }
        Object[] objectArray = file.listFiles();
        if (objectArray == null) {
            return;
        }
        MiscUtilities.quicksort(objectArray, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Macros.Handler handler = Macros.getHandlerForPathName(((File)object).getPath());
            if (handler == null) continue;
            try {
                Macros.Macro macro = handler.createMacro(((File)object).getName(), ((File)object).getPath());
                handler.runMacro(null, macro, false);
                continue;
            }
            catch (Exception exception) {
                Log.log(9, jEdit.class, exception);
            }
        }
    }

    private static void initProxy() {
        String string;
        boolean bl = jEdit.getBooleanProperty("socks.enabled");
        if (!bl) {
            Log.log(1, jEdit.class, "SOCKS proxy disabled");
            System.getProperties().remove("socksProxyHost");
            System.getProperties().remove("socksProxyPort");
        } else {
            String string2 = jEdit.getProperty("firewall.socks.host");
            if (string2 != null) {
                System.setProperty("socksProxyHost", string2);
                Log.log(1, jEdit.class, "SOCKS proxy enabled: " + string2);
            }
            if ((string = jEdit.getProperty("firewall.socks.port")) != null) {
                System.setProperty("socksProxyPort", string);
            }
        }
        boolean bl2 = jEdit.getBooleanProperty("firewall.enabled");
        if (!bl2) {
            Log.log(1, jEdit.class, "HTTP proxy disabled");
            System.getProperties().remove("proxySet");
            System.getProperties().remove("proxyHost");
            System.getProperties().remove("proxyPort");
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.nonProxyHosts");
            Authenticator.setDefault(null);
        } else {
            String string3;
            string = jEdit.getProperty("firewall.host");
            if (string == null) {
                return;
            }
            System.setProperty("http.proxyHost", string);
            Log.log(1, jEdit.class, "HTTP proxy enabled: " + string);
            String string4 = jEdit.getProperty("firewall.port");
            if (string4 != null) {
                System.setProperty("http.proxyPort", string4);
            }
            if ((string3 = jEdit.getProperty("firewall.nonProxyHosts")) != null) {
                System.setProperty("http.nonProxyHosts", string3);
            }
            String string5 = jEdit.getProperty("firewall.user");
            String string6 = jEdit.getProperty("firewall.password");
            if (string6 == null) {
                string6 = "";
            }
            if (string5 == null || string5.length() == 0) {
                Log.log(1, jEdit.class, "HTTP proxy without user");
                Authenticator.setDefault(new FirewallAuthenticator(null));
            } else {
                Log.log(1, jEdit.class, "HTTP proxy user: " + string5);
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(string5, string6.toCharArray());
                Authenticator.setDefault(new FirewallAuthenticator(passwordAuthentication));
            }
        }
    }

    private static void finishStartup(final boolean bl, final boolean bl2, final String string, final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl3;
                Buffer buffer = jEdit.openFiles(null, string, stringArray);
                int n = jEdit.getBufferCount();
                if (n == 0) {
                    jEdit.newFile(null);
                }
                View view = null;
                boolean bl22 = bl3 = bl2 && jEdit.getBooleanProperty("restore") && (jEdit.getBufferCount() == 0 || jEdit.getBooleanProperty("restore.cli"));
                if (bl || n != 0) {
                    if (view == null) {
                        view = jEdit.newView(null, buffer);
                    } else if (buffer != null) {
                        view.setBuffer(buffer);
                    }
                }
                EditBus.send(new EditorStarted(null));
                VFSManager.start();
                if (server != null) {
                    server.start();
                }
                GUIUtilities.hideSplashScreen();
                Log.log(3, jEdit.class, "Startup complete");
                if (pluginErrors != null) {
                    jEdit.showPluginErrorDialog();
                }
                startupDone = true;
                Toolkit.getDefaultToolkit();
            }
        });
    }

    private static void showPluginErrorDialog() {
        if (pluginErrors == null) {
            return;
        }
        String string = jEdit.getProperty("plugin-error.caption" + (pluginErrors.size() == 1 ? "-1" : ""));
        Frame frame = PluginManager.getInstance() == null ? viewsFirst.getFrame() : PluginManager.getInstance();
        new ErrorListDialog(frame, jEdit.getProperty("plugin-error.title"), string, pluginErrors, true);
        pluginErrors = null;
    }

    private static void getNotLoadedPluginJARs(Vector vector, String string, String[] stringArray) {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.toLowerCase().endsWith(".jar")) continue;
            String string3 = MiscUtilities.constructPath(string, string2);
            for (int j = 0; j < jars.size(); ++j) {
                PluginJAR pluginJAR = (PluginJAR)jars.elementAt(j);
                String string4 = pluginJAR.getPath();
                String string5 = MiscUtilities.getFileName(string4);
                if (string3.equals(string4) || !new File(string4).exists() && string2.equals(string5)) continue block0;
            }
            vector.addElement(string3);
        }
    }

    private static void gotoMarker(final View view, final Buffer buffer, final String string) {
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                int n;
                if (string.startsWith("+line:")) {
                    try {
                        int n2 = Integer.parseInt(string.substring(6));
                        n = buffer.getLineStartOffset(n2 - 1);
                    }
                    catch (Exception exception) {
                        return;
                    }
                } else if (string.startsWith("+marker:")) {
                    if (string.length() != 9) {
                        return;
                    }
                    Marker marker = buffer.getMarker(string.charAt(8));
                    if (marker == null) {
                        return;
                    }
                    n = marker.getPosition();
                } else {
                    throw new InternalError();
                }
                if (view != null && view.getBuffer() == buffer) {
                    view.getTextArea().setCaretPosition(n);
                } else {
                    buffer.setIntegerProperty("Buffer__caret", n);
                    buffer.unsetProperty("Buffer__scrollVert");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBufferToList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            String string = buffer.getSymlinkPath();
            if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
                string = string.toLowerCase();
            }
            if (viewCount <= 1 && buffersFirst != null && buffersFirst == buffersLast && buffersFirst.isUntitled() && !buffersFirst.isDirty()) {
                Buffer buffer2 = buffersFirst;
                buffersFirst = buffersLast = buffer;
                DisplayManager.bufferClosed(buffer2);
                EditBus.send(new BufferUpdate(buffer2, null, BufferUpdate.CLOSED));
                bufferHash.clear();
                bufferHash.put(string, buffer);
                return;
            }
            ++bufferCount;
            bufferHash.put(string, buffer);
            if (buffersFirst == null) {
                buffersFirst = buffersLast = buffer;
                return;
            }
            if (sortBuffers) {
                String string2;
                String string3;
                if (sortByName) {
                    string3 = buffer.getName();
                    string2 = buffer.getDirectory();
                } else {
                    string3 = buffer.getDirectory();
                    string2 = buffer.getName();
                }
                Buffer buffer3 = buffersFirst;
                while (buffer3 != null) {
                    String string4;
                    String string5;
                    if (sortByName) {
                        string5 = buffer3.getName();
                        string4 = buffer3.getDirectory();
                    } else {
                        string5 = buffer3.getDirectory();
                        string4 = buffer3.getName();
                    }
                    int n = MiscUtilities.compareStrings(string3, string5, true);
                    if (n < 0 || n == 0 && MiscUtilities.compareStrings(string2, string4, true) < 0) {
                        buffer.next = buffer3;
                        buffer.prev = buffer3.prev;
                        buffer3.prev = buffer;
                        if (buffer3 != buffersFirst) {
                            buffer.prev.next = buffer;
                        } else {
                            buffersFirst = buffer;
                        }
                        return;
                    }
                    buffer3 = buffer3.next;
                }
            }
            buffer.prev = buffersLast;
            buffer.next = null;
            jEdit.buffersLast.next = buffer;
            buffersLast = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBufferFromList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            --bufferCount;
            boolean bl = OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
            String string = buffer.getPath();
            if (bl) {
                string = string.toLowerCase();
            }
            bufferHash.remove(string);
            if (buffer == buffersFirst && buffer == buffersLast) {
                buffersLast = null;
                buffersFirst = null;
                return;
            }
            if (buffer == buffersFirst) {
                buffersFirst = buffer.next;
                buffer.next.prev = null;
            } else {
                buffer.prev.next = buffer.next;
            }
            if (buffer == buffersLast) {
                buffersLast = jEdit.buffersLast.prev;
                buffer.prev.next = null;
            } else {
                buffer.next.prev = buffer.prev;
            }
            buffer.prev = null;
            buffer.next = null;
        }
    }

    private static void addViewToList(View view) {
        ++viewCount;
        if (viewsFirst == null) {
            viewsFirst = viewsLast = view;
        } else {
            view.prev = viewsLast;
            jEdit.viewsLast.next = view;
            viewsLast = view;
        }
    }

    private static void removeViewFromList(View view) {
        --viewCount;
        if (viewsFirst == viewsLast) {
            viewsLast = null;
            viewsFirst = null;
            return;
        }
        if (view == viewsFirst) {
            viewsFirst = view.next;
            view.next.prev = null;
        } else {
            view.prev.next = view.next;
        }
        if (view == viewsLast) {
            viewsLast = jEdit.viewsLast.prev;
            view.prev.next = null;
        } else {
            view.next.prev = view.prev;
        }
    }

    public static void closeView(View view, boolean bl) {
        PerspectiveManager.setPerspectiveDirty(true);
        if (viewsFirst == viewsLast && bl) {
            jEdit.exit(view, false);
        } else {
            EditBus.send(new ViewUpdate(view, ViewUpdate.CLOSED));
            view.close();
            jEdit.removeViewFromList(view);
            if (view == activeView) {
                activeView = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadModeCatalog(String string, boolean bl) {
        block14: {
            Log.log(3, jEdit.class, "Loading mode catalog file " + string);
            ModeCatalogHandler modeCatalogHandler = new ModeCatalogHandler(MiscUtilities.getParentOfPath(string), bl);
            XmlParser xmlParser = new XmlParser();
            xmlParser.setHandler(modeCatalogHandler);
            Reader reader = null;
            InputStream inputStream = bl ? jEdit.class.getResourceAsStream(string) : new FileInputStream(string);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            xmlParser.parse(null, null, reader);
            Object var9_8 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                Log.log(9, jEdit.class, iOException);
            }
            break block14;
            {
                catch (XmlException xmlException) {
                    int n = xmlException.getLine();
                    String string2 = xmlException.getMessage();
                    Log.log(9, jEdit.class, string + ":" + n + ": " + string2);
                    Object var9_9 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        Log.log(9, jEdit.class, iOException);
                    }
                    break block14;
                }
                catch (Exception exception) {
                    Log.log(9, jEdit.class, exception);
                    Object var9_10 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        Log.log(9, jEdit.class, iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, jEdit.class, iOException);
                }
                throw throwable;
            }
        }
    }

    private static void initKeyBindings() {
        inputHandler.removeAllKeyBindings();
        ActionSet[] actionSetArray = jEdit.getActionSets();
        for (int i = 0; i < actionSetArray.length; ++i) {
            actionSetArray[i].initKeyBindings();
        }
    }

    public static boolean isStartupDone() {
        return startupDone;
    }

    static {
        pluginErrorLock = new Object();
        bufferListLock = new Object();
    }

    static class FirewallAuthenticator
    extends Authenticator {
        PasswordAuthentication pw;

        public FirewallAuthenticator(PasswordAuthentication passwordAuthentication) {
            this.pw = passwordAuthentication;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pw;
        }
    }
}

