/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SplashScreen
extends JComponent {
    private FontMetrics fm;
    private JWindow win;
    private Image image;
    private int progress;
    private static final int PROGRESS_HEIGHT = 20;

    public SplashScreen() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBackground(Color.white);
        Font font = new Font("Dialog", 0, 10);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.image = this.getToolkit().getImage(this.getClass().getResource("/org/gjt/sp/jedit/icons/splash.png"));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
        this.win = new JWindow();
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2 + 20);
        this.win.setSize(dimension2);
        this.win.getContentPane().add("Center", this);
        this.win.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.win.validate();
        this.win.setVisible(true);
    }

    public void dispose() {
        this.win.dispose();
    }

    public synchronized void advance() {
        ++this.progress;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            Log.log(9, this, interruptedException);
        }
    }

    public synchronized void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.image, 1, 1, this);
        graphics.setColor(Color.white);
        graphics.fillRect(1, this.image.getHeight(this) + 1, (this.win.getWidth() - 2) * this.progress / 5, 20);
        graphics.setColor(Color.black);
        String string = "VERSION " + jEdit.getVersion();
        graphics.drawString(string, (this.getWidth() - this.fm.stringWidth(string)) / 2, this.image.getHeight(this) + (20 + this.fm.getAscent() + this.fm.getDescent()) / 2);
        this.notify();
    }
}

