/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class PasteFromListDialog
extends EnhancedDialog {
    private View view;
    private JList clips;
    private JTextArea clipText;
    private JButton insert;
    private JButton cancel;

    public PasteFromListDialog(String string, View view, ListModel listModel) {
        super(view, jEdit.getProperty(string + ".title"), true);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 2, 12));
        this.clips = new JList(listModel);
        this.clips.setCellRenderer(new Renderer());
        this.clips.setVisibleRowCount(12);
        this.clips.addMouseListener(new MouseHandler());
        this.clips.addListSelectionListener(new ListHandler());
        this.insert = new JButton(jEdit.getProperty("common.insert"));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        JLabel jLabel = new JLabel(jEdit.getProperty(string + ".caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel.add("North", jLabel);
        JScrollPane jScrollPane = new JScrollPane(this.clips);
        jScrollPane.setPreferredSize(new Dimension(500, 150));
        jPanel2.add(jScrollPane);
        this.clipText = new JTextArea();
        this.clipText.setEditable(false);
        jScrollPane = new JScrollPane(this.clipText);
        jScrollPane.setPreferredSize(new Dimension(500, 150));
        jPanel2.add(jScrollPane);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel3.add(Box.createGlue());
        jPanel3.add(this.insert);
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(this.cancel);
        jPanel3.add(Box.createGlue());
        jPanel.add((Component)jPanel3, "South");
        if (listModel.getSize() >= 1) {
            this.clips.setSelectedIndex(0);
        }
        this.updateButtons();
        this.getRootPane().setDefaultButton(this.insert);
        this.insert.addActionListener(new ActionHandler());
        this.cancel.addActionListener(new ActionHandler());
        GUIUtilities.requestFocus(this, this.clips);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)view));
        this.setVisible(true);
    }

    public void ok() {
        Object[] objectArray = this.clips.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.view.getTextArea().setSelectedText(this.getSelectedClipText());
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    private String getSelectedClipText() {
        Object[] objectArray = this.clips.getSelectedValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    private void updateButtons() {
        int n = this.clips.getSelectedIndex();
        this.insert.setEnabled(n != -1);
    }

    private void showClipText() {
        Object[] objectArray = this.clips.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            this.clipText.setText("");
        } else {
            this.clipText.setText(this.getSelectedClipText());
        }
        this.clipText.setCaretPosition(0);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                PasteFromListDialog.this.ok();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PasteFromListDialog.this.showClipText();
            PasteFromListDialog.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PasteFromListDialog.this.insert) {
                PasteFromListDialog.this.ok();
            } else if (object == PasteFromListDialog.this.cancel) {
                PasteFromListDialog.this.cancel();
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        String shorten(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.toLowerCase().startsWith("<html>")) {
                stringBuffer.append(' ');
            }
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (bl) continue;
                    stringBuffer.append(' ');
                    bl = true;
                    continue;
                }
                bl = false;
                stringBuffer.append(c);
            }
            if (stringBuffer.length() == 0) {
                return jEdit.getProperty("paste-from-list.whitespace");
            }
            return stringBuffer.toString();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(this.shorten(object.toString()));
            return this;
        }
    }
}

