/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public abstract class OptionsDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private String name;
    private JSplitPane splitter;
    private JTree paneTree;
    private JPanel stage;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    private OptionPane currentPane;
    private Map deferredOptionPanes;

    public OptionsDialog(Frame frame, String string, String string2) {
        super(frame, jEdit.getProperty(string + ".title"), true);
        this.init(string, string2);
    }

    public OptionsDialog(Dialog dialog, String string, String string2) {
        super(dialog, jEdit.getProperty(string + ".title"), true);
        this.init(string, string2);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.getDefaultGroup().addOptionGroup(optionGroup);
    }

    public void addOptionPane(OptionPane optionPane) {
        this.getDefaultGroup().addOptionPane(optionPane);
    }

    public void ok() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        this.ok(true);
    }

    public void cancel() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        this.dispose();
    }

    public void ok(boolean bl) {
        OptionTreeModel optionTreeModel = (OptionTreeModel)this.paneTree.getModel();
        this.save(optionTreeModel.getRoot());
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        if (bl) {
            this.dispose();
        }
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, this.name);
        jEdit.setIntegerProperty(this.name + ".splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.apply) {
            this.ok(false);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof String) && !(object instanceof OptionPane)) {
            return;
        }
        Object[] objectArray = treePath.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        OptionPane optionPane = null;
        int n2 = objectArray.length - 1;
        int n3 = n = this.paneTree.isRootVisible() ? 0 : 1;
        while (n <= n2) {
            block12: {
                String string;
                block10: {
                    String string2;
                    block13: {
                        Object object2;
                        block11: {
                            block9: {
                                object2 = objectArray[n];
                                if (!(object2 instanceof OptionPane)) break block9;
                                optionPane = (OptionPane)object2;
                                string = jEdit.getProperty("options." + optionPane.getName() + ".label");
                                break block10;
                            }
                            if (!(object2 instanceof OptionGroup)) break block11;
                            string = ((OptionGroup)object2).getLabel();
                            break block10;
                        }
                        if (!(object2 instanceof String)) break block12;
                        string = jEdit.getProperty("options." + object2 + ".label");
                        optionPane = (OptionPane)this.deferredOptionPanes.get((String)object2);
                        if (optionPane != null) break block10;
                        string2 = "options." + object2 + ".code";
                        String string3 = jEdit.getProperty(string2);
                        if (string3 == null) break block13;
                        optionPane = (OptionPane)BeanShell.eval(jEdit.getActiveView(), BeanShell.getNameSpace(), string3);
                        if (optionPane == null) break block12;
                        this.deferredOptionPanes.put(object2, optionPane);
                        break block10;
                    }
                    Log.log(9, this, string2 + " not defined");
                    break block12;
                }
                stringBuffer.append(string);
                if (n != n2) {
                    stringBuffer.append(": ");
                }
            }
            ++n;
        }
        if (optionPane == null) {
            return;
        }
        this.setTitle(jEdit.getProperty("options.title-template", new Object[]{jEdit.getProperty(this.name + ".title"), stringBuffer.toString()}));
        try {
            optionPane.init();
        }
        catch (Throwable throwable) {
            Log.log(9, this, "Error initializing options:");
            Log.log(9, this, throwable);
        }
        if (this.currentPane != null) {
            this.stage.remove(this.currentPane.getComponent());
        }
        this.currentPane = optionPane;
        this.stage.add("Center", this.currentPane.getComponent());
        this.stage.revalidate();
        this.stage.repaint();
        if (!this.isShowing()) {
            this.addNotify();
        }
        this.updateSize();
        this.currentPane = optionPane;
    }

    protected abstract OptionTreeModel createOptionTreeModel();

    protected abstract OptionGroup getDefaultGroup();

    private void init(String string, String string2) {
        int n;
        this.name = string;
        this.deferredOptionPanes = new HashMap();
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.stage = new JPanel(new BorderLayout());
        this.paneTree = new JTree(this.createOptionTreeModel());
        this.paneTree.setVisibleRowCount(1);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        if (!OperatingSystem.isMacOSLF()) {
            this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane(this.paneTree, 22, 30);
        this.splitter = new JSplitPane(1, jScrollPane, this.stage);
        jPanel.add((Component)this.splitter, "Center");
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        box.add(this.cancel);
        box.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(jEdit.getProperty("common.apply"));
        this.apply.addActionListener(this);
        box.add(this.apply);
        box.add(Box.createGlue());
        jPanel.add((Component)box, "South");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup optionGroup = (OptionGroup)this.paneTree.getModel().getRoot();
        for (n = 0; n < optionGroup.getMemberCount(); ++n) {
            this.paneTree.expandPath(new TreePath(new Object[]{optionGroup, optionGroup.getMember(n)}));
        }
        if (!this.selectPane(optionGroup, string2)) {
            this.selectPane(optionGroup, null);
        }
        this.splitter.setDividerLocation(this.paneTree.getPreferredSize().width + jScrollPane.getVerticalScrollBar().getPreferredSize().width);
        GUIUtilities.loadGeometry(this, string);
        n = jEdit.getIntegerProperty(string + ".splitter", -1);
        if (n != -1) {
            this.splitter.setDividerLocation(n);
        }
        this.updateSize();
        this.setVisible(true);
    }

    private boolean selectPane(OptionGroup optionGroup, String string) {
        return this.selectPane(optionGroup, string, new ArrayList());
    }

    private boolean selectPane(OptionGroup optionGroup, String string, ArrayList arrayList) {
        arrayList.add(optionGroup);
        Enumeration enumeration = optionGroup.getMembers();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof OptionGroup) {
                object = (OptionGroup)e;
                if (((OptionGroup)object).getName().equals(string)) {
                    arrayList.add(object);
                    arrayList.add(((OptionGroup)object).getMember(0));
                    TreePath treePath = new TreePath(arrayList.toArray());
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)e, string, arrayList)) continue;
                return true;
            }
            if (e instanceof OptionPane) {
                object = (OptionPane)e;
                if (!object.getName().equals(string) && string != null) continue;
                arrayList.add(object);
                TreePath treePath = new TreePath(arrayList.toArray());
                this.paneTree.scrollPathToVisible(treePath);
                this.paneTree.setSelectionPath(treePath);
                return true;
            }
            if (!(e instanceof String) || !((String)(object = (String)e)).equals(string) && string != null) continue;
            arrayList.add(object);
            TreePath treePath = new TreePath(arrayList.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            this.paneTree.setSelectionPath(treePath);
            return true;
        }
        arrayList.remove(optionGroup);
        return false;
    }

    private void save(Object object) {
        if (object instanceof OptionGroup) {
            OptionGroup optionGroup = (OptionGroup)object;
            Enumeration enumeration = optionGroup.getMembers();
            while (enumeration.hasMoreElements()) {
                this.save(enumeration.nextElement());
            }
        } else if (object instanceof OptionPane) {
            try {
                ((OptionPane)object).save();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error saving options:");
                Log.log(9, this, throwable);
            }
        } else if (object instanceof String) {
            this.save(this.deferredOptionPanes.get(object));
        }
    }

    private void updateSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        if (dimension3.width < 300) {
            dimension3.width = 300;
        }
        if (dimension3.height < 200) {
            dimension3.height = 200;
        }
        this.setSize(dimension3);
        this.validate();
    }

    public class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup(null);
        private EventListenerList listenerList = new EventListenerList();

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(TreeModelListener.class, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(TreeModelListener.class, treeModelListener);
        }

        public Object getChild(Object object, int n) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMember(n);
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberIndex(object2);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            return !(object instanceof OptionGroup);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        protected void fireNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
            }
        }

        protected void fireNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
            }
        }

        protected void fireNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
            }
        }
    }

    class PaneNameRenderer
    extends DefaultTreeCellRenderer {
        private Font paneFont = UIManager.getFont("Tree.font");
        private Font groupFont;

        public PaneNameRenderer() {
            if (this.paneFont == null) {
                this.paneFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.paneFont.deriveFont(1);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            String string = null;
            if (object instanceof OptionGroup) {
                this.setText(((OptionGroup)object).getLabel());
                this.setFont(this.groupFont);
            } else if (object instanceof OptionPane) {
                string = ((OptionPane)object).getName();
                this.setFont(this.paneFont);
            } else if (object instanceof String) {
                string = (String)object;
                this.setFont(this.paneFont);
            }
            if (string != null) {
                String string2 = jEdit.getProperty("options." + string + ".label");
                if (string2 == null) {
                    this.setText("NO LABEL PROPERTY: " + string);
                } else {
                    this.setText(string2);
                }
            }
            this.setIcon(null);
            return this;
        }
    }
}

