/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class InputHandler {
    private static final int REPEAT_COUNT_THRESHOLD = 20;
    protected View view;
    protected int repeatCount;
    protected EditAction lastAction;
    protected int lastActionCount;
    protected String readNextChar;

    public InputHandler(View view) {
        this.view = view;
        this.repeatCount = 1;
    }

    public abstract void addKeyBinding(String var1, String var2);

    public abstract void addKeyBinding(String var1, EditAction var2);

    public abstract void removeKeyBinding(String var1);

    public abstract void removeAllKeyBindings();

    public boolean isPrefixActive() {
        return this.readNextChar != null;
    }

    public abstract boolean handleKey(KeyEventTranslator.Key var1);

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int n) {
        int n2 = this.repeatCount;
        this.repeatCount = n;
        if (n2 != n) {
            this.view.getStatus().setMessage(null);
        }
    }

    public EditAction getLastAction() {
        return this.lastAction;
    }

    public int getLastActionCount() {
        return this.lastActionCount;
    }

    public void readNextChar(String string, String string2) {
        this.view.getStatus().setMessage(string);
        this.readNextChar = string2;
    }

    public void readNextChar(String string) {
        this.readNextChar = string;
    }

    public void resetLastActionCount() {
        this.lastActionCount = 0;
    }

    public void invokeAction(String string) {
        this.invokeAction(jEdit.getAction(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(EditAction editAction) {
        Buffer buffer = this.view.getBuffer();
        if (!editAction.noRememberLast()) {
            HistoryModel.getModel("action").addItem(editAction.getName());
            if (this.lastAction == editAction) {
                ++this.lastActionCount;
            } else {
                this.lastAction = editAction;
                this.lastActionCount = 1;
            }
        }
        int n = this.repeatCount;
        if (editAction.noRepeat() || n == 1) {
            editAction.invoke(this.view);
        } else {
            String string;
            Object[] objectArray;
            if (n > 20 && GUIUtilities.confirm((Component)((Object)this.view), "large-repeat-count", objectArray = new Object[]{string = (string = editAction.getLabel()) == null ? editAction.getName() : GUIUtilities.prettifyMenuLabel(string), new Integer(n)}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < n; ++i) {
                    editAction.invoke(this.view);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null && !editAction.noRecord()) {
            recorder.record(n, editAction.getCode());
        }
        if (n != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
            this.view.getStatus().setMessage(null);
        }
    }

    public void invokeLastAction() {
        if (this.lastAction == null) {
            this.view.getToolkit().beep();
        } else {
            this.invokeAction(this.lastAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void userInput(char c) {
        Object[] objectArray;
        this.lastActionCount = 0;
        JEditTextArea jEditTextArea = this.view.getTextArea();
        if (this.repeatCount == 1) {
            jEditTextArea.userInput(c);
        } else {
            if (this.repeatCount > 20 && GUIUtilities.confirm((Component)((Object)this.view), "large-repeat-count.user-input", objectArray = new Object[]{String.valueOf(c), new Integer(this.repeatCount)}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            objectArray = this.view.getBuffer();
            try {
                if (this.repeatCount != 1) {
                    objectArray.beginCompoundEdit();
                }
                for (int i = 0; i < this.repeatCount; ++i) {
                    jEditTextArea.userInput(c);
                }
            }
            finally {
                if (this.repeatCount != 1) {
                    objectArray.endCompoundEdit();
                }
            }
        }
        objectArray = this.view.getMacroRecorder();
        if (objectArray != null) {
            objectArray.recordInput(this.repeatCount, c, jEditTextArea.isOverwriteEnabled());
        }
        this.repeatCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeReadNextChar(char c) {
        int n;
        Buffer buffer = this.view.getBuffer();
        String string = MiscUtilities.charsToEscapes(String.valueOf(c));
        while ((n = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, n) + '\'' + string + '\'' + this.readNextChar.substring(n + 8);
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.record(this.getRepeatCount(), this.readNextChar);
        }
        if (this.getRepeatCount() != 1) {
            try {
                buffer.beginCompoundEdit();
                BeanShell.eval(this.view, BeanShell.getNameSpace(), "for(int i = 1; i < " + this.getRepeatCount() + "; i++)\n{\n" + this.readNextChar + "\n}");
            }
            finally {
                buffer.endCompoundEdit();
            }
        } else {
            BeanShell.eval(this.view, BeanShell.getNameSpace(), this.readNextChar);
        }
        this.readNextChar = null;
        this.view.getStatus().setMessage(null);
    }
}

