/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class CompleteWord
extends JWindow {
    private View view;
    private JEditTextArea textArea;
    private Buffer buffer;
    private String word;
    private JList words;
    private String noWordSep;

    public static void completeWord(View view) {
        JEditTextArea jEditTextArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int n = jEditTextArea.getCaretLine();
        int n2 = jEditTextArea.getCaretPosition();
        if (!buffer.isEditable()) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(n2);
        String string = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        String string2 = CompleteWord.getWordToComplete(buffer, n, n2, string);
        if (string2 == null) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        Object[] objectArray = CompleteWord.getCompletions(buffer, string2, n2);
        if (objectArray.length == 0) {
            jEditTextArea.getToolkit().beep();
        } else if (objectArray.length == 1) {
            Completion completion = objectArray[0];
            if (completion.text.equals(string2)) {
                jEditTextArea.getToolkit().beep();
            } else {
                jEditTextArea.setSelectedText(completion.text.substring(string2.length()));
            }
        } else {
            String string3 = MiscUtilities.getLongestPrefix(objectArray, keywordMap != null ? keywordMap.getIgnoreCase() : false);
            if (string2.length() < string3.length()) {
                buffer.insert(n2, string3.substring(string2.length()));
            }
            jEditTextArea.scrollToCaret(false);
            Point point = jEditTextArea.offsetToXY(n2 - string2.length());
            point.y += jEditTextArea.getPainter().getFontMetrics().getHeight();
            SwingUtilities.convertPointToScreen(point, jEditTextArea.getPainter());
            new CompleteWord(view, string3, (Completion[])objectArray, point, string);
        }
    }

    public CompleteWord(View view, String string, Completion[] completionArray, Point point, String string2) {
        super(view.getFrame());
        this.noWordSep = string2;
        this.setContentPane(new JPanel(new BorderLayout()){

            public boolean isManagingFocus() {
                return false;
            }

            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        });
        this.view = view;
        this.textArea = view.getTextArea();
        this.buffer = view.getBuffer();
        this.word = string;
        this.words = new JList<Completion>(completionArray);
        this.words.setVisibleRowCount(Math.min(completionArray.length, 8));
        this.words.addMouseListener(new MouseHandler());
        this.words.setSelectedIndex(0);
        this.words.setSelectionMode(0);
        this.words.setCellRenderer(new Renderer());
        JScrollPane jScrollPane = new JScrollPane(this.words, 22, 31);
        this.getContentPane().add((Component)jScrollPane, "Center");
        GUIUtilities.requestFocus(this, this.words);
        this.pack();
        this.setLocation(point);
        this.setVisible(true);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.words.addKeyListener(keyHandler);
        view.setKeyEventInterceptor(keyHandler);
    }

    public void dispose() {
        this.view.setKeyEventInterceptor(null);
        super.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CompleteWord.this.textArea.requestFocus();
            }
        });
    }

    private static String getNonAlphaNumericWordChars(Buffer buffer, KeywordMap keywordMap) {
        String string;
        String string2 = buffer.getStringProperty("noWordSep");
        if (string2 == null) {
            string2 = "";
        }
        if (keywordMap != null && (string = keywordMap.getNonAlphaNumericChars()) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    private static String getWordToComplete(Buffer buffer, int n, int n2, String string) {
        String string2 = buffer.getLineText(n);
        int n3 = n2 - buffer.getLineStartOffset(n);
        if (n3 == 0) {
            return null;
        }
        char c = string2.charAt(n3 - 1);
        if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
            return null;
        }
        int n4 = TextUtilities.findWordStart(string2, n3 - 1, string);
        String string3 = string2.substring(n4, n3);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    private static Completion[] getCompletions(Buffer buffer, String string, int n) {
        Object[] objectArray;
        TreeSet treeSet = new TreeSet(new MiscUtilities.StringCompare());
        HashSet<Buffer> hashSet = new HashSet<Buffer>();
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(n);
        String string2 = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            objectArray = view.getEditPanes();
            for (int i = 0; i < objectArray.length; ++i) {
                Buffer buffer2 = ((EditPane)objectArray[i]).getBuffer();
                if (hashSet.contains(buffer2)) continue;
                hashSet.add(buffer2);
                KeywordMap keywordMap2 = buffer2 == buffer ? keywordMap : null;
                int n2 = buffer2 == buffer ? n : 0;
                CompleteWord.getCompletions(buffer2, string, keywordMap, string2, n2, treeSet);
            }
        }
        objectArray = treeSet.toArray(new Completion[treeSet.size()]);
        return objectArray;
    }

    private static void getCompletions(Buffer buffer, String string, KeywordMap keywordMap, String string2, int n, Set set) {
        int n2 = string.length();
        if (keywordMap != null) {
            String[] stringArray = keywordMap.getKeywords();
            for (int i = 0; i < stringArray.length; ++i) {
                Completion completion;
                String string3 = stringArray[i];
                if (!string3.regionMatches(keywordMap.getIgnoreCase(), 0, string, 0, n2) || set.contains(completion = new Completion(string3, true))) continue;
                set.add(completion);
            }
        }
        for (int i = 0; i < buffer.getLineCount(); ++i) {
            String string4;
            Completion completion;
            String string5 = buffer.getLineText(i);
            int n3 = buffer.getLineStartOffset(i);
            if (string5.startsWith(string) && n != n3 + string.length() && !set.contains(completion = new Completion(string4 = CompleteWord.completeWord(string5, 0, string2), false))) {
                set.add(completion);
            }
            int n4 = string5.length() - string.length();
            for (int j = 0; j < n4; ++j) {
                String string6;
                Completion completion2;
                char c = string5.charAt(j);
                if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 || !string5.regionMatches(j + 1, string, 0, n2) || n == n3 + j + string.length() + 1 || set.contains(completion2 = new Completion(string6 = CompleteWord.completeWord(string5, j + 1, string2), false))) continue;
                set.add(completion2);
            }
        }
    }

    private static String completeWord(String string, int n, String string2) {
        int n2 = TextUtilities.findWordEnd(string, n + 1, string2);
        return string.substring(n, n2);
    }

    private void insertSelected() {
        this.textArea.setSelectedText(this.words.getSelectedValue().toString().substring(this.word.length()));
        this.dispose();
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            CompleteWord.this.insertSelected();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 9: 
                case 10: {
                    CompleteWord.this.insertSelected();
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    CompleteWord.this.dispose();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    int n = CompleteWord.this.words.getSelectedIndex();
                    if (n == 0) {
                        n = CompleteWord.this.words.getModel().getSize() - 1;
                    } else {
                        if (CompleteWord.this.getFocusOwner() == CompleteWord.this.words) {
                            return;
                        }
                        --n;
                    }
                    CompleteWord.this.words.setSelectedIndex(n);
                    CompleteWord.this.words.ensureIndexIsVisible(n);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    int n = CompleteWord.this.words.getSelectedIndex();
                    if (n == CompleteWord.this.words.getModel().getSize() - 1) {
                        n = 0;
                    } else {
                        if (CompleteWord.this.getFocusOwner() == CompleteWord.this.words) {
                            return;
                        }
                        ++n;
                    }
                    CompleteWord.this.words.setSelectedIndex(n);
                    CompleteWord.this.words.ensureIndexIsVisible(n);
                    keyEvent.consume();
                    break;
                }
                case 8: {
                    if (CompleteWord.this.word.length() == 1) {
                        CompleteWord.this.textArea.backspace();
                        keyEvent.consume();
                        CompleteWord.this.dispose();
                        break;
                    }
                    CompleteWord.this.word = CompleteWord.this.word.substring(0, CompleteWord.this.word.length() - 1);
                    CompleteWord.this.textArea.backspace();
                    int n = CompleteWord.this.textArea.getCaretPosition();
                    Completion[] completionArray = CompleteWord.getCompletions(CompleteWord.this.buffer, CompleteWord.this.word, n);
                    if (completionArray.length == 0) {
                        CompleteWord.this.dispose();
                        return;
                    }
                    CompleteWord.this.words.setListData(completionArray);
                    CompleteWord.this.words.setSelectedIndex(0);
                    CompleteWord.this.words.setVisibleRowCount(Math.min(completionArray.length, 8));
                    CompleteWord.this.pack();
                    keyEvent.consume();
                    break;
                }
                default: {
                    if (!keyEvent.isActionKey() && !keyEvent.isControlDown() && !keyEvent.isAltDown() && !keyEvent.isMetaDown()) break;
                    CompleteWord.this.dispose();
                    CompleteWord.this.view.processKeyEvent(keyEvent);
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            char c = keyEvent.getKeyChar();
            if ((keyEvent = KeyEventWorkaround.processKeyEvent(keyEvent)) == null) {
                return;
            }
            if (Character.isDigit(c)) {
                n = c - 48;
                n = n == 0 ? 9 : --n;
                if (n < CompleteWord.this.words.getModel().getSize()) {
                    CompleteWord.this.words.setSelectedIndex(n);
                    CompleteWord.this.textArea.setSelectedText(CompleteWord.this.words.getModel().getElementAt(n).toString().substring(CompleteWord.this.word.length()));
                    CompleteWord.this.dispose();
                    return;
                }
            }
            if (c != '\b' && c != '\t') {
                if (!Character.isLetterOrDigit(c) && CompleteWord.this.noWordSep.indexOf(c) == -1) {
                    CompleteWord.this.insertSelected();
                    CompleteWord.this.textArea.userInput(c);
                    CompleteWord.this.dispose();
                    return;
                }
                CompleteWord.this.textArea.userInput(c);
                CompleteWord.this.word = CompleteWord.this.word + c;
                n = CompleteWord.this.textArea.getCaretPosition();
                Completion[] completionArray = CompleteWord.getCompletions(CompleteWord.this.buffer, CompleteWord.this.word, n);
                if (completionArray.length == 0) {
                    CompleteWord.this.dispose();
                    return;
                }
                CompleteWord.this.words.setListData(completionArray);
                CompleteWord.this.words.setSelectedIndex(0);
                CompleteWord.this.words.setVisibleRowCount(Math.min(completionArray.length, 8));
            }
        }
    }

    static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            Completion completion = (Completion)object;
            if (n < 9) {
                this.setText(n + 1 + ": " + completion.text);
            } else if (n == 9) {
                this.setText("0: " + completion.text);
            } else {
                this.setText(completion.text);
            }
            if (completion.keyword) {
                this.setFont(jList.getFont().deriveFont(1));
            } else {
                this.setFont(jList.getFont());
            }
            return this;
        }
    }

    static class Completion {
        String text;
        boolean keyword;

        Completion(String string, boolean bl) {
            this.text = string;
            this.keyword = bl;
        }

        public String toString() {
            return this.text;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Completion) {
                return ((Completion)object).text.equals(this.text);
            }
            return false;
        }
    }
}

