/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.Position;
import org.gjt.sp.util.Log;

public class PositionManager {
    boolean iteration;
    private SortedMap positions = new TreeMap();

    public synchronized Position createPosition(int n) {
        PosBottomHalf posBottomHalf = new PosBottomHalf(n);
        PosBottomHalf posBottomHalf2 = (PosBottomHalf)this.positions.get(posBottomHalf);
        if (posBottomHalf2 == null) {
            this.positions.put(posBottomHalf, posBottomHalf);
            posBottomHalf2 = posBottomHalf;
        }
        return new PosTopHalf(posBottomHalf2);
    }

    public synchronized void contentInserted(int n, int n2) {
        if (this.positions.size() == 0) {
            return;
        }
        Iterator<PosBottomHalf> iterator = this.positions.tailMap(new PosBottomHalf(n)).keySet().iterator();
        this.iteration = true;
        while (iterator.hasNext()) {
            PosBottomHalf posBottomHalf = iterator.next();
            posBottomHalf.offset += n2;
        }
        this.iteration = false;
    }

    public synchronized void contentRemoved(int n, int n2) {
        if (this.positions.size() == 0) {
            return;
        }
        Iterator<PosBottomHalf> iterator = this.positions.tailMap(new PosBottomHalf(n)).keySet().iterator();
        this.iteration = true;
        while (iterator.hasNext()) {
            PosBottomHalf posBottomHalf = iterator.next();
            if (posBottomHalf.offset <= n + n2) {
                posBottomHalf.offset = n;
                continue;
            }
            posBottomHalf.offset -= n2;
        }
        this.iteration = false;
    }

    class PosBottomHalf
    implements Comparable {
        int offset;
        int ref;

        PosBottomHalf(int n) {
            this.offset = n;
        }

        void ref() {
            ++this.ref;
        }

        void unref() {
            if (--this.ref == 0) {
                PositionManager.this.positions.remove(this);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof PosBottomHalf)) {
                return false;
            }
            return ((PosBottomHalf)object).offset == this.offset;
        }

        public int compareTo(Object object) {
            if (PositionManager.this.iteration) {
                Log.log(9, this, "Consistency failure");
            }
            return this.offset - ((PosBottomHalf)object).offset;
        }
    }

    class PosTopHalf
    implements Position {
        PosBottomHalf bh;

        PosTopHalf(PosBottomHalf posBottomHalf) {
            this.bh = posBottomHalf;
            posBottomHalf.ref();
        }

        public int getOffset() {
            return this.bh.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            PositionManager positionManager = PositionManager.this;
            synchronized (positionManager) {
                this.bh.unref();
            }
        }
    }
}

