/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.Log;

public abstract class FoldHandler {
    public static final String SERVICE = "org.gjt.sp.jedit.buffer.FoldHandler";
    private String name;
    private static ArrayList foldHandlers = new ArrayList();

    public String getName() {
        return this.name;
    }

    public abstract int getFoldLevel(Buffer var1, int var2, Segment var3);

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static void registerFoldHandler(FoldHandler foldHandler) {
        if (FoldHandler.getFoldHandler(foldHandler.getName()) != null) {
            Log.log(9, FoldHandler.class, "Cannot register more than one fold handler with the same name");
            return;
        }
        foldHandlers.add(foldHandler);
    }

    public static void unregisterFoldHandler(FoldHandler foldHandler) {
        foldHandlers.remove(foldHandler);
    }

    public static FoldHandler[] getFoldHandlers() {
        FoldHandler[] foldHandlerArray = new FoldHandler[foldHandlers.size()];
        return foldHandlers.toArray(foldHandlerArray);
    }

    public static FoldHandler getFoldHandler(String string) {
        FoldHandler foldHandler2 = (FoldHandler)ServiceManager.getService(SERVICE, string);
        if (foldHandler2 != null) {
            return foldHandler2;
        }
        for (FoldHandler foldHandler2 : foldHandlers) {
            if (!string.equals(foldHandler2.getName())) continue;
            return foldHandler2;
        }
        return null;
    }

    public static String[] getFoldModes() {
        FoldHandler[] foldHandlerArray = FoldHandler.getFoldHandlers();
        String[] stringArray = ServiceManager.getServiceNames(SERVICE);
        String[] stringArray2 = new String[foldHandlerArray.length + stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        for (int i = 0; i < foldHandlerArray.length; ++i) {
            stringArray2[i + stringArray.length] = foldHandlerArray[i].getName();
        }
        Arrays.sort(stringArray2, new MiscUtilities.StringCompare());
        return stringArray2;
    }

    protected FoldHandler(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

