/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.Log;

class ServiceListHandler
extends HandlerBase {
    private PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private String code;
    private Stack stateStack;
    private List cachedServices;

    ServiceListHandler(PluginJAR pluginJAR, URL uRL) {
        this.plugin = pluginJAR;
        this.uri = uRL;
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList();
    }

    public Object resolveEntity(String string, String string2) {
        if ("services.dtd".equals(string2)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String string, String string2, boolean bl) {
        if (string.equals("NAME")) {
            this.serviceName = string2;
        } else if (string.equals("CLASS")) {
            this.serviceClass = string2;
        }
    }

    public void doctypeDecl(String string, String string2, String string3) throws Exception {
        if ("SERVICES".equals(string)) {
            return;
        }
        Log.log(9, this, this.uri + ": DOCTYPE must be SERVICES");
    }

    public void charData(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        String string2 = new String(cArray, n, n2);
        if (string == "SERVICE") {
            this.code = string2;
        }
    }

    public void startElement(String string) {
        string = this.pushElement(string);
    }

    public void endElement(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.peekElement();
        if (string.equals(string2)) {
            if (string2 == "SERVICE") {
                ServiceManager.Descriptor descriptor = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code, this.plugin);
                ServiceManager.registerService(descriptor);
                this.cachedServices.add(descriptor);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(new ServiceManager.Descriptor[this.cachedServices.size()]);
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

