/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.util.Hashtable;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;

public class Mode {
    private String name;
    private Hashtable props;
    private RE firstlineRE;
    private RE filenameRE;
    private TokenMarker marker;

    public Mode(String string) {
        this.name = string;
        this.props = new Hashtable();
    }

    public void init() {
        try {
            String string;
            String string2 = (String)this.getProperty("filenameGlob");
            if (string2 != null && string2.length() != 0) {
                this.filenameRE = new RE(MiscUtilities.globToRE(string2), 2);
            }
            if ((string = (String)this.getProperty("firstlineGlob")) != null && string.length() != 0) {
                this.firstlineRE = new RE(MiscUtilities.globToRE(string), 2);
            }
        }
        catch (REException rEException) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + this.name);
            Log.log(9, this, rEException);
        }
        this.marker = null;
    }

    public TokenMarker getTokenMarker() {
        this.loadIfNecessary();
        return this.marker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.marker = tokenMarker;
    }

    public void loadIfNecessary() {
        if (this.marker == null) {
            jEdit.loadMode(this);
        }
    }

    public Object getProperty(String string) {
        String string2 = "mode." + this.name + ".";
        String string3 = jEdit.getProperty(string2 + string);
        if (string3 != null) {
            Object object;
            try {
                object = new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                object = string3;
            }
            return object;
        }
        Object v = this.props.get(string);
        if (v != null) {
            return v;
        }
        String string4 = jEdit.getProperty("buffer." + string);
        if (string4 != null) {
            try {
                return new Integer(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return string4;
            }
        }
        return null;
    }

    public boolean getBooleanProperty(String string) {
        Object object = this.getProperty(string);
        return "true".equals(object) || "on".equals(object) || "yes".equals(object);
    }

    public void setProperty(String string, Object object) {
        this.props.put(string, object);
    }

    public void unsetProperty(String string) {
        this.props.remove(string);
    }

    public void setProperties(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        String string = (String)this.props.get("filenameGlob");
        String string2 = (String)this.props.get("firstlineGlob");
        String string3 = (String)this.props.get("file");
        this.props = hashtable;
        if (string != null) {
            hashtable.put("filenameGlob", string);
        }
        if (string2 != null) {
            hashtable.put("firstlineGlob", string2);
        }
        if (string3 != null) {
            hashtable.put("file", string3);
        }
    }

    public boolean accept(String string, String string2) {
        if (this.filenameRE != null && this.filenameRE.isMatch(string)) {
            return true;
        }
        return this.firstlineRE != null && this.firstlineRE.isMatch(string2);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

