/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenu;

public abstract class EditPlugin {
    JAR jar;

    public void start() {
    }

    public void stop() {
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public final JMenuItem createMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String string = jEdit.getProperty("plugin." + this.getClassName() + ".menu-item");
        if (string != null) {
            return GUIUtilities.loadMenuItem(string);
        }
        String string2 = "plugin." + this.getClassName() + ".menu";
        String string3 = "plugin." + this.getClassName() + ".menu.code";
        if (jEdit.getProperty(string2) != null || jEdit.getProperty(string3) != null) {
            String string4 = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(string2, string4);
        }
        return null;
    }

    public final JMenuItem createBrowserMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String string = jEdit.getProperty("plugin." + this.getClassName() + ".browser-menu-item");
        if (string != null) {
            return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), string, false);
        }
        String string2 = "plugin." + this.getClassName() + ".browser-menu";
        if (jEdit.getProperty(string2) != null) {
            String string3 = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(string2, string3, VFSBrowser.getActionContext());
        }
        return null;
    }

    public void createMenuItems(Vector vector) {
    }

    public void createOptionPanes(OptionsDialog optionsDialog) {
    }

    public JAR getJAR() {
        return this.jar;
    }

    public static class JAR
    extends PluginJAR {
        JAR(File file) {
            super(file);
        }
    }

    public static class Deferred
    extends EditPlugin {
        private String clazz;

        public String getClassName() {
            return this.clazz;
        }

        Deferred(String string) {
            this.clazz = string;
        }

        EditPlugin loadPluginClass() {
            return null;
        }

        public String toString() {
            return "Deferred[" + this.clazz + "]";
        }
    }

    public static class Broken
    extends EditPlugin {
        private String clazz;

        public String getClassName() {
            return this.clazz;
        }

        Broken(String string) {
            this.clazz = string;
        }
    }
}

