/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionListHandler;
import org.gjt.sp.jedit.BeanShellAction;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ActionSet {
    ActionContext context;
    private String label = "<no label set; plugin bug>";
    private Hashtable actions = new Hashtable();
    private PluginJAR plugin;
    private URL uri;
    private boolean loaded = true;
    private static final Object placeholder = new Object();

    public ActionSet() {
    }

    public ActionSet(PluginJAR pluginJAR, String[] stringArray, boolean[] blArray, URL uRL) {
        this();
        this.plugin = pluginJAR;
        this.uri = uRL;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.actions.put(stringArray[i], placeholder);
                jEdit.setTemporaryProperty(stringArray[i] + ".toggle", blArray[i] ? "true" : "false");
            }
        }
        this.loaded = false;
    }

    public ActionSet(String string) {
        this();
        this.setLabel(string);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.label = string;
    }

    public PluginJAR getPluginJAR() {
        return this.plugin;
    }

    public void addAction(EditAction editAction) {
        this.actions.put(editAction.getName(), editAction);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.put(editAction.getName(), this);
        }
    }

    public void removeAction(String string) {
        this.actions.remove(string);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.remove(string);
        }
    }

    public void removeAllActions() {
        if (this.context != null) {
            this.context.actionNames = null;
            String[] stringArray = this.getActionNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.context.actionHash.remove(stringArray[i]);
            }
        }
        this.actions.clear();
    }

    public EditAction getAction(String string) {
        Object v = this.actions.get(string);
        if (v == placeholder) {
            this.load();
            v = this.actions.get(string);
            if (v == placeholder) {
                Log.log(7, this, "Outdated cache");
                v = null;
            }
        }
        return (EditAction)v;
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public String[] getActionNames() {
        String[] stringArray = new String[this.actions.size()];
        Enumeration enumeration = this.actions.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getCacheableActionNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Enumeration enumeration = this.actions.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v == placeholder) {
                Log.log(7, this, "Action set not up to date");
                continue;
            }
            if (!(v instanceof BeanShellAction)) continue;
            linkedList.add(((BeanShellAction)v).getName());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public EditAction[] getActions() {
        this.load();
        EditAction[] editActionArray = new EditAction[this.actions.size()];
        Enumeration enumeration = this.actions.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            editActionArray[n++] = (EditAction)enumeration.nextElement();
        }
        return editActionArray;
    }

    public boolean contains(String string) {
        return this.actions.containsKey(string);
    }

    public int size() {
        return this.actions.size();
    }

    public String toString() {
        return this.label;
    }

    public void initKeyBindings() {
        InputHandler inputHandler = jEdit.getInputHandler();
        for (Map.Entry entry : this.actions.entrySet()) {
            String string;
            String string2 = (String)entry.getKey();
            String string3 = jEdit.getProperty(string2 + ".shortcut");
            if (string3 != null) {
                inputHandler.addKeyBinding(string3, string2);
            }
            if ((string = jEdit.getProperty(string2 + ".shortcut2")) == null) continue;
            inputHandler.addKeyBinding(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Reader reader = null;
        try {
            Log.log(1, this, "Loading actions from " + this.uri);
            ActionListHandler actionListHandler = new ActionListHandler(this.uri.toString(), this);
            reader = new BufferedReader(new InputStreamReader(this.uri.openStream()));
            XmlParser xmlParser = new XmlParser();
            xmlParser.setHandler(actionListHandler);
            xmlParser.parse(null, null, reader);
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string = xmlException.getMessage();
            Log.log(9, this, this.uri + ":" + n + ": " + string);
        }
        catch (Exception exception) {
            Log.log(9, this.uri, exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
        }
    }

    void getActionNames(List list) {
        Enumeration enumeration = this.actions.keys();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
    }
}

