/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedReader;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.CharUnit;
import gnu.regexp.IntPair;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenEndSub;
import gnu.regexp.RETokenLookAhead;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import gnu.regexp.RETokenWordBoundary;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class RE
extends REToken {
    private static final String VERSION = "1.1.5-dev";
    private static ResourceBundle messages = PropertyResourceBundle.getBundle("gnu/regexp/MessagesBundle", Locale.getDefault());
    private REToken firstToken;
    private REToken lastToken;
    private int numSubs;
    private int minimumLength;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;
    public static final int REG_NO_INTERPOLATE = 128;

    public static final String version() {
        return VERSION;
    }

    static final String getLocalizedMessage(String string) {
        return messages.getString(string);
    }

    public RE(Object object) throws REException {
        this(object, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n) throws REException {
        this(object, n, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n, RESyntax rESyntax) throws REException {
        this(object, n, rESyntax, 0, 0);
    }

    private RE(REToken rEToken, REToken rEToken2, int n, int n2, int n3) {
        super(n2);
        this.firstToken = rEToken;
        this.lastToken = rEToken2;
        this.numSubs = n;
        this.minimumLength = n3;
        this.addToken(new RETokenEndSub(n2));
    }

    private RE(Object object, int n, RESyntax rESyntax, int n2, int n3) throws REException {
        super(n2);
        this.initialize(object, n, rESyntax, n2, n3);
    }

    protected RE() {
        super(0);
    }

    protected void initialize(Object object, int n, RESyntax rESyntax, int n2, int n3) throws REException {
        char[] cArray;
        if (object instanceof String) {
            cArray = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            cArray = (char[])object;
        } else if (object instanceof StringBuffer) {
            cArray = new char[((StringBuffer)object).length()];
            ((StringBuffer)object).getChars(0, cArray.length, cArray, 0);
        } else {
            cArray = object.toString().toCharArray();
        }
        int n4 = cArray.length;
        this.numSubs = 0;
        Vector<RE> vector = null;
        this.lastToken = null;
        this.firstToken = null;
        boolean bl = (n & 2) > 0;
        int n5 = 0;
        CharUnit charUnit = new CharUnit();
        IntPair intPair = new IntPair();
        REToken rEToken = null;
        while (n5 < n4) {
            int n6;
            int n7;
            int n8;
            boolean bl2;
            n5 = RE.getCharUnit(cArray, n5, charUnit);
            if ((charUnit.ch == '|' && rESyntax.get(14) ^ charUnit.bk || rESyntax.get(10) && charUnit.ch == '\n' && !charUnit.bk) && !rESyntax.get(9)) {
                this.addToken(rEToken);
                RE rE = new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength);
                this.minimumLength = 0;
                if (vector == null) {
                    vector = new Vector<RE>();
                }
                vector.addElement(rE);
                rEToken = null;
                this.lastToken = null;
                this.firstToken = null;
                continue;
            }
            if (charUnit.ch == '{' && rESyntax.get(8) && rESyntax.get(11) ^ charUnit.bk) {
                int n9 = this.getMinMax(cArray, n5, intPair, rESyntax);
                if (n9 > n5) {
                    if (intPair.first > intPair.second) {
                        throw new REException(RE.getLocalizedMessage("interval.order"), 1, n9);
                    }
                    if (rEToken == null) {
                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n9);
                    }
                    if (rEToken instanceof RETokenRepeated) {
                        throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n9);
                    }
                    if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                        throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n9);
                    }
                    if (rEToken.getMinimumLength() == 0 && intPair.second == Integer.MAX_VALUE) {
                        throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, n9);
                    }
                    n5 = n9;
                    rEToken = RE.setRepeated(rEToken, intPair.first, intPair.second, n5);
                    continue;
                }
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, charUnit.ch, bl);
                continue;
            }
            if (charUnit.ch == '[' && !charUnit.bk) {
                Vector<REToken> vector2 = new Vector<REToken>();
                bl2 = false;
                n8 = 0;
                if (n5 == n4) {
                    throw new REException(RE.getLocalizedMessage("unmatched.bracket"), 4, n5);
                }
                int n10 = cArray[n5];
                if (n10 == 94) {
                    bl2 = true;
                    if (++n5 == n4) {
                        throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n5);
                    }
                    n10 = cArray[n5];
                }
                if (n10 == 93) {
                    n8 = n10;
                    if (++n5 == n4) {
                        throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n5);
                    }
                }
                while ((n10 = cArray[n5++]) != 93) {
                    if (n10 == 45 && n8 != 0) {
                        if (n5 == n4) {
                            throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n5);
                        }
                        n10 = cArray[n5];
                        if (n10 == 93) {
                            vector2.addElement(new RETokenChar(this.subIndex, (char)n8, bl));
                            n8 = 45;
                        } else {
                            vector2.addElement(new RETokenRange(this.subIndex, (char)n8, (char)n10, bl));
                            n8 = 0;
                            ++n5;
                        }
                    } else if (n10 == 92 && rESyntax.get(0)) {
                        if (n5 == n4) {
                            throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n5);
                        }
                        int n11 = -1;
                        n7 = 0;
                        n6 = 0;
                        if ("dswDSW".indexOf(cArray[n5]) != -1 && rESyntax.get(24)) {
                            switch (cArray[n5]) {
                                case 'D': {
                                    n7 = 1;
                                }
                                case 'd': {
                                    n11 = 4;
                                    break;
                                }
                                case 'S': {
                                    n7 = 1;
                                }
                                case 's': {
                                    n11 = 9;
                                    break;
                                }
                                case 'W': {
                                    n7 = 1;
                                }
                                case 'w': {
                                    n11 = 0;
                                }
                            }
                        } else if ("nrt".indexOf(cArray[n5]) != -1) {
                            switch (cArray[n5]) {
                                case 'n': {
                                    n6 = 10;
                                    break;
                                }
                                case 't': {
                                    n6 = 9;
                                    break;
                                }
                                case 'r': {
                                    n6 = 13;
                                }
                            }
                        }
                        if (n8 != 0) {
                            vector2.addElement(new RETokenChar(this.subIndex, (char)n8, bl));
                        }
                        if (n11 != -1) {
                            vector2.addElement(new RETokenPOSIX(this.subIndex, n11, bl, n7 != 0));
                        } else {
                            n8 = n6 != 0 ? n6 : cArray[n5];
                        }
                        ++n5;
                    } else if (n10 == 91 && rESyntax.get(2) && n5 < n4 && cArray[n5] == ':') {
                        StringBuffer stringBuffer = new StringBuffer();
                        n5 = RE.getPosixSet(cArray, n5 + 1, stringBuffer);
                        n7 = RETokenPOSIX.intValue(stringBuffer.toString());
                        if (n7 != -1) {
                            vector2.addElement(new RETokenPOSIX(this.subIndex, n7, bl, false));
                        }
                    } else {
                        if (n8 != 0) {
                            vector2.addElement(new RETokenChar(this.subIndex, (char)n8, bl));
                        }
                        n8 = n10;
                    }
                    if (n5 != n4) continue;
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, n5);
                }
                if (n8 != 0) {
                    vector2.addElement(new RETokenChar(this.subIndex, (char)n8, bl));
                }
                this.addToken(rEToken);
                vector2.trimToSize();
                rEToken = new RETokenOneOf(this.subIndex, vector2, bl2);
                continue;
            }
            if (charUnit.ch == '(' && rESyntax.get(12) ^ charUnit.bk) {
                boolean bl3 = false;
                bl2 = false;
                n8 = 0;
                boolean bl4 = false;
                if (n5 + 1 < n4 && cArray[n5] == '?') {
                    switch (cArray[n5 + 1]) {
                        case '!': {
                            if (!rESyntax.get(21)) break;
                            bl3 = true;
                            bl4 = true;
                            n8 = 1;
                            n5 += 2;
                            break;
                        }
                        case '=': {
                            if (!rESyntax.get(21)) break;
                            bl3 = true;
                            n8 = 1;
                            n5 += 2;
                            break;
                        }
                        case ':': {
                            if (!rESyntax.get(20)) break;
                            bl3 = true;
                            n5 += 2;
                            break;
                        }
                        case '#': {
                            if (!rESyntax.get(23)) break;
                            bl2 = true;
                            break;
                        }
                        default: {
                            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                        }
                    }
                }
                if (n5 >= n4) {
                    throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, n5);
                }
                n7 = n5;
                n6 = n5;
                int n12 = 0;
                while (!((n6 = RE.getCharUnit(cArray, n7, charUnit)) <= 0 || n12 == 0 && charUnit.ch == ')' && rESyntax.get(12) ^ charUnit.bk)) {
                    n7 = n6;
                    if (n7 >= n4) {
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, n6);
                    }
                    if (charUnit.ch == '(' && rESyntax.get(12) ^ charUnit.bk) {
                        ++n12;
                        continue;
                    }
                    if (charUnit.ch != ')' || !(rESyntax.get(12) ^ charUnit.bk)) continue;
                    --n12;
                }
                if (bl2) {
                    n5 = n6;
                    continue;
                }
                this.addToken(rEToken);
                if (!bl3) {
                    ++this.numSubs;
                }
                int n13 = bl3 || n8 != 0 ? 0 : n3 + this.numSubs;
                rEToken = new RE(String.valueOf(cArray, n5, n7 - n5).toCharArray(), n, rESyntax, n13, n3 + this.numSubs);
                this.numSubs += ((RE)rEToken).getNumSubs();
                if (n8 != 0) {
                    rEToken = new RETokenLookAhead(rEToken, bl4);
                }
                n5 = n6;
                continue;
            }
            if (!rESyntax.get(16) && charUnit.ch == ')' && rESyntax.get(12) ^ charUnit.bk) {
                throw new REException(RE.getLocalizedMessage("unmatched.paren"), 7, n5);
            }
            if (charUnit.ch == '^' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenStart(this.subIndex, (n & 8) > 0 ? rESyntax.getLineSeparator() : null));
                continue;
            }
            if (charUnit.ch == '$' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenEnd(this.subIndex, (n & 8) > 0 ? rESyntax.getLineSeparator() : null));
                continue;
            }
            if (charUnit.ch == '.' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = new RETokenAny(this.subIndex, rESyntax.get(6) || (n & 4) > 0, rESyntax.get(7));
                continue;
            }
            if (charUnit.ch == '*' && !charUnit.bk) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                if (rEToken.getMinimumLength() == 0) {
                    throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 0, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '+' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                if (rEToken.getMinimumLength() == 0) {
                    throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 1, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '?' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                if (rEToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n5);
                }
                if (rEToken instanceof RETokenRepeated) {
                    if (rESyntax.get(18) && !((RETokenRepeated)rEToken).isStingy()) {
                        ((RETokenRepeated)rEToken).makeStingy();
                        continue;
                    }
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, n5);
                }
                if (rEToken instanceof RETokenWordBoundary || rEToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, n5);
                }
                rEToken = RE.setRepeated(rEToken, 0, 1, n5);
                continue;
            }
            if (charUnit.bk && Character.isDigit(charUnit.ch) && !rESyntax.get(13)) {
                this.addToken(rEToken);
                rEToken = new RETokenBackRef(this.subIndex, Character.digit(charUnit.ch, 10), bl);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'A' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenStart(this.subIndex, null);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'b' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 3, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == '<') {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 1, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == '>') {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 2, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'B' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenWordBoundary(this.subIndex, 3, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'd' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 4, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'D' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 4, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'n') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\n', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'r') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\r', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 's' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 9, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'S' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 9, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 't') {
                this.addToken(rEToken);
                rEToken = new RETokenChar(this.subIndex, '\t', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'w' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 0, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'W' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(this.subIndex, 0, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'Z' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenEnd(this.subIndex, null);
                continue;
            }
            this.addToken(rEToken);
            rEToken = new RETokenChar(this.subIndex, charUnit.ch, bl);
        }
        this.addToken(rEToken);
        if (vector != null) {
            vector.addElement(new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength));
            vector.trimToSize();
            this.minimumLength = 0;
            this.lastToken = null;
            this.firstToken = null;
            this.addToken(new RETokenOneOf(this.subIndex, vector, false));
        } else {
            this.addToken(new RETokenEndSub(this.subIndex));
        }
    }

    private static int getCharUnit(char[] cArray, int n, CharUnit charUnit) throws REException {
        charUnit.ch = cArray[n++];
        charUnit.bk = charUnit.ch == '\\';
        if (charUnit.bk) {
            if (n < cArray.length) {
                charUnit.ch = cArray[n++];
            } else {
                throw new REException(RE.getLocalizedMessage("ends.with.backslash"), 10, n);
            }
        }
        return n;
    }

    public boolean isMatch(Object object) {
        return this.isMatch(object, 0, 0);
    }

    public boolean isMatch(Object object, int n) {
        return this.isMatch(object, n, 0);
    }

    public boolean isMatch(Object object, int n, int n2) {
        return this.isMatchImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private boolean isMatchImpl(CharIndexed charIndexed, int n, int n2) {
        if (this.firstToken == null) {
            return charIndexed.charAt(0) == '\uffff';
        }
        REMatch rEMatch = new REMatch(this.numSubs, n, n2);
        if (this.firstToken.match(charIndexed, rEMatch)) {
            while (rEMatch != null) {
                if (charIndexed.charAt(rEMatch.index) == '\uffff') {
                    return true;
                }
                rEMatch = rEMatch.next;
            }
        }
        return false;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    void setUncle(REToken rEToken) {
        if (this.lastToken != null) {
            this.lastToken.setUncle(rEToken);
        } else {
            super.setUncle(rEToken);
        }
    }

    boolean chain(REToken rEToken) {
        super.chain(rEToken);
        this.setUncle(rEToken);
        return true;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public REMatch[] getAllMatches(Object object) {
        return this.getAllMatches(object, 0, 0);
    }

    public REMatch[] getAllMatches(Object object, int n) {
        return this.getAllMatches(object, n, 0);
    }

    public REMatch[] getAllMatches(Object object, int n, int n2) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private REMatch[] getAllMatchesImpl(CharIndexed charIndexed, int n, int n2) {
        Vector<REMatch> vector = new Vector<REMatch>();
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, null)) != null) {
            vector.addElement(rEMatch);
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                ++n;
                charIndexed.move(1);
            } else {
                charIndexed.move(rEMatch.end[0]);
            }
            if (charIndexed.isValid()) continue;
        }
        Object[] objectArray = new REMatch[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.firstToken == null) {
            return this.next(charIndexed, rEMatch);
        }
        rEMatch.start[this.subIndex] = rEMatch.index;
        return this.firstToken.match(charIndexed, rEMatch);
    }

    public REMatch getMatch(Object object) {
        return this.getMatch(object, 0, 0);
    }

    public REMatch getMatch(Object object, int n) {
        return this.getMatch(object, n, 0);
    }

    public REMatch getMatch(Object object, int n, int n2) {
        return this.getMatch(object, n, n2, null);
    }

    public REMatch getMatch(Object object, int n, int n2, StringBuffer stringBuffer) {
        return this.getMatchImpl(RE.makeCharIndexed(object, n), n, n2, stringBuffer);
    }

    REMatch getMatchImpl(CharIndexed charIndexed, int n, int n2, StringBuffer stringBuffer) {
        REMatch rEMatch = new REMatch(this.numSubs, n, n2);
        do {
            if ((this.minimumLength == 0 || charIndexed.charAt(this.minimumLength - 1) != '\uffff') && this.match(charIndexed, rEMatch)) {
                REMatch rEMatch2 = rEMatch;
                while ((rEMatch = rEMatch.next) != null) {
                    if (rEMatch.index <= rEMatch2.index) continue;
                    rEMatch2 = rEMatch;
                }
                rEMatch2.end[0] = rEMatch2.index;
                rEMatch2.finish(charIndexed);
                return rEMatch2;
            }
            rEMatch.clear(++n);
            if (stringBuffer == null || charIndexed.charAt(0) == '\uffff') continue;
            stringBuffer.append(charIndexed.charAt(0));
        } while (charIndexed.move(1));
        if (this.minimumLength == 0 && this.match(charIndexed, rEMatch)) {
            rEMatch.finish(charIndexed);
            return rEMatch;
        }
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object object) {
        return this.getMatchEnumeration(object, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n) {
        return this.getMatchEnumeration(object, n, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n, int n2) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(object, n), n, n2);
    }

    public String substitute(Object object, String string) {
        return this.substitute(object, string, 0, 0);
    }

    public String substitute(Object object, String string, int n) {
        return this.substitute(object, string, n, 0);
    }

    public String substitute(Object object, String string, int n, int n2) {
        return this.substituteImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteImpl(CharIndexed charIndexed, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        REMatch rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer);
        if (rEMatch == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append((n2 & 0x80) > 0 ? string : rEMatch.substituteInto(string));
        if (charIndexed.move(rEMatch.end[0])) {
            do {
                stringBuffer.append(charIndexed.charAt(0));
            } while (charIndexed.move(1));
        }
        return stringBuffer.toString();
    }

    public String substituteAll(Object object, String string) {
        return this.substituteAll(object, string, 0, 0);
    }

    public String substituteAll(Object object, String string, int n) {
        return this.substituteAll(object, string, n, 0);
    }

    public String substituteAll(Object object, String string, int n, int n2) {
        return this.substituteAllImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteAllImpl(CharIndexed charIndexed, String string, int n, int n2) {
        REMatch rEMatch;
        StringBuffer stringBuffer = new StringBuffer();
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer)) != null) {
            stringBuffer.append((n2 & 0x80) > 0 ? string : rEMatch.substituteInto(string));
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                char c = charIndexed.charAt(0);
                if (c != '\uffff') {
                    stringBuffer.append(c);
                }
                charIndexed.move(1);
            } else {
                charIndexed.move(rEMatch.end[0]);
            }
            if (charIndexed.isValid()) continue;
            break;
        }
        return stringBuffer.toString();
    }

    private void addToken(REToken rEToken) {
        if (rEToken == null) {
            return;
        }
        this.minimumLength += rEToken.getMinimumLength();
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
        } else if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    private static REToken setRepeated(REToken rEToken, int n, int n2, int n3) throws REException {
        if (rEToken == null) {
            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, n3);
        }
        return new RETokenRepeated(rEToken.subIndex, rEToken, n, n2);
    }

    private static int getPosixSet(char[] cArray, int n, StringBuffer stringBuffer) {
        for (int i = n; i < cArray.length - 1; ++i) {
            if (cArray[i] == ':' && cArray[i + 1] == ']') {
                return i + 2;
            }
            stringBuffer.append(cArray[i]);
        }
        return n;
    }

    private int getMinMax(char[] cArray, int n, IntPair intPair, RESyntax rESyntax) throws REException {
        boolean bl = !rESyntax.get(11);
        int n2 = n;
        if (n == cArray.length) {
            if (bl) {
                throw new REException(RE.getLocalizedMessage("unmatched.brace"), 3, n);
            }
            return n2;
        }
        int n3 = 0;
        CharUnit charUnit = new CharUnit();
        StringBuffer stringBuffer = new StringBuffer();
        do {
            n = RE.getCharUnit(cArray, n, charUnit);
            if (!Character.isDigit(charUnit.ch)) continue;
            stringBuffer.append(charUnit.ch);
        } while (n != cArray.length && Character.isDigit(charUnit.ch));
        if (stringBuffer.length() == 0) {
            if (bl) {
                throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
            }
            return n2;
        }
        int n4 = Integer.parseInt(stringBuffer.toString());
        if (charUnit.ch == '}' && rESyntax.get(11) ^ charUnit.bk) {
            n3 = n4;
        } else {
            if (n == cArray.length) {
                if (bl) {
                    throw new REException(RE.getLocalizedMessage("interval.no.end"), 3, n);
                }
                return n2;
            }
            if (charUnit.ch == ',' && !charUnit.bk) {
                stringBuffer = new StringBuffer();
                while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
                    stringBuffer.append(charUnit.ch);
                }
                if (charUnit.ch != '}' || !(rESyntax.get(11) ^ charUnit.bk)) {
                    if (bl) {
                        throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
                    }
                    return n2;
                }
                n3 = stringBuffer.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(stringBuffer.toString());
            } else {
                if (bl) {
                    throw new REException(RE.getLocalizedMessage("interval.error"), 3, n);
                }
                return n2;
            }
        }
        intPair.first = n4;
        intPair.second = n3;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.dump(stringBuffer);
        return stringBuffer.toString();
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        if (this.subIndex == 0) {
            stringBuffer.append("?:");
        }
        if (this.firstToken != null) {
            this.firstToken.dumpAll(stringBuffer);
        }
        stringBuffer.append(')');
    }

    private static CharIndexed makeCharIndexed(Object object, int n) {
        if (object instanceof String) {
            return new CharIndexedString((String)object, n);
        }
        if (object instanceof char[]) {
            return new CharIndexedCharArray((char[])object, n);
        }
        if (object instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)object, n);
        }
        if (object instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)object, n);
        }
        if (object instanceof Reader) {
            return new CharIndexedReader((Reader)object, n);
        }
        if (object instanceof CharIndexed) {
            return (CharIndexed)object;
        }
        return new CharIndexedString(object.toString(), n);
    }
}

