/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.spectral;

import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;

public class RegularSpectralCurve
extends SpectralCurve {
    private float[] spectrum;
    private float lambdaMin;
    private float lambdaMax;
    private float delta;
    private float invDelta;
    public static final Type $TYPE = new Type(RegularSpectralCurve.class);
    public static final SCOType.Field spectrum$FIELD = Type._addManagedField($TYPE, "spectrum", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(float[].class), null, 0);
    public static final SCOType.Field lambdaMin$FIELD = Type._addManagedField($TYPE, "lambdaMin", 0x200002, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field lambdaMax$FIELD = Type._addManagedField($TYPE, "lambdaMax", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field delta$FIELD = Type._addManagedField($TYPE, "delta", 0x200002, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field invDelta$FIELD = Type._addManagedField($TYPE, "invDelta", 0x200002, de.grogra.reflect.Type.FLOAT, null, 4);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public RegularSpectralCurve() {
    }

    public RegularSpectralCurve(float[] fArray, float f, float f2) {
        this.lambdaMin = f;
        this.lambdaMax = f2;
        this.spectrum = fArray;
        this.delta = (f2 - f) / (float)(fArray.length - 1);
        this.invDelta = 1.0f / this.delta;
    }

    public float sample(float f) {
        if (f < this.lambdaMin || f > this.lambdaMax) {
            return 0.0f;
        }
        float f2 = (f - this.lambdaMin) * this.invDelta;
        int n = (int)f2;
        int n2 = Math.min(n + 1, this.spectrum.length - 1);
        float f3 = f2 - (float)n;
        return (1.0f - f3) * this.spectrum[n] + f3 * this.spectrum[n2];
    }

    static /* synthetic */ float[] access$402(RegularSpectralCurve regularSpectralCurve, float[] fArray) {
        regularSpectralCurve.spectrum = fArray;
        return fArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(RegularSpectralCurve regularSpectralCurve, SCOType sCOType) {
            super((Object)regularSpectralCurve, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 1: {
                    ((RegularSpectralCurve)((Object)object)).lambdaMin = f;
                    return;
                }
                case 2: {
                    ((RegularSpectralCurve)((Object)object)).lambdaMax = f;
                    return;
                }
                case 3: {
                    ((RegularSpectralCurve)((Object)object)).delta = f;
                    return;
                }
                case 4: {
                    ((RegularSpectralCurve)((Object)object)).invDelta = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((RegularSpectralCurve)((Object)object)).lambdaMin;
                }
                case 2: {
                    return ((RegularSpectralCurve)((Object)object)).lambdaMax;
                }
                case 3: {
                    return ((RegularSpectralCurve)((Object)object)).delta;
                }
                case 4: {
                    return ((RegularSpectralCurve)((Object)object)).invDelta;
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    RegularSpectralCurve.access$402((RegularSpectralCurve)((Object)object), (float[])object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((RegularSpectralCurve)((Object)object)).spectrum;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new RegularSpectralCurve();
        }
    }
}

