/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.shading;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.shading.FluxIORShader;
import de.grogra.gpuflux.scene.shading.FluxPhongShader;
import de.grogra.gpuflux.scene.shading.FluxRGBAShader;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.FluxSwitchShader;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMapBuilder;
import de.grogra.imp3d.shading.AlgorithmSwitchShader;
import de.grogra.imp3d.shading.IORShader;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.imp3d.shading.ShaderVisitor;
import de.grogra.imp3d.shading.SideSwitchShader;
import de.grogra.imp3d.shading.SunSkyLight;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluxShaderBuilder
implements ShaderVisitor {
    FluxChannelMapBuilder channelMapBuilder = new FluxChannelMapBuilder(){

        protected void warning(String string) {
            FluxShaderBuilder.this.warning(string);
        }
    };
    private FluxShader currentFluxShader;
    private Hashtable<Shader, FluxShader> shaderCache = new Hashtable();
    private Vector<FluxShader> shaders = new Vector();
    private FluxRGBAShader defaultShader = new FluxRGBAShader(new RGBAShader());
    boolean switched;
    boolean iored;

    public FluxShaderBuilder() {
        this.shaders.add(this.defaultShader);
        this.currentFluxShader = this.defaultShader;
        this.switched = false;
        this.iored = false;
    }

    public void visit(ShaderRef shaderRef) {
        shaderRef.resolve().accept((ShaderVisitor)this);
    }

    protected abstract void warning(String var1);

    public void visit(Phong phong) {
        this.addShader(new FluxPhongShader(phong, this.channelMapBuilder), (Shader)phong);
    }

    public void visit(RGBAShader rGBAShader) {
        this.addShader(new FluxRGBAShader(rGBAShader), (Shader)rGBAShader);
    }

    public void visit(SideSwitchShader sideSwitchShader) {
        Shader shader = sideSwitchShader.getFrontShader();
        Shader shader2 = sideSwitchShader.getBackShader();
        if (!this.switched) {
            this.switched = true;
            FluxShader fluxShader = this.buildShader(shader);
            FluxShader fluxShader2 = this.buildShader(shader2);
            this.switched = false;
            this.addShader(new FluxSwitchShader(fluxShader, fluxShader2), (Shader)sideSwitchShader);
        } else {
            this.warning("GPUFlux: nested switch shader has no effect.");
            this.buildShader(shader);
        }
    }

    public void visit(SunSkyLight sunSkyLight) {
        this.visit((Shader)sunSkyLight);
    }

    public void visit(AlgorithmSwitchShader algorithmSwitchShader) {
        algorithmSwitchShader.getRaytracerShader().accept((ShaderVisitor)this);
    }

    public void visit(Shader shader) {
        if (shader instanceof IORShader) {
            IORShader iORShader = (IORShader)shader;
            if (this.iored) {
                this.warning("GPUFlux: nested switch shader has no effect.");
                this.buildShader(iORShader.getInputshader());
            } else {
                boolean bl = this.switched;
                this.switched = true;
                this.iored = true;
                FluxShader fluxShader = this.buildShader(iORShader.getInputshader());
                this.iored = false;
                this.switched = bl;
                this.addShader(new FluxIORShader(iORShader, fluxShader), iORShader);
            }
        } else {
            this.warning("GPUFlux: Unkown shader " + shader.getClass().getName() + ", average color is used instead.");
            RGBAShader rGBAShader = new RGBAShader(shader.getAverageColor());
            this.addShader(new FluxRGBAShader(rGBAShader), (Shader)rGBAShader);
        }
    }

    public FluxShader buildShader(Shader shader) {
        this.currentFluxShader = this.defaultShader;
        if (shader != null) {
            FluxShader fluxShader = this.shaderCache.get(shader);
            if (fluxShader == null) {
                shader.accept((ShaderVisitor)this);
            } else {
                this.currentFluxShader = fluxShader;
            }
        }
        return this.currentFluxShader;
    }

    private void addShader(FluxShader fluxShader, Shader shader) {
        this.currentFluxShader = fluxShader;
        this.shaderCache.put(shader, this.currentFluxShader);
        this.shaders.add(fluxShader);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer, ComputeByteBuffer computeByteBuffer2) throws IOException {
        this.channelMapBuilder.serialize(computeByteBuffer);
        for (FluxShader fluxShader : this.shaders) {
            fluxShader.setOffset(computeByteBuffer2.size());
            fluxShader.serialize(computeByteBuffer2);
        }
    }

    public int getShaderCount() {
        return this.shaders.size();
    }

    public FluxChannelMapBuilder getChannelBuilder() {
        return this.channelMapBuilder;
    }

    public Vector<FluxShader> getShaders() {
        return this.shaders;
    }
}

