/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.shading;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMapBuilder;
import de.grogra.imp3d.shading.Phong;
import de.grogra.math.ColorMap;
import de.grogra.math.Graytone;
import java.io.IOException;

public class FluxPhongShader
extends FluxShader {
    private Phong phong;
    private FluxChannelMap diffuse;
    private FluxChannelMap diffuseTransparancy;
    private FluxChannelMap shininess;
    private FluxChannelMap specular;
    private FluxChannelMap transparancy;
    private FluxChannelMap transparancyShininess;
    public static final ColorMap DEFAULT_DIFFUSE = new Graytone(0.5f);
    public static final ColorMap DEFAULT_TRANSPARENCY = new Graytone(0.0f);
    public static final ColorMap DEFAULT_SPECULAR = null;
    public static final ColorMap DEFAULT_DIFFUSE_TRANSPARENCY = new Graytone(0.0f);
    public static final ColorMap DEFAULT_AMBIENT = new Graytone(0.0f);
    public static final ColorMap DEFAULT_EMISSIVE = new Graytone(0.0f);
    public static final ColorMap DEFAULT_SHININESS = new Graytone(0.37275f);
    public static final ColorMap DEFAULT_TRANSPARENCY_SHININESS = new Graytone(1.0f);

    public FluxPhongShader(Phong phong, FluxChannelMapBuilder fluxChannelMapBuilder) {
        this.phong = phong;
        this.diffuse = fluxChannelMapBuilder.buildChannelMap(phong.getDiffuse(), DEFAULT_DIFFUSE);
        this.diffuseTransparancy = fluxChannelMapBuilder.buildChannelMap(phong.getDiffuseTransparency(), DEFAULT_DIFFUSE_TRANSPARENCY);
        this.shininess = fluxChannelMapBuilder.buildChannelMap(phong.getShininess(), DEFAULT_SHININESS);
        this.specular = fluxChannelMapBuilder.buildChannelMap(phong.getSpecular(), DEFAULT_SPECULAR);
        this.transparancy = fluxChannelMapBuilder.buildChannelMap(phong.getTransparency(), DEFAULT_TRANSPARENCY);
        this.transparancyShininess = fluxChannelMapBuilder.buildChannelMap(phong.getTransparencyShininess(), DEFAULT_TRANSPARENCY_SHININESS);
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        computeByteBuffer.writeInt(1);
        this.serialize(computeByteBuffer, this.diffuse);
        this.serialize(computeByteBuffer, this.specular);
        this.serialize(computeByteBuffer, this.shininess);
        this.serialize(computeByteBuffer, this.diffuseTransparancy);
        this.serialize(computeByteBuffer, this.transparancy);
        this.serialize(computeByteBuffer, this.transparancyShininess);
        computeByteBuffer.writeBoolean(this.phong.isInterpolatedTransparency());
    }

    private void serialize(ComputeByteBuffer computeByteBuffer, FluxChannelMap fluxChannelMap) throws IOException {
        if (fluxChannelMap == null) {
            computeByteBuffer.writeInt(-1);
        } else {
            computeByteBuffer.writeInt(fluxChannelMap.getOffset());
        }
    }
}

