/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.experiment.MeasuringSetup;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxSensor;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.vecmath.BoundingBox3d;
import de.grogra.vecmath.Math2;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxSceneSerializer {
    private static final int CAMERA_PROJECT = 1;
    private static final int CAMERA_PARALLEL = 2;
    private FluxScene scene;
    private MeasuringSetup measuringSetup;

    public void serializeScene(FluxScene fluxScene) {
        this.scene = fluxScene;
    }

    public void serializeMeasureSetup(MeasuringSetup measuringSetup) {
        this.measuringSetup = measuringSetup;
    }

    public void serializeDetectors(ComputeByteBuffer computeByteBuffer) throws IOException {
        Vector<MeasuringSetup.FluxDetector> vector = this.measuringSetup.getDetectors();
        for (int i = 0; i < vector.size(); ++i) {
            MeasuringSetup.FluxDetector fluxDetector = vector.get(i);
            computeByteBuffer.writeInt(fluxDetector.getOffset());
            computeByteBuffer.writeInt(fluxDetector.getMeasurements());
        }
    }

    public void serializeBVH(ComputeByteBuffer computeByteBuffer, boolean bl) throws IOException {
        if (bl) {
            this.scene.getBVH().serializeBIH(computeByteBuffer, this.scene.getInfPrimitives().size());
        } else {
            this.scene.getBVH().serializeBVH(computeByteBuffer, this.scene.getInfPrimitives().size());
        }
    }

    public void serializeSensorBVH(ComputeByteBuffer computeByteBuffer, boolean bl) throws IOException {
        if (this.scene.getSensorBVH() != null) {
            if (bl) {
                this.scene.getSensorBVH().serializeBIH(computeByteBuffer, 0);
            } else {
                this.scene.getSensorBVH().serializeBVH(computeByteBuffer, 0);
            }
        }
    }

    public void serializeSensors(ComputeByteBuffer computeByteBuffer) throws IOException {
        if (this.scene.getSensorBVH() != null) {
            Integer[] integerArray = this.scene.getSensorBVH().getVolumeOrdering();
            for (int i = 0; i < integerArray.length; ++i) {
                int n = integerArray[i];
                FluxSensor fluxSensor = this.scene.getSensors().get(n);
                fluxSensor.serialize(computeByteBuffer);
            }
        }
    }

    public void serializeShaders(ComputeByteBuffer computeByteBuffer) throws IOException {
        Vector<FluxShader> vector = this.scene.getShaders();
        this.serializeShaders(vector, computeByteBuffer);
    }

    private void serializeShaders(Vector<FluxShader> vector, ComputeByteBuffer computeByteBuffer) throws IOException {
        for (FluxShader fluxShader : vector) {
            fluxShader.setOffset(computeByteBuffer.size());
            fluxShader.serialize(computeByteBuffer);
        }
    }

    public void serializeChannels(ComputeByteBuffer computeByteBuffer) throws IOException {
        Vector<FluxChannelMap> vector = this.scene.getChannels();
        this.serializeChannels(vector, computeByteBuffer);
    }

    private void serializeChannels(Vector<FluxChannelMap> vector, ComputeByteBuffer computeByteBuffer) throws IOException {
        for (FluxChannelMap fluxChannelMap : vector) {
            fluxChannelMap.setOffset(computeByteBuffer.size());
            fluxChannelMap.serialize(computeByteBuffer);
        }
    }

    public void serializePrimitives(ComputeByteBuffer computeByteBuffer) throws IOException {
        int n;
        Integer[] integerArray = this.scene.getBVH().getVolumeOrdering();
        Vector<FluxPrimitive> vector = this.scene.getInfPrimitives();
        Vector<FluxPrimitive> vector2 = this.scene.getPrimitives();
        for (n = 0; n < vector.size(); ++n) {
            vector.get(n).setOffset(computeByteBuffer.size());
            vector.get(n).serialize(computeByteBuffer);
        }
        for (n = 0; n < integerArray.length; ++n) {
            int n2 = integerArray[n];
            vector2.get(n2).setOffset(computeByteBuffer.size());
            vector2.get(n2).serialize(computeByteBuffer);
        }
    }

    public void serializePrimitiveOffsets(ComputeByteBuffer computeByteBuffer) throws IOException {
        int n;
        Integer[] integerArray = this.scene.getBVH().getVolumeOrdering();
        Vector<FluxPrimitive> vector = this.scene.getInfPrimitives();
        Vector<FluxPrimitive> vector2 = this.scene.getPrimitives();
        for (n = 0; n < vector.size(); ++n) {
            computeByteBuffer.writeInt(vector.get(n).getOffset());
        }
        for (n = 0; n < integerArray.length; ++n) {
            int n2 = integerArray[n];
            computeByteBuffer.writeInt(vector2.get(n2).getOffset());
        }
    }

    public void serializeLights(ComputeByteBuffer computeByteBuffer) throws IOException {
        Vector<FluxLight> vector = this.scene.getLights();
        this.serializeChannels(this.scene.getLightChannels(), computeByteBuffer);
        this.serializeShaders(this.scene.getLightShaders(), computeByteBuffer);
        for (int i = 0; i < vector.size(); ++i) {
            FluxLight fluxLight = vector.elementAt(i);
            int n = computeByteBuffer.size();
            fluxLight.setOffset(n);
            fluxLight.serialize(computeByteBuffer);
        }
    }

    public void serializeLightOffsets(ComputeByteBuffer computeByteBuffer) throws IOException {
        Vector<FluxLight> vector = this.scene.getLights();
        for (int i = 0; i < vector.size(); ++i) {
            computeByteBuffer.writeInt(vector.elementAt(i).getOffset());
        }
    }

    public void serializeCumulativeLightPowerDistribution(ComputeByteBuffer computeByteBuffer) throws IOException {
        float[] fArray = this.scene.getCumulativeLightPower();
        for (int i = 0; i < fArray.length; ++i) {
            computeByteBuffer.writeFloat(fArray[i]);
        }
    }

    public void serializeBoundingSphere(ComputeByteBuffer computeByteBuffer) {
        BoundingBox3d boundingBox3d = this.scene.getBounds();
        Point3d point3d = new Point3d();
        boundingBox3d.getCenter((Tuple3d)point3d);
        float f = (float)boundingBox3d.getRadius();
        try {
            computeByteBuffer.write((Tuple3d)point3d);
            computeByteBuffer.writeFloat(f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void serializeCamera(ComputeByteBuffer computeByteBuffer, int n, int n2) {
        Camera camera = this.scene.getCamera();
        Matrix4d matrix4d = new Matrix4d();
        Math2.invertAffine((Matrix4d)camera.getWorldToViewTransformation(), (Matrix4d)matrix4d);
        Vector4d vector4d = new Vector4d();
        Vector4d vector4d2 = new Vector4d();
        Vector4d vector4d3 = new Vector4d();
        Vector4d vector4d4 = new Vector4d();
        matrix4d.getColumn(0, vector4d);
        matrix4d.getColumn(1, vector4d2);
        matrix4d.getColumn(2, vector4d3);
        matrix4d.getColumn(3, vector4d4);
        Projection projection = camera.getProjection();
        vector4d.scale(1.0 / (double)projection.getScaleX());
        vector4d2.scale(-1.0 / (double)projection.getScaleY());
        vector4d.scale(1.0);
        vector4d2.scale((double)n2 / (double)n);
        vector4d3.negate();
        try {
            if (projection instanceof PerspectiveProjection) {
                computeByteBuffer.writeInt(1);
            } else {
                computeByteBuffer.writeInt(2);
            }
            computeByteBuffer.write((Tuple4d)vector4d);
            computeByteBuffer.write((Tuple4d)vector4d2);
            computeByteBuffer.write((Tuple4d)vector4d3);
            computeByteBuffer.write((Tuple4d)vector4d4);
            computeByteBuffer.writeInt(n);
            computeByteBuffer.writeInt(n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public FluxScene getScene() {
        return this.scene;
    }

    public int getSkyOffset() {
        if (this.scene.getSky() == null) {
            return -1;
        }
        return this.scene.getSky().getOffset();
    }
}

