/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl.compute;

import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLContext;
import de.grogra.gpuflux.jocl.JOCLDevice;
import de.grogra.gpuflux.jocl.JOCLDeviceFilter;
import de.grogra.gpuflux.jocl.JOCLKernel;
import de.grogra.gpuflux.jocl.JOCLPlatform;
import de.grogra.gpuflux.jocl.JOCLProgram;
import de.grogra.gpuflux.jocl.JOCLSource;
import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.jocl.compute.SharedBuffer;
import de.grogra.pf.ui.Workbench;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jocl.CL;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeContext {
    private Vector<Device> devices = new Vector();
    private Vector<JOCLContext> contexts = new Vector();
    private JOCLDeviceFilter filter;
    String log = "";
    private boolean hasLittleEndian = false;
    private boolean hasBigEndian = false;

    public String getLog() {
        return this.log;
    }

    public ComputeContext(JOCLDeviceFilter jOCLDeviceFilter) {
        Object object;
        this.filter = jOCLDeviceFilter;
        this.log = this.log + "<B>Compute Context</B>\n";
        CL.setExceptionsEnabled((boolean)true);
        int[] nArray = new int[1];
        CL.clGetPlatformIDs((int)0, null, (int[])nArray);
        cl_platform_id[] cl_platform_idArray = new cl_platform_id[nArray[0]];
        CL.clGetPlatformIDs((int)cl_platform_idArray.length, (cl_platform_id[])cl_platform_idArray, null);
        Vector<JOCLPlatform> vector = new Vector<JOCLPlatform>();
        for (cl_platform_id cl_platform_id2 : cl_platform_idArray) {
            JOCLPlatform jOCLPlatform = new JOCLPlatform(cl_platform_id2);
            JOCLPlatform.JOCLPlatformVersion object22 = jOCLPlatform.getVersion();
            object = vector.iterator();
            while (object.hasNext()) {
                JOCLPlatform jOCLPlatform2 = (JOCLPlatform)object.next();
                if (jOCLPlatform2.getName() != jOCLPlatform.getName()) continue;
                if (object22.compare(object22, jOCLPlatform2.getVersion()) < 0) {
                    jOCLPlatform = null;
                    break;
                }
                object.remove();
            }
            if (jOCLPlatform == null) continue;
            vector.add(jOCLPlatform);
        }
        this.log = this.log + "    <B>Available Compute Platforms:</B>\n";
        jOCLDeviceFilter.init();
        for (JOCLPlatform jOCLPlatform : vector) {
            this.log = this.log + "    Platform: " + jOCLPlatform.getName() + "\n";
            this.log = this.log + "    Vendor:   " + jOCLPlatform.getVendor() + "\n";
            this.log = this.log + "    Version:  " + jOCLPlatform.getVersion() + "\n\n";
            for (cl_device_id cl_device_id2 : jOCLPlatform.getDevices()) {
                jOCLDeviceFilter.filter(cl_device_id2);
            }
        }
        AbstractList<cl_device_id> abstractList = jOCLDeviceFilter.getDevices();
        this.log = this.log + "    <B>Selected Compute Devices:</B>\n";
        if (abstractList.size() == 0) {
            this.log = this.log + "    No suitable devices where found\n";
        }
        Iterator iterator = abstractList.iterator();
        while (iterator.hasNext()) {
            cl_device_id cl_device_id2 = (cl_device_id)iterator.next();
            ArrayList<cl_device_id> arrayList = new ArrayList<cl_device_id>(1);
            ((AbstractList)arrayList).add(cl_device_id2);
            JOCLPlatform jOCLPlatform = new JOCLPlatform(JOCLDevice.getPlatform(cl_device_id2));
            JOCLContext jOCLContext = jOCLPlatform.createContext(arrayList);
            this.log = this.log + jOCLContext.getLog();
            object = new Device(this.contexts.size(), jOCLContext.getDevices().get(0), this);
            this.devices.add((Device)object);
            this.contexts.add(jOCLContext);
            this.hasLittleEndian |= jOCLContext.hasLittleEndian();
            this.hasBigEndian |= jOCLContext.hasBigEndian();
        }
        this.log = this.log + "\n";
    }

    public Kernel createKernel(String string, String string2, String string3) throws IOException {
        JOCLSource jOCLSource = new JOCLSource(string);
        String string4 = "<html><pre><i>Load kernel:</i> " + string2 + "\n";
        Workbench workbench = Workbench.current();
        Kernel kernel = new Kernel(this.contexts.size(), this);
        for (int i = 0; i < this.contexts.size(); ++i) {
            String string5 = string + string3;
            JOCLProgram jOCLProgram = this.contexts.get(i).getProgram(string5);
            if (jOCLProgram == null) {
                long l = System.currentTimeMillis();
                string4 = string4 + "Device: \n" + this.contexts.get(i).getDeviceNames();
                try {
                    jOCLProgram = this.contexts.get(i).loadProgram(string5, jOCLSource, string3);
                }
                catch (IOException iOException) {
                    throw new IOException(string + " " + string3 + "\n\n" + jOCLSource.dereferenceError(iOException.getMessage()));
                }
                long l2 = System.currentTimeMillis() - l;
                string4 = string4 + "Load time: " + l2 + " ms\n";
                string4 = string4 + "Build log: " + jOCLSource.dereferenceError(jOCLProgram.getBuildLog());
            }
            JOCLKernel jOCLKernel = jOCLProgram.createKernel(string2);
            kernel.setContextKernel(i, jOCLKernel);
        }
        if (workbench != null) {
            workbench.logGUIInfo(string4 + "</pre></html>");
        }
        return kernel;
    }

    public SharedBuffer createSharedBuffer(ComputeByteBuffer computeByteBuffer, long l) {
        SharedBuffer sharedBuffer = new SharedBuffer(this.contexts.size(), this);
        for (int i = 0; i < this.contexts.size(); ++i) {
            JOCLBuffer jOCLBuffer = null;
            JOCLBuffer jOCLBuffer2 = null;
            if (this.contexts.get(i).hasLittleEndian()) {
                jOCLBuffer = this.contexts.get(i).createBufferFromByteArray(computeByteBuffer.getLittleEndianBuffer(), l);
            }
            if (this.contexts.get(i).hasBigEndian()) {
                jOCLBuffer2 = this.contexts.get(i).createBufferFromByteArray(computeByteBuffer.getBigEndianBuffer(), l);
            }
            sharedBuffer.setContextBuffer(i, jOCLBuffer, jOCLBuffer2);
        }
        return sharedBuffer;
    }

    public AbstractList<Device> getDeviceList() {
        return this.devices;
    }

    protected JOCLContext getContext(int n) {
        return this.contexts.get(n);
    }

    public JOCLDeviceFilter getFilter() {
        return this.filter;
    }

    public boolean hasLittleEndian() {
        return this.hasLittleEndian;
    }

    public boolean hasBigEndian() {
        return this.hasBigEndian;
    }

    public Device getPrimaryDevice() {
        return this.devices.get(0);
    }

    public boolean valid() {
        return this.devices.size() != 0;
    }

    public void finish() {
        for (Device device : this.devices) {
            device.finish();
        }
    }

    public ComputeByteBuffer createByteBuffer() {
        return new ComputeByteBuffer(this.hasLittleEndian(), this.hasBigEndian());
    }

    public Object aquireLog() {
        String string = this.log;
        this.log = "";
        return string;
    }
}

