/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.util;

import de.grogra.ext.x3d.X3DImport;
import de.grogra.imp.io.ImageReader;
import de.grogra.imp.objects.FixedImageAdapter;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.math.RGBColor;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Workbench;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static String splitExpr = "[ ,\n]+";

    public static float[] splitStringToArray2f(String string) {
        return Util.splitStringToArray2f(string, 0.0f, 0.0f);
    }

    public static float[] splitStringToArray2f(String string, float f, float f2) {
        float[] fArray = new float[]{f, f2};
        if (string != null) {
            string = string.trim();
            String[] stringArray = string.split(splitExpr);
            for (int i = 0; i < 2 && i < stringArray.length; ++i) {
                fArray[i] = Float.valueOf(stringArray[i]).floatValue();
            }
        }
        return fArray;
    }

    public static double[] splitStringToArray3d(String string) {
        return Util.splitStringToArray3d(string, 0.0, 0.0, 0.0);
    }

    public static float[] splitStringToArray3f(String string) {
        return Util.splitStringToArray3f(string, 0.0f, 0.0f, 0.0f);
    }

    public static double[] splitStringToArray3d(String string, double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        if (string != null) {
            string = string.trim();
            String[] stringArray = string.split(splitExpr);
            for (int i = 0; i < 3 && i < stringArray.length; ++i) {
                dArray[i] = Double.valueOf(stringArray[i]);
            }
        }
        return dArray;
    }

    public static float[] splitStringToArray3f(String string, float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        if (string != null) {
            string = string.trim();
            String[] stringArray = string.split(splitExpr);
            for (int i = 0; i < 3 && i < stringArray.length; ++i) {
                fArray[i] = Float.valueOf(stringArray[i]).floatValue();
            }
        }
        return fArray;
    }

    public static Tuple2f splitStringToTuple2f(Tuple2f tuple2f, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple2f.x = Float.valueOf(stringArray[0]).floatValue();
        tuple2f.y = Float.valueOf(stringArray[1]).floatValue();
        return tuple2f;
    }

    public static Tuple3f convertStringToTuple3f(Tuple3f tuple3f, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple3f.x = Float.valueOf(stringArray[0]).floatValue();
        tuple3f.y = -Float.valueOf(stringArray[2]).floatValue();
        tuple3f.z = Float.valueOf(stringArray[1]).floatValue();
        return tuple3f;
    }

    public static Tuple3f splitStringToTuple3f(Tuple3f tuple3f, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple3f.x = Float.valueOf(stringArray[0]).floatValue();
        tuple3f.y = Float.valueOf(stringArray[1]).floatValue();
        tuple3f.z = Float.valueOf(stringArray[2]).floatValue();
        return tuple3f;
    }

    public static Tuple3d convertStringToTuple3d(Tuple3d tuple3d, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple3d.x = Double.valueOf(stringArray[0]);
        tuple3d.y = -Double.valueOf(stringArray[2]).doubleValue();
        tuple3d.z = Double.valueOf(stringArray[1]);
        return tuple3d;
    }

    public static Tuple3d splitStringToTuple3d(Tuple3d tuple3d, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple3d.x = Double.valueOf(stringArray[0]);
        tuple3d.y = Double.valueOf(stringArray[1]);
        tuple3d.z = Double.valueOf(stringArray[2]);
        return tuple3d;
    }

    public static Tuple4f splitStringToTuple4f(Tuple4f tuple4f, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple4f.x = Float.valueOf(stringArray[0]).floatValue();
        tuple4f.y = Float.valueOf(stringArray[1]).floatValue();
        tuple4f.z = Float.valueOf(stringArray[2]).floatValue();
        tuple4f.w = Float.valueOf(stringArray[3]).floatValue();
        return tuple4f;
    }

    public static Tuple4f convertStringToTuple4f(Tuple4f tuple4f, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        tuple4f.x = Float.valueOf(stringArray[0]).floatValue();
        tuple4f.y = -Float.valueOf(stringArray[2]).floatValue();
        tuple4f.z = Float.valueOf(stringArray[1]).floatValue();
        tuple4f.w = Float.valueOf(stringArray[3]).floatValue();
        return tuple4f;
    }

    public static AxisAngle4d convertStringToAxisAngle4d(AxisAngle4d axisAngle4d, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        axisAngle4d.x = Double.valueOf(stringArray[0]);
        axisAngle4d.y = -Double.valueOf(stringArray[2]).doubleValue();
        axisAngle4d.z = Double.valueOf(stringArray[1]);
        axisAngle4d.angle = Double.valueOf(stringArray[3]);
        return axisAngle4d;
    }

    public static AxisAngle4d splitStringToAxisAngle4d(AxisAngle4d axisAngle4d, String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        axisAngle4d.x = Double.valueOf(stringArray[0]);
        axisAngle4d.y = Double.valueOf(stringArray[1]);
        axisAngle4d.z = Double.valueOf(stringArray[2]);
        axisAngle4d.angle = Double.valueOf(stringArray[3]);
        return axisAngle4d;
    }

    public static int[] splitStringToArrayOfInt(String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.valueOf(stringArray[i]);
        }
        return nArray;
    }

    public static int[] splitStringToArrayOfInt(String string, int[] nArray) {
        if (string != null) {
            return Util.splitStringToArrayOfInt(string);
        }
        return nArray;
    }

    public static float[] splitStringToArrayOfFloat(String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = Float.valueOf(stringArray[i]).floatValue();
        }
        return fArray;
    }

    public static float[] splitStringToArrayOfFloat(String string, float[] fArray) {
        if (string != null) {
            return Util.splitStringToArrayOfFloat(string);
        }
        return fArray;
    }

    public static double[] splitStringToArrayOfDouble(String string) {
        string = string.trim();
        String[] stringArray = string.split(splitExpr);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.valueOf(stringArray[i]);
        }
        return dArray;
    }

    public static double[] splitStringToArrayOfDouble(String string, double[] dArray) {
        if (string != null) {
            return Util.splitStringToArrayOfDouble(string);
        }
        return dArray;
    }

    public static String[] splitStringToArrayOfString(String string) {
        string = string.trim();
        String[] stringArray = string.split("\"[, ]+\"");
        stringArray[0] = stringArray[0].replace("\"", "");
        stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1].replace("\"", "");
        return stringArray;
    }

    public static String[] splitStringToArrayOfString(String string, String[] stringArray) {
        if (string != null) {
            string = string.trim();
            String[] stringArray2 = string.split("\"[, ]+\"");
            stringArray2[0] = stringArray2[0].replace("\"", "");
            stringArray2[stringArray2.length - 1] = stringArray2[stringArray2.length - 1].replace("\"", "");
            return stringArray2;
        }
        return stringArray;
    }

    public static double[] splitStringToArray4d(String string) {
        return Util.splitStringToArray4d(string, 0.0, 0.0, 0.0, 0.0);
    }

    public static float[] splitStringToArray4f(String string) {
        return Util.splitStringToArray4f(string, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static double[] splitStringToArray4d(String string, double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{d, d2, d3, d4};
        if (string != null) {
            string = string.trim();
            String[] stringArray = string.split(splitExpr);
            for (int i = 0; i < 4 && i < stringArray.length; ++i) {
                dArray[i] = Double.valueOf(stringArray[i]);
            }
        }
        return dArray;
    }

    public static float[] splitStringToArray4f(String string, float f, float f2, float f3, float f4) {
        float[] fArray = new float[]{f, f2, f3, f4};
        if (string != null) {
            string = string.trim();
            String[] stringArray = string.split(splitExpr);
            for (int i = 0; i < 4 && i < stringArray.length; ++i) {
                fArray[i] = Float.valueOf(stringArray[i]).floatValue();
            }
        }
        return fArray;
    }

    public static String getRealPath(URL uRL) {
        String string = uRL.getPath();
        int n = 0;
        if (string.startsWith("/")) {
            n = 1;
        }
        int n2 = string.lastIndexOf("/") + 1;
        String string2 = string.substring(n, n2);
        string2 = string2.replace("%20", " ");
        return string2;
    }

    public static String getRealPath(File file) {
        return file.getParent() + File.separator;
    }

    public static Matrix4d vectorsToTransMatrix(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        AxisAngle4d axisAngle4d = null;
        if (vector3d3.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0))) {
            vector3d3 = Util.findOrthogonalVector(vector3d);
            axisAngle4d = new AxisAngle4d(vector3d3, vector3d.angle(vector3d2) + Math.PI);
        } else {
            axisAngle4d = new AxisAngle4d(vector3d3, vector3d.angle(vector3d2));
        }
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setRotation(axisAngle4d);
        return matrix4d;
    }

    public static Vector3d findOrthogonalVector(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(0.0, 0.0, 0.0);
        if (vector3d.x == 0.0 && vector3d.y == 0.0 || vector3d.x == 0.0 && vector3d.z == 0.0) {
            vector3d2.x = 1.0;
        } else if (vector3d.y == 0.0 && vector3d.z == 0.0) {
            vector3d2.y = 1.0;
        } else if (vector3d.x != 0.0) {
            vector3d2.x = -vector3d.x;
            vector3d2.y = vector3d.y;
            vector3d2.z = vector3d.z;
        } else {
            vector3d2.x = vector3d.x;
            vector3d2.y = -vector3d.y;
            vector3d2.z = vector3d.z;
        }
        return vector3d2;
    }

    public static boolean pointsOnLine(ArrayList<Point3d> arrayList) {
        if (arrayList.size() <= 2) {
            return true;
        }
        Vector3d vector3d = new Vector3d(arrayList.get((int)0).x - arrayList.get((int)1).x, arrayList.get((int)0).y - arrayList.get((int)1).y, arrayList.get((int)0).z - arrayList.get((int)1).z);
        vector3d.normalize();
        for (int i = 2; i < arrayList.size(); ++i) {
            Vector3d vector3d2 = new Vector3d(arrayList.get((int)0).x - arrayList.get((int)i).x, arrayList.get((int)0).y - arrayList.get((int)i).y, arrayList.get((int)0).z - arrayList.get((int)i).z);
            vector3d2.normalize();
            if (vector3d2.equals((Tuple3d)vector3d)) continue;
            return false;
        }
        return true;
    }

    public static List<String> splitStringToListOfStrings(String string) {
        string = string.trim();
        String[] stringArray = string.split("\"[, ]+\"");
        stringArray[0] = stringArray[0].replace("\"", "");
        stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1].replace("\"", "");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static RGBColor intToRGB(int n) {
        float f = (float)(n >> 16 & 0xFF) * 0.003921569f;
        float f2 = (float)(n >> 8 & 0xFF) * 0.003921569f;
        float f3 = (float)(n & 0xFF) * 0.003921569f;
        return new RGBColor(f, f2, f3);
    }

    public static float intToGray(int n) {
        float f = (float)(n >> 16 & 0xFF) * 0.003921569f;
        float f2 = (float)(n >> 8 & 0xFF) * 0.003921569f;
        float f3 = (float)(n & 0xFF) * 0.003921569f;
        return (f + f2 + f3) / 3.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageAdapter getImageForURL(String string, boolean bl) {
        FixedImageAdapter fixedImageAdapter = null;
        boolean bl2 = false;
        File file = null;
        URL uRL = null;
        Workbench workbench = Workbench.current();
        try {
            Object object;
            String string2 = string;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.toLowerCase().startsWith("http://")) {
                int n;
                object = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                String string3 = string2.substring(string2.lastIndexOf("."), string2.length());
                file = File.createTempFile((String)object, string3);
                uRL = new URL(string2);
                InputStream inputStream = uRL.openStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[65535];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                fileOutputStream.close();
                uRL = file.toURI().toURL();
                bl2 = true;
            } else {
                if (!string2.startsWith("/") && string2.charAt(1) != ':') {
                    object = X3DImport.getTheImport().getCurrentParser().getFile();
                    string2 = Util.getRealPath((File)object) + string2;
                }
                if ((object = (uRL = (file = new File(string2)).toURI().toURL()).getContent()) == null) {
                    ImageAdapter imageAdapter = null;
                    return imageAdapter;
                }
                bl2 = false;
            }
            if (bl) {
                object = ImageReader.getFactory((RegistryContext)workbench.getRegistry());
                fixedImageAdapter = (FixedImageAdapter)object.addFromURL(workbench.getRegistry(), uRL, null, workbench);
            } else {
                fixedImageAdapter = new FixedImageAdapter(ImageIO.read(uRL));
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bl2 && file != null) {
                file.delete();
            }
        }
        return fixedImageAdapter;
    }

    public static ImageAdapter getImageForURL(List<String> list, HashMap<String, String> hashMap, boolean bl) {
        String string;
        ImageAdapter imageAdapter = null;
        List<String> list2 = null;
        if (hashMap.get("url") != null) {
            string = hashMap.get("url");
            list2 = Util.splitStringToListOfStrings(string);
        } else {
            list2 = list;
            string = list2.toString();
            list2 = Util.splitStringToListOfStrings(string);
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            imageAdapter = Util.getImageForURL(list2.get(i), bl);
            X3DImport.getTheImport().increaseProgress();
        }
        return imageAdapter;
    }

    private static int f2i(float f) {
        int n = Math.round(f * 255.0f);
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    public static int colorToInt(Tuple4f tuple4f) {
        return (Util.f2i(tuple4f.w) << 24) + (Util.f2i(tuple4f.x) << 16) + (Util.f2i(tuple4f.y) << 8) + Util.f2i(tuple4f.z);
    }

    public static int colorToInt(Tuple3f tuple3f) {
        return -16777216 + (Util.f2i(tuple3f.x) << 16) + (Util.f2i(tuple3f.y) << 8) + Util.f2i(tuple3f.z);
    }

    public static int overlapPixel(int n, int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = n >> 16 & 0xFF;
        int n8 = n >> 8 & 0xFF;
        int n9 = n & 0xFF;
        double d = (double)n3 / 255.0;
        n7 = (int)((1.0 - d) * (double)n7 + d * (double)n4);
        n8 = (int)((1.0 - d) * (double)n8 + d * (double)n5);
        n9 = (int)((1.0 - d) * (double)n9 + d * (double)n6);
        return -16777216 + (n7 << 16) + (n8 << 8) + n9;
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }
}

