/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import javax.swing.table.AbstractTableModel;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class TimeSeriesTableModel
extends AbstractTableModel
implements SeriesChangeListener {
    private TimeSeries series;
    private boolean editable;
    private RegularTimePeriod newTimePeriod;
    private Number newValue;

    public TimeSeriesTableModel() {
        this(new TimeSeries("Untitled"));
    }

    public TimeSeriesTableModel(TimeSeries timeSeries) {
        this(timeSeries, false);
    }

    public TimeSeriesTableModel(TimeSeries timeSeries, boolean bl) {
        this.series = timeSeries;
        this.series.addChangeListener(this);
        this.editable = bl;
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        if (n == 1) {
            return Double.class;
        }
        return null;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Period:";
        }
        if (n == 1) {
            return "Value:";
        }
        return null;
    }

    public int getRowCount() {
        return this.series.getItemCount();
    }

    public Object getValueAt(int n, int n2) {
        if (n < this.series.getItemCount()) {
            if (n2 == 0) {
                return this.series.getTimePeriod(n);
            }
            if (n2 == 1) {
                return this.series.getValue(n);
            }
            return null;
        }
        if (n2 == 0) {
            return this.newTimePeriod;
        }
        if (n2 == 1) {
            return this.newValue;
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.editable) {
            return n2 == 0 || n2 == 1;
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < this.series.getItemCount()) {
            if (n2 == 1) {
                try {
                    Double d = Double.valueOf(object.toString());
                    this.series.update(n, (Number)d);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Number format exception");
                }
            }
        } else if (n2 == 0) {
            this.newTimePeriod = null;
        } else if (n2 == 1) {
            this.newValue = Double.valueOf(object.toString());
        }
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.fireTableDataChanged();
    }
}

