/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Month
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -5090216912548722570L;
    private int month;
    private Year year;

    public Month() {
        this(new Date());
    }

    public Month(int n, int n2) {
        this(n, new Year(n2));
    }

    public Month(int n, Year year) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month outside valid range.");
        }
        this.month = n;
        this.year = year;
    }

    public Month(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Month(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.month = calendar.get(2) + 1;
        this.year = new Year(calendar.get(1));
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getMonth() {
        return this.month;
    }

    public RegularTimePeriod previous() {
        Year year;
        Month month = this.month != 1 ? new Month(this.month - 1, this.year) : ((year = (Year)this.year.previous()) != null ? new Month(12, year) : null);
        return month;
    }

    public RegularTimePeriod next() {
        Year year;
        Month month = this.month != 12 ? new Month(this.month + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Month(1, year) : null);
        return month;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 12L + (long)this.month;
    }

    public String toString() {
        return SerialDate.monthCodeToString(this.month) + " " + this.year;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Month) {
                Month month = (Month)object;
                return this.month == month.getMonth() && this.year.equals(month.getYear());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.month;
        n = 37 * n + this.year.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Month) {
            Month month = (Month)object;
            n = this.year.getYear() - month.getYear().getYear();
            if (n == 0) {
                n = this.month - month.getMonth();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getFirstMillisecond(Calendar calendar) {
        Day day = new Day(1, this.month, this.year.getYear());
        return day.getFirstMillisecond(calendar);
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = SerialDate.lastDayOfMonth(this.month, this.year.getYear());
        Day day = new Day(n, this.month, this.year.getYear());
        return day.getLastMillisecond(calendar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Month parseMonth(String string) {
        Month month = null;
        if (string == null) return month;
        int n = Month.findSeparator(string = string.trim());
        if (n == -1) throw new TimePeriodFormatException("Could not find separator.");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, string.length()).trim();
        Year year = Month.evaluateAsYear(string2);
        if (year != null) {
            int n2 = SerialDate.stringToMonthCode(string3);
            if (n2 != -1) return new Month(n2, year);
            throw new TimePeriodFormatException("Can't evaluate the month.");
        }
        year = Month.evaluateAsYear(string3);
        if (year == null) throw new TimePeriodFormatException("Can't evaluate the year.");
        int n3 = SerialDate.stringToMonthCode(string2);
        if (n3 != -1) return new Month(n3, year);
        throw new TimePeriodFormatException("Can't evaluate the month.");
    }

    private static int findSeparator(String string) {
        int n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(46);
        }
        return n;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return year;
    }
}

