/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.tree;

import de.grogra.pf.ui.Synchronizer;
import de.grogra.xl.util.ObjectList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SyncMappedList
implements Synchronizer.Callback,
ListDataListener,
ListModel {
    protected final Synchronizer sync;
    protected final ListModel source;
    private ObjectList listeners = new ObjectList();
    private ObjectList syncData = new ObjectList();

    public SyncMappedList(ListModel listModel, Synchronizer synchronizer) {
        this.sync = synchronizer;
        this.source = listModel;
        synchronizer.initCallback(this);
        this.copy();
    }

    private void copy() {
        this.syncData.clear();
        for (int i = 0; i < this.source.getSize(); ++i) {
            this.syncData.add(this.source.getElementAt(i));
        }
    }

    protected synchronized void fireContentsChanged(int n, int n2) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n2);
        for (int i = this.listeners.size - 1; i >= 0; --i) {
            ((ListDataListener)this.listeners.get(i)).contentsChanged(listDataEvent);
        }
    }

    public Object run(int n, int n2, Object object, Object object2) {
        this.copy();
        this.fireContentsChanged(n2 >= 0 ? 0 : -1, n2 >= 0 ? this.syncData.size - 1 : -1);
        return null;
    }

    public synchronized void addListDataListener(ListDataListener listDataListener) {
        boolean bl = this.listeners.size == 0;
        this.listeners.add((Object)listDataListener);
        if (bl) {
            this.source.addListDataListener(this);
        }
    }

    public synchronized void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove((Object)listDataListener);
        if (this.listeners.size == 0) {
            this.source.removeListDataListener(this);
        }
    }

    public int getSize() {
        return this.syncData.size;
    }

    public Object getElementAt(int n) {
        return this.syncData.get(n);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.sync.invokeAndWait(0, listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.sync.invokeAndWait(0, listDataEvent);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.sync.invokeAndWait(0, listDataEvent);
    }
}

