/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.registry;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.icon.IconSource;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.ResourceLoader;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.UIItem;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.lang.ObjectToBoolean;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class SourceFile
extends Item
implements UIItem,
ObjectToBoolean,
TreeModelListener,
Showable {
    protected MimeType mimeType;
    protected boolean editable = true;
    protected boolean disabled = false;
    protected transient String deactivationCategory;
    protected transient int activationStamp = -1;
    public static final Node.NType $TYPE = new Node.NType((Node)new SourceFile());
    public static final Node.NType.Field mimeType$FIELD = new _Field("mimeType", 0x200000, (Type)ClassAdapter.wrap(MimeType.class), null, 0);
    public static final Node.NType.Field editable$FIELD;
    public static final Node.NType.Field disabled$FIELD;

    public int getActivationStamp() {
        return this.activationStamp;
    }

    public void setActivationStamp(int n) {
        this.activationStamp = n;
    }

    private SourceFile() {
        this(null, null);
    }

    public SourceFile(String string, MimeType mimeType) {
        super(string);
        this.mimeType = mimeType;
    }

    public FileSource toFileSource() {
        return FileSource.createFileSource((String)this.getName(), (MimeType)this.mimeType, (RegistryContext)this, (ModifiableMap)new StringMap((Map)this));
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public MimeTypeItem getMimeTypeItem() {
        return MimeTypeItem.get((RegistryContext)this, (MimeType)this.mimeType);
    }

    private void reinstantiateMTG() {
        Node node = this.getRegistry().getProjectGraph().getRoot();
        if (node != null) {
            this.reinstantiateMTGInternal(node);
        }
    }

    private boolean isObsoleteInstance(Node node) {
        if (this.isMTGNode(node)) {
            Item item = this.getRegistry().getItem("/classes");
            for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
                Type type = (Type)((TypeItem)item2).getObject();
                if (!node.getNType().getName().equals(type.getName())) continue;
                return !type.isInstance((Object)node);
            }
        }
        return false;
    }

    private boolean isMTGNode(Node node) {
        Node.NType nType = node.getNType();
        if (nType != null) {
            return nType.getName().contains("mtg_");
        }
        return false;
    }

    private Type getNewType(Node node) {
        Item item = this.getRegistry().getItem("/classes");
        for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
            Type type = (Type)((TypeItem)item2).getObject();
            if (!node.getNType().getName().equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    public static void copyNodeFields(Node node, Node node2) {
        int n;
        String string;
        Method method;
        int n2;
        Node.NType nType = node.getNType();
        Node.NType nType2 = node2.getNType();
        int n3 = nType.getDeclaredMethodCount();
        int n4 = nType2.getDeclaredMethodCount();
        for (n2 = 0; n2 < n3; ++n2) {
            method = nType.getDeclaredMethod(n2);
            if (!method.getName().startsWith("get")) continue;
            string = method.getName();
            string = string.substring(3);
            for (n = 0; n < n4; ++n) {
                Method method2 = nType2.getDeclaredMethod(n);
                if (!method2.getName().equals("set" + string)) continue;
                Object[] objectArray = new Object[]{};
                Object[] objectArray2 = new Object[1];
                try {
                    objectArray2[0] = method.invoke((Object)node, objectArray);
                    method2.invoke((Object)node2, objectArray2);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        try {
            for (n2 = 0; n2 < nType2.getManagedFieldCount(); ++n2) {
                method = nType2.getManagedField(n2);
                if (!SourceFile.isStandardAttribute(method.getName())) continue;
                string = null;
                for (n = 0; n < nType.getManagedFieldCount(); ++n) {
                    string = nType.getManagedField(n);
                    if (!string.getName().equals(method.getName())) continue;
                    if (SourceFile.isStandardAttributeDouble(string.getName())) {
                        method.setDouble((Object)node2, string.getDouble((Object)node));
                    }
                    if (SourceFile.isStandardAttributeInt(string.getName())) {
                        method.setInt((Object)node2, string.getInt((Object)node));
                    }
                    if (!SourceFile.isStandardAttributeObject(string.getName())) continue;
                    method.setObject((Object)node2, string.getObject((Object)node));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static boolean isStandardAttribute(String string) {
        if (string == null) {
            return false;
        }
        return SourceFile.isStandardAttributeDouble(string) || SourceFile.isStandardAttributeInt(string) || SourceFile.isStandardAttributeObject(string);
    }

    private static boolean isStandardAttributeDouble(String string) {
        return string.equals("L1") || string.equals("L2") || string.equals("L3") || string.equals("DAB") || string.equals("DAC") || string.equals("DBC") || string.equals("XX") || string.equals("YY") || string.equals("ZZ") || string.equals("Length") || string.equals("Azimut") || string.equals("Alpha") || string.equals("AA") || string.equals("BB") || string.equals("CC") || string.equals("TopDia") || string.equals("BotDia") || string.equals("Position");
    }

    private static boolean isStandardAttributeInt(String string) {
        return string.equals("Category") || string.equals("Order") || string.equals("mtgClassID") || string.equals("mtgID") || string.equals("mtgScale") || string.equals("stdAttFlag");
    }

    private static boolean isStandardAttributeObject(String string) {
        return string.equals("DirectionPrimary") || string.equals("mtgClass");
    }

    private void reinstantiateMTGInternal(Node node) {
        Node node2;
        Edge edge;
        ArrayList<Node> arrayList;
        boolean bl = this.isObsoleteInstance(node);
        Node node3 = null;
        if (bl) {
            Edge edge2;
            arrayList = new ArrayList<Node>();
            edge = new ArrayList();
            node2 = new ArrayList();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (edge2 = node.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node)) {
                if (edge2.getTarget() == node) {
                    edge.add(new Integer(edge2.getEdgeBits()));
                    arrayList.add(edge2.getSource());
                }
                if (edge2.getSource() != node) continue;
                arrayList2.add(new Integer(edge2.getEdgeBits()));
                node2.add(edge2.getTarget());
            }
            edge2 = this.getNewType(node);
            try {
                node3 = (Node)edge2.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (node3 != null) {
                int n;
                SourceFile.copyNodeFields(node, node3);
                for (n = 0; n < arrayList.size(); ++n) {
                    ((Node)arrayList.get(n)).addEdgeBitsTo(node3, ((Integer)edge.get(n)).intValue(), null);
                }
                for (n = 0; n < node2.size(); ++n) {
                    node3.addEdgeBitsTo((Node)node2.get(n), ((Integer)arrayList2.get(n)).intValue(), null);
                }
                for (Edge edge3 = node.getFirstEdge(); edge3 != null; edge3 = edge3.getNext(node)) {
                    if (edge3.getSource() == node) {
                        node.removeEdgeBitsTo(edge3.getTarget(), edge3.getEdgeBits(), null);
                        continue;
                    }
                    if (edge3.getTarget() != node) continue;
                    edge3.getSource().removeEdgeBitsTo(node, edge3.getEdgeBits(), null);
                }
            }
        } else {
            node3 = node;
        }
        arrayList = new ArrayList();
        for (edge = node3.getFirstEdge(); edge != null; edge = edge.getNext(node3)) {
            if (edge.getSource() != node3) continue;
            arrayList.add(edge.getTarget());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            node2 = (Node)arrayList.get(i);
            if (this.isMTGNode(node2)) {
                if (!this.isObsoleteInstance(node2)) continue;
                this.reinstantiateMTGInternal(node2);
                continue;
            }
            this.reinstantiateMTGInternal(node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateImpl() {
        FileSource fileSource;
        FilterSource filterSource;
        if (this.disabled) {
            this.activationStamp = -1;
            return;
        }
        Object object = this.getRegistry().getProjectFile(this.getName());
        if (object != null) {
            this.getRegistry().addFileSystemListener((TreeModelListener)this);
            this.getRegistry().getFileSystem().setMimeType(object, this.mimeType);
        }
        if (!((filterSource = IO.createPipeline((FilterSource)(fileSource = this.toFileSource()), (IOFlavor)IOFlavor.RESOURCE_LOADER)) instanceof ObjectSource)) {
            return;
        }
        filterSource.initProgressMonitor(UI.createProgressAdapter(Workbench.get((RegistryContext)this)));
        try {
            final ResourceLoader resourceLoader = (ResourceLoader)((ObjectSource)filterSource).getObject();
            this.deactivationCategory = resourceLoader.getJoinedDeactivationCategory();
            if (this.activationStamp != this.getRegistry().getActivationStamp()) {
                this.activationStamp = this.getRegistry().getActivationStamp();
                ((Item)this.getAxisParent()).forAll(null, null, new ItemVisitor(){

                    public void visit(Item item, Object object) {
                        if (!item.isActivated() && item instanceof SourceFile && !((SourceFile)item).disabled && ((SourceFile)item).activationStamp != SourceFile.this.activationStamp && resourceLoader.addResource((FilterSource)((SourceFile)item).toFileSource())) {
                            ((SourceFile)item).activationStamp = SourceFile.this.activationStamp;
                        }
                    }
                }, null, false);
                resourceLoader.loadResource(this.getRegistry());
                if (this.getName().contains("generated.xl")) {
                    this.reinstantiateMTG();
                }
            }
        }
        catch (Exception exception) {
            Workbench.get((RegistryContext)this).logGUIInfo(IO.I18N.msg("openfile.failed", (Object)fileSource.getSystemId()), exception);
        }
        finally {
            filterSource.setProgress(null, 2.0f);
        }
    }

    protected void deactivateImpl() {
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
    }

    protected Object getDescriptionImpl(String string) {
        if ("Name".equals(string)) {
            return IO.toPath((String)this.getName());
        }
        Object object = super.getDescriptionImpl(string);
        return "Icon".equals(string) ? UI.getIcon(this.getName(), this.mimeType.getMediaType(), (IconSource)object, (RegistryContext)this, true) : object;
    }

    public Object invoke(Context context, String string, Object object) {
        return null;
    }

    public void show(Context context) {
        this.show(context, null);
    }

    public void show(Context context, String string) {
        MimeTypeItem mimeTypeItem = this.getMimeTypeItem();
        if (mimeTypeItem != null) {
            if (this.editable && mimeTypeItem.isEditable()) {
                TextEditor textEditor;
                Panel[] panelArray = context.getWindow().getPanels(this);
                for (int i = 0; i < panelArray.length; ++i) {
                    textEditor = (TextEditor)panelArray[i];
                    if (!Utils.isContained((Object)this.getName(), (Object[])textEditor.getDocuments())) continue;
                    textEditor.openDocument(this.getName(), string);
                    textEditor.show(false, null);
                    return;
                }
                textEditor = panelArray.length > 0 ? (TextEditor)panelArray[0] : (TextEditor)PanelFactory.createPanel(context, "/ui/panels/texteditor", null);
                textEditor.openDocument(this.getName(), string);
                textEditor.show(false, null);
            } else if (mimeTypeItem.isViewable()) {
                context.getWorkbench().showViewerPanel(this.getName(), this.getName(), (Map)this);
            }
        }
    }

    public void showLater(Context context) {
        UI.getJobManager(context).runLater(new Command(){

            public void run(Object object, Context context) {
                SourceFile.this.show(context, null);
            }

            public String getCommandName() {
                return null;
            }
        }, null, context, 10000);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean isEnabled(Context context) {
        return true;
    }

    public int getUINodeType() {
        return 8;
    }

    public boolean evaluateBoolean(Object object) {
        return object instanceof TextEditor;
    }

    public void addRequiredFiles(Collection collection) {
        Object object = this.getRegistry().getProjectFile(this.getName());
        if (object != null) {
            collection.add(object);
        }
    }

    public static SourceFile get(RegistryContext registryContext, String string) {
        Item item = registryContext.getRegistry().getItem("/project/objects/files");
        return item != null ? (SourceFile)item.getItem((CharSequence)string) : null;
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (FileSystem.isContainedInChildren((Object)this.getRegistry().getProjectFile(this.getName()), (TreeModelEvent)treeModelEvent)) {
            SourceFile.refresh((Item)this.getAxisParent(), this, this.deactivationCategory, new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object object, Context context) {
                    if (Utils.getBoolean((Map)UI.getOptions(context), (Object)"saveProjectOnFileModification")) {
                        context.getWorkbench().save(false);
                    }
                }
            });
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public static void refresh(final Item item, final SourceFile sourceFile, final String string, final Command command) {
        Workbench workbench = Workbench.get((RegistryContext)item);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Deactivator
        extends LockProtectedCommand
        implements ItemVisitor {
            Deactivator(Workbench workbench) {
                super((Lockable)workbench.getRegistry().getProjectGraph(), true, 10000);
            }

            @Override
            public String getCommandName() {
                return null;
            }

            @Override
            protected void runImpl(Object object, Context context, Lock lock) {
                item.forAll(null, null, (ItemVisitor)this, null, false);
                item.getRegistry().activateItems();
                if (command != null) {
                    UI.getJobManager(context).runLater(command, object, context, 70536);
                }
            }

            public void visit(Item item2, Object object) {
                if (!item2.isActivated() || !(item2 instanceof SourceFile)) {
                    return;
                }
                if (item2 == sourceFile || ((SourceFile)item2).activationStamp == -1 || string != null && item2 instanceof SourceFile && string.equals(((SourceFile)item2).deactivationCategory)) {
                    item2.deactivate();
                }
            }
        }
        workbench.getJobManager().runLater(new Deactivator(workbench), null, workbench, 10000);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new SourceFile();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mimeType$FIELD);
        editable$FIELD = new _Field("editable", 0x200000, Type.BOOLEAN, null, 1);
        $TYPE.addManagedField((ManageableType.Field)editable$FIELD);
        disabled$FIELD = new _Field("disabled", 0x200000, Type.BOOLEAN, null, 2);
        $TYPE.addManagedField((ManageableType.Field)disabled$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 1: {
                    ((SourceFile)object).editable = bl;
                    return;
                }
                case 2: {
                    ((SourceFile)object).disabled = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 1: {
                    return ((SourceFile)object).isEditable();
                }
                case 2: {
                    return ((SourceFile)object).isDisabled();
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((SourceFile)object).mimeType = (MimeType)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((SourceFile)object).mimeType;
                }
            }
            return super.getObject(object);
        }
    }

    public static class Loader
    extends FilterBase
    implements ObjectSource,
    ProjectLoader {
        public Loader(FilterItem filterItem, FilterSource filterSource) {
            super(filterItem, filterSource);
            this.setFlavor(IOFlavor.PROJECT_LOADER);
        }

        public Object getObject() {
            return this;
        }

        public void loadRegistry(Registry registry) {
            File file = ((FileSource)this.source).getInputFile();
            registry.initFileSystem((FileSystem)new LocalFileSystem("pfs", file.getParentFile()));
            SourceFile sourceFile = new SourceFile(IO.toSystemId((FileSystem)registry.getFileSystem(), (Object)file), IO.getRoot((FilterSource)this.source).getFlavor().getMimeType());
            registry.getDirectory("/project/objects/files", null).addUserItem((Item)sourceFile);
            Workbench workbench = Workbench.get((RegistryContext)registry);
            if (workbench != null) {
                Item item = this.item.getItem((CharSequence)"layout");
                if (item != null) {
                    item = item.resolveLink((RegistryContext)registry);
                }
                if (item != null) {
                    workbench.setProperty("initial-layout", item.getAbsoluteName());
                    sourceFile.showLater(workbench);
                }
            }
        }

        public void loadGraph(Registry registry) {
            registry.setEmptyGraph();
        }
    }
}

