/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.util.Disposable;
import de.grogra.util.DisposableWrapper;
import de.grogra.util.EventListener;
import de.grogra.util.Map;
import java.util.EventObject;

public class PropertyEditorManager
implements Disposable,
EventListener {
    private boolean disposed = false;
    private Panel panel;

    public PropertyEditorManager(Panel panel, boolean bl) {
        this.panel = panel;
        UIProperty.WORKBENCH_SELECTION.addPropertyListener(panel, this);
    }

    public void eventOccured(EventObject eventObject) {
        Object object = ((UIPropertyEditEvent)eventObject).getNewValue();
        if (object == null || object instanceof Selection) {
            this.setSelection((Selection)object);
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        UIProperty.WORKBENCH_SELECTION.removePropertyListener(this.panel, this);
        this.disposed = true;
        this.setSelection(null);
    }

    private void setSelection(Selection selection) {
        this.panel.setContent(null);
        if (selection != null && this.setSelection0(selection)) {
            this.panel.show(false, selection.getContext().getPanel());
        }
    }

    private boolean setSelection0(Selection selection) {
        ComponentWrapper componentWrapper = selection.createPropertyEditorComponent();
        if (componentWrapper == null) {
            return false;
        }
        this.panel.setContent(componentWrapper);
        return true;
    }

    public static Panel createEditor(Context context, Map map) {
        DisposableWrapper disposableWrapper = new DisposableWrapper();
        Panel panel = UIToolkit.get(context).createPanel(context, (Disposable)disposableWrapper, map);
        PropertyEditorManager propertyEditorManager = new PropertyEditorManager(panel, true);
        Object object = UIProperty.WORKBENCH_SELECTION.getValue(panel);
        if (object instanceof Selection) {
            propertyEditorManager.setSelection0((Selection)object);
        }
        disposableWrapper.disposable = propertyEditorManager;
        return panel;
    }
}

