/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.LogStore;
import de.grogra.persistence.Transaction;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.Value;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.edit.GraphSelectionImpl;
import de.grogra.pf.ui.edit.MapSource;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.registry.Layout;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.pf.ui.tree.RegistryAdapter;
import de.grogra.pf.ui.tree.TableMapper;
import de.grogra.pf.ui.tree.UISubTree;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.util.Configurable;
import de.grogra.util.ConfigurationSet;
import de.grogra.util.DescribedLevel;
import de.grogra.util.DetailedException;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.MimeTypeFileFilter;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.ThreadContext;
import de.grogra.util.UserException;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.vfs.FileSystem;
import de.grogra.xl.util.ObjectList;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public abstract class Workbench
implements Context,
RegistryContext,
ClipboardOwner {
    public static final Timer TIMER = new Timer(true);
    public static final String CURRENT_DIRECTORY = "current-dir";
    public static final String[] LAST_FILES = new String[]{"last-file-01", "last-file-02", "last-file-03", "last-file-04", "last-file-05", "last-file-06", "last-file-07", "last-file-08", "last-file-09", "last-file-10"};
    public static final String START_AS_DEMO = "start-as-demo";
    public static final String INITIAL_LAYOUT = "initial-layout";
    public static final Level SOFT_GUI_INFO = new DescribedLevel(UI.I18N, "log.guiinfo", 850);
    public static final Level GUI_INFO = new DescribedLevel(UI.I18N, "log.guiinfo", 870);
    final HashMap propertyMap = new HashMap();
    private static final int CURRENT = ThreadContext.registerProperty();
    private static final int REG_ID = Registry.allocatePropertyId();
    private static final HashSet PREFERENCES_PROPERTIES = new HashSet();
    private final Registry registry;
    private final JobManager jm;
    private final UIToolkit ui;
    private final StringMap props;
    private String name;
    private boolean modified;
    private boolean ignoreIfModified;
    private File file;
    private MimeType mimeType;
    private final Object statusLock = new Object();
    private Object statusOwner;
    private String status;
    private Float progress;
    private PropertyChangeSupport statusListeners = new PropertyChangeSupport(this);

    public Workbench(Registry registry, JobManager jobManager, UIToolkit uIToolkit, Map map) {
        this.props = new StringMap(map);
        this.registry = registry;
        registry.setUserProperty(REG_ID, (Object)this);
        this.jm = jobManager;
        this.ui = uIToolkit;
        class Helper
        extends Handler
        implements Command {
            private final ObjectList logRecords = new ObjectList();
            private final ObjectList newGUIRecords = new ObjectList();

            Helper() {
                this.setLevel(GUI_INFO);
            }

            public void close() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() {
                ObjectList objectList = this.logRecords;
                synchronized (objectList) {
                    LogRecord logRecord;
                    long l = System.currentTimeMillis() - 60000L;
                    while (this.logRecords.size > 10 && (logRecord = (LogRecord)this.logRecords.get(0)).getMillis() < l) {
                        Throwable throwable = Utils.getMainException((Throwable)logRecord.getThrown());
                        if (throwable instanceof DetailedException) {
                            ((DetailedException)throwable).dispose();
                        }
                        this.logRecords.remove(0);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Object object, Context context) {
                ObjectList objectList = this.newGUIRecords;
                synchronized (objectList) {
                    try {
                        LogRecord[][] logRecordArray = new LogRecord[1][this.newGUIRecords.size];
                        this.newGUIRecords.toArray(logRecordArray[0]);
                        PanelFactory.getAndShowPanel(context, "/ui/panels/log", (Map)new StringMap().putObject("logrecords", (Object)logRecordArray));
                    }
                    catch (RuntimeException runtimeException) {
                        this.getErrorManager().error("Error while checking log viewer", runtimeException, 0);
                    }
                    this.newGUIRecords.clear();
                }
            }

            public String getCommandName() {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void publish(LogRecord logRecord) {
                ObjectList objectList = this.logRecords;
                synchronized (objectList) {
                    this.logRecords.add((Object)logRecord);
                }
                objectList = this.newGUIRecords;
                synchronized (objectList) {
                    if (logRecord.getLevel().intValue() >= GUI_INFO.intValue()) {
                        this.newGUIRecords.add((Object)logRecord);
                        if (this.newGUIRecords.size == 1) {
                            Workbench.this.getJobManager().runLater(this, null, Workbench.this, 70536);
                        }
                    }
                }
            }
        }
        this.getLogger().addHandler(new Helper());
        class Notifier
        extends LockProtectedCommand
        implements Runnable {
            private final GraphManager graph;

            Notifier(GraphManager graphManager) {
                super((Lockable)graphManager, false, 10000);
                this.graph = graphManager;
                graphManager.initNonlocalTransactionNotifier((Runnable)this);
            }

            protected void runImpl(Object object, Context context, Lock lock) {
                Transaction transaction = this.graph.getTransaction(true);
                transaction.begin(true);
                transaction.commit();
            }

            public void run() {
                Workbench.this.getJobManager().runLater(this, null, Workbench.this, 10000);
            }
        }
        new Notifier(registry.getProjectGraph());
    }

    public static Workbench current() {
        return Workbench.current(ThreadContext.current());
    }

    public static Workbench get(RegistryContext registryContext) {
        Object object = registryContext.getRegistry().getUserProperty(REG_ID);
        return object != null ? (Workbench)object : Workbench.current();
    }

    public static Workbench current(ThreadContext threadContext) {
        return (Workbench)threadContext.getProperty(CURRENT);
    }

    public static void setCurrent(Workbench workbench) {
        ThreadContext.current().setProperty(CURRENT, (Object)workbench);
        Registry.setCurrent((RegistryContext)workbench);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsCurrent(Runnable runnable) {
        ThreadContext threadContext = ThreadContext.current();
        Workbench workbench = Workbench.current(threadContext);
        Registry registry = Registry.current();
        try {
            threadContext.setProperty(CURRENT, (Object)this);
            Registry.setCurrent((RegistryContext)this);
            runnable.run();
        }
        finally {
            threadContext.setProperty(CURRENT, (Object)workbench);
            Registry.setCurrent((RegistryContext)registry);
        }
    }

    public boolean isWorkbenchThread() {
        return Thread.currentThread() == this.jm.getMainThread();
    }

    protected void initializeWindow(Window window) {
        if (window == null) {
            return;
        }
        window.initializeWorkbench(this);
        UI.setMenu(window, this.getRegistry().getItem("/workbench/menu"), null);
        Workbench.refreshLastUsed(this.getRegistry(), this.getMainWorkbench());
        Item item = this.getRegistry().getItem("/workbench/state/layout");
        if (item instanceof Layout) {
            window.setLayout((Layout)item, (Map)this.props);
        } else {
            String string = (String)this.props.get(INITIAL_LAYOUT);
            if (string != null) {
                item = Item.resolveItem((RegistryContext)this, (String)string);
                string = null;
                if (item instanceof Layout) {
                    window.setLayout((Layout)item, (Map)this.props);
                    return;
                }
            }
            if ((item = this.getRegistry().getItem("/workbench/layouts")) != null && (item = (Item)item.getBranch()) != null && (item = item.resolveLink((RegistryContext)this)) instanceof Layout) {
                window.setLayout((Layout)item, (Map)this.props);
            }
        }
    }

    public abstract Workbench getMainWorkbench();

    public final Logger getLogger() {
        return this.registry.getLogger();
    }

    public final Registry getRegistry() {
        return this.registry;
    }

    public final JobManager getJobManager() {
        return this.jm;
    }

    public final UIToolkit getToolkit() {
        return this.ui;
    }

    public final Workbench getWorkbench() {
        return this;
    }

    public final Panel getPanel() {
        return this.getWindow() != null ? this.getWindow().getPanel() : null;
    }

    public final Object getComponent() {
        return this.getWindow() != null ? this.getWindow().getComponent() : null;
    }

    public boolean isHeadless() {
        return this.getWindow() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        HashSet hashSet = PREFERENCES_PROPERTIES;
        synchronized (hashSet) {
            this.props.put(string, object);
            if (PREFERENCES_PROPERTIES.contains(string)) {
                Preferences preferences = Preferences.userRoot().node("/de/grogra/workbench");
                preferences.put(string, String.valueOf(object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        HashSet hashSet = PREFERENCES_PROPERTIES;
        synchronized (hashSet) {
            if (this.props.containsKey(string)) {
                return this.props.get(string);
            }
            if (this.getMainWorkbench().props.containsKey(string)) {
                return this.getMainWorkbench().props.get(string);
            }
            if (PREFERENCES_PROPERTIES.contains(string)) {
                Preferences preferences = Preferences.userRoot().node("/de/grogra/workbench");
                String string2 = preferences.get(string, null);
                this.getMainWorkbench().props.put(string, (Object)string2);
                return string2;
            }
            return null;
        }
    }

    public void setName(String string) {
        this.getRegistry().setProjectName(string);
        this.name = string;
        this.updateName();
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public final void setModified() {
        this.setModified(true);
    }

    public final boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean bl) {
        if (!this.ignoreIfModified && bl != this.modified) {
            this.modified = bl;
            this.updateName();
        }
    }

    protected void updateName() {
        String string = (String)Main.getApplication().getDescription("Name");
        string = this.name == null ? UI.I18N.msg("title.noprojectname", (Object)string) : (this.modified ? UI.I18N.msg("title.projectname.modified", (Object)string, (Object)this.name) : UI.I18N.msg("title.projectname.unmodified", (Object)string, (Object)this.name));
        ModifiableMap modifiableMap = UI.getOptions(this);
        if (Utils.getBoolean((Map)modifiableMap, (Object)"showHostname", (boolean)false)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string2 = inetAddress.getHostName();
                string = string + " [" + string2 + "]";
            }
            catch (UnknownHostException unknownHostException) {
                string = string + " [unknown]";
            }
        }
        UIProperty.WORKBENCH_TITLE.setValue(this, string);
    }

    public void undo() {
        final boolean[] blArray = new boolean[1];
        UI.executeLockedly((Lockable)this.getRegistry().getProjectGraph(), true, new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                GraphManager graphManager = Workbench.this.getRegistry().getProjectGraph();
                try {
                    blArray[0] = graphManager.undo(graphManager.getActiveTransaction());
                }
                catch (IOException iOException) {
                    throw new WrapException((Throwable)iOException);
                }
            }
        }, null, this, 10000);
        if (blArray[0]) {
            LogStore logStore = this.getRegistry().getProjectGraph().getLog();
            logStore.removeLast(2);
        }
    }

    public boolean save(boolean bl) {
        if (this.file == null) {
            return bl && this.saveAs();
        }
        if (this.save(this.file, this.mimeType)) {
            this.setModified(false);
            return true;
        }
        return false;
    }

    public boolean saveAs() {
        FileChooserResult fileChooserResult = this.chooseFileToSave(UI.I18N.getString("filedialog.saveproject", "Save Project"), IOFlavor.REGISTRY, null);
        if (fileChooserResult != null && this.save(fileChooserResult.file, fileChooserResult.getMimeType())) {
            this.ignoreIfModified = false;
            this.setModified(false);
            this.setName(IO.toSimpleName((String)fileChooserResult.file.getName()));
            this.file = fileChooserResult.file;
            this.mimeType = fileChooserResult.getMimeType();
            return true;
        }
        return false;
    }

    public abstract Workbench open(FilterSource var1, Map var2);

    public static void save(Item item, Object object, Context context) {
        context.getWorkbench().save(true);
    }

    public static void undo(Item item, Object object, Context context) {
        context.getWorkbench().undo();
    }

    public static void saveAs(Item item, Object object, Context context) {
        context.getWorkbench().saveAs();
    }

    public static void open(Item item, Object object, Context context) {
        Workbench workbench = context.getWorkbench();
        FileChooserResult fileChooserResult = workbench.chooseFileToOpen(UI.I18N.getString("filedialog.openproject", "Open Project"), IOFlavor.PROJECT_LOADER);
        if (fileChooserResult != null) {
            FileSource fileSource = fileChooserResult.createFileSource(workbench.getRegistry(), null);
            workbench.open((FilterSource)fileSource, null);
            Workbench.addToLastUsed(workbench, fileChooserResult.file);
        }
    }

    public static void openRecent(Item item, Object object, Context context) {
        Workbench workbench = context.getWorkbench();
        ActionEditEvent actionEditEvent = (ActionEditEvent)object;
        String string = (String)((Value)actionEditEvent.getSource()).getObject();
        FileSource fileSource = FileSource.createFileSource((String)string, (MimeType)IO.getMimeType((String)string), (RegistryContext)context.getWorkbench(), null);
        workbench.open((FilterSource)fileSource, null);
        Workbench.addToLastUsed(workbench, fileSource.getInputFile());
    }

    public static void openAsDemo(Item item, Object object, Context context) {
        Object object2;
        Object object3;
        if (object instanceof URL) {
            object3 = ((URL)object).toString();
            if (((String)object3).contains("Examples.gs")) {
                object2 = context.getWorkbench().getRegistry().getPluginDescriptor("de.grogra.examples").getI18NBundle().getString("examplesFile.Name");
                object3 = ((String)object3).replaceAll("Examples.gs", (String)object2);
            }
            try {
                object = Utils.urlToFile((URL)new URL((String)object3)).getAbsolutePath();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else if (object instanceof File) {
            object = ((File)object).getAbsolutePath();
        }
        object3 = context.getWorkbench();
        object2 = new StringMap().putBoolean(START_AS_DEMO, true);
        FileSource fileSource = FileSource.createFileSource((String)((String)object), (MimeType)IO.getMimeType((String)((String)object)), (RegistryContext)context.getWorkbench(), null);
        ((Workbench)object3).open((FilterSource)fileSource, (Map)object2);
        Workbench.addToLastUsed((Workbench)object3, fileSource.getInputFile());
    }

    public static void addToLastUsed(Workbench workbench, File file) {
        Workbench workbench2 = workbench.getMainWorkbench();
        String string = file.getAbsolutePath();
        Object object = string;
        for (int i = 0; i < 10; ++i) {
            Object object2 = workbench2.getProperty(LAST_FILES[i]);
            if (object2 == null || object2.equals(string)) {
                workbench2.setProperty(LAST_FILES[i], object);
                return;
            }
            workbench2.setProperty(LAST_FILES[i], object);
            object = object2;
        }
    }

    public static void refreshLastUsed(Registry registry, Workbench workbench) {
        for (int i = 0; i < 10; ++i) {
            Item item = registry.getItem("/workbench/menu/src/file/openclose/openrecent");
            String string = (String)workbench.getProperty(LAST_FILES[i]);
            if (string == null) break;
            Value value = new Value(i + 1 + ": " + string, (Object)string);
            item.add((Item)value);
        }
    }

    public void ignoreIfModified() {
        this.ignoreIfModified = true;
    }

    public void setFile(File file, MimeType mimeType) {
        if (file != null && mimeType != null && IOFlavor.REGISTRY.isWritableTo(new IOFlavor(mimeType, 64, null))) {
            this.file = file;
            this.mimeType = mimeType;
        } else {
            this.file = null;
            this.mimeType = null;
        }
    }

    private boolean save(File file, MimeType mimeType) {
        FilterSource filterSource = IO.createPipeline((FilterSource)new ObjectSourceImpl((Object)this.getRegistry(), "registry", IOFlavor.REGISTRY, this.getRegistry(), null), (IOFlavor)new IOFlavor(mimeType, 64, null));
        if (filterSource == null) {
            this.logGUIInfo(IO.I18N.msg("save.unsupported", (Object)file, (Object)IO.getDescription((MimeType)mimeType)));
            return false;
        }
        try {
            Directory directory = new Directory("state");
            this.getState((Item)directory);
            Item item = (Item)directory.getBranch();
            if (item != null) {
                directory.makeUserItem(true);
                directory.setBranch(null);
                directory = this.getRegistry().getDirectory("/workbench/state", null);
                directory.setBranch((Node)item);
            }
            ((FileWriterSource)filterSource).write(file);
            Workbench.addToLastUsed(Workbench.current(), file);
            return true;
        }
        catch (IOException iOException) {
            this.logGUIInfo(IO.I18N.msg("saveproject.failed", (Object)this.file), iOException);
            return false;
        }
    }

    public void export(FilterSource filterSource) {
        FileChooserResult fileChooserResult = this.chooseFileToSave("Export", filterSource.getFlavor(), null);
        if (fileChooserResult != null) {
            this.export(filterSource, fileChooserResult.getMimeType(), fileChooserResult.file);
        }
    }

    public void export(FilterSource filterSource, MimeType mimeType, File file) {
        FilterSource filterSource2 = IO.createPipeline((FilterSource)filterSource, (IOFlavor)new IOFlavor(mimeType, 64, null));
        if (filterSource2 == null) {
            this.logGUIInfo(IO.I18N.msg("save.unsupported", (Object)file, (Object)IO.getDescription((MimeType)mimeType)));
            return;
        }
        try {
            filterSource2.setMetaData(FilterSource.DESTINATION_FILE, (Object)file);
            filterSource2.setMetaData(FilterSource.DESTINATION_URL, (Object)Utils.fileToURL((File)file));
            ((FileWriterSource)filterSource2).write(file);
        }
        catch (IOException iOException) {
            this.logGUIInfo(IO.I18N.msg("saveproject.failed", (Object)file), iOException);
        }
    }

    protected void getState(Item item) {
        Layout layout = this.getWindow().getLayout();
        layout.setName("layout");
        item.appendBranchNode((Node)layout);
    }

    public FileChooserResult chooseFile(String string, FileFilter[] fileFilterArray, int n, boolean bl, FileFilter fileFilter) {
        FileFilter[] fileFilterArray2;
        String string2;
        File file;
        if (string == null) {
            switch (n) {
                case 0: {
                    string = "filedialog.openfile";
                    break;
                }
                case 1: {
                    string = "filedialog.addfile";
                    break;
                }
                case 2: {
                    string = "filedialog.savefile";
                }
            }
            string = UI.I18N.getString(string);
        }
        File file2 = file = (string2 = (String)this.getProperty(CURRENT_DIRECTORY)) != null ? new File(string2) : null;
        if (n != 2 && fileFilterArray != null && fileFilterArray.length > 1) {
            fileFilterArray2 = new FileFilter[fileFilterArray.length + 1];
            System.arraycopy(fileFilterArray, 0, fileFilterArray2, 1, fileFilterArray.length);
            final FileFilter[] fileFilterArray3 = fileFilterArray;
            fileFilterArray2[0] = new MimeTypeFileFilter(){

                public MimeType getMimeType(File file) {
                    for (int i = 0; i < fileFilterArray3.length; ++i) {
                        if (!(fileFilterArray3[i] instanceof MimeTypeFileFilter) || !fileFilterArray3[i].accept(file)) continue;
                        return ((MimeTypeFileFilter)fileFilterArray3[i]).getMimeType(file);
                    }
                    return IO.getMimeType((String)file.getName());
                }

                public boolean accept(File file) {
                    for (int i = 0; i < fileFilterArray3.length; ++i) {
                        if (!fileFilterArray3[i].accept(file)) continue;
                        return true;
                    }
                    return false;
                }

                public String getDescription() {
                    return UI.I18N.msg("filedialog.allfilters");
                }
            };
            fileFilterArray = fileFilterArray2;
        }
        if ((fileFilterArray2 = this.getWindow().chooseFile(string, file, fileFilterArray, n, bl, fileFilter)) != null) {
            this.getMainWorkbench().setProperty(CURRENT_DIRECTORY, fileFilterArray2.file.getParentFile().getAbsolutePath());
        }
        return fileFilterArray2;
    }

    public FileChooserResult chooseFileToOpen(String string, IOFlavor iOFlavor) {
        return this.chooseFile(string, (FileFilter[])IO.getReadableFileTypes((IOFlavor[])new IOFlavor[]{iOFlavor}), 0, true, null);
    }

    public FileChooserResult chooseFileToSave(String string, IOFlavor iOFlavor, FileTypeItem.Filter filter) {
        FileChooserResult fileChooserResult = null;
        boolean bl = true;
        while (bl) {
            fileChooserResult = this.chooseFile(string, (FileFilter[])IO.getWritableFileTypes((IOFlavor)iOFlavor), 2, false, (FileFilter)filter);
            if (fileChooserResult == null) {
                return null;
            }
            bl = fileChooserResult.file.exists();
            if (!bl) continue;
            int n = 0;
            if (Workbench.current() != null) {
                n = Workbench.current().getWindow().showDialog(UI.I18N.msg("filedialog.fileexists.title"), UI.I18N.msg("filedialog.fileexists.message"), 100);
            }
            if (n == 0) {
                return fileChooserResult;
            }
            if (n != 2) continue;
            return null;
        }
        return fileChooserResult;
    }

    public Object readObject(FileChooserResult fileChooserResult, IOFlavor iOFlavor) {
        if (fileChooserResult == null) {
            return null;
        }
        return this.readObject((FilterSource)fileChooserResult.createFileSource(this.registry, (ModifiableMap)new StringMap()), iOFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(FilterSource filterSource, IOFlavor iOFlavor) {
        Object object;
        FilterSource filterSource2 = IO.createPipeline((FilterSource)filterSource, (IOFlavor)iOFlavor);
        if (!(filterSource2 instanceof ObjectSource)) {
            this.logGUIInfo(IO.I18N.msg("openfile.unsupported", (Object)IO.toName((String)filterSource.getSystemId()), (Object)IO.getDescription((MimeType)filterSource.getFlavor().getMimeType())));
            return null;
        }
        ConfigurationSet configurationSet = new ConfigurationSet(IO.I18N.msg("openfile.options", (Object)filterSource.getSystemId()));
        FilterSource filterSource3 = filterSource2;
        while (true) {
            if (filterSource3 instanceof Configurable) {
                configurationSet.add((Configurable)filterSource3);
            }
            if ((object = filterSource3.getFilter()) == null) break;
            if (object instanceof Configurable) {
                configurationSet.add((Configurable)object);
            }
            filterSource3 = object.getSource();
        }
        if (configurationSet.size() > 0 && !this.showConfigurationDialog(configurationSet)) {
            return null;
        }
        filterSource2.initProgressMonitor(UI.createProgressAdapter(this));
        try {
            object = ((ObjectSource)filterSource2).getObject();
            return object;
        }
        catch (IOException iOException) {
            this.logGUIInfo(IO.I18N.msg("openfile.failed", (Object)IO.toName((String)filterSource.getSystemId())), iOException);
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            filterSource2.setProgress(null, 2.0f);
        }
    }

    public void showAboutAppDialog(PluginDescriptor pluginDescriptor) {
        String[] stringArray = new String[]{"provider", "name", "version", "id"};
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = UI.I18N.getString("plugins." + stringArray[i], stringArray[i]);
        }
        final Item item = this.registry.getPluginDirectory();
        UISubTree uISubTree = new UISubTree(new RegistryAdapter(this), new TreePath(item.getPath()));
        final ComponentWrapper componentWrapper = this.ui.createTable(new TableMapper(uISubTree, stringArray, new String[]{"provider", "pluginName", "version", "pluginId"}, false), this);
        Object object = this.ui.createContainer(10);
        this.ui.addComponent(object, componentWrapper.getComponent(), "Center");
        Object object2 = this.ui.createContainer(0);
        this.ui.addComponent(object, object2, "South");
        this.ui.addComponent(object2, this.ui.createButton(UI.I18N, "plugins.moreinfo", UIToolkit.MENU_ICON_SIZE, 0, new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                int n = Workbench.this.ui.getSelectedRow(componentWrapper);
                if (n < 0) {
                    return;
                }
                Item item2 = (Item)item.getBranchNode(n);
                if (!(item2 instanceof PluginDescriptor)) {
                    return;
                }
                Workbench.this.showAboutPluginDialog((PluginDescriptor)item2);
            }
        }, (Context)this), "East");
        ObjectList objectList = new ObjectList(4).push((Object)UI.I18N.getString("aboutapp.tab.plugins")).push(object);
        object = this.ui.createContainer(10);
        this.ui.addComponent(object, this.ui.createLabel(UI.I18N.keyToDescribed("thirdparty.info"), 0), "North");
        StringBuffer stringBuffer = new StringBuffer("<html>");
        for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
            if (!(item2 instanceof PluginDescriptor)) continue;
            Workbench.getThirdPartyContent((PluginDescriptor)item2, stringBuffer, false);
        }
        object2 = this.ui.createLabel(stringBuffer.append("</html>").toString(), 0);
        this.ui.addComponent(object, this.ui.createScrollPane(object2), "Center");
        objectList.push((Object)UI.I18N.getString("aboutapp.tab.thirdparty")).push(object);
        this.getWindow().showDialog(pluginDescriptor.getI18NBundle().getString("aboutapp.Title", pluginDescriptor.getPluginName()), this.ui.createAbout(pluginDescriptor, "aboutapp", objectList), 101);
    }

    public void showAboutPluginDialog(PluginDescriptor pluginDescriptor) {
        String string = (String)pluginDescriptor.getFromResource("aboutplugin.tab.about.content");
        if (string == null) {
            string = UI.I18N.msg("aboutplugin.tab.about.content", (Object)pluginDescriptor.getName(), (Object)pluginDescriptor.getPluginName(), (Object)pluginDescriptor.getPluginProvider(), (Object)pluginDescriptor.getPluginVersion(), (Object)String.valueOf(pluginDescriptor.getFromResource("aboutplugin.License")));
        }
        ObjectList objectList = new ObjectList(4).push((Object)UI.I18N.getString("aboutplugin.tab.about")).push(this.ui.createScrollPane(this.ui.createLabel(string, 0)));
        StringBuffer stringBuffer = new StringBuffer();
        Workbench.getThirdPartyContent(pluginDescriptor, stringBuffer, true);
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "<html>").append("</html>");
            objectList.push((Object)UI.I18N.getString("aboutplugin.tab.thirdparty")).push(this.ui.createScrollPane(this.ui.createLabel(stringBuffer.toString(), 0)));
        }
        this.getWindow().showDialog(pluginDescriptor.getI18NBundle().getString("aboutplugin.Title", pluginDescriptor.getPluginName()), this.ui.createAbout(pluginDescriptor, "aboutplugin", objectList), 101);
    }

    private static void getThirdPartyContent(PluginDescriptor pluginDescriptor, StringBuffer stringBuffer, boolean bl) {
        String string = (String)pluginDescriptor.getFromResource("thirdparty.list");
        if (string != null) {
            String string2;
            if (!bl) {
                stringBuffer.append("<h2>").append(UI.I18N.msg("thirdparty.ofplugin", (Object)pluginDescriptor.getPluginName())).append("</h2>");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = string2 = bl ? "h2>" : "h3>";
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = "thirdparty." + stringTokenizer.nextToken() + '.';
                stringBuffer.append('<').append(string2).append(pluginDescriptor.getFromResource(string4 + "Name")).append("</").append(string2);
                if (!bl) {
                    stringBuffer.append("<blockquote>");
                }
                if ((string = (String)pluginDescriptor.getFromResource(string4 + "Copy")) != null) {
                    stringBuffer.append(string).append("<br>");
                }
                if ((string = (String)pluginDescriptor.getFromResource(string4 + "License")) != null) {
                    stringBuffer.append(UI.I18N.getString("thirdparty.license")).append(": ").append(string).append("<br>");
                }
                if ((string = (String)pluginDescriptor.getFromResource(string4 + "URL")) != null) {
                    stringBuffer.append(UI.I18N.getString("thirdparty.url")).append(": ").append(string).append("<br>");
                }
                if (bl) {
                    string = (String)pluginDescriptor.getFromResource(string4 + "Details");
                    if (string == null) continue;
                    stringBuffer.append("<blockquote>").append(string).append("</blockquote>");
                    continue;
                }
                stringBuffer.append("</blockquote>");
            }
            if (!bl) {
                stringBuffer.append("<hr>");
            }
        }
    }

    public boolean showConfigurationDialog(ConfigurationSet configurationSet) {
        MapSource mapSource = new MapSource(this, (ModifiableMap)configurationSet, configurationSet.getKeyDescriptions(), configurationSet.getName());
        boolean bl = this.showConfigurationDialog(mapSource);
        if (bl) {
            configurationSet.writeBack();
        }
        return bl;
    }

    public boolean showConfigurationDialog(Selection selection) {
        ComponentWrapper componentWrapper = selection.createPropertyEditorComponent();
        if (componentWrapper == null) {
            return true;
        }
        int n = this.getWindow().showDialog((String)selection.getDescription("Name"), this.ui.createScrollPane(componentWrapper.getComponent()), 102);
        componentWrapper.dispose();
        return n == 0;
    }

    public ChartPanel getChartPanel(String string, Map map) {
        ChartPanel chartPanel;
        String string2;
        if (this.getWindow() == null) {
            return null;
        }
        String string3 = string2 = string == null ? "/ui/panels/chart" : "/ui/panels/chart?" + string;
        if (string == null) {
            string = "Chart";
        }
        if ((chartPanel = (ChartPanel)this.getWindow().getPanel(string2)) == null) {
            StringMap stringMap = new StringMap(map).putObject("panelId", (Object)string2).putObject(UIProperty.PANEL_TITLE.getName(), (Object)string);
            chartPanel = (ChartPanel)PanelFactory.createPanel(this, "/ui/panels/chart", (Map)stringMap);
            chartPanel.show(false, null);
        }
        return chartPanel;
    }

    public void showViewerPanel(String string, URL uRL, Map map) {
        if (this.isHeadless()) {
            return;
        }
        string = string == null ? "/ui/panels/viewer" : "/ui/panels/viewer?" + string;
        Panel panel = this.getWindow().getPanel(string);
        if (panel != null) {
            this.ui.setContent(this.ui.getTextViewerComponent(panel), uRL);
            panel.show(false, null);
        } else {
            StringMap stringMap = new StringMap(map).putObject("panelId", (Object)string).putObject("systemId", (Object)IO.toSystemId((FileSystem)this.getRegistry().getFileSystem(), (URL)uRL));
            panel = PanelFactory.createPanel(this, "/ui/panels/viewer", (Map)stringMap);
            if (panel != null) {
                panel.show(false, null);
            }
        }
    }

    public void showViewerPanel(String string, String string2, Map map) {
        try {
            this.showViewerPanel(string, IO.toURL((RegistryContext)this.getRegistry(), (String)string2), map);
        }
        catch (MalformedURLException malformedURLException) {
            this.logGUIInfo(null, malformedURLException);
        }
    }

    public void logInfo(String string) {
        this.logInfo(string, null);
    }

    public void logGUIInfo(String string) {
        this.logGUIInfo(string, null);
    }

    public void logInfo(String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        this.getLogger().log(Level.INFO, string, Utils.initCauses((Throwable)throwable));
    }

    public void logGUIInfo(String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        throwable = Utils.getMainException((Throwable)throwable);
        this.getLogger().log(throwable == null || throwable instanceof UserException ? GUI_INFO : Level.WARNING, string, Utils.initCauses((Throwable)throwable));
    }

    public static void log(Throwable throwable) {
        Workbench workbench = Workbench.current();
        if (workbench != null) {
            workbench.logGUIInfo("", throwable);
        } else {
            Main.logWarning((Throwable)throwable);
        }
    }

    public void addStatusChangeListener(PropertyChangeListener propertyChangeListener) {
        this.statusListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeStatusChangeListener(PropertyChangeListener propertyChangeListener) {
        this.statusListeners.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginStatus(Object object) {
        boolean bl;
        Object object2 = this.statusLock;
        synchronized (object2) {
            bl = object != this.statusOwner;
            if (bl) {
                this.statusOwner = object;
            }
        }
        if (bl) {
            this.clearStatusAndProgress(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Object object, String string) {
        String string2;
        Object object2 = this.statusLock;
        synchronized (object2) {
            if (object != this.statusOwner) {
                return;
            }
            string2 = this.status;
            this.status = string;
        }
        if (!Utils.equal((Object)string2, (Object)string)) {
            if (this.isHeadless()) {
                System.err.println(string);
            } else {
                this.statusListeners.firePropertyChange("status", string2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProgress(Object object, Float f) {
        Float f2;
        Object object2 = this.statusLock;
        synchronized (object2) {
            if (object != this.statusOwner) {
                return;
            }
            f2 = this.progress;
            this.progress = f;
        }
        if (!Utils.equal((Object)f2, (Object)f)) {
            if (this.isHeadless()) {
                System.err.println(f == null ? "Done" : f.floatValue() * 100.0f + "%");
            } else {
                this.statusListeners.firePropertyChange("progress", f2, f);
            }
        }
    }

    public void setStatus(Object object, String string, float f) {
        this.setStatus(object, string);
        this.setProgress(object, f);
    }

    public void setStatusClearProgress(Object object, String string) {
        this.setStatus(object, string);
        this.clearProgress(object);
    }

    public void setProgress(Object object, float f) {
        this.setProgress(object, new Float(f));
    }

    public void clearProgress(Object object) {
        this.setProgress(object, null);
    }

    public void setIndeterminateProgress(Object object) {
        this.setProgress(object, -1.0f);
    }

    public void clearStatusAndProgress(Object object) {
        this.setStatus(object, null);
        this.setProgress(object, null);
    }

    public static void cut(Item item, Object object, Context context) {
    }

    public static boolean isCutEnabled(Context context) {
        return Workbench.isCopyEnabled(context) && Workbench.isDeleteEnabled(context);
    }

    public static void copy(Item item, Object object, Context context) {
        Object object2 = UIProperty.WORKBENCH_SELECTION.getValue(context);
        if (object2 instanceof Selection && (((Selection)object2).getCapabilities() & 1) != 0) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(((Selection)object2).toTransferable(true), context.getWorkbench());
        }
    }

    public static boolean isCopyEnabled(Context context) {
        Object object = UIProperty.WORKBENCH_SELECTION.getValue(context);
        return object instanceof Selection && (((Selection)object).getCapabilities() & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(Item item, Object object, Context context) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(Main.getLoaderForAll());
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(context.getWorkbench());
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public static void delete(Item item, Object object, Context context) {
        Object object2 = UIProperty.WORKBENCH_SELECTION.getValue(context);
        if (object2 instanceof Selection && (((Selection)object2).getCapabilities() & 2) != 0) {
            ((Selection)object2).delete(true);
        }
    }

    public static boolean isDeleteEnabled(Context context) {
        Object object = UIProperty.WORKBENCH_SELECTION.getValue(context);
        return object instanceof Selection && (((Selection)object).getCapabilities() & 2) != 0;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("lostOwnership of " + clipboard);
    }

    public void select(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            UIProperty.WORKBENCH_SELECTION.setValue(this, null);
            return;
        }
        Object[] objectArray = new GraphState[nodeArray.length];
        Arrays.fill(objectArray, GraphState.get((Graph)this.getRegistry().getProjectGraph(), (ThreadContext)this.jm.getThreadContext()));
        boolean[] blArray = new boolean[nodeArray.length];
        Arrays.fill(blArray, true);
        UIProperty.WORKBENCH_SELECTION.setValue(this, new GraphSelectionImpl((Context)this, (GraphState[])objectArray, nodeArray, blArray));
    }

    public File getFile() {
        return this.file;
    }

    public static void refreshJEdit(String string) {
        if (Workbench.current() == null) {
            return;
        }
        Item item = Workbench.current().getRegistry().getDirectory("/project/objects/files", null);
        for (Node node = item.getBranch(); node != null; node = node.getSuccessor()) {
            SourceFile sourceFile;
            if (!(node instanceof SourceFile) || !(sourceFile = (SourceFile)node).getName().equals("pfs:" + string)) continue;
            sourceFile.showLater(Workbench.current());
        }
    }

    public static void refreshJEdit(Workbench workbench, String string) {
        if (workbench == null) {
            return;
        }
        Item item = workbench.getRegistry().getDirectory("/project/objects/files", null);
        for (Node node = item.getBranch(); node != null; node = node.getSuccessor()) {
            SourceFile sourceFile;
            if (!(node instanceof SourceFile) || !(sourceFile = (SourceFile)node).getName().equals("pfs:" + string)) continue;
            sourceFile.showLater(workbench);
        }
    }

    static {
        PREFERENCES_PROPERTIES.add(CURRENT_DIRECTORY);
        for (int i = 0; i < 10; ++i) {
            PREFERENCES_PROPERTIES.add(LAST_FILES[i]);
        }
    }

    public static interface Loader
    extends ProjectLoader {
        public void loadWorkbench(Workbench var1);
    }
}

