/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.icon.IconSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.LoggingHandler;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Widget;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.reflect.Type;
import de.grogra.util.Described;
import de.grogra.util.Disposable;
import de.grogra.util.HTMLLoggingFormatter;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.Quantity;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.awt.Dimension;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import javax.swing.ListModel;
import javax.swing.table.TableModel;

public abstract class UIToolkit {
    public static final Dimension ABOUT_ICON_SIZE = new Dimension(64, 64);
    public static final Dimension TOOLBAR_ICON_SIZE = new Dimension(32, 32);
    public static final Dimension MEDIUM_ICON_SIZE = new Dimension(22, 22);
    public static final Dimension MENU_ICON_SIZE = new Dimension(16, 16);
    public static final Dimension WINDOW_ICON_SIZE = new Dimension(16, 16);
    public static final String EXPLORER_ACTION = "explore";
    public static final String UPDATE_COMPONENT_WRAPPER_METHOD = "updateComponentWrapper";
    public static final String CREATE_COMPONENT_WRAPPER_METHOD = "createComponentWrapper";
    public static final int FONT_SIZE_MASK = 255;
    public static final int FONT_PLAIN = 256;
    public static final int FONT_ITALIC = 512;
    public static final int FONT_BOLD = 1024;
    public static final int FONT_MONOSPACED = 2048;
    public static final int FONT_SANS_SERIF = 4096;
    public static final int FONT_SERIF = 8192;
    public static final int FONT_DIALOG = 16384;
    public static final int FONT_DIALOG_INPUT = 32768;
    public static final int FONT_MASK = 65535;
    public static final int ALIGNMENT_LEADING = 65536;
    public static final int ALIGNMENT_CENTER = 131072;
    public static final int ALIGNMENT_TRAILING = 262144;
    public static final int FORCE_DIMENSION = 524288;
    public static final int FOR_MENU = 0x100000;

    public static UIToolkit get(Context context) {
        return context.getWorkbench().getToolkit();
    }

    protected static Object getFirstMatching(int n, int[] nArray, Object[] objectArray, Object object) {
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) == 0) continue;
            return objectArray[i];
        }
        return object;
    }

    protected static int getFirstMatching(int n, int[] nArray, int[] nArray2, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) == 0) continue;
            return nArray2[i];
        }
        return n2;
    }

    public Object createLabel(Described described, int n) {
        return this.createLabel(described, MENU_ICON_SIZE, n);
    }

    public Object createLabel(Described described, Dimension dimension, int n) {
        return this.createLabel((String)described.getDescription("Name"), (IconSource)described.getDescription("Icon"), dimension, n);
    }

    public Object createLabel(String string, int n) {
        return this.createLabel(string, null, MENU_ICON_SIZE, n);
    }

    public Object createLabel(String string, IconSource iconSource, int n) {
        return this.createLabel(string, iconSource, MENU_ICON_SIZE, n);
    }

    public abstract Object createLabel(String var1, IconSource var2, Dimension var3, int var4);

    public Object createButton(I18NBundle i18NBundle, String string, Dimension dimension, int n, Command command, Context context) {
        return this.createButton(i18NBundle.getString(string + ".Name", string), (IconSource)i18NBundle.getObject(string + ".Icon", null), dimension, n, command, context);
    }

    public Object createButton(Described described, int n, Command command, Context context) {
        return this.createButton(described, MENU_ICON_SIZE, n, command, context);
    }

    public Object createButton(Described described, Dimension dimension, int n, Command command, Context context) {
        return this.createButton((String)described.getDescription("Name"), (IconSource)described.getDescription("Icon"), dimension, n, command, context);
    }

    public Object createButton(String string, int n, Command command, Context context) {
        return this.createButton(string, null, MENU_ICON_SIZE, n, command, context);
    }

    public Object createButton(String string, IconSource iconSource, int n, Command command, Context context) {
        return this.createButton(string, iconSource, MENU_ICON_SIZE, n, command, context);
    }

    public abstract Object createButton(String var1, IconSource var2, Dimension var3, int var4, Command var5, Context var6);

    public abstract Object createLabeledComponent(Object var1, Object var2);

    public abstract Widget createNumericWidget(Type var1, Quantity var2, Map var3);

    public abstract Widget createStringWidget(Map var1);

    public abstract Widget createTreeChoiceWidget(UITree var1);

    public abstract Widget createChoiceWidget(ListModel var1, boolean var2);

    public abstract Widget createBooleanWidget(boolean var1, Map var2);

    public abstract Widget createColorWidget(Map var1);

    public abstract ChartPanel createChartPanel(Context var1, Map var2);

    public abstract Panel createPanel(Context var1, Disposable var2, Map var3);

    public abstract Object createScrollPane(Object var1);

    public abstract Object createTabbedPane(String[] var1, Object[] var2);

    public abstract Object createContainer(int var1);

    public abstract Object createSplitContainer(int var1);

    public abstract Object createContainer(int var1, int var2, int var3);

    public abstract Object createContainer(float[] var1, int var2);

    public abstract Object setBorder(Object var1, int var2);

    public void addComponent(Object object, Object object2, Object object3) {
        this.addComponent(object, object2, object3, -1);
    }

    public abstract void addComponent(Object var1, Object var2, Object var3, int var4);

    public abstract void removeComponent(Object var1);

    public abstract Object getParent(Object var1);

    public abstract int indexOf(Object var1);

    public abstract int getComponentCount(Object var1);

    public abstract Object getComponent(Object var1, int var2);

    public abstract Point getLocationOnScreen(Object var1);

    public abstract int getWidth(Object var1);

    public abstract int getHeight(Object var1);

    public abstract void revalidate(Object var1);

    public abstract void repaint(Object var1);

    public void dispose(Object object) {
        if (this.getParent(object) == null) {
            return;
        }
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        } else {
            for (int i = this.getComponentCount(object) - 1; i >= 0; --i) {
                this.dispose(this.getComponent(object, i));
            }
        }
        this.removeComponent(object);
    }

    public abstract Window createWindow(Command var1, Map var2);

    public abstract Panel createToolBar(Context var1, Map var2);

    public abstract Panel createStatusBar(Context var1, Map var2);

    public Panel createViewerPanel(Context context, String string, Map map) {
        try {
            return this.createViewerPanel(context, IO.toURL((RegistryContext)UI.getRegistry(context), (String)string), map);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public abstract Panel createViewerPanel(Context var1, URL var2, Map var3);

    public abstract Object getTextViewerComponent(Panel var1);

    public abstract TextEditor createTextEditor(Context var1, Map var2);

    public abstract Console createConsole(Context var1, Map var2);

    public abstract ComponentWrapper createTree(UITree var1);

    public abstract ComponentWrapper createTreeInSplit(UITree var1, Object var2);

    public abstract ComponentWrapper createComponentTree(UITree var1);

    public abstract ComponentWrapper createComponentMenu(UITree var1);

    public abstract Object createTextViewer(URL var1, String var2, String var3, Command var4, boolean var5);

    public abstract void setContent(Object var1, String var2, String var3);

    public abstract void setContent(Object var1, URL var2);

    public abstract ComponentWrapper createTable(TableModel var1, Context var2);

    public abstract int getSelectedRow(ComponentWrapper var1);

    public abstract TableModel getTable(ComponentWrapper var1);

    public abstract void showPopupMenu(UITree var1, Object var2, int var3, int var4);

    public Panel createLogViewer(final Context context, Map map) {
        Object object;
        final LoggingHandler loggingHandler = new LoggingHandler(context);
        loggingHandler.setFormatter((Formatter)new HTMLLoggingFormatter(UI.I18N, MEDIUM_ICON_SIZE));
        loggingHandler.setMimeType("text/html");
        loggingHandler.setLevel(Workbench.SOFT_GUI_INFO);
        Object object2 = Utils.get((Map)map, (Object)"logrecords", null);
        if (object2 instanceof LogRecord[][]) {
            object = (LogRecord[][])object2;
            for (int i = 0; i < ((LogRecord[][])object).length; ++i) {
                LogRecord[] logRecordArray = object[i];
                if (logRecordArray == null || logRecordArray.length <= 0) continue;
                loggingHandler.beginGrouping();
                for (int j = 0; j < logRecordArray.length; ++j) {
                    loggingHandler.publish(logRecordArray[j]);
                }
                loggingHandler.endGrouping();
            }
        }
        context.getWorkbench().getLogger().addHandler(loggingHandler);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper
        implements ComponentWrapper,
        JobManager.ExecutionListener {
            private boolean executing;

            Helper() {
            }

            public void dispose() {
                UI.getJobManager(context).removeExecutionListener(this);
                context.getWorkbench().getLogger().removeHandler(loggingHandler);
            }

            @Override
            public Object getComponent() {
                return loggingHandler.getComponent();
            }

            @Override
            public void executionStarted(JobManager jobManager) {
                this.executing = true;
                loggingHandler.beginGrouping();
            }

            @Override
            public void executionFinished(JobManager jobManager) {
                if (this.executing) {
                    this.executing = false;
                    loggingHandler.endGrouping();
                }
            }
        }
        object = new Helper();
        UI.getJobManager(context).addExecutionListener((JobManager.ExecutionListener)object);
        Panel panel = this.createPanel(context, null, map);
        panel.setContent((ComponentWrapper)object);
        return panel;
    }

    public Object createAbout(PluginDescriptor pluginDescriptor, String string, ObjectList objectList) {
        Object object = this.createContainer(10);
        I18NBundle i18NBundle = pluginDescriptor.getI18NBundle();
        Object object2 = this.createLabel(i18NBundle.getString(string + ".Name", pluginDescriptor.getPluginName()), (IconSource)i18NBundle.getObject(string + ".Icon", null), ABOUT_ICON_SIZE, 82962);
        this.addComponent(object, object2, "North");
        int n = objectList != null ? objectList.size() / 2 : 0;
        String string2 = i18NBundle.getString(string + ".tabs", null);
        StringTokenizer stringTokenizer = null;
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2);
            n += stringTokenizer.countTokens();
        }
        String[] stringArray = new String[n];
        Object[] objectArray = new Object[n];
        int n2 = 0;
        if (stringTokenizer != null) {
            while (stringTokenizer.hasMoreTokens()) {
                Object object3;
                URL uRL;
                string2 = stringTokenizer.nextToken();
                String string3 = i18NBundle.getString(string + ".tab." + string2 + ".content", null);
                if (string3 == null || (uRL = pluginDescriptor.getURLForResource(string3)) == null || (object3 = this.createTextViewer(uRL, null, null, null, false)) == null) continue;
                stringArray[n2] = i18NBundle.getString(string + ".tab." + string2, string2);
                objectArray[n2++] = this.setBorder(this.createScrollPane(object3), 4);
            }
        }
        if (objectList != null) {
            for (int i = 0; i < objectList.size(); i += 2) {
                stringArray[n2] = (String)objectList.get(i);
                objectArray[n2++] = this.setBorder(objectList.get(i + 1), 4);
            }
        }
        if (n2 > 0) {
            if (n2 < n) {
                String[] stringArray2 = stringArray;
                stringArray = new String[n2];
                System.arraycopy(stringArray2, 0, stringArray, 0, n2);
                Object[] objectArray2 = objectArray;
                objectArray = new Object[n2];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
            }
            this.addComponent(object, this.createTabbedPane(stringArray, objectArray), "Center");
        }
        return object;
    }
}

