/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Widget;
import de.grogra.util.Described;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.DefaultListModel;

public class LoggingHandler
extends Handler {
    final Context ctx;
    final Object component;
    final Object viewer;
    final DefaultListModel recordList;
    final StringBuffer buffer;
    final Widget choice;
    private String mimeType;
    private int groupingCount;
    private ObjectList groupedRecords = new ObjectList();
    private ObjectList pendingRecords = new ObjectList();

    public LoggingHandler(Context context) {
        this.ctx = context;
        this.recordList = new DefaultListModel();
        this.buffer = new StringBuffer();
        this.mimeType = "text/plain";
        UIToolkit uIToolkit = context.getWorkbench().getToolkit();
        Helper helper = new Helper(0);
        this.choice = uIToolkit.createChoiceWidget(this.recordList, false);
        this.choice.addPropertyChangeListener(helper);
        this.viewer = uIToolkit.createTextViewer(null, this.mimeType, "", helper, false);
        this.component = uIToolkit.createContainer(5);
        uIToolkit.addComponent(this.component, this.choice.getComponent(), "North");
        uIToolkit.addComponent(this.component, uIToolkit.createScrollPane(this.viewer), "Center");
    }

    public synchronized void beginGrouping() {
        ++this.groupingCount;
    }

    public synchronized void endGrouping() {
        if (--this.groupingCount == 0 && this.groupedRecords.size > 0) {
            this.pendingRecords.addAll(this.groupedRecords);
            this.groupedRecords.clear();
            this.publish();
        }
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.groupingCount == 0) {
            this.pendingRecords.add((Object)logRecord);
            this.publish();
        } else {
            this.groupedRecords.add((Object)logRecord);
        }
    }

    private void publish() {
        this.ctx.getWorkbench().getJobManager().runLater(500L, new Helper(1), null, this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewerContent(LogRecord[] logRecordArray) {
        String string;
        Formatter formatter = this.getFormatter();
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.setLength(0);
            this.buffer.append(formatter.getHead(this));
            for (int i = 0; i < logRecordArray.length; ++i) {
                this.buffer.append(formatter.format(logRecordArray[i]));
            }
            string = this.buffer.append(formatter.getTail(this)).toString();
        }
        this.ctx.getWorkbench().getToolkit().setContent(this.viewer, this.mimeType, string);
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Object getComponent() {
        return this.component;
    }

    public void close() {
    }

    public void flush() {
    }

    private final class Helper
    implements Command,
    PropertyChangeListener,
    Described {
        static final int HYPERLINK = 0;
        static final int PUBLISH = 1;
        private final int command;
        private LogRecord[] records;

        Helper(int n) {
            this.command = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LogRecord[] getRecords() {
            LoggingHandler loggingHandler = LoggingHandler.this;
            synchronized (loggingHandler) {
                if (this.records == null) {
                    this.records = new LogRecord[LoggingHandler.this.pendingRecords.size()];
                    LoggingHandler.this.pendingRecords.toArray((Object[])this.records);
                    LoggingHandler.this.pendingRecords.clear();
                }
            }
            return this.records;
        }

        public void run(Object object, Context context) {
            switch (this.command) {
                case 0: {
                    UI.executeHyperlinkURL((String)object, context);
                    break;
                }
                case 1: {
                    if (this.getRecords().length <= 0) break;
                    LoggingHandler.this.recordList.addElement(this);
                    LoggingHandler.this.choice.updateValue(this);
                    this.setViewerContent();
                }
            }
        }

        private void setViewerContent() {
            LoggingHandler.this.setViewerContent(this.getRecords());
        }

        public String getCommandName() {
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ((Helper)propertyChangeEvent.getNewValue()).setViewerContent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getDescription(String string) {
            if (Utils.isStringDescription((String)string)) {
                LogRecord[] logRecordArray = this.getRecords();
                LogRecord logRecord = logRecordArray[logRecordArray.length - 1];
                StringBuffer stringBuffer = LoggingHandler.this.buffer;
                synchronized (stringBuffer) {
                    LoggingHandler.this.buffer.setLength(0);
                    LoggingHandler.this.buffer.append('[').append(logRecordArray.length).append("] ");
                    Utils.formatDateAndName((LogRecord)logRecord, (StringBuffer)LoggingHandler.this.buffer);
                    LoggingHandler.this.buffer.append(' ').append(logRecord.getLevel().getLocalizedName());
                    if (logRecord.getMessage().length() > 0) {
                        LoggingHandler.this.buffer.append(": ").append(logRecord.getMessage());
                    } else {
                        Throwable throwable = Utils.getMainException((Throwable)logRecord.getThrown());
                        if (throwable != null) {
                            LoggingHandler.this.buffer.append(": ").append(throwable.getLocalizedMessage());
                        }
                    }
                    return LoggingHandler.this.buffer.toString();
                }
            }
            return null;
        }
    }
}

