/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.data.DatasetAdapterBase;
import java.util.Collections;
import java.util.List;
import org.jfree.data.statistics.StatisticalCategoryDataset;

public final class StatisticsAdapter
extends DatasetAdapterBase
implements StatisticalCategoryDataset {
    private static final List<String> COLUMN_KEYS = Collections.singletonList("");

    public StatisticsAdapter(Dataset dataset) {
        super(dataset);
    }

    public Number getMeanValue(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = 0;
        double d = 0.0;
        while (this.dataset.hasCell0(n3, n)) {
            d += this.dataset.getCell0(n3++, n).getY();
        }
        return n3 > 0 ? d / (double)n3 : 0.0;
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(this.getRowIndex(comparable), 0);
    }

    public Number getStdDevValue(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        while (this.dataset.hasCell0(n3, n)) {
            double d3 = this.dataset.getCell0(n3++, n).getY();
            d += d3;
            d2 += d3 * d3;
        }
        if (n3 == 0) {
            return 0;
        }
        return (d = (d2 * (double)n3 - d * d) / (double)(n3 * n3)) > 0.0 ? Math.sqrt(d) : 0.0;
    }

    public Number getStdDevValue(Comparable comparable, Comparable comparable2) {
        return this.getStdDevValue(this.getRowIndex(comparable), 0);
    }

    public int getColumnIndex(Comparable comparable) {
        return 0;
    }

    public Comparable getColumnKey(int n) {
        return "";
    }

    public List getColumnKeys() {
        return COLUMN_KEYS;
    }

    public int getRowIndex(Comparable comparable) {
        return this.indexOf(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.getSeriesKey(n);
    }

    public List getRowKeys() {
        return this.dataset.seriesInRows ? this.dataset.rowKeys : this.dataset.columnKeys;
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(comparable, comparable2);
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.getSeriesCount();
    }

    public Number getValue(int n, int n2) {
        return this.getMeanValue(n, n2);
    }
}

