/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class Datacell
implements Serializable {
    private static final long serialVersionUID = -6908940238176224539L;
    Number x = Null.INSTANCE;
    Number y = Null.INSTANCE;
    Number z = Null.INSTANCE;
    String text = null;
    private final Dataset dataset;

    public Datacell(String string) {
        this.dataset = null;
        this.text = string;
    }

    Datacell(Dataset dataset) {
        this.dataset = dataset;
    }

    public boolean isNull() {
        return this.x == Null.INSTANCE && this.y == Null.INSTANCE && this.z == Null.INSTANCE;
    }

    public boolean isScalar() {
        return this.x == this.y;
    }

    public boolean isXNull() {
        return this.x == Null.INSTANCE;
    }

    public boolean isYNull() {
        return this.y == Null.INSTANCE;
    }

    public boolean isZNull() {
        return this.z == Null.INSTANCE;
    }

    public double getX() {
        return this.x.doubleValue();
    }

    public double getY() {
        return this.y.doubleValue();
    }

    public double getZ() {
        return this.z.doubleValue();
    }

    public void setX(Number number) {
        this.x = number;
        this.dataset.fireDatasetChanged(this);
    }

    public void setY(Number number) {
        this.y = number;
        this.dataset.fireDatasetChanged(this);
    }

    public void setZ(Number number) {
        this.z = number;
        this.dataset.fireDatasetChanged(this);
    }

    public void set(Number number) {
        this.y = this.z = number;
        this.x = this.z;
        this.dataset.fireDatasetChanged(this);
    }

    public void setText(String string) {
        this.text = string;
        this.dataset.fireDatasetChanged(this);
    }

    public void set(Number number, Number number2) {
        this.x = number;
        this.y = this.z = number2;
        this.dataset.fireDatasetChanged(this);
    }

    public void set(Number number, Number number2, Number number3) {
        this.x = number;
        this.y = number2;
        this.z = number3;
        this.dataset.fireDatasetChanged(this);
    }

    private void makeNumeric() {
        if (this.text == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.text);
        this.text = null;
        Double[] doubleArray = new Double[3];
        int n = 0;
        while (n < 3 && stringTokenizer.hasMoreTokens()) {
            try {
                doubleArray[n] = new Double(stringTokenizer.nextToken());
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        switch (n) {
            case 1: {
                this.y = this.z = doubleArray[0];
                this.x = this.z;
                break;
            }
            case 2: {
                this.x = doubleArray[0];
                this.y = this.z = doubleArray[1];
                break;
            }
            case 3: {
                this.x = doubleArray[0];
                this.y = doubleArray[1];
                this.z = doubleArray[2];
            }
        }
    }

    void set(Datacell datacell) {
        this.x = datacell.x;
        this.y = datacell.y;
        this.z = datacell.z;
        if (this.text != null) {
            this.text = datacell.toString();
        } else if (datacell.text != null && datacell.dataset == null) {
            this.text = datacell.text;
            this.makeNumeric();
        }
        this.dataset.fireDatasetChanged(this);
    }

    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        if (this.y == this.z) {
            if (this.x == this.y) {
                return this.x == Null.INSTANCE ? "" : this.x.toString();
            }
            return this.x + " " + this.y;
        }
        return this.x + " " + this.y + " " + this.z;
    }

    private static final class Null
    extends Number {
        private static final long serialVersionUID = -3690894023817622459L;
        static final Null INSTANCE = new Null();

        private Null() {
        }

        public double doubleValue() {
            return 0.0;
        }

        public float floatValue() {
            return 0.0f;
        }

        public int intValue() {
            return 0;
        }

        public long longValue() {
            return 0L;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

