/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThreadPool;

public class WorkThread
extends Thread {
    private WorkThreadPool pool;
    private Object abortLock = new Object();
    private boolean requestRunning;
    private boolean abortable;
    private boolean aborted;
    private String status;
    private int progressValue;
    private int progressMaximum;

    public WorkThread(WorkThreadPool workThreadPool, ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        this.setPriority(1);
        this.pool = workThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbortable(boolean bl) {
        Object object = this.abortLock;
        synchronized (object) {
            this.abortable = bl;
            if (this.aborted) {
                this.stop(new Abort());
            }
        }
    }

    public boolean isRequestRunning() {
        return this.requestRunning;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
        this.pool.fireProgressChanged(this);
    }

    public int getProgressValue() {
        return this.progressValue;
    }

    public void setProgressValue(int n) {
        this.progressValue = n;
        this.pool.fireProgressChanged(this);
    }

    public int getProgressMaximum() {
        return this.progressMaximum;
    }

    public void setProgressMaximum(int n) {
        this.progressMaximum = n;
        this.pool.fireProgressChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortCurrentRequest() {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.abortable && !this.aborted) {
                this.stop(new Abort());
            }
            this.aborted = true;
        }
    }

    public void run() {
        Log.log(1, this, "Work request thread starting [" + this.getName() + "]");
        while (true) {
            this.doRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequests() {
        WorkThreadPool.Request request;
        while ((request = this.pool.getNextRequest()) != null) {
            this.requestRunning = true;
            this.pool.fireStatusChanged(this);
            this.doRequest(request);
            this.requestRunning = false;
        }
        this.pool.fireStatusChanged(this);
        Object object = this.pool.waitForAllLock;
        synchronized (object) {
            this.pool.waitForAllLock.notifyAll();
        }
        object = this.pool.lock;
        synchronized (object) {
            try {
                this.pool.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.log(9, this, interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(WorkThreadPool.Request request) {
        Log.log(1, WorkThread.class, "Running in work thread: " + request);
        try {
            request.run.run();
        }
        catch (Abort abort) {
            Log.log(9, WorkThread.class, "Unhandled abort");
        }
        catch (Throwable throwable) {
            Log.log(9, WorkThread.class, "Exception in work thread:");
            Log.log(9, WorkThread.class, throwable);
        }
        finally {
            Object object = this.abortLock;
            synchronized (object) {
                this.abortable = false;
                this.aborted = false;
            }
            this.status = null;
            this.progressMaximum = 0;
            this.progressValue = 0;
            this.pool.requestDone();
            this.pool.fireStatusChanged(this);
        }
    }

    public static class Abort
    extends Error {
        public Abort() {
            super("Work request aborted");
        }
    }
}

