/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.Hashtable;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.util.CharIndexedSegment;

public class TokenMarker {
    private Hashtable ruleSets;
    private ParserRuleSet mainRuleSet;
    private TokenHandler tokenHandler;
    private Segment line;
    private LineContext context;
    private KeywordMap keywords;
    private Segment pattern = new Segment();
    private int lastOffset;
    private int lineLength;
    private int pos;
    private boolean escaped;
    private int whitespaceEnd;
    private boolean seenWhitespaceEnd;

    public TokenMarker() {
        this.ruleSets = new Hashtable(64);
    }

    public void addRuleSet(ParserRuleSet parserRuleSet) {
        this.ruleSets.put(parserRuleSet.getSetName(), parserRuleSet);
        if (parserRuleSet.getSetName().equals("MAIN")) {
            this.mainRuleSet = parserRuleSet;
        }
    }

    public ParserRuleSet getMainRuleSet() {
        return this.mainRuleSet;
    }

    public ParserRuleSet getRuleSet(String string) {
        return (ParserRuleSet)this.ruleSets.get(string);
    }

    public ParserRuleSet[] getRuleSets() {
        return this.ruleSets.values().toArray(new ParserRuleSet[this.ruleSets.size()]);
    }

    public LineContext markTokens(LineContext lineContext, TokenHandler tokenHandler, Segment segment) {
        ParserRule parserRule;
        this.tokenHandler = tokenHandler;
        this.line = segment;
        this.lastOffset = segment.offset;
        this.lineLength = segment.count + segment.offset;
        this.context = new LineContext();
        if (lineContext == null) {
            this.context.rules = this.getMainRuleSet();
        } else {
            this.context.parent = lineContext.parent;
            this.context.inRule = lineContext.inRule;
            this.context.rules = lineContext.rules;
            this.context.spanEndSubst = lineContext.spanEndSubst;
        }
        this.keywords = this.context.rules.getKeywords();
        this.escaped = false;
        this.seenWhitespaceEnd = false;
        this.whitespaceEnd = segment.offset;
        int n = this.context.rules.getTerminateChar();
        boolean bl = false;
        this.pos = segment.offset;
        while (this.pos < this.lineLength) {
            block18: {
                if (n >= 0 && this.pos - segment.offset >= n && !bl) {
                    bl = true;
                    this.context = new LineContext(ParserRuleSet.getStandardRuleSet(this.context.rules.getDefault()), this.context);
                    this.keywords = this.context.rules.getKeywords();
                }
                if (this.context.parent != null && (parserRule = this.context.parent.inRule) != null && this.checkDelegateEnd(parserRule)) {
                    this.seenWhitespaceEnd = true;
                } else {
                    char c = segment.array[this.pos];
                    parserRule = this.context.rules.getRules(c);
                    while (parserRule != null) {
                        if (this.handleRule(parserRule, false)) {
                            this.seenWhitespaceEnd = true;
                            break block18;
                        }
                        parserRule = parserRule.next;
                    }
                    if (Character.isWhitespace(c)) {
                        if (!this.seenWhitespaceEnd) {
                            this.whitespaceEnd = this.pos + 1;
                        }
                        if (this.context.inRule != null) {
                            this.handleRule(this.context.inRule, true);
                        }
                        this.handleNoWordBreak();
                        this.markKeyword(false);
                        if (this.lastOffset != this.pos) {
                            tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.lastOffset - segment.offset, this.pos - this.lastOffset, this.context);
                        }
                        tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.pos - segment.offset, 1, this.context);
                        this.lastOffset = this.pos + 1;
                        this.escaped = false;
                    } else {
                        if (this.keywords != null || this.context.rules.getRuleCount() != 0) {
                            String string = this.context.rules.getNoWordSep();
                            if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                                if (this.context.inRule != null) {
                                    this.handleRule(this.context.inRule, true);
                                }
                                this.handleNoWordBreak();
                                this.markKeyword(true);
                                tokenHandler.handleToken(segment, this.context.rules.getDefault(), this.lastOffset - segment.offset, 1, this.context);
                                this.lastOffset = this.pos + 1;
                            }
                        }
                        this.seenWhitespaceEnd = true;
                        this.escaped = false;
                    }
                }
            }
            ++this.pos;
        }
        this.pos = this.lineLength;
        if (this.context.inRule != null) {
            this.handleRule(this.context.inRule, true);
        }
        this.handleNoWordBreak();
        this.markKeyword(true);
        while (this.context.parent != null && ((parserRule = this.context.parent.inRule) != null && (parserRule.action & 0x200) == 512 || bl)) {
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
        }
        tokenHandler.handleToken(segment, (byte)127, this.pos - segment.offset, 0, this.context);
        this.context = this.context.intern();
        tokenHandler.setLineContext(this.context);
        return this.context;
    }

    private boolean checkDelegateEnd(ParserRule parserRule) {
        ParserRule parserRule2;
        if (parserRule.end == null) {
            return false;
        }
        LineContext lineContext = this.context;
        this.context = this.context.parent;
        this.keywords = this.context.rules.getKeywords();
        boolean bl = this.escaped;
        boolean bl2 = this.handleRule(parserRule, true);
        this.context = lineContext;
        this.keywords = this.context.rules.getKeywords();
        if (bl2 && !bl) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.markKeyword(true);
            this.context = (LineContext)this.context.parent.clone();
            this.tokenHandler.handleToken(this.line, (this.context.inRule.action & 0x100) == 256 ? this.context.rules.getDefault() : this.context.inRule.token, this.pos - this.line.offset, this.pattern.count, this.context);
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
            this.lastOffset = this.pos + this.pattern.count;
            this.pos += this.pattern.count - 1;
            return true;
        }
        return (parserRule.action & 0x1000) == 0 && (parserRule2 = this.context.parent.rules.getEscapeRule()) != null && this.handleRule(parserRule2, false);
    }

    private boolean handleRule(ParserRule parserRule, boolean bl) {
        byte by;
        int n;
        if (!bl && Character.toUpperCase(parserRule.hashChar) != Character.toUpperCase(this.line.array[this.pos])) {
            return false;
        }
        int n2 = (parserRule.action & 4) != 0 ? this.lastOffset : this.pos;
        int n3 = n = bl ? parserRule.endPosMatch : parserRule.startPosMatch;
        if ((n & 2) == 2 ? n2 != this.line.offset : ((n & 4) == 4 ? n2 != this.whitespaceEnd : (n & 8) == 8 && n2 != this.lastOffset)) {
            return false;
        }
        int n4 = 1;
        CharIndexedSegment charIndexedSegment = null;
        REMatch rEMatch = null;
        if (!bl || (parserRule.action & 8) == 0) {
            if ((parserRule.action & 0x2000) == 0 || bl) {
                this.pattern.array = bl ? (this.context.spanEndSubst != null ? this.context.spanEndSubst : parserRule.end) : parserRule.start;
                this.pattern.offset = 0;
                n4 = this.pattern.count = this.pattern.array.length;
                if (!SyntaxUtilities.regionMatches(this.context.rules.getIgnoreCase(), this.line, this.pos, this.pattern.array)) {
                    return false;
                }
            } else {
                by = this.pos - this.line.offset;
                charIndexedSegment = new CharIndexedSegment(this.line, by);
                rEMatch = parserRule.startRegexp.getMatch(charIndexedSegment, 0, 64);
                if (rEMatch == null) {
                    return false;
                }
                if (rEMatch.getStartIndex() != 0) {
                    throw new InternalError("Can't happen");
                }
                n4 = rEMatch.getEndIndex();
                if (n4 == 0) {
                    n4 = 1;
                }
            }
        }
        if ((parserRule.action & 0x800) == 2048) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.escaped = !this.escaped;
            this.pos += this.pattern.count - 1;
        } else if (this.escaped) {
            this.escaped = false;
            this.pos += this.pattern.count - 1;
        } else if (!bl) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.markKeyword((parserRule.action & 4) != 4);
            switch (parserRule.action & 0xFF) {
                case 0: {
                    this.context.spanEndSubst = null;
                    if ((parserRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, parserRule.token, this.pos - this.line.offset, n4, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, parserRule.token, this.pos - this.line.offset, n4, this.context);
                    }
                    if (parserRule.delegate == null) break;
                    this.context = new LineContext(parserRule.delegate, this.context.parent);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 2: 
                case 16: {
                    this.context.inRule = parserRule;
                    by = (parserRule.action & 0x100) == 256 ? this.context.rules.getDefault() : parserRule.token;
                    if ((parserRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, by, this.pos - this.line.offset, n4, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, by, this.pos - this.line.offset, n4, this.context);
                    }
                    char[] cArray = null;
                    if (charIndexedSegment != null && parserRule.end != null) {
                        cArray = this.substitute(rEMatch, parserRule.end);
                    }
                    this.context.spanEndSubst = cArray;
                    this.context = new LineContext(parserRule.delegate, this.context);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 8: {
                    this.tokenHandler.handleToken(this.line, (parserRule.action & 0x100) == 256 ? this.context.rules.getDefault() : parserRule.token, this.pos - this.line.offset, this.pattern.count, this.context);
                    this.context.spanEndSubst = null;
                    this.context.inRule = parserRule;
                    break;
                }
                case 4: {
                    this.context.spanEndSubst = null;
                    if ((parserRule.action & 0x100) == 256) {
                        if (this.pos != this.lastOffset) {
                            this.tokenHandler.handleToken(this.line, parserRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
                        }
                        this.tokenHandler.handleToken(this.line, this.context.rules.getDefault(), this.pos - this.line.offset, this.pattern.count, this.context);
                        break;
                    }
                    this.tokenHandler.handleToken(this.line, parserRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset + this.pattern.count, this.context);
                    break;
                }
                default: {
                    throw new InternalError("Unhandled major action");
                }
            }
            this.pos += n4 - 1;
            this.lastOffset = this.pos + 1;
        } else if ((this.context.inRule.action & 8) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, this.context.inRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context.inRule = null;
        }
        return true;
    }

    private void handleNoWordBreak() {
        ParserRule parserRule;
        if (this.context.parent != null && (parserRule = this.context.parent.inRule) != null && (this.context.parent.inRule.action & 0x400) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, parserRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
        }
    }

    private void handleTokenWithSpaces(TokenHandler tokenHandler, byte by, int n, int n2, LineContext lineContext) {
        int n3 = n;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (!Character.isWhitespace(this.line.array[i + this.line.offset])) continue;
            if (n3 != i) {
                tokenHandler.handleToken(this.line, by, n3, i - n3, lineContext);
            }
            tokenHandler.handleToken(this.line, by, i, 1, lineContext);
            n3 = i + 1;
        }
        if (n3 != n4) {
            tokenHandler.handleToken(this.line, by, n3, n4 - n3, lineContext);
        }
    }

    private void markKeyword(boolean bl) {
        byte by;
        int n = this.pos - this.lastOffset;
        if (n == 0) {
            return;
        }
        if (this.context.rules.getHighlightDigits()) {
            by = 0;
            boolean bl2 = false;
            for (int i = this.lastOffset; i < this.pos; ++i) {
                char c = this.line.array[i];
                if (Character.isDigit(c)) {
                    by = 1;
                    continue;
                }
                bl2 = true;
            }
            if (bl2) {
                RE rE = this.context.rules.getDigitRegexp();
                if (by != 0) {
                    if (rE == null) {
                        by = 0;
                    } else {
                        CharIndexedSegment charIndexedSegment = new CharIndexedSegment(this.line, false);
                        int n2 = this.line.count;
                        int n3 = this.line.offset;
                        this.line.offset = this.lastOffset;
                        this.line.count = n;
                        if (!rE.isMatch(charIndexedSegment)) {
                            by = 0;
                        }
                        this.line.offset = n3;
                        this.line.count = n2;
                    }
                }
            }
            if (by != 0) {
                this.tokenHandler.handleToken(this.line, (byte)5, this.lastOffset - this.line.offset, n, this.context);
                this.lastOffset = this.pos;
                return;
            }
        }
        if (this.keywords != null && (by = this.keywords.lookup(this.line, this.lastOffset, n)) != 0) {
            this.tokenHandler.handleToken(this.line, by, this.lastOffset - this.line.offset, n, this.context);
            this.lastOffset = this.pos;
            return;
        }
        if (bl) {
            this.tokenHandler.handleToken(this.line, this.context.rules.getDefault(), this.lastOffset - this.line.offset, n, this.context);
            this.lastOffset = this.pos;
        }
    }

    private char[] substitute(REMatch rEMatch, char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '$') {
                if (i == cArray.length - 1) {
                    stringBuffer.append(c);
                    continue;
                }
                char c2 = cArray[i + 1];
                if (!Character.isDigit(c2)) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(rEMatch.toString(c2 - 48));
                ++i;
                continue;
            }
            stringBuffer.append(c);
        }
        char[] cArray2 = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray2, 0);
        return cArray2;
    }

    public static class LineContext {
        private static Hashtable intern = new Hashtable();
        public LineContext parent;
        public ParserRule inRule;
        public ParserRuleSet rules;
        public char[] spanEndSubst;

        public LineContext(ParserRuleSet parserRuleSet, LineContext lineContext) {
            this.rules = parserRuleSet;
            this.parent = lineContext == null ? null : (LineContext)lineContext.clone();
        }

        public LineContext() {
        }

        public LineContext intern() {
            Object v = intern.get(this);
            if (v == null) {
                intern.put(this, this);
                return this;
            }
            return (LineContext)v;
        }

        public int hashCode() {
            if (this.inRule != null) {
                return this.inRule.hashCode();
            }
            if (this.rules != null) {
                return this.rules.hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof LineContext) {
                LineContext lineContext = (LineContext)object;
                return lineContext.inRule == this.inRule && lineContext.rules == this.rules && MiscUtilities.objectsEqual(this.parent, lineContext.parent) && this.charArraysEqual(this.spanEndSubst, lineContext.spanEndSubst);
            }
            return false;
        }

        public Object clone() {
            LineContext lineContext = new LineContext();
            lineContext.inRule = this.inRule;
            lineContext.rules = this.rules;
            lineContext.parent = this.parent == null ? null : (LineContext)this.parent.clone();
            lineContext.spanEndSubst = this.spanEndSubst;
            return lineContext;
        }

        private boolean charArraysEqual(char[] cArray, char[] cArray2) {
            if (cArray == null) {
                return cArray2 == null;
            }
            if (cArray2 == null) {
                return cArray == null;
            }
            if (cArray.length != cArray2.length) {
                return false;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

